/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 27-Nov-85 | Created
* 24-Nov-91 | [1.177] <jmn> converted to C6.0
* 26-Nov-91 | [1.194] <jmn> fixed error format to be compiler-compatible
*****************************************************************************/

#include <stdio.h>
#include <boolean.h>
#include <list.h>

extern line_number;
extern char filename[80];
void report(int err,char * msg,char * severity);

/****************************************************************************
*                                    error
* Inputs:
*       int err: Error code
*	char * msg: String to print
* Effect: 
*       Writes an error message to stderr
****************************************************************************/

void error(int err,char * msg)
    {
     report(err,msg,"Error");
     list_err(err);
    }

/****************************************************************************
*                                    warning
* Inputs:
*       int err: Error code
*	char * msg: String to print
* Effect: 
*       Writes a warning message to stderr
****************************************************************************/

void warning(int err,char * msg)
    {
     report(err,msg,"Warning");
     list_err(err);
    }

/****************************************************************************
*                                   report
* Inputs:
*	int err: Error code
*       char * msg: Message to print
*	char * severity: Severity code
* Effect: 
*       Writes the error message to the error stream
****************************************************************************/

void report(int err,char * msg,char * severity)
    {
     fprintf(stderr,"%s(%d): %s %d: %s\n",
     		filename,
		line_number,
		severity,
		err,
		msg);
    }
