/* i1401_defs.h: IBM 1401 simulator definitions

   Copyright (c) 1993-2002, Robert M. Supnik

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   ROBERT M SUPNIK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   Except as contained in this notice, the name of Robert M Supnik shall not
   be used in advertising or otherwise to promote the sale, use or other dealings
   in this Software without prior written authorization from Robert M Supnik.

   03-May-02   WVSnyder Added definitions for the rest of BCD
   30-Jan-02   WVSnyder Added a definition for BCD_QMARK -- for completeness
   14-Apr-99	RMS	Converted t_addr to unsigned

   This simulator is based on the 1401 simulator written by Len Fehskens
   with assistance from Sarah Lee Harris and Bob Supnik. This one's for
   you, Len.  I am grateful to Paul Pierce and Charles Owen for their help
   in answering questions, gathering source material, and debugging.
*/

#include "sim_defs.h"

/* Simulator stop codes */

#define STOP_NXI	1				/* unimpl instr */
#define STOP_NXM	2				/* non-exist mem */
#define STOP_NXD	3				/* non-exist dev */
#define STOP_NOWM	4				/* no WM under op */
#define STOP_INVA	5				/* invalid A addr */
#define STOP_INVB	6				/* invalid B addr */
#define STOP_INVL	7				/* invalid length */
#define STOP_INVM	8				/* invalid modifier */
#define STOP_INVBR	9				/* invalid branch */
#define STOP_IBKPT	10				/* breakpoint */
#define STOP_HALT	11				/* halt */
#define STOP_INVMTU	12				/* invalid MT unit */
#define STOP_MTZ	13				/* MT zero lnt rec */
#define STOP_MTL	14				/* MT write lock */
#define STOP_CCT	15				/* inv CCT channel */
#define STOP_NOCD	16				/* no cards left */
#define STOP_WRAP	17				/* AS, BS mem wrap */
#define STOP_MCE1	18				/* MCE short A field */
#define STOP_MCE2	19				/* MCE short B field */
#define STOP_MCE3	20				/* MCE hanging $ */
#define STOP_IOC	21				/* I/O check */

/* Memory and devices */

#define	MAXMEMSIZE	16000				/* max memory */
#define MEMSIZE		(cpu_unit.capac)		/* current memory */
#define CDR_BUF		1				/* card rdr buffer */
#define CDR_WIDTH	80				/* card rdr width */
#define CDP_BUF		101				/* card punch buffer */
#define CDP_WIDTH	80				/* card punch width */
#define LPT_BUF		201				/* line print buffer */
#define LPT_WIDTH	132				/* line print width */
#define CCT_LNT		132				/* car ctrl length */
#define INQ_WIDTH	80				/* inq term width */
#define ADDR_ERR(x)	(((t_addr) (x)) >= MEMSIZE)

/* Binary address format

	<14:0>		address, with index added in
	<23:16>		index register memory address
	<25:24>		address error bits
*/

#define ADDRMASK	037777				/* addr mask */
#define INDEXMASK	077777				/* addr + index mask */
#define V_INDEX		16
#define M_INDEX		0177
#define V_ADDRERR	24
#define BA		(1 << V_ADDRERR)		/* bad addr digit */
#define X1		(87 << V_INDEX)			/* index reg 1 */
#define X2		(92 << V_INDEX)			/* index reg 2 */
#define X3		(97 << V_INDEX)			/* index reg 3 */

/* CPU instruction control flags.  The flag definitions must be harmonized
   with the UNIT flag definitions used by the simulator. */

/* Lengths */

#define L1		0001				/* 1: op */
#define L2		0002				/* 2: op d */
#define L4		0004				/* 4: op aaa */
#define L5		0010				/* 5: op aaa d */
#define L7		0020				/* 7: op aaa bbb */
#define L8		0040				/* 8: op aaa bbb d */

/* CPU options, stored in cpu_unit.flags */

#define MDV		(1 << (UNIT_V_UF + 0))		/* multiply/divide */
#define MR		(1 << (UNIT_V_UF + 1))		/* move record */
#define XSA		(1 << (UNIT_V_UF + 2))		/* index, store addr */
#define EPE		(1 << (UNIT_V_UF + 3))		/* expanded edit */
#define MA		(1 << (UNIT_V_UF + 4))		/* modify address */
#define BBE		(1 << (UNIT_V_UF + 5))		/* br bit equal */
#define HLE		(1 << (UNIT_V_UF + 6))		/* high/low/equal */
#define UNIT_MSIZE	(1 << (UNIT_V_UF + 7))		/* fake flag */
#define ALLOPT		(MDV + MR + XSA + EPE + MA + BBE + HLE)
#define STDOPT		(MR + XSA + EPE + MA + BBE + HLE)

/* Fetch control */

#define AREQ		(1 << (UNIT_V_UF + 8))		/* validate A */
#define BREQ		(1 << (UNIT_V_UF + 9))		/* validate B */
#define MLS		(1 << (UNIT_V_UF + 10))		/* move load store */
#define NOWM		(1 << (UNIT_V_UF + 11))		/* no WM at end */
#define HNOP		(1 << (UNIT_V_UF + 12))		/* halt or nop */
#define IO		(1 << (UNIT_V_UF + 13))		/* IO */
#define UNIT_BCD	(1 << (UNIT_V_UF + 14))		/* BCD strings */

#if (UNIT_V_UF < 6) || ((UNIT_V_UF + 14) > 31)
	Definition error: flags overlap
#endif

/* BCD memory character format */

#define WM		0100				/* word mark */
#define ZONE		0060				/* zone */
#define BBIT            0040                            /* 1 in valid sign */
#define ABIT            0020                            /* sign (1 = +) */
#define DIGIT		0017				/* digit */
#define CHAR		0077				/* character */

#define V_WM		6
#define V_ZONE		4
#define V_DIGIT		0

/* BCD characters              Card Code   ASCII / Name */

#define BCD_BLANK	000 /* None        Blank */
#define BCD_ONE		001 /* 1           1     */
#define BCD_TWO		002 /* 2           2     */
#define BCD_THREE	003 /* 3           3     */
#define BCD_FOUR	004 /* 4           4     */
#define BCD_FIVE	005 /* 5           5     */
#define BCD_SIX		006 /* 6           6     */
#define BCD_SEVEN	007 /* 7           7     */
#define BCD_EIGHT	010 /* 8           8     */
#define BCD_NINE	011 /* 9           9     */
#define BCD_ZERO	012 /* 0           0     */
#define BCD_HASH        013 /* 3-8         #     */
#define BCD_AT          014 /* 4-8         @     */
#define BCD_COLON       015 /* 5-8         :     */
#define BCD_GREATER     016 /* 6-8         >     */
#define BCD_TM          017 /* 7-8          Tape Mark */
#define BCD_ALT		020 /* Impossible   Blank on even parity tape */
#define BCD_SLASH       021 /* 0-1         /     */
#define BCD_S		022 /* 0-2         S     */
#define BCD_T           023 /* 0-3         T     */
#define BCD_U		024 /* 0-4         U     */
#define BCD_V           025 /* 0-5         V     */
#define BCD_W		026 /* 0-6         W     */
#define BCD_X           027 /* 0-7         X     */
#define BCD_Y           030 /* 0-8         Y     */
#define BCD_Z           031 /* 0-9         Z     */
#define BCD_RECMRK	032 /* 0-2-8       '|    */
#define BCD_COMMA	033 /* 0-3-8       ,     */
#define BCD_PERCNT	034 /* 0-4-8       %     */
#define BCD_WM		035 /* 0-5-8       = Word separator -- word mark on tape */
#define BCD_BS		036 /* 0-6-8       ' Apostrophe */
#define BCD_TS		037 /* 0-7-8       " Tape segment mark */
#define BCD_MINUS	040 /* 11          -     */
#define BCD_J           041 /* 11-1        J     */
#define BCD_K           042 /* 11-2        K     */
#define BCD_L           043 /* 11-3        L     */
#define BCD_M		044 /* 11-3        M     */
#define BCD_N           045 /* 11-4        N     */
#define BCD_O           046 /* 11-6        O     */
#define BCD_P           047 /* 11-7        P     */
#define BCD_Q           050 /* 11-8        Q     */
#define BCD_R		051 /* 11-9        R     */
#define BCD_BANG        052 /* 11-0        ! Minus zero */
#define BCD_DOLLAR	053 /* 11-3-8      $     */
#define BCD_ASTER	054 /* 11-4-8      *     */
#define BCD_RPAREN      055 /* 11-5-8      )]    */
#define BCD_SEMIC       056 /* 11-6-8      ;     */
#define BCD_DELTA       057 /* 11-7-8      _ Delta */
#define BCD_AMPER	060 /* 12          &     */
#define BCD_A           061 /* 12-1        A     */
#define BCD_B		062 /* 12-2        B     */
#define BCD_C		063 /* 12-3        C     */
#define BCD_D           064 /* 12-4        D     */
#define BCD_E		065 /* 12-5        E     */
#define BCD_F           066 /* 12-6        F     */
#define BCD_G           067 /* 12-7        G     */
#define BCD_H           070 /* 12-8        H     */
#define BCD_I           071 /* 12-9        I     */
#define BCD_QMARK       072 /* 12-0        ? Plus zero */
#define BCD_DECIMAL	073 /* 12-3-8      .     */
#define BCD_SQUARE	074 /* 12-4-8       Lozenge */
#define BCD_LPAREN      075 /* 12-5-8      ([    */
#define BCD_LESS        076 /* 12-6-8      <     */
#define BCD_GRPMRK	077 /* 12-7-8      "}    */

/* Opcodes */

#define OP_R	     /*	001 */ BCD_ONE			/* read */
#define OP_W	     /* 002 */ BCD_TWO			/* write */
#define OP_WR	     /* 003 */ BCD_THREE		/* write and read */
#define OP_P	     /* 004 */ BCD_FOUR			/* punch */
#define OP_RP	     /* 005 */ BCD_FIVE			/* read and punch */
#define OP_WP	     /*	006 */ BCD_SIX			/* write and punch */
#define OP_WRP	     /*	007 */ BCD_SEVEN		/* write read punch */
#define OP_RF	     /*	010 */ BCD_EIGHT		/* reader feed */
#define OP_PF	     /*	011 */ BCD_NINE			/* punch feed */
#define OP_MA	     /*	013 */ BCD_HASH			/* modify address */
#define OP_MUL	     /*	014 */ BCD_AT			/* multiply */
#define OP_CS	     /*	021 */ BCD_SLASH		/* clear storage */
#define OP_S	     /*	022 */ BCD_S			/* subtract */
#define OP_MTF	     /*	024 */ BCD_U			/* magtape function */
#define OP_BWZ	     /*	025 */ BCD_V			/* branch wm or zone */
#define OP_BBE	     /*	026 */ BCD_W			/* branch bit equal */
#define OP_MZ	     /*	030 */ BCD_Y			/* move zone */
#define OP_MSZ	     /*	031 */ BCD_Z			/* move suppr zeroes */
#define OP_SWM	     /*	033 */ BCD_COMMA		/* set word mark */
#define OP_DIV	     /*	034 */ BCD_PERCNT		/* divide */
#define OP_SS	     /*	042 */ BCD_K			/* select stacker */
#define OP_LCA	     /*	043 */ BCD_L			/* load characters */
#define OP_MCW	     /*	044 */ BCD_M			/* move characters */
#define OP_NOP	     /*	045 */ BCD_N			/* no op */
#define OP_MCM	     /*	047 */ BCD_P			/* move to rec/grp mk */
#define OP_SAR	     /*	050 */ BCD_Q			/* store A register */
#define OP_ZS	     /*	052 */ BCD_BANG			/* zero and subtract */
#define OP_A	     /*	061 */ BCD_A			/* add */
#define OP_B	     /*	062 */ BCD_B			/* branch */
#define OP_C	     /*	063 */ BCD_C			/* compare */
#define OP_MN	     /*	064 */ BCD_D			/* move numeric */
#define OP_MCE	     /*	065 */ BCD_E			/* move char and edit */
#define OP_CC	     /*	066 */ BCD_F			/* carriage control */
#define OP_SBR	     /*	070 */ BCD_H			/* store B register */
#define OP_ZA	     /*	072 */ BCD_QMARK		/* zero and add */
#define OP_H	     /*	073 */ BCD_DECIMAL		/* halt */
#define OP_CWM	     /*	074 */ BCD_SQUARE		/* clear word mark */

/* I/O addresses */

#define IO_INQ		023				/* inquiry terminal */
#define IO_MT		024				/* magtape */
#define IO_MTB		062				/* binary magtape */
#define IO_DP		066				/* 1311 diskpack */

/* I/O modes */

#define MD_NORM		0				/* normal (move) */
#define MD_WM		1				/* word mark (load) */
#define MD_BIN		2				/* binary */

/* Indicator characters */

#define IN_UNC		000				/* unconditional */
#define IN_CC9		011				/* carr ctrl chan 9 */
#define IN_CC12		014				/* carr ctrl chan 12 */
#define IN_UNQ		021				/* unequal */
#define IN_EQU		022				/* equal */
#define IN_LOW		023				/* low */
#define IN_HGH		024				/* high */
#define IN_PAR		025				/* parity check */
#define IN_LNG		026				/* wrong lnt record */
#define IN_UNA		027				/* unequal addr cmp */
#define IN_DSK		030				/* disk error */
#define IN_OVF		031				/* overflow */
#define IN_LPT		032				/* printer error */
#define IN_PRO		034				/* process check */
#define IN_END		042				/* end indicator */
#define IN_TAP		043				/* tape error */
#define IN_ACC		045				/* access error */
#define IN_BSY		047				/* printer busy */
#define IN_INR		050				/* inquiry request */
#define IN_PCB		051				/* printer carr busy */
#define IN_PNCH		052				/* punch error */
#define IN_INC		054				/* inquiry clear */
#define IN_LST		061				/* last card */
#define IN_SSB		062				/* sense switch B */
#define IN_SSC		063				/* sense switch C */
#define IN_SSD		064				/* sense switch D */
#define IN_SSE		065				/* sense switch E */
#define IN_SSF		066				/* sense switch F */
#define IN_SSG		067				/* sense switch G */
#define IN_READ		072				/* reader error */
