               job  tape error subroutine
               ctl  6611
     * Generalized tape error subroutine
     *  Read or write errors on any drive.
     *  LCA or MCW tape command
     * Required entry linkage
     *  After   LCA/MCW %UX  AREA  R/W
     *  must be    B    TAPERR      L
     *   I.e., every 8 character tape I/O command
     *   must be immediately followed by a branch to
     *   TAPERR if indicator is on
     * Read error
     *  Routine will reread record 10 times, then hlt
     * Write error
     *  Routine tries to write 2 times without
     *  skipping tape, then tries 7 skip and writes,
     *  then stops.
     * Press start after halt for an additional 10
     *  attempts.
     * If sense sw G is on when start is pressed
     *  control will return to main program.
     *
               org  1
     taperr    sbr  taperx+3            store exit
               sbr  *+4                 init a addr to error cmnd+13
               c    *,taperc+13         use compare to decrement addr
               c                         to error command
               mlc                      move error command to routine
               mn   c7,taperx+4         set count to 7
               mn   taperc+3,taperb+3   set drive in backspace
     taperp    a    *-6,taperx+4        add 1 to count
               c    taperx+4,c7         compare count to 7
               bu   *+7                 Q. 10 repeats.
               h                         yes. press start for 10 more or
               bss  taperx,g             if g on accept as correct-ed.
     taperb    bsp  1                   backspace for another try
               bce  taperc,taperc+7,r   Q. Read command.
               bl   taperc               No Q. Two retries in same place
               skp  1                        Yes, turn on skip switch
     taperc    nop  *,*,*               repeat tape I/O command.
               ber  taperp              Q. error again.
     taperx    b    *-3                  no, exit program
               dcw  @ @                 count, no ovfl zone in one pos.
     c7        dcw  7                   must not have zone.
               end  0
