               JOB  Common code                                            CCOM
               CTL  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * C on to print correct results
     * D on to repeat test without reading new detail
     * E on to halt on errors
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 458 in A-star and 490 in I-star if test error and SS E on.  Pushing
     *    start continues, depending on SS D.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     headpr    equ  190            Print first two detail if not blank.
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headct    dcw  0              How many detail read?  Print first 2.
               dc   #10
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  finis          No cards left?
               r    testhd         Read a detail or header card
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
               org  407
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Results
     *
               org  453
     worked    bss  corrpr,c       C ON TO CORRECT PRINT ROUTINE
     loop      bss  repeat,d       D ON TO REPEAT
               cs   detail,80      BRANCH TO READ NEXT RECORD
     failed    lca  error,285      BEGIN ERROR PRINT ROUTINE
               bss  errhlt,e       E ON TO ERROR STOP
     corrpr    w    loop           ERROR OR CORRECT PRINT
     errhlt    h    loop           ERROR STOP
     error     dcw  @error@        CONSTANTS
     *
     * Continue or repeat the test
     *
     cont      equ  *&1
     repeat    sw   1,78           LOAD PRINT AREA
               cs   332              ,,
               lca  80               ,,
               cs                    ,,
               lca  72,272           ,,
               end
