               job  Test infrastructure
               ctl  6611
     *
     * Sense switches:
     * B on for tightest loop -- for scoping
     * C on to print correct results
     * D on to loop over test plus printing
     * E on to halt on error instead of printing
     *
     * Detail format:
     * 1-6   Lengths of up to six instructions in test
     * 7-45  Instructions to implement test
     * 46-55 A field or D modifier
     * 56-65 B field
     * 66-75 Correct result
     * 76-80 Test ID
     *
     * Halts:
     * 086 in A-star and B-star if tape read error
     * 099 in A-star and B-star if test failure
     *
               org  333
     *
     * Page heading
     *
     start     cs   332
               cs
               mcw  @A/D@,203        201-210
               mcw  @B@,216          216-225
               mcw  @Should Be@,239  231-240
               mcw  @Actual@,251     246-255
               mcw  @Status@,266     261-270
               mcw  @ID@,277         276-280
               w
               cs
               cs
     *
     * Read a test and execute it
     *
     readit    bce  tapein,81,"  Tape load puts GM in 81
               cs   80           Start fresh
               r    gotit
     taperr    bsp  1
               nop  86           Halt 86 for tape error
               h
     tapein    rt   1,1
               ber  taperr
     *
     * Got a detail record.  Print it if 1 is *
     *
     gotit     bce  prntdr,1,*
     hook      b    setup
     prntdr    sw   1        Print the detail record
               mcw  80,280
               w
               cs   readit,280
     *
     * set word marks for up to six instructions
     *
     setup     mcw  @07@,sw&3    Refresh changed instructions
               mcw  @1@,add&3
               sw   6
               chain5
     sw        sw   0-0          Set word mark under instruction
               sw   sw&1
     add       a    0-0,sw&3     Bump where to set word mark
               cw   sw&1
               bce  donesw,add&3,7  Done setting word marks?
               a    *-6,add&3    Bump instruction width counter
               b    sw           Go set another word mark
     *
     * Done setting word marks under instructions
     * Set word marks for A, B, Correct and ID fields
     * Move fields to print area
     *
     donesw    sw   46,56        Set word marks for A and B fields
               sw   66,76          Should Be and ID
               mcw  55,210       Load A field to print area
               mcw  65,225            B field
               mcw  75,240            Should be
               mcw  80,280            Id
     *
     * Run the test
     *
               b    7
     *
     * Return  here for success
     *
     worked    bss  7,b          Tight loop for scoping
               bss  prntok,c     Print correct result
               b    testd
     prntok    mcw  @OK@,262
     prntit    mcw  65,255       Actual result
               w
               cs
               cs
     testd     bss  7,d          Loose loop -- test & print
               b    readit       Go do another test
     *
     * Return here for failure
     *
     failed    bss  7,b          Tight loop for scoping
               bss  errhlt,e     Error halt?
               mcw  @ERROR@,265
               b    prntit
     errhlt    nop  99           Halt 99 for test failure
               h
               b    testd
               end  start
