               JOB  RIPPLE PRINT                                           1020A
               ctl  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * D on to repeat test without reading new detail
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Continue here after reading detail
     *
     cont      cw   table-39,table-19  EXPAND TABLE
               lca  table,tab2       ,,
               cw   table&1          ,,
               lca  tab2,tab5        ,,
               cw   tab2&1           ,,
               sw   201            SET WM IN PRINT AREA
     repeat    lca  kbeg,lctr      LOAD LINE COUNTER
     line      mcw  lctr,*&4       MOVE LINE CTR INTO NEXT INSTRUC
               mcw  tab3,332       MOVE TABLE INTO PRINT AREA
     scope     w                   PRINT
               bss  scope,B        B ON TO SCOPE
               c    kend,lctr      COMPARE LINE COUNTER WITH 891
               bu   bump           BRANCH TO ADD 1 IF NOT 891
               bss  repeat,D       D ON TO REPEAT TEST
               b    detail         BRANCH TO READ NEXT RECORD
     bump      a    k1,lctr        ADD 1 TO LINE COUNTER
               b    line           BRANCH TO PRINT NEXT LINE
     kbeg      dsa  tab3           CONSTANT TO START LINE COUNTER
     k1        dcw  1              CONSTANT TO INCREMENT LINE COUNTER
     kend      dsa  tab4           CONSTANT TO STOP LINE COUNTER
     lctr      dcw  #3                       LINE COUNTER
               dcw  @AKT4 BLU5 CMV6"DNW7 @   TABLE TO BE RIPPLE PRINTED
               dcw  @EOX8 FPY9_GQZ0 HR'# @     ,,
     table     dcw  @I-,@+&$%1 .*/2 )JS3(@     ,,
     tab2      ds   60
     tab3      ds   12
     tab4      ds   59
     tab5      ds   49
               dcw  @"@            GMWM
     *
     * Modify header printer to print only the title
     *
               org  headct
               dcw  1
               end  start
