               job  Test infrastructure
               ctl  6611
     *
     * Sense switches:
     * B on for tightest loop -- for scoping
     * C on to print correct results
     * D on to loop over test plus printing
     * E on to halt on error instead of printing
     *
     * Detail format:
     * 1-6   Lengths of up to six instructions in test
     * 7-45  Instructions to implement test
     * 46-52 A field or D modifier
     * 53-66 B field
     * 67-80 Correct result
     *
     * Halts:
     * 086 in A-star and B-star if tape read error
     * 099 in A-star and B-star if test failure
     *
               org  333
     *
     * Page heading
     *
     start     cs   332
               cs
               mcw  @A/D----@,207         201-207
               mcw  @B-------------@,229  216-229
               mcw  @Should Be-----@,249  236-249
               mcw  @Actual--------@,269  256-269
               mcw  @Status@,281          276-285
               w
               cs
               cs
     *
     * Read a test and execute it
     *
     readit    bce  tapein,81,"  Tape load puts GM in 81
               cs   80           Start fresh
               r    gotit
     taperr    bsp  1
               nop  86           Halt 86 for tape error
               h
     tapein    rt   1,1
               ber  taperr
     *
     * Got a detail record.  Print it if 1 is *
     *
     gotit     bce  prntdr,1,*
     hook      b    setup
     prntdr    sw   1        Print the detail record
               mcw  80,280
               w
               cs   readit,280
     *
     * set word marks for up to six instructions
     *
     setup     mcw  @07@,sw&3    Refresh changed instructions
               mcw  @1@,add&3
               sw   6
               chain5
     sw        sw   0-0          Set word mark under instruction
               sw   sw&1
     add       a    0-0,sw&3     Bump where to set word mark
               cw   sw&1
               bce  donesw,add&3,7  Done setting word marks?
               a    *-6,add&3    Bump instruction width counter
               b    sw           Go set another word mark
     *
     * Done setting word marks under instructions
     * Set word marks for A, B, Correct and ID fields
     * Move fields to print area
     *
     donesw    sw   46,53        Set word marks for A, B
               sw   67             and Should Be fields
               mcw  52,207       Load A field to print area
               mcw  66,229            B field
               mcw  80,249            Should be
     *
     * Run the test
     *
     scope     lca  66,269       Result starts as B, them formed here
               b    7
     *
     * Return here for success
     *
     worked    bss  scope,b      Tight loop for scoping
     * Return here for success but no scoping test
     workns    bss  prntok,c     Print correct result
               b    testd
     prntok    mcw  @OK@,277
     prntit    w
               cs
               cs
     testd     bss  scope,d      Loose loop -- test & print
               b    readit       Go do another test
     *
     * Return here for failure
     *
     failed    bss  scope,b      Tight loop for scoping
     * Return here for failure but no scoping test
     failns    bss  errhlt,e     Error halt?
               mcw  @ERROR@,280
               b    prntit
     errhlt    nop  99           Halt 99 for test failure
               h
               b    testd
     *
     * Return here to compare B to Correct and announce
     * error if unequal.
     *
     compar    c    249,269
     test      bu   failed
               b    worked
     *
     * Return here to compare B to Correct and announce
     * error if unequal, without scoping test
     *
     compns    c    249,269
     testns    bu   failns
               b    workns
               end  start
