               JOB  Test reading and writing short records on tape         5040c
               ctl  6611
     *
     * Sense switches:
     *  B: Repeat write-backspace-read for scoping if on
     *  C: Print correct results if on
     *  D: Repeat same record if on
     *  E: Halt on error if on
     *  F: Not used
     *  G: Repeat entire test if on
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 491 in A-star and 638 in I-star if tape write error and SS E on.
     *    Pushing start continues.
     * 718 in A-star and 665 in I-star if tape read error and SS E on.
     *    Pushing start continues.
     * 523 in A-star and 699 in I-star if error detected by compare
     *    and SS E on.  Pushing start continues.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise if 81 is not GM (program is not loaded from
     * tape). Otherwise read a record from tape into 1. If 80 is  A,
     * branch to 1.
     *
     * Print the first two if headpr is not blank.
     *
     start     equ  detail
     nxprog    equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     cont      equ  *&1
     * Continue here after reading detail
     *
     * Start test here
     *
     repeat    MCW  k001,passct   SET PASS COUNTER TO 001
                  N00             NOP
               SW   199           SET WM IN 199
     bop       B    init          BR TO SET MOD INSTR TO INITIAL COND.
     write     WT   4,208         WRITE 15 CHARACTER RECORD
               BSS  testef,B      B ON TO SCOPE
               BER  error         BRANCH IF WRITE ERROR
     testef    BEF  eor           BRANCH IF END OF REEL
               BSP  4             BACKSPACE
               RT   4,245         READ BACK SAME 15 CHARACTER RECORD
               BSS  write,B       B ON TO SCOPE
               BER  seter         BRANCH IF READ ERROR
               B    wmtest        BRANCH TO TEST FOR ERROR BY COMPARING
     mvpass    MCS  passct,203    MOVE PASS NUMBER
     nopsw     NOP  erprnt        NOP IF NO ERRORS - BRANCH IF ANY ERRORS
               BSS  print,C       C ON TO CORRECT ROUTINE
     dtest     BSS  swdone,D      D ON TO REPEAT SAME RECORD
               C    move&3,tapca  TEST IF LAST RECORD HAS BEEN WRITTEN
               BU   bump          BRANCH IF NOT LAST RECORD
               BCE  loopt,passct-1,1 BRANCH IF END OF 10TH PASS
               A    k001-4,passct   ADD 1 TO PASS COUNTER
               B    init          BRANCH TO START NEXT PASS
     loopt     BSS  repeat,G      G ON TO REPEAT TEST
               CS   nxprog,299    BRANCH TO READ NEXT PROGRAM
     bump      SW   move&1        ADD 1 TO MOVE INSTR TO SET UP NEXT
               A    k001-4,move&3  RECORD TO BE WRITTEN
               B    swdone        BRANCH TO SET UP NEXT RECORD
     eor       RWD  4             REWIND
               B    swdone        BRANCH TO SET UP SAME RECORD
     error     LCA  bop,nopsw     CHANGE NOP TO BRANCH
               MCW  tapwrd,230    MOVE TAPE WRITE ERROR COMMENT
               BSS  wrhalt,E      E ON TO ERROR STOP
               B    testef        BRANCH TO TEST FOR END OF REEL
     wrhalt    H    testef        ERROR STOP IF TAPE WRITE ERROR
     seter     LCA  bop,nopsw     CHANGE NOP TO BRANCH
               MCW  tapwrd,267    MOVE TAPE READ ERROR COMMENT
               BSS  rehalt,E      E ON TO ERROR STOP
               B    wmtest        BRANCH TO TEST FOR ERROR BY COMPARING
     rehalt    H    wmtest        ERROR STOP IF TAPE READ ERROR
     uneq      SW   246,258       SET WM IN TAPE READ AREA
     uneq2     LCA  bop,nopsw     CHANGE NOP TO BRANCH
               MCW  cmpmsg,278    MOVE COMPARE ERROR COMMENT
               BSS  unhalt,E      E ON TO ERROR STOP
               B    mvpass        BRANCH TO MOVE PASS NUMBER
     unhalt    H    mvpass        ERROR STOP IF ERROR DETECTED BY COMPARE
     erprnt    MCW  errmsg,285    MOVE WORD ERROR TO PRINT
               BSS  dtest,E       E OFF TO ERROR PRINT
     print     W                  PRINT
               WM                 PRINT WORD MARKS
               B    dtest         BRANCH TO SENSE D
     wmtest    BW   *&5,246       TEST FOR WORD MARKS
               B    uneq2           ,,
               BW   *&5,258         ,,
               B    uneq2           ,,
               CW   246,258         ,,
               CW   260,223         ,,
               C    260,223       TEST FOR ERRORS BY COMPARING
               BU   uneq            ,,
               C    258,221         ,,
               BU   uneq            ,,
               C    252,215         ,,
               BU   uneq            ,,
               BW   uneq,259     TEST FOR WORD MARKS
               BW   uneq,253        ,,
               BW   uneq,245        ,,
               SW   246,258         ,,
               B    mvpass          ,,
     init      MCW  tapca&4,mod1&3  SET MODIFIED INSTR TO INITIAL COND
               MCW  tapca&8,move&3   ,,
     init2     CW   mod1&1,tapcon  SET WORD MARKS THROUGHOUT TABLE
     mod1      SW   tapcon-12,mod1&1  ,,
               BW   swdone,tapcon   ,,
               A    k001-4,mod1&3   ,,
               B    init2           ,,
     swdone    CS   299           CLEAR PRINT AREA
               CW   move&1        SET UP 15 CHARACTER RECORD TO BE
     move      MCW  tapcon-11,209  WRITTEN ON TAPE
               LCA                  ,,
               MCW  209,211         ,,
               MCW  211,215         ,,
               LCA  214,222         ,,
               SW   222             ,,
               LCA  gmwm,223        ,,
               MCW  @N@,nopsw     CHANGE ERROR BRANCH TO NOP
               SW   246,258       SET WORD MARK IN TAPE READ AREA
               B    write         BRANCH TO WRITE TAPE
     k001      dcw  10001         CONSTANT
     passct    dcw  @xxx@         PASS COUNTER FOR NO. OF TEST PASSES
     tapca     dsa  tapcon
               sw   tapcon-12
               mcw  tapcon-11
     tapwrd    DCW  @TAPE@        CONSTANTS FOR PRINTOUTS
     cmpmsg    dcw  @compare@       ,,
     errmsg    dcw  @error@         ,,
     tapcon    DCW  @AAKT4EOX8I-,@@  CONSTANTS FOR TAPE RECORDS
               ltorg*
     gmwm      DCW  @"@                        ,,
               END  start
