               JOB  backspace skip                                         5030c
               ctl  6611
     *
     * Sense switches
     *
     * B: Repeat same test -- useful for scoping
     * C: Print correct results
     * D: Repeat read test
     * E: Don't print errors
     * F: Not used
     * G: Repeat entire test
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 660 in I-star if tape write error and SS E on.
     *    Pushing start continues.
     * 914 in I-star if error detected by compare and SS E on.
     *    Pushing start continues.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise if 81 is not GM (program is not loaded from
     * tape). Otherwise read a record from tape into 1. If 80 is  A,
     * branch to 1.
     *
     * Print the first two if headpr is not blank.
     *
     start     equ  detail
     nxprog    equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     cont      equ  *&1
     * Continue here after reading detail
     *
     * Start test here
     *
               MCW  k0001,passno   SET PASS COUNTER TO ONE
     rwd       RWD  4              REWIND
     repeat    LCA  nop,sw1        LOAD -N- IN LOCATION sw1
     nop       NOP                 NOP
               CS   299            CLEAR PRINT AREA
               MCW  passno,203     MOVE PASS NO. IN PRINT AREA
               MCW  write,211      MOVE WORD -WRITE- IN PRINT AREA
               LCA  rec1,226       LOAD RECORD 1 & GM IN PRINT AREA
               LCA  rec2,260       LOAD RECORD 2 & GM IN PRINT AREA
               SW   226,260        SET WM IN GM LOCATIONS
               WTW  4,216          WRITE RECORD 1
     bop       BER  wrterr         BRANCH IF TAPE WRITE ERROR
     eftst1    BEF  rwd            BRANCH IF END OF REEL
               MCW  k0001-1,rwc    SET RE-WRITE COUNTER TO ZERO
     wrec2     WTW  4,250          WRITE RECORD 2
               BSS  eftst2,B       B ON TO SCOPE
               BCE  ertest,rwc-1,1  BRANCH IF 10 IN RE-WRITE COUNTER
               A    rec1-10,rwc    ADD 1 TO RE-WRITE COUNTER
     eftst2    BEF  rwd            BRANCH IF END OF REEL
               BSP  4              BACKSPACE
               SKP  4              SKIP
               B    wrec2          BRANCH TO REWRITE RECORD 2
     wrterr    LCA  bop,sw1        LOAD -B- IN LOC. sw1 TO BRANCH ON ERROR
               MCW  tape,232       MOVE TAPE WRITE ERROR TO PRINT
               B    eftst1         BRANCH TO TEST FOR END OF REEL
     ertest    BER  set1           BRANCH IF TAPE WRITE ERROR
     eftst3    BEF  rwd            BRANCH IF END OF REEL
     sw1       NOP  erprnt         NOP IF NO ERRORS - BRANCH IF ANY ERRORS
               BSS  erwrit,C       C ON TO CORRECT PRINT
               B    rdtest         BRANCH TO BEGIN READ PORTION OF TEST
     set1      LCA  bop,sw1        LOAD -B- IN LOC. sw1 TO BRANCH ON ERROR
               MCW  tape,266       MOVE TAPE WRITE ERROR TO PRINT
               B    eftst3         BRANCH TO TEST FOR END OF REEL
     erprnt    MCW  error,285      MOVE WORD ERROR TO PRINT AREA
               BSS  erhalt,E       E ON TO ERROR STOP
     erwrit    W    rdtest         PRINT
     erhalt    H                   ERROR STOP
               B    rdtest         BRANCH TO BEGIN READ PORTION OF TEST
     rdtest    LCA  nop,sw2        LOAD -N- IN LOCATION sw2
               CS   299            CLEAR PRINT AREA
               MCW  passno,203     MOVE PASS NO. IN PRINT AREA
               MCW  read,210       MOVE WORD -READ- IN PRINT AREA
               LCA  gmwm,226       LOAD GM-WM FOR RECORD 1
               LCA  gmwm,260       LOAD GM-WM FOR RECORD 2
               BSP  4              BACKSPACE
               BSP  4              BACKSPACE
               RTW  4,216          READ RECORD 1 FROM TAPE
               BSS  read2,B        B ON TO SCOPE
               BER  set2           BRANCH IF TAPE READ ERROR
     testeq    C    225,1029       COMPARE TAPE REC 1 WITH REC IN STORAGE
               BU   noteq1         BRANCH IF ERROR
     read2     RTW  4,250          READ RECORD 2 FROM TAPE
               BSS  rdtest,B       B ON TO SCOPE
               BER  rderr          BRANCH IF TAPE READ ERROR
     test2     C    259,1049       COMPARE TAPE REC 2 WITH REC IN STORAGE
               BU   noteq2         BRANCH IF ERROR
     sw2       NOP  errtn2         NOP IF NO ERRORS - BRANCH IF ANY ERRORS
               BSS  erprt2,C       C ON TO CORRECT PRINT
     testd     BSS  rdtest,D       D ON TO REPEAT READ PORTION OF PROGRAM
               BCE  done,passno-1,1  BRANCH IF 10 IN PASS COUNTER
               A    rec1-10,passno  ADD 1 TO PASS COUNTER
               B    repeat         BRANCH TO REPEAT PROG. IF NOT 10TH PASS
     done      BSS  repeat,G       G ON TO REPEAT TEST
               RWD  4              REWIND
               CS   nxprog,299     CLEAR GM-WM & BRANCH TO LOAD NEXT PROG.
     set2      LCA  bop,sw2        LOAD -B- IN LOC. sw2 TO BRANCH ON ERROR
               MCW  tape,232       MOVE TAPE READ ERROR COMMENT TO PRINT
               B    testeq         BRANCH TO TEST FOR COMPARE ERROR
     noteq1    LCA  bop,sw2        LOAD -B- IN LOC. sw2 TO BRANCH ON ERROR
               MCW  compar,244     MOVE COMPARE ERROR COMMENT TO PRINT
               B    read2          BRANCH TO READ RECORD 2
     rderr     LCA  bop,sw2        LOAD -B- IN LOC sw2 TO BRANCH ON ERROR
               MCW  tape,266       MOVE TAPE READ ERROR COMMMENT TO PRINT
               B    test2          BRANCH TO TEST FOR COMPARE ERROR
     noteq2    LCA  bop,sw2        LOAD -B- IN LOC sw2 TO BRANCH ON ERROR
               MCW  compar,278     MOVE COMPARE ERROR COMMENT TO PRINT
               B    sw2            BRANCH TO NOP OR BRANCH
     errtn2    MCW  error,285      MOVE WORD ERROR TO PRINT AREA
               BSS  erhlt2,B       E ON TO ERROR STOP
     erprt2    W                   PRINT
               WM   testd          PRINT WORD MARKS
     erhlt2    H                   ERROR STOP
               B    testd          BRANCH TO SENSE D
     rec1      DCW  @1111111111"@   RECORD ONE    GM IN '30
     k0001     DCW  @0001     @    CONSTANT TO INCREMENT PASS & RE-WR. CTRS
     rec2      DCW  @RWRWRWRWRW" @   RECORD TWO    GM IN '50
     passno    dcw  @XX@           COUNTER FOR COUNTING NO. OF PASSES
     rwc       DCW  @XXX@          COUNTER FOR COUNTING NO. OF RE-WRITES
               dc   @   @
     write     dcw  @WRITE@        CONSTANTS FOR PRINTOUTS
     read      DCW  @READ@           ,,
     tape      DCW  @TAPE@           ,,
     compar    dcw  @compare@        ,,
     error     DCW  @ERROR               @     ,,
     gmwm      DCW  @"@
               END  start
