               JOB  RIPPLE READ                                            1040A
               ctl  6611
     *
     * Sense switches:
     * C on to print correct results.
     * D on to repeat test (as opposed to chaining).  Another set of
     *   detail cards is needed.
     * E on for error print.
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 611 (517 in A-STAR, 593 in I-STAR) if compare fails.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Test starts here.  First detail card is already in 1-80.
     *
     cont      cs   332            START TEST
               cs
     outer     lca  k01,ccount     SET CARD COUNTER TO ONE
     again     lca  80,280         LOAD CARD INTO PRINT AREA
               lca  ccount,299     LOAD CARD NUMBER INTO PRINT AREA
               lca  rstart,rcount  START RIPPLING COUNTER AT 779
               a    ccount,rcount  ADD CARD COUNTER TO RIPPLING COUNTER
               mcw  rcount,*&4     MOVE RIPPLING COUNTER INTO NEXT INSTRUCT
               c    0-0,80         COMPARE TABLE WITH CARD
               bu   errprt         BRANCH TO ERROR PRINT ROUTINE IF UNEQ
               bss  corr,c         C ON TO CORRECT PRINT
     test      c    ccount,k60     COMPARE CARD COUNTER WITH 60
               bu   more           BR TO ADD 1 TO CARD COUNTER IF NOT 60
     done      bss  repeat,D       D ON TO REPEAT TEST
               b    detail         BRANCH TO CHAIN NEXT PROGRAM
     more      a    *-6,ccount     ADD 1 TO CARD COUNTER
               r    again          READ NEXT DETAIL CARD AND BRANCH BACK
     repeat    r    outer          READ FIRST DETAIL CARD IN 2ND ETC. SET
     *
     * Results
     *
     errprt    lca  error,290      BEGIN ERROR PRINT ROUTINE
               bss  errhlt,e       E ON TO ERROR STOP
     corr      w                   PRINT CARD
               cs                  CLEAR PRINT AREA
               cs                    ,,
               sw   201            SET WM IN PRINT AREA
               mcw  rcount,*&4     MOVE RIPPLING COUNTER INTO NEXT INSTRUCT
               mcw  0-0,280        MOVE TABLE INTO PRINT AREA
               w                   PRINT TABLE
               cs                  CLEAR PRINT AREA
               cs                    ,,
               w    test           SPACE
     errhlt    h    test           ERROR STOP
     error     dcw  @ERROR@
     *
     * Data
     *
     ccount    dcw  #2             CARD COUNTER
     k60       dcw  60             CONSTANT TO STOP CARD COUNTER
     rstart    dsa  data1-1        CONSTANT TO START RIPPLING COUNTER
     rcount    dcw  #3             RIPPLING COUNTER
               dcw  @AKT4 BLU5"CMV6 DNW7_@   TABLE TO CHECK RIPPLE READ
               dc   @EOX8 FPY9+GQZ0 HR'#(@     ,,
               dc   @I-,@ &$%1?.*/2 )JS3!@     ,,
     data1     dc   @AKT4 BLU5"CMV6 DNW7_@     ,,
               dc   @EOX8 FPY9+GQZ0 HR'#(@     ,,
               dc   @I-,@ &$%1?.*/2 )JS3!@     ,,
               dc   @AKT4 BLU5"CMV6 DNW7@      ,,
               dcw  @"@            GMWM
               end  start
