               job  RIPPLE PRINT                                           1020B
               ctl  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * D on to repeat test without reading new detail
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Continue here after reading detail
     *
     cont      cs   dat11
               cs
               lca  tab1,dat3      EXPAND
               mcw  dat3,dat5       THE
               mcw  dat5,dat11       DATA
     rep1      lca  tab3,332
               w
               mcw  adat6,move1&3  Set the starting print address
     loop1     sw   move1&1        Bump
               a    *-6,move1&3      the print
               cw   move1&1            address
     move1     mcw  dat6,332       MOVE TABLE INTO PRINT AREA
     scope1    w                   PRINT
               bss  scope1,B       B ON TO SCOPE
               c    move1&3,adat9  Done?
               bu   loop1          No, do it again
               cc   J
               bss  rep1,D         Repeat same test
               mz   cont,tab2-1
               lca  tab2,dat1      Expand
               mcw  dat1,dat2        the
               mcw  dat2,dat4          data
               mcw  dat4,dat7
               mcw  dat2,dat10
     rep2      mcw  adat6,move2&3  Set the print address
     loop2     sw   move2&1        Bump
               a    *-6,move2&3      the print
               cw   move2&1            address
     move2     mcw  dat6,332       MOVE TABLE INTO PRINT AREA
     scope2    w                   PRINT
               bss  scope2,B       B ON TO SCOPE
               c    move2&3,adat8  Done?
               bu   loop2          No, do it again
               cc   J
               bss  rep2,D
               b    detail         Chain next program
     *
     * Constants and data areas
     *
     adat6     dsa  dat6
     adat9     dsa  dat9
     adat8     dsa  dat8
     tab1      dcw  @1234567890#@/STUVWXYZ?,%JKLMNOPQR!$*ABCDEFGHI&.)@
     tab2      dcw  @[] :? <;\>! "_+(  @
               dcw  @1  2  3  4  5  6  7  8  9  10 11 12 13 @
               dc   @14 15 16 17 18 19 20 21 22 23 24 25 26 @
               dc   @27 28 29 30 31 32 33 34 35 36 37 38 39 @
     tab3      dc   @40 41 42 43 44 @
               dcw  @"@            GMWM
               org  *&x00
     dat1      ds   19
     dat2      ds   18
     dat3      ds   12
     dat4      ds   24
     dat5      ds   24
     dat6      ds   35
     dat7      ds   13
     dat8      ds   5
     dat9      ds   30
     dat10     ds   1
     dat11     ds   12
     *
     * Modify header printer to print only the title
     *
               org  headct
               dcw  1
               end  start
