unit IBM1402;

interface

uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, ExtCtrls,StdCtrls, ComCtrls,
     URecDisp,
     IBMChars,
     B1401CNV;

type
  TReaderForm = class(TForm)
    Panel1: TPanel;
    LACardCount: TLabel;
    Label1: TLabel;
    Reader: TUnitRecordDisplay;
    CBSize: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure CBSizeClick(Sender: TObject);
  private
  public
    procedure Clear;
    procedure LoadDeck(PN: String);
    Function  CardCount: Word;
    function  ReadCard: TCard;
  end;

var ReaderForm: TReaderForm;

implementation

{$R *.DFM}

procedure TReaderForm.FormShow(Sender: TObject);
begin
  Caption:='IBM Emulator - 1402 Card Reader';
end;

procedure TReaderForm.FormResize(Sender: TObject);
begin
  Reader.Width:=Width;  // Force recalc
end;

procedure TReaderForm.CBSizeClick(Sender: TObject);
begin
  If Not CBSize.Checked then Reader.Font.Size:=7
                        else Reader.Font.Size:=10;
end;

procedure TReaderForm.Clear;
begin
  Reader.Clear;
end;

procedure TReaderForm.LoadDeck(PN: String);
begin
  CharMapForm.ProcessCardFile(PN,Reader.Records);
End;
(*
procedure TReaderForm.ConvertCardFile(PN: String);
Var CF: TextFile;
    CM: TCharMapW;
    CD: String;
    CI: Integer;
    CC: Char;
begin
  FillChar(CM,SizeOf(CM),#0);
  AssignFile(CF,PN); Reset(CF);
  While Not Eof(CF) do begin
    Readln(CF,CD);
//  While Length(CD)<80 do CD:=CD+' ';
    For CI:=1 to Length(CD) do begin
      CC:=CD[CI];
      Inc(CM[Ord(CC)]);
    End;
  End;
  CloseFile(CF);
  DisplayCharMap(PN,CM);
  LACardCount.Caption:=IntToStr(Reader.Count);
  With Reader.Records do
    For IC:=0 to Count-1 do begin
      CD:=Strings[IC];
      For CC:=1 to 80 do begin
        CV:=CD[CC];
        TV:=BCDOfAsc(CV);
        If TV=0 then begin
          OV:=CV;
          If CV=' '  then CV:=#0;      // Translate ' ' to #0
          If CV=#$D8 then CV:='?';     // Translate #$D8 to '?'
          If CV=':'  then CV:='#';     // Translate ':' to '#'
          If CV='('  then CV:='%';     // Translate '(' to '%'
          If CV='('  then CV:='%';     // Translate ')' to '%'
          If CV=')'  then CV:=#$7F;    // Translate ')' to '%'
          // Update if code was translated
          If CV<>OV then begin
            CD[CC]:=CV; Strings[IC]:=CD; TV:=1;
          End;
        End;
        If (TV=0) Or (TV>$80) then begin
          MR:=MessageDlg('Invalid ASCII code in card deck:-'+#$D+
                         'Card: '+IntToStr(IC+1)+' Column: '+IntToStr(CC)+#$D+
                         ' Char="'+CV+'" Value='+IntToHex(Ord(CV),2),
                         MTError,[MBOK,MBCancel],0);
          If MR=MRCancel then begin
            Reader.Clear;
            LACardCount.Caption:=IntToStr(Reader.Count);
            Exit;
          End;
        End;
      End;
   End;
end;
*)
function TReaderForm.CardCount: Word;
begin
  Result:=Reader.Count;
end;

function TReaderForm.ReadCard: TCard;
begin
  Result:=Reader.ReadCard;
  LACardCount.Caption:=IntToStr(Reader.Count);
end;

end.
