unit URecDisp;

interface

uses Windows,Messages,SysUtils,Classes,StdCtrls,
     Graphics,Controls,Forms,Dialogs;
//   I1401CNV;

Type TCard=String[80];
     TLine=String[132];

Type TURMode=(URMRDR,URMPUN,URMPRN);

Type TUnitRecordDisplay = class(TCustomControl)
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        Procedure Loaded;                                  Override;
      private
        SBVert:    TScrollBar;
        DrwBitMap: TBitMap;
        DrwCanvas: TCanvas;
        RecSize:   Integer;
        CharWid,
        CharHgt:  Integer;
        VisWid,
        VisHgt:   Integer;
        LftChar:  Integer;
        TopRec:   Integer;
        BotRec:   Integer;
        FURMode:  TURMode;
        SetOrLock: Boolean;
        procedure SBVertChange(Sender: TObject);
        procedure FontChanged(Sender: TObject);
        procedure SetDisplayOrigin(X, Y: Integer);
        procedure SetURMode(const Value: TURMode);
        procedure SetVSBMax;
      protected
        Procedure WMERASEBKGND(Var WM: TWMERASEBKGND);         Message WM_ERASEBKGND;
        procedure Paint; Override;
        procedure Resize; Override;
      public
        Records:  TStringList;
        procedure Clear;
        Function  Count: Word;
        Procedure LoadRecords(PN: String);
        Procedure SaveRecords(PN: String);
        Function  ReadCard: TCard;
        Procedure PunchCard(CD: TCard);
        Procedure PrintLine(PL: TLine);
      published
        Property URMode: TURMode Read FURMode Write SetURMode;
        Property Align;
        Property Font;
      end;

procedure Register;

implementation

Const SBSize=15;

procedure Register;
begin
  RegisterComponents('BertComps', [TUnitRecordDisplay]);
end;

Constructor TUnitRecordDisplay.Create(AOwner: TComponent);
Begin
  Inherited;
  Name:='UnitRecord';
  URMode:=URMRDR; RecSize:=80;
  Records:=TStringList.Create;
  TabStop:=True;
  Color:=CLWhite;
  Width:=100; Height:=100;
  Align:=ALLeft;
  LftChar:=1; BotRec:=1;
  With Font do begin
    Name:='lucidia console'; Size:=7; Pitch:=FPFixed;
  End;
//OnClick:=MOClick;
//OnDblClick:=DBClick;
  DrwBitMap:=TBitMap.Create;
  SBVert:=TScrollBar.Create(Self);
  With SBVert do begin
    Parent:=Self;       TabStop:=False;
    Kind:=SBVertical;   Align:=ALRight;
    Width:=SBSize;      OnChange:=SBVertChange;
  End;
{  SBHorz:=TScrollBar.Create(Self);
  With SBHorz do begin
    Parent:=Self;       TabStop:=False;
    Kind:=SBHorizontal; Align:=ALBottom;
    Width:=SBSize;      OnChange:=SBHorzChange;
  End;}
  Font.OnChange:=FontChanged;
  Resize;
End;

destructor TUnitRecordDisplay.Destroy;
begin
//SBHorz.Free;
  SBVert.Free;
  DrwBitMap.Free;
  Records.Free;
  inherited;
end;

procedure TUnitRecordDisplay.Loaded;
begin
  Inherited;
  Resize;
End;

procedure TUnitRecordDisplay.SetURMode(const Value: TURMode);
begin
  FURMode:=Value;
  If Records=NIL then Exit;
  Records.Clear;
  If Value=URMPRN then RecSize:=132 else RecSize:=80;
  Resize;
end;

procedure TUnitRecordDisplay.FontChanged(Sender: TObject);
begin
  Resize;
end;

procedure TUnitRecordDisplay.Resize;
begin
  Align:=ALLeft;
  Inherited;
  With DrwBitMap do begin
    With Canvas do begin
      Font.Assign(Self.Font);             // Set to same font as screen
      With TextExtent('WM') do begin
        CharWid:=CX Div 2; CharHgt:=CY;
      End;
    End;
    Width:=(CharWid*RecSize)+2;
    Self.Width:=Width+SBSize;
    Height:=Self.Height;
    VisHgt:=Height Div CharHgt;
    VisWid:=Width  Div CharHgt;
    DrwCanvas:=Canvas;                  // Make it available for drawing on
  End;
  If Parent<>NIL then
    Parent.Width:=Width+8;
  With SBVert do begin
    SmallChange:=1;
    LargeChange:=VisHgt;
    Min:=1; Max:=VisHgt;
  End;
  SetDisplayOrigin(1,1);
//Invalidate;
end;

procedure TUnitRecordDisplay.WMERASEBKGND(Var WM: TWMERASEBKGND);
begin
  WM.Result:=1;
end;

procedure TUnitRecordDisplay.Paint;
Var PY: Integer;
    RN: Word;
    RS: String[132];
begin
  Inherited;
  If CSLoading in ComponentState then Exit;
  If DrwBitMap=NIL then Exit;
  // Work with offscreen bitmap's canvas
  With DrwCanvas do begin
    // Clear it
    Brush.Color:=Self.Color;
    FillRect(Rect(0,0,Width,Height));
    Pen.Style:=PSSolid; Pen.Color:=CLBlack;
    If FURMode=URMRDR then begin
      RN:=BotRec;
      PY:=Height-CharHgt;
      While (PY>0) And (RN<=Records.Count) do begin
        RS:=Records[RN-1];
        RS:=Copy(RS,LftChar,RecSize);
        TextOut(0,PY,RS);
        Dec(PY,CharHgt); Inc(RN);
      End;
    End else Begin
      RN:=TopRec;
      If RN>Records.Count then RN:=Records.Count;
      PY:=0;
      While (PY<=Height) And (RN<=Records.Count) And (RN>0) do begin
        RS:=Records[RN-1];
        RS:=Copy(RS,LftChar,RecSize);
        TextOut(0,PY,RS);
        Inc(PY,CharHgt); Inc(RN);
      End;
    End;
    If CSDesigning in ComponentState then
      TextOut(0,0,StringOfChar('W',RecSize-1)+'X');
  End;
  // Update screen canvas from offscreen canvas
  Canvas.Draw(0,0,DrwBitMap);
//If Records.Count=0 then SBVert.Max:=1 else SBVert.Max:=Records.Count;
End;
{
procedure TUnitRecordDisplay.SBHorzChange(Sender: TObject);
begin
//SetDisplayOrigin(SBHorz.Position,BotRec);
end;
}
procedure TUnitRecordDisplay.SBVertChange(Sender: TObject);
begin
  If FURMode=URMRDR then
    SetDisplayOrigin(LftChar,SBVert.Max-SBVert.Position+1)
  Else
    SetDisplayOrigin(LftChar,SBVert.Position);
end;

procedure TUnitRecordDisplay.SetVSBMax;
begin
  If Records.Count=0 then SBVert.Max:=1
                     else SBVert.Max:=Records.Count;
End;

procedure TUnitRecordDisplay.SetDisplayOrigin(X,Y: Integer);
begin
  If SetOrLock then Exit;
  SetOrLock:=True;
  LftChar:=X;
  SetVSBMax;
  If Y>Records.Count then Y:=Records.Count;
  If Y<1 then Y:=1;
  If FURMode=URMRDR then begin
    BotRec:=Y;
    SBVert.Position:=SBVert.Max-Y+1;
  End else Begin
    TopRec:=Y;
    SBVert.Position:=Y;
  End;
  Invalidate;
//SBHorz.Position:=LftChar;
  SetOrLock:=False;
end;

function TUnitRecordDisplay.Count: Word;
begin
  Result:=Records.Count;
end;

procedure TUnitRecordDisplay.LoadRecords(PN: String);
begin
  Records.LoadFromFile(PN);
  SetDisplayOrigin(1,1);
end;

procedure TUnitRecordDisplay.SaveRecords(PN: String);
begin
  Records.SaveToFile(PN);
end;

function TUnitRecordDisplay.ReadCard: TCard;
begin
  Result:=Records[0];
  Records.Delete(0);
  SetVSBMax;
  Invalidate;
end;

Procedure TUnitRecordDisplay.PunchCard(CD: TCard);
begin
  Records.Add(CD);
  SetVSBMax;
  Invalidate;
end;

Procedure TUnitRecordDisplay.PrintLine(PL: TLine);
begin
  Records.Add(PL);
  SetVSBMax;
  Invalidate;
end;

procedure TUnitRecordDisplay.Clear;
begin
  Records.Clear;
  SetVSBMax;
  Invalidate;
end;

end.
