/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Nov-85 | [1.107] Created
* 15-Dec-85 | [1.204] Added draw_punch, check_punch
* 24-Dec-85 | [1.231] Removed right button cursor display
* 11-Jan-86 | [1.293] Use keyboard cursor controls
* 23-Jan-86 | [1.301] Use vmouse interface
* 24-Jan-86 | [1.314] Rewrote to use new 'scan' interface
* 24-Jan-86 | [1.321] Save cursor around screen draw
* 27-Jan-86 | [1.349] Save cursor position around activation
* 27-Jan-86 | [1.350] Added last part to scan call
* 22-Feb-86 | [1.362] do set_display and draw_current_screen to get
*           | instantaneous display in color
* 22-Feb-86 | [1.362] include <> => include ""
* 22-Feb-86 | [1.364] replace all printf with scdspmsg
* 22-Feb-86 | [1.364] FUll color support
* 31-Jul-86 | [1.405] Made lastkey unsigned
* 18-Aug-86 | [1.414] screen.h -> bscreen.h
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0
* 23-Nov-91 | [1.465] <jmn> moved polling to separate module
*  7-Dec-91 | [1.475] <jmn> use new keybindings table
* 23-Dec-91 | [1.538] <jmn> after initializing peripherals screen, wait for
*           | mouse up so a long mouse click doesn't blow us back to the
*           | console 
*****************************************************************************/

#include "stdio.h"
#include "boolean.h"

#include "btypes.h"
#include "scdspmsg.h"

#include "mouse.h"
#include "hercules.h"
#include "display.h"
#include "disp.h"
#include "graph.h"
#include "diag.h"
#include "periph.h"
#include "panel.h"
#include "keys.h"
#include "pr.h"
#include "print.h"
#include "cdr.h"
#include "cdp.h"
#include "button.h"
#include "kb.h"
#include "kbd.h"
#include "scan.h"
#include "alert.h"
#include "color.h"
#include "1401.h"

extern void draw_console(void);
extern boolean check_console(coord X, coord Y);

extern boolean done;	/* Power-off switch */
extern unsigned char lastkey;
static boolean pdone;

void activate_peripherals(mouse_coord mX,mouse_coord mY);
void periph_nop(mouse_coord mX,mouse_coord mY);

static keybindings kb =
	   { 
	    activate_peripherals,/* mouse left */
	    periph_nop,		/* mouse middle */
	    periph_nop,		/* mouse right */
	    ins_key,		/* INS */
	    del_key,		/* DEL */
	    move_y_up,		/* uparrow */
	    move_y_down,	/* downarrow */
	    move_x_left,	/* leftarrow */
	    move_x_right,	/* rightarrow */
	    pr_go,		/* pgup */
	    pr_go,		/* pgdn */
	    NULL,		/* home */
	    NULL,		/* end */
	    NULL,		/* c-left */
	    NULL,		/* c-right */
	    {
	     NULL,		/* 000 */
	     NULL,		/* ^A */
	     NULL,		/* ^B */
	     ctlc,		/* ^C */
	     NULL,		/* ^D */
	     NULL,		/* ^E */
	     NULL,		/* ^F */
	     NULL,		/* ^G */
	     NULL,		/* ^H */
	     NULL,		/* ^I */
	     NULL,		/* ^J */
	     NULL,		/* ^K */
	     draw_current_screen,/* ^L */
	     ins_key,		/* ^M */
	     NULL,		/* ^N */
	     NULL,		/* ^O */
	     ctlp,		/* ^P */
	     ctlq,		/* ^Q */
	     NULL,		/* ^R */
	     ctls,		/* ^S */
	     NULL,		/* ^T */
	     NULL,		/* ^U */
	     NULL,		/* ^V */
	     NULL,		/* ^W */
	     NULL,		/* ^X */
	     NULL,		/* ^Y */
	     NULL,		/* ^Z */
	     ctlc,		/* ^[ */
	     NULL,		/* ^\ */
	     NULL,		/* ^] */
	     NULL,		/* ^^ */
	     NULL		/* ^_ */
	    }
	   };


/****************************************************************************
*                            activate_peripherals
* Inputs:
*       mouse_coord mX: screen X of mouse hit
*	mouse_coord mY: screen Y of mouse hit
* Effect: 
*       Handles all peripherals activation.  Sets 'pdone' if necessary to
*	halt processing of peripherals screen scan
****************************************************************************/

void activate_peripherals(mouse_coord mX,mouse_coord mY)
    {
     coord X;
     coord Y;
     coord old_x;
     coord old_y;

     X = mouse_to_screen_x(mX);
     Y = mouse_to_screen_y(mY);

     sccurpos(&old_y, &old_x);

     if(check_console(X,Y)) 
        { /* quit */
	 pdone = true;
	 return;
	} /* quit */

     check_printer(X,Y);
     check_reader(X,Y);
     check_punch(X,Y);
     check_off_button(X,Y);

     if(done) 
        { /* quit */
	 pdone = true;
	 goto exit;
	} /* quit */
     check_reset_button(X,Y);
     check_diag(X,Y);

exit:
     sccurset(old_y, old_x);
     return;
    }

/****************************************************************************
*                                 periph_nop
* Inputs:
*       mouse_coord mX: X-coordinate of mouse hit
*	mouse_coord mY: Y-coordinate of mouse hit
* Effect: 
*       Does nothing
****************************************************************************/
/*ARGSUSED */

void periph_nop(mouse_coord mX,mouse_coord mY)
    {
     return;
    }

/****************************************************************************
*                               do_peripherals
* Effect: 
*       Handles all dispatching for the peripherals screen
****************************************************************************/

void do_peripherals()
    {
     clear_off();

     set_display(PERIPHERALS);

     draw_current_screen();

     show_mouse_cursor();

     pdone = false;
	 
     wait_for_mouse_up();

     scan(&pdone,&kb,false);

     clear_off();
    }

/****************************************************************************
*			    draw_peripherals_screen
* Effect: 
*	Draws all the peripherals information on the screen
****************************************************************************/

void draw_peripherals_screen()
    {
     coord x;
     coord y;

     hide_mouse_cursor();

     sccurpos(&y, &x);

     sccurset(0,0);
     _clearscreen(_GCLEARSCREEN);

     draw_printer();
     draw_reader();
     draw_punch();
     draw_console();
     draw_alerts();
     draw_reset_button();
     draw_off_button();
     draw_diagnostic_key();

     redraw_messages();

     sccurset(y,x);

     show_mouse_cursor();
    }


/****************************************************************************
*                              draw_peripherals
* Effect: 
*       Draws the 'peripherals' button on the screen
****************************************************************************/

void draw_peripherals()
    {
     unsigned char fore;
     unsigned char back;


     if(ismono())
        { /* mono */
	 fore = H_NORMAL;
	 back = 0;
	} /* mono */
     else
        { /* color */
	 fore = WHITE;
	 back = BLACK;
	} /* color */

     scdspmsg(peripherals_Y,peripherals_X,fore,back,  "ͻ");
     scdspmsg(peripherals_Y+1,peripherals_X,fore,back,"Peripherals");
     scdspmsg(peripherals_Y+2,peripherals_X,fore,back,"ͼ");
    }

/****************************************************************************
*                              draw_console
* Effect: 
*       Draws the 'console' button on the screen
****************************************************************************/

void draw_console()
    {
     unsigned char fore;
     unsigned char back;


     if(ismono())
        { /* mono */
	 fore = H_NORMAL;
	 back = 0;
	} /* mono */
     else
        { /* color */
	 fore = WHITE;
	 back = BLACK;
	} /* color */

     scdspmsg(console_Y,console_X,fore,back,  "ͻ");
     scdspmsg(console_Y+1,console_X,fore,back," Console ");
     scdspmsg(console_Y+2,console_X,fore,back,"ͼ");
    }
