/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 16-Nov-85 | [1.80] Created
* 25-Nov-85 | [1.133] Set cycle to B-cycle at end of execution
*  8-Dec-85 | [1.157] Set state to single_cycle_complete at the end of each
*           | run state completion.
*           | Add default case decode error trap
* 11-Dec-85 | [1.165] Use ~ (bitwise) not ! (logical) not
* 25-Jan-86 | [1.327] Check for bad inst length before checking for bad
*           | address 
* 25-Feb-86 | [1.379] include<> => include ""
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "boolean.h"

#include "mem1401.h"
#include "btypes.h"
#include "mach.h"
#include "diag.h"
#include "instr.h"
#include "alerts.h"
#include "ifetch.h"
#include "alert.h"

/* Machine State:	*/

#define CW_A_f_complete single_cycle(i_CW,A_f_complete)
#define CW_A_s_complete single_cycle(i_CW,A_s_complete)
#define CW_B_f_complete single_cycle(i_CW,B_f_complete)
#define CW_B_s_complete single_cycle(i_CW,B_s_complete)

/*****************************************************************************
				1401 Simulator

			  Clear Word Mark Instruction


			Clear Word Mark (Two Addresses)
			-------------------------------

Instruction format

Mnemonic	Op Code	A-address	B-address
--------        ------- ---------       ---------
CW		)	AAA		BBB

Function: A word mark is cleared at each address specified in the instruction.
The data at each address is undisturbed.  A word mark cannot be cleared in
core-storage location 000; if so, a process error occurs.

Word Marks:  Word marks are set at both the A- and B-addresses specified.

Address Registers After Operation:

I-Add		A-Add		B-Add
NSI		A-1		B-1

Chaining: This instruction can be chained to the preceding operation (if
that instruction left usable address-register contents) by supplying
only the operation code.


			 Clear Word Mark (One Address)
			 -----------------------------
Instruction format

Mnemonic	Op Code	A-address
--------        ------- ---------
CW		)	AAA		

Function: A word mark is cleared at the A-address specified in the
instruction.  The data at the address is undisturbed.  A word mark cannot be
cleared in core-storage location 000.

Word Marks:  A word marks is cleared at  the A-address specified.

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		A-1		A-1

Chaining: This instruction can be chained to the preceding operation (if
that instruction left usable address-register contents) by supplying
only the operation code.


*****************************************************************************/


/****************************************************************************
*                                   inst_CW
* result: boolean
*	true if instruction succeeded
*	false if instruction failed
* Effect: 
*	Executes clear-word-mark instruction
****************************************************************************/

boolean inst_CW()
    {
     tell_op(op_A|op_B);

     switch(I_cycle)
         {
	  case 1: /* chained */
	  case 4: /* one-address */
	  case 7: /* two-address */
	  	break;
	  default: /* Illegal length */
	  	illegal_length();
	  	return false;
	 }

     if(bad_address(A_addr)) 
     	{ /* bogus A */
	 cycle = cycle_A;
	 return false;
	} /* bogus A */

     if(bad_address(B_addr))
     	{ /* bogus A */
	 cycle = cycle_B;
	 return false;
	} /* bogus A */

      switch(single_cycle_state)
         { /* state decode */
	  case single_cycle_run:
	  	clear_wm(A_addr);
		clear_wm(B_addr);
		B = memory[B_addr];
		A_addr--;
		B_addr--;
		single_cycle_state = single_cycle_complete;
		break;
	  case single_cycle_start:
	  	B = memory[A_addr];
		cycle = cycle_A;
		single_cycle_state = CW_A_f_complete;
		break;
	  case CW_A_f_complete:
	  	A = B & (~word_mark);
		memory[A_addr] = A;
		cycle = cycle_A;
		switch(I_cycle)
		   { /* next state */
		    case 4:
		    	single_cycle_state = single_cycle_complete;
			break;
		    case 1:
		    case 7:
		    	single_cycle_state = CW_A_s_complete;
			break;
		   } /* next state */
		A_addr--;
		break;
	  case CW_A_s_complete:
	  	B = memory[B_addr];
		cycle = cycle_B;
		single_cycle_state = CW_B_f_complete;
		break;
	  case CW_B_f_complete:
	  	A = B & (~word_mark);
		memory[B_addr] = A;
		cycle = cycle_B;
		single_cycle_state = single_cycle_complete;
		B_addr--;
		break;
	  default:
		   { /* error */
		    tell("Bad instruction microstate decode---CW");
		    alert(alert_process);
		    tell_new_state("CW");
		    return false;
		   } /* error */
	 } /* state decode */

      tell_new_state("CW");
      return true;	
    }
