/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
*  6-Dec-85 | [1.151] Created change log
*  6-Dec-85 | [1.151] Added check_memory operation
* 24-Nov-91 | [1.177] <jmn> converted to C6.0
*****************************************************************************/
#include <stdio.h>
#include <err.h>
#include <error.h>

char memory[16000];


/****************************************************************************
*                                check_memory
* Inputs:
*       int i: Integer which is supposed to be within memory
* Result: int
*       An integer which is within memory.  If i was out of bounds
*	an error message is issued, and zero is returned
* Effect: 
*       May issue an error message
****************************************************************************/

unsigned check_memory(unsigned i)
    {
     char msg[80];

     if(i < 16000) 
	return i;

     sprintf(msg,"Attempt to put something in location %u, not in memory\n",i);
     error(err_operand,msg);

     return (unsigned) 0;
     
    }

