/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Jan-86 | [1.314] Created
* 24-Jan-86 | [1.319] Preserve cursor position around mouse msg
* 22-Feb-86 | [1.362] Use color
* 18-Aug-86 | [1.414] screen.h -> bscreen.h
*****************************************************************************/
/* #include "graph.h" */

#include "boolean.h"

#include "btypes.h"
#include "scdspmsg.h"

#include "disp.h"
#include "hercules.h"
#include "color.h"
#include "pause.h"
#include "display.h"

/****************************************************************************
*                                  dead_mouse
* Effect: 
*       Displays a dead mouse message
****************************************************************************/

void dead_mouse()
    { 
     coord x;
     coord y;
     coord row;
     unsigned char mouse_fore;
     unsigned char mouse_back;
     unsigned char msg_fore;
     unsigned char msg_back;

     if(ismono())
        { /* mono */
	 mouse_fore = H_NORMAL;
	 mouse_back = 0;

	 msg_fore = H_NORMAL;
	 msg_back = 0;
	} /* mono */
     else
        { /* color */
	 mouse_fore = COLOR_BROWN;
	 mouse_back = COLOR_BLACK;

	 msg_fore = COLOR_RED;
	 msg_back = COLOR_BLACK;
	} /* color */
	 
     sccurpos(&y, &x);
     sccurset(0,0);
     sc_setnocursor();
     sc_clearscreen();
     row = 6;
#define xpf(msg) scdspmsg(row++,0,mouse_fore,mouse_back,msg);
#define mpf(msg) scdspmsg(row++,0,msg_fore,msg_back,msg);

xpf("                 ___              ___");
xpf("                 \\  ___           \\   ___");
xpf("                  \\ \\              \\  \\");
xpf("                  _\\_\\______________\\__\\____");
xpf("                 /    \\                 \\   \\");
xpf("        ________/                            \\                  ^");
xpf("       / ___                                  \\                //");
xpf(" _____/                                        \\______________//");
xpf("o___________+__+______________________________________________/ ");
xpf("            U  U");
mpf("                     Your Mouse Appears to be Dead");
mpf("                  (there is no mouse driver installed)");
pause(2000);
sccurset(0,0);
sc_clearscreen();
sccurset(y, x);
sc_setnormalcursor();
}