/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Nov-85 | [1.107] Created
* 14-Dec-85 | [1.194] Do not worry about Mdown state, but force
*           | wait_for_mouse_up in various action routines
* 31-Dec-85 | [1.283] Added check_IOcheck call
* 11-Jan-86 | [1.294] Work with function keys
* 23-Jan-86 | [1.301] Use vmouse interface
* 27-Jan-86 | [1.350] Updated to use new scan interface
* 27-Jan-86 | [1.352] Transpose poll_ac and poll_ac2 parameters
* 27-Jan-86 | [1.353] Added check_addr_switches to console poll (checked
*           | decrement but not increment condition)
* 23-Feb-86 | [1.368] include <> => include ""
* 31-Jul-86 | [1.405] Made lastkey unsigned
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0
*****************************************************************************/

#include "stdio.h"
#include "graph.h"
#include "boolean.h"
#include "btypes.h"
#include "scdspmsg.h"

#include "mouse.h"
#include "keys.h"
#include "addr.h"
#include "periph.h"
#include "diag.h"
#include "iocheck.h"
#include "kb.h"
#include "kbd.h"
#include "scan.h"
#include "button.h"
#include "switches.h"
#include "enter.h"
#include "display.h"
#include "1401.h"

extern unsigned char lastkey;
void poll_console(short mX,short mY);

void poll_ac(mouse_coord mX,mouse_coord mY);
void poll_nop(short mX,short mY);
void poll_ac2(mouse_coord mX,mouse_coord mY);


static keybindings kb =
	   { 
	    poll_ac,		/* mouse left */
	    poll_nop,		/* mouse middle */
	    poll_ac2,		/* mouse right */
	    ins_key,		/* INS */
	    del_key,		/* DEL */
	    move_y_up,		/* uparrow */
	    move_y_down,	/* downarrow */
	    move_x_left,	/* leftarrow */
	    move_x_right,	/* rightarrow */
	    pr_go,		/* pgup */
	    pr_go,		/* pgdn */
	    NULL,		/* home */
	    NULL,		/* end */
	    NULL,		/* c-left */
	    NULL,		/* c-right */
	    {
	     NULL,		/* 000 */
	     NULL,		/* ^A */
	     NULL,		/* ^B */
	     ctlc,		/* ^C */
	     NULL,		/* ^D */
	     NULL,		/* ^E */
	     NULL,		/* ^F */
	     NULL,		/* ^G */
	     NULL,		/* ^H */
	     NULL,		/* ^I */
	     NULL,		/* ^J */
	     NULL,		/* ^K */
	     draw_current_screen,/* ^L */
	     ins_key,		/* ^M */
	     NULL,		/* ^N */
	     NULL,		/* ^O */
	     ctlp,		/* ^P */
	     ctlq,		/* ^Q */
	     NULL,		/* ^R */
	     ctls,		/* ^S */
	     NULL,		/* ^T */
	     NULL,		/* ^U */
	     NULL,		/* ^V */
	     NULL,		/* ^W */
	     NULL,		/* ^X */
	     NULL,		/* ^Y */
	     NULL,		/* ^Z */
	     ctlc,		/* ^[ */
	     NULL,		/* ^\ */
	     NULL,		/* ^] */
	     NULL,		/* ^^ */
	     NULL		/* ^_ */
	    }
	   };

/*****************************************************************************
				1401 Simulator

		       Poll console for operater actions

This module implements a subset of the main console loop polling, and is
called whenever there is a branch instruction or other control change
point.

The following switches can be activated in RUN mode when this is polled:

	STOP
	SSA-SSG
	OFF
	PERIPHERALS
	DIAGNOSTIC MODE

*****************************************************************************/


/****************************************************************************
*                                poll_console
* Inputs:
*       short X: mouse-X coordinate of mouse hit
*	short Y: mouse-Y coordinate of mouse hit
* Effect: 
*       Handles all console polling for run mode
****************************************************************************/

void poll_console(mouse_coord mX,mouse_coord mY)
    {
     coord X;
     coord Y;

     X = mouse_to_screen_x(mX);
     Y = mouse_to_screen_y(mY);

     check_addr_switches(X,Y,1);

     check_run_buttons(X,Y);

     check_switches(X,Y);	/* sense switches */

     check_peripherals(X,Y);	/* go handle peripherals */

     check_pattern_hit(X,Y);	/* Modify storage bit pattern */

     check_diag(X,Y);		/* diagnostic mode? */

     check_IOcheck(X,Y);	/* IO check switch touched? */

    }

/****************************************************************************
*                                   poll_ac
* Inputs:
*	mouse_coord mX:
*	mouse_coord mY:
* Effect: 
*       Activates the switches
****************************************************************************/

void poll_ac(mouse_coord mX,mouse_coord mY)
    {
     coord x;
     coord y;
     short M1, M2, M3, M4;

     sccurpos(&y, &x);

     hide_mouse_cursor();

     poll_console(mX,mY);
	 
     M1 = mouse_get_cursor;	/* handle any mouse changes */
     vmouse(&M1,&M2,&M3,&M4);
     M1 = mouse_set_cursor;
     vmouse(&M1,&M2,&M3,&M4); /* return cursor to original pos */

     sccurset(y,x);
     show_mouse_cursor();

    }

/****************************************************************************
*                                  poll_nop
* Inputs:
*       short mX:
*	short mY:
* Effect: 
*       Does nothing
****************************************************************************/
/*ARGSUSED */
void poll_nop(short mX,short mY)
    {
     return;
    }

/****************************************************************************
*                                  poll_ac2
* Inputs:
*       mouse_coord mX: mouse X-coordinate of hit
*	mouse_coord mY: mouse Y-coordinate of hit
* Effect: 
*       Handles decrement of address switches
****************************************************************************/

void poll_ac2(mouse_coord mX,mouse_coord mY)
    {
     coord x;
     coord y;

     sccurpos(&y, &x);

     check_addr_switches(mouse_to_screen_x(mX),
     			 mouse_to_screen_y(mY),-1);
     					/* Address switches decrement */

     sccurset(y,x);
    }

/****************************************************************************
*                                    poll
* Effect: 
*       Polls console during run mode and handles switches which may change
****************************************************************************/

void poll()
    {
     boolean once;

     once = false;

     scan(&once,&kb,true);

	 
    }

