/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 25-Feb-86 | [1.374] Created
* 2-Mar-92    <jrj>  Added "COLOR" prefix to avoid conflict with BORLAND C
* 2-Mar-92    <jrj>  Removed casts.  Since it is integertype < sizeof int OK
* 8-Mar-92    <jrj>  Copied in contents of scr.h (COLOR_, RGB_)
* 8-Mar-92    <jrj>  Moved RGB macro in from VPRINTER.C
* 15-Mar-92   <jrj>  Change RGB macro, add EGA_COLOR macro for BORLAND C
*****************************************************************************/
/* Colors used by the address and data register displays */

/*
	Macros take 3 BORLAND style color values (high 6 bits) and put
	them in 3 bytes per long, lower 6 bits per byte (ala  MicroSoft)
*/

#define RGB(r,g,b) ( ((long)((b) & 0xfc) << 14L) + \
		     ((long)((g) & 0xfc) << 6L ) + \
		     ((long)((r) & 0xfc) >> 2L ) )

#define RGB_R(rgb) ( (rgb) & 0x3f )
#define RGB_G(rgb) ( ((rgb) >> 8) & 0x3f)
#define RGB_B(rgb) ( ((rgb) >> 16) & 0x3f)

/*
	Special macro to take a 6 bit color intensity value and
	map it into a 2 bit value over 4 bits as used by BORLAND's
	setpalette function(for EGA)
*/
#define EGA_COLOR(c) ( (((c) & 0x20) >> 5) | (((c) & 0x10) >> 1) )

#define digit_off COLOR_BLACK
#define digit_on  COLOR_LTRED

#define legend_fore COLOR_WHITE
#define legend_back COLOR_BLACK

#define control_fore COLOR_LTBLUE
#define control_back COLOR_BLACK

#define COLOR_BLACK	0
#define COLOR_BLUE	1
#define COLOR_GREEN	2
#define COLOR_CYAN	3
#define COLOR_RED	4
#define COLOR_MAGENTA	5
#define COLOR_BROWN	6
#define COLOR_WHITE	7
#define COLOR_GRAY	8
#define COLOR_LTBLUE	9
#define COLOR_LTGREEN	10
#define COLOR_LTCYAN	11
#define COLOR_LTRED	12
#define COLOR_LTMAGENTA	13
#define COLOR_YELLOW	14
#define COLOR_BRIGHT	15

#ifdef __BORLANDC__

#include <graphics.h>

#define	RGB_BLACK	RGB(0x00,0x00,0x00)
#define RGB_BLUE	RGB(0x00,0x00,0xa8)
#define RGB_GREEN	RGB(0x00,0xa8,0x00)
#define RGB_CYAN	RGB(0x00,0xa8,0xa8)
#define RGB_RED		RGB(0xa8,0x00,0x00)
#define RGB_MAGENTA	RGB(0xa8,0x00,0xa8)
#define RGB_BROWN    	RGB(0xa8,0x54,0x00)
#define RGB_WHITE	RGB(0xa8,0xa8,0xa8)
#define RGB_GRAY	RGB(0x54,0x54,0x54)
#define RGB_LIGHTBLUE	RGB(0x54,0x54,0xfc)
#define RGB_LIGHTGREEN	RGB(0x54,0xfc,0x54)
#define RGB_LIGHTCYAN	RGB(0x54,0xfc,0xfc)
#define RGB_LIGHTRED	RGB(0xfc,0x54,0x54)
#define RGB_LIGHTMAGENTA RGB(0xfc,0x54,0xfc)
#define RGB_YELLOW	RGB(0xfc,0xfc,0x54)
#define RGB_BRIGHTWHITE	RGB(0xfc,0xfc,0xfc)

#endif

#ifndef __BORLANDC__

#include <graph.h>

#define	RGB_BLACK	_BLACK
#define RGB_BLUE	_BLUE
#define RGB_GREEN	_GREEN
#define RGB_CYAN	_CYAN
#define RGB_RED		_RED
#define RGB_MAGENTA	_MAGENTA
#define RGB_BROWN	_BROWN
#define RGB_WHITE	_WHITE
#define RGB_GRAY	_GRAY
#define RGB_LIGHTBLUE	_LIGHTBLUE
#define RGB_LIGHTGREEN	_LIGHTGREEN
#define RGB_LIGHTCYAN	_LIGHTCYAN
#define RGB_LIGHTRED	_LIGHTRED
#define RGB_LIGHTMAGENTA _LIGHTMAGENTA
#define RGB_YELLOW	_YELLOW
#define RGB_BRIGHTWHITE	_BRIGHTWHITE

#endif
