/*

  E11 definitions for user-written DLLs compiled with Watcom C.

  Copyright (C) 1999-2006 by Digby's Bitpile, Inc.  All rights reserved.

  01/13/1999	JMBW	Created.
  04/28/2001	JMBW	Opcode emulation entry points.
  08/13/2002	JMBW	Thread management entry points.
  06/01/2004	JMBW	32-bit version, supports Digital Mars C too.

*/

/* E11 uses Win32-style calling conventions for its visible entry points */
#define E11API __stdcall

typedef unsigned long dword;
typedef unsigned short word;

typedef dword addr16;		/* virtual address */
typedef dword addr18;		/* Unibus address */
typedef dword addr22;		/* Q22 or physical address */

/* this is all for the DllMain() declaration: */

#ifndef APIENTRY
#define APIENTRY __stdcall
#endif

#ifndef WINAPI
#define WINAPI __stdcall
#endif

#ifndef BOOL
#define BOOL int
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef HINSTANCE
#define HINSTANCE dword
#endif

#ifndef DWORD
#define DWORD dword
#endif

#ifndef LPVOID
#define LPVOID void *
#endif

#ifndef DLL_PROCESS_ATTACH
#define DLL_PROCESS_ATTACH 1
#endif

#ifndef DLL_PROCESS_DETACH
#define DLL_PROCESS_DETACH 0
#endif

/* handles for the various types of allocatable queue elements etc. */

#ifndef E11HANDLE
#define E11HANDLE dword
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

/* general-purpose entry points */

unsigned long E11API E11Version(void);
	/* get E11 version number (major in bits 31:8, minor in bits 7:0) */

void *(E11API GetItem(const char *itemname));
	/* get value corresponding to item */

void *(E11API GetMemory(dword numbytes));
	/* allocate memory */

void E11API RetMemory(void *memory);
	/* free memory */

E11HANDLE E11API GetDelayQel(void);
	/* get delay queue element */

void E11API RetDelayQel(E11HANDLE handle);
	/* return delay queue element */

/* host file I/O (similar to C library routines) */

#define O_RDONLY 0
#define O_WRONLY 1
#define O_RDWR 2
#define O_CREAT 0x20	/* (must use O_CREAT|O_TRUNC_O|WRONLY together) */
#define O_TRUNC 0x40	/* (i.e. same as creat) */
#define O_TEXT 0x4000	/* use MS/Borland value (Watcom uses 0x100) */
#define O_BINARY 0x8000	/* use MS/Borland value (Watcom uses 0x200) */

int open(const char *name,int flags,...);	/* open or create */
int creat(const char *name,int mode);		/* just create */
int read(int fd,void *buf,int count);
int write(int fd,void *buf,int count);
int close(int fd);

/* fork queue service */

E11HANDLE E11API GetForkQel(void);
	/* get FORK queue element */

void E11API RetForkQel(E11HANDLE handle);
	/* return FORK queue el */

void E11API EnqueueFork(E11HANDLE handle,void E11API (*crtn)(dword),
	dword parm);
	/* enqueue FORK event */
	/* (CALL WITH INTERRUPTS DISABLED IF RUNNING UNDER DOS/STANDALONE) */

void E11API DequeueFork(E11HANDLE handle);
	/* dequeue FORK event */

/* peripheral emulation */

E11HANDLE E11API GetCSRBlock(dword first,dword wc,
	word E11API (*dati)(),void E11API (*dato)(),void E11API (*init)());
	/* get block of CSR addresses */

void E11API RetCSRBlock(E11HANDLE ptr);
	/* return CSR block */

/* emulated interrupts */

E11HANDLE E11API GetIntQel(dword level,dword rank,dword vec);
	/* get interrupt queue element */

void E11API SetIntVec(E11HANDLE handle,dword vec);
	/* adjust interrupt vector on interrupt queue element */

void E11API RetIntQel(E11HANDLE handle);
	/* return interrupt queue element */

void E11API EnqueueInt(E11HANDLE handle,int E11API (*crtn)(dword),dword parm);
	/* enqueue interrupt queue element */

void E11API DequeueInt(E11HANDLE handle);
	/* dequeue interrupt queue element */

/* emulated DMA */

long E11API AbsTransfer(dword func,addr22 pdp11addr,void *x86addr,dword len);
	/* perform DMA transfer using absolute (i.e. no) mapping */

long E11API MapTransfer(dword func,addr18 pdp11addr,void *x86addr,dword len);
	/* perform DMA transfer using Unibus map, if any */

/* function codes for AbsTransfer() and MapTransfer() */
#define TOPDP 0		/* copy from host memory to emulated PDP-11 memory */
#define TOHOST 1	/* copy from emulated PDP-11 memory to host memory */
#define COMPARE -1	/* compare the two */

/* entry points for dealing with physical PC hardware (DOS/standalone only) */

void *(E11API GetPhysWind(dword base,dword size));
	/* get physical window to memory-mapped device */

void E11API RetPhysWind(void *addr);
	/* free physical memory window */

void E11API GetHWIntVec(dword irq,word *sel,dword *offs);
	/* get hardware interrupt vector (DOS/standalone only) */

void E11API SetHWIntVec(dword irq,dword sel,dword offs);
	/* set hardware interrupt vector */

/* thread management (Linux/Win32 only) */

E11HANDLE E11API SpawnThread(const char *title);
	/* spawn a new thread */

void E11API KillThread(E11HANDLE thread);
	/* kill thread */

void E11API StopThread(E11HANDLE thread);
	/* stop thread execution (SIGSTOP => SIGCHLD) */

void E11API ContThread(E11HANDLE thread);
	/* continue execution of stopped thread */

/* user-defined opcode emulation */

E11HANDLE E11API GetOpcode(dword first,dword wc,void E11API (*exec)(),
	void E11API (*init)());
	/* get block of opcodes */

void E11API RetOpcode(E11HANDLE ptr);
	/* return opcode block */

dword E11API GetReg(dword regnum);
	/* read register value */

void E11API SetReg(dword regnum,dword value);
	/* write register value */

dword E11API GetPSW(void);
	/* read processor status word */

void E11API SetPSW(dword value);
	/* write processor status word */

long E11API Peek(dword space,addr16 pdp11addr);
	/* peek (word) into virtual memory */

long E11API PeekB(dword space,addr16 pdp11addr);
	/* peek (byte) into virtual memory */

int E11API Poke(dword space,addr16 pdp11addr,dword data);
	/* poke into virtual memory */

int E11API PokeB(dword space,addr16 pdp11addr,dword data); 
	/* poke byte into virtual memory */

/* values for "space" parameter */
#define KD 0		/* kernel */
#define KI 1
#define SD 2		/* supervisor */
#define SI 3
#define UD 6		/* user */
#define UI 7
#define D 8		/* current */
#define I 9
#define PD 10		/* previous */
#define PI 11

long E11API PeekCD(addr16 pdp11addr);
	/* peek from current D space */

long E11API PeekBCD(addr16 pdp11addr);
	/* peek byte from current D space */

int E11API PokeCD(addr16 pdp11addr,dword data);
	/* poke into current D space */

int E11API PokeBCD(addr16 pdp11addr,dword data);
	/* poke byte into current D space */

long E11API PeekPhys(addr22 pdp11addr);
	/* peek from physical memory space */

long E11API PeekBPhys(addr22 pdp11addr);
	/* peek byte from physical memory */

int E11API PokePhys(addr22 pdp11addr,dword data);
	/* poke into physical memory space */

int E11API PokeBPhys(addr22 pdp11addr,dword data);
	/* poke byte into physical memory */
