.;Don't forget to change PATLEV as well as VERSION in .MODULE
.;.MODULE SYSGEN,RELEASE=V05,VERSION=150,COMMENT=<SYSGEN Control File>
.;
.; Copyright (c) 1998 by Mentec, Inc., Nashua, NH.
.; All rights reserved
.;
.; This software is furnished under a license for use only on a
.; single computer system and  may  be  copied  only  with  the
.; inclusion of the above copyright notice.  This software,  or
.; any other copies thereof, may not be provided  or  otherwise
.; made available to any other person except for  use  on  such
.; system and to one who agrees to these license  terms.  Title
.; to  and  ownership of the software shall at all times remain
.; in Mentec, Inc.
.;
.; The information in this document is subject to change without
.; notice and should not be construed as a commitment by Digital
.; Equipment Corporation, or Mentec, Inc.
.;
.; Digital and Mentec  assume  no  responsibility for the use or
.; reliability of its software on equipment which is not supplied
.; by Digital  or Mentec,  and listed  in the  Software  Product
.; Description.

.SETS PATLEV	"V05.150"	.;SYSGEN version number
.SETS CPRTYR	"1998" .;Year for copyrights in output files

.BEGIN:	.DISABLE PREFIX
	.DISABLE SUFFIX
	.ENABLE ESCAPE
	.ENABLE QUIET

.; Parameters:
.;
.; P1 = LIST/NOLIST create assembly listing files
.; P2 = QUERY or NOQUERY
.; P3 = Name of answer file to be used (only if NOQUERY)
.; P4 = True/False, should SYSG$N conditional be generated
.;
.; The following ensures that parameters are uppercase for tests
	.DISABLE LOWERCASE
	.SETS P1 "'P1'"
	.SETS P2 "'P2'"
	.SETS P3 "'P3'"
	.SETS P4 "'P4'"
	.ENABLE LOWERCASE

	.SETS ANSFIL "SYSGEN.ANS"
	.SETT GENSYS
	.SETF LST
	.SETF NOQ
	.IF P1 EQ "" .GOTO WH5
	.IF P1 EQ "LIST" .SETT LST
	.IF P2 EQ "" .GOTO WH1
	.SETS TEMPS P2[1:3]
	.IF TEMPS EQ "NOQ" .SETT NOQ
	.IF P3 EQ "" .GOTO WH1
	.SETS ANSFIL P3
	.IF P4 EQ "" .GOTO WH1
	.SET'P4' GENSYS
.WH1:	;
	.IFT NOQ ;	*** SYSGEN being run in NOQUERY mode
	.IFT NOQ ;	*** Answer file being used: 'ANSFIL'
	.IFF GENSYS ;	*** SYSG$N conditional will not be output
	.IFT LST ;	*** Listing files will be created on device LST:
.WH5:	.SETT VT100
	.SETN UDEVCT 0
	.SETN MAXUDV 32.
	.SETN EMPTY 0
	.SETN UPNO 0
	.SETS CANSF ""
	.SETS LP1 "P"	;CTS-300 PRINTERS
	.SETS LP2 "Q"
	.SETS LP3 "R"
	.SETS LP4 "S"
	.SETS LPID1 "3"	;LPn
	.SETS LPID2 "31";LQn
	.SETS LPID3 "32";LRn
	.SETS LPID4 "33";LSn
	.SETS C1 "first"
	.SETS C2 "second"
	.SETS C3 "third"
	.SETS C4 "fourth"
	.SETS C5 "fifth"
	.SETS C6 "sixth"
	.SETS C7 "seventh"
	.SETS C10 "eighth"
	.SETS C11 "ninth"
	.SETS C12 "tenth"
	.SETS C13 "eleventh"
	.SETS C14 "twelfth"
	.SETS C15 "thirteenth"
	.SETS C16 "fourteenth"
	.SETS C17 "fifteenth"
	.SETS C20 "sixteenth"
	.SETS HEXSTR "0123456789ABCDEF"
	.SETF CHANGE
	.SETT NOPRO
	.SETS SYCND "SYSGEN.CND"
	.SETS SYFIL SYCND
	.SETS DEVTBL "SYSGEN.TBL"
	.SETS DEVFIL DEVTBL
	.SETS MONBLD "SYSGEN.MON"
	.SETS DEVBLD "SYSGEN.DEV"
	.SETS SYSBLD "SYSGEN.BLD"

.; DEVBND is list of handlers that require /BOUND:512. on link command
.; because they use SET overlay(s)

	.SETS DEVBND " DU DW LS LD MU NQ NU SP "

.; DEV64 is list of extended-unit handlers with the default number of
.; units for the # of units question.
.;
.; To add an extended-unit handler to sysgen: 1) Insert the handler name
.; in this list along with the default number of units. 2) Add code to the
.; .CND file output routines (DU is by label .G90:, LD is by label .G141:)
.; to output the dd$N64 flag and dd$UNI=n. assignment. 3) Add code to the
.; end of question 160 (label ".Q160:") to setup and call XUNIT for the new
.; device when changing 64 unit support. 4) Add code after Z27 (below) to
.; initialize dd$N64 to FALSE and dd$UNI to 8.

	.SETS DEV64 "DU=16,LD=16"

.; DEVSTR is list of "known" handler names

	.SETS DEVSTR " DX DY RK DL DM MT MM MS MU NL LD VM DZ DW SP XL XC NC NQ NU LP DU LS "

.; DEVSTR should correspond to DCMnn as listed below:

	.SETS DCM1 "DX  RX01 Single-Density Diskette"
	.SETS DCM2 "DY  RX02 Double-Density Diskette"
	.SETS DCM3 "RK  RK05 Cartridge Disk         "
	.SETS DCM4 "DL  RL01/RL02 Cartridge Disk    "
	.SETS DCM5 "DM  RK06/RK07 Cartridge Disk    "
	.SETS DCM6 "MT  TM11 (UNIBUS) Magtape       "
	.SETS DCM7 "MS  TS11,TU80/TSV05/TSU05 Tape  "
	.SETS DCM10 "MM  TJU16 (MASSBUS) Magtape     "
	.SETS DCM11 "NL  Null Handler                "
	.SETS DCM12 "LP  Line Printer                "
	.SETS DCM13 "DU  MSCP Disk Class Handler     "
	.SETS DCM14 "LD  Logical Disk Handler        "
	.SETS DCM15 "VM  Virtual Memory Handler      "
	.SETS DCM16 "DZ  RX50 PRO Series             "
	.SETS DCM17 "DW  RD50/51/52 PRO Series       "
	.SETS DCM20 "SP  Transparent Spooling Handler"
	.SETS DCM21 "XL  VTCOM Communications Handler"
	.SETS DCM22 "XC  VTCOM Handler PRO Series    "
	.SETS DCM23 "MU  TMSCP Magtape Class Handler "
	.SETS DCM24 "NC  Ethernet Handler PRO Series "
	.SETS DCM25 "NQ  Ethernet Handler for Q-BUS  "
	.SETS DCM26 "NU  Ethernet Handler for UNIBUS "

	.SETN CTSMAX 26
.;; END OF CTS HANDLERS

	.SETS DCM27 "LS  Serial Line Printer         "
	.SETN MAXDEV 27
	.SETN RTDEVS MAXDEV


	.SETN CNT 1
.Z27:
	.SETS DCOM DCM'CNT'[1:2]
	.SETF 'DCOM'
	.INC CNT
	.IF CNT LE RTDEVS  .GOTO Z27
	.SETF LPP
	.SETF LQP
	.SETF LRP
	.SETF LSP
	.SETF LPS
	.SETF LQS
	.SETF LRS
	.SETF LSS
	.SETF MT$FSM
	.SETF MM$FSM
	.SETF MS$FSM
	.SETF MU$FSM
	.SETF PROCTS
	.SETF BU$BBR
	.SETF BU$BOO
	.SETF CTS
	.SETF SWIT
	.SETF UNI$64
	.SETF DU$N64
	.SETN DU$UNI 8.
	.SETF LD$N64
	.SETN LD$UNI 8.
	.SETF OWN$ER
	.SETS LINK "LINK/NOBITMAP/EXE:BIN:"
	.SETS MAP ""
	.IFT LST .SETS MAP "/MAP:LST:"
	.SETS LODDEV ""

	.SETS STARS "*****************************************************************"
	;
	;
	; 'STARS'
	; 		RT-11 SYSTEM GENERATION PROGRAM 'PATLEV'
	; 'STARS'
	;
.INASK:
	.IFT NOQ .GOTO ANSFL
	;
	.ASK ANS Do you want an introduction to system generation (N)?
	.IFF <ESCAPE> .GOTO IN10
	;
	; Type  "Y"  for  a  detailed  explanation of the system generation
	; process.
	.GOTO INASK

.IN10:	.IFF ANS .GOTO CTSCHK
	;
	; The  System  Generation (SYSGEN)  program  functions as an inter-
	; active  dialog  in  which  the  program  asks  you  a  series  of
	; questions.   Your   answers  establish  the  characteristics  and
	; features  of  the monitor(s) and device handlers that the program
	; generates.  SYSGEN  prints  each  question  and  waits  for  your
	; response.  You  can  reply  immediately with a valid response, or
	; you can obtain a detailed explanation of the  question  by typing
	; the  ESCAPE  key  followed  by  the  RETURN key.  You can prevent
	; SYSGEN from printing the entire explanation  by  typing  <CTRL/O>
	; at  any  time during the explanation.  SYSGEN then stops printing
	; the  explanation,   prints  the  question,  and  waits  for  your
	; response.
	;
	; SYSGEN  can  generate one or more monitors from the output of one
	; dialog  session, depending  on  the responses you give.  However,
	; your  responses  during  a  session  apply  to  all  the monitors
	; generated  during  that  session.
	.IFF VT100 .GOTO IN20
	;
	.ASK CONTIN Type RETURN to continue
.IN20:	;
	; The system generation process produces two conditional files  and
	; three  indirect command files as output.  To produce these files,
	; the  SYSGEN  dialog  asks  you  questions about the target system
	; configuration  and  about  monitor and device support options you
	; want.  To  be able to respond effectively, you  should  read  the
	; RT-11 SYSTEM GENERATION GUIDE before proceeding.
	;
	; The  dialog  simply  asks a question and waits for your response.
	; Although the dialog questions are  sequentially numbered, certain
	; responses cause SYSGEN to skip some  questions which do not apply
	; for the system you are generating.
	;
	; Dialog  questions  require  one  of  several  types of responses.
	; Responses may be in the form of a character string, a number,  or
	; YES/NO  (Y/N).   SYSGEN  expects a decimal number for all numeric
	; answers  except  for CSR and vector addresses;  in these cases it
	; expects  an  octal  number.  A  default response, in parentheses,
	; follows  each  question.   If  you  choose  to  use  the  default
	; response, type only RETURN in response to the question.
	;
	; To terminate SYSGEN at any time, type <CTRL/C>.

.;;
.;; Check if this is a CTS SYSGEN
.;;
.CTSCHK:
	.TESTFILE SYSGEN.CTS
	.IF <FILERR> NE <SUCCES> .GOTO PCTSCK
	;
	.ASK [<TRUE>] CTS Do you want the CTS-300 dialog (Y)?
	.IFF <ESCAPE> .GOTO CTS5
	;
	; To  generate  a  CTS-300  system,  SYSGEN must change some of the
	; default responses, and add or remove some  of the  questions.  If
	; you are generating a CTS-300 system, type "Y" in response to this
	; question.
	.GOTO CTSCHK

.CTS5:	.IFT CTS .GOTO CTS10

.PCTSCK:
	.TESTFILE PROCTS.ANS
	.IF <FILERR> NE <SUCCES> .GOTO ANSFL
	;
	.ASK [<TRUE>] PROCTS Do you want the Professional CTS-300 dialog (Y)?
	.IFF <ESCAPE> .GOTO CTS10
	;
	; To generate  a  Professional  CTS-300  system, SYSGEN must change
	; some  of  the  default  responses, and add or remove some  of the
	; questions.  If  you  are generating a CTS-300 system, type "Y" in
	; response to this question.
	.GOTO PCTSCK

.CTS10:	.IFT PROCTS .SETT CTS
	.SETN HIGHL CTSMAX*3+1
	.IFT CTS .SETS DEVSTR DEVSTR[1:'HIGHL']
	.IFT CTS .SETN MAXDEV CTSMAX

.;;
.;; See if an answer file is to be used
.;;
.ANSFL:
	.SETT ANS
	.IFT NOQ .GOTO AN30
	;
	.ASK ANS Do you want to use a previously created answer file (N)?
	.IFF <ESCAPE> .GOTO AN10
	;
        ; SYSGEN can use commands and responses contained in an answer file
	; to  determine  the  characteristics  of  the  monitors and device
	; handlers  for your target system.  If you choose to use an answer
	; file,  SYSGEN uses  the  responses in the answer file instead  of
	; printing the interactive dialog to obtain your responses.
	;
	; Answer  files  that  create the distributed monitors and handlers
	; are  included  on  the  RT-11  distribution kit. You can also use
	; answer  files  that you have created during earlier system gener-
	; ation sessions.
	.GOTO ANSFL

.AN10:	.IFF ANS .GOTO CRLOG

.AN20:
	.SETS ANSFIL "SYSGEN.ANS"
	.IFT CTS .SETS ANSFIL "SYSGEN.CTS"
	.IFT PROCTS .SETS ANSFIL "PROCTS.ANS"
	;
	.DISABLE LOWERCASE
	.ASKS [1:14.:ANSFIL] ANSFIL What answer file do you want to use ('ANSFIL')?
	.ENABLE LOWERCASE
	.IFF <ESCAPE> .GOTO AN30
	.GOSUB CR25
	.GOTO AN20

.AN30:	.SETS FILE ANSFIL
	.SETS DEFFIL "SYSGEN"
	.SETS DEFEXT "ANS"
	.SETF NOPRO
	.GOSUB FILTST
	.SETS ANSNAM FIL
	.SETT NOPRO
	.SETS ANSFIL FILE
	.IFF FILST .GOTO ANSFL
	.TESTFILE 'ANSFIL'
	.IF <FILERR> = 1 .GOTO CRLOG
	.IF <FILERR> = 346 .GOTO FNFND
	;
	; ?SYSGEN-F-Input error 'ANSFIL'
	.EXIT 4

.FNFND:	;
	; ?SYSGEN-E-File not found 'ANSFIL'
.AN40:
	;
	.ASK CONTIN Do you want to continue this session (N)?
	.IFF <ESCAPE> .GOTO AN50
	;
	; The answer file you entered was not on the specified  device.  If
	; you  want  to re-enter an answer file name type Y.  Type N if you
	; want to terminate this session.
	.GOTO AN40

.AN50:	.IFT CONTIN .GOTO ANSFL
	.EXIT

.;;
.;; See if an answer file is to be created.
.;;
.CRLOG:
	.SETF Q
	.IFT NOQ .GOTO CR10
	;
	.ASK Q Do you want to create an answer file (N)?
	.IFF <ESCAPE> .GOTO CR10
	;
	; Type Y to create an answer  file  that reflects the responses you
	; make  during this session.  This answer file can be used during a
	; later SYSGEN session.
	.GOTO CRLOG
.CR10:	.IFF Q .GOTO PICKWF
.CR20:
	.SETS CANSF "SYSGEN.ANS"
	.IFT CTS .SETS CANSF "SYSGEN.CTS"
	.IFT PROCTS .SETS CANSF "PROCTS.ANS"
	;
	.DISABLE LOWERCASE
	.ASKS [1:14.:CANSF] CANSF What answer file do you want to create ('CANSF')?
	.ENABLE LOWERCASE
	.IFF <ESCAPE> .GOTO CR30
	.GOSUB CR25
	.GOTO CR20

.CR25:	;
	; Type the device, filename and  filetype  of  the  answer file you
	; want to create.  Use the following format for your response:
	;
	;	ddn:filnam.typ
	;
	; The variable  ddn is  the device  name and unit number where  the
	; answer  file  is  to  reside, and  filnam.typ is the filename and
	; filetype of the answer file you are creating.
	.RETURN

.CR30:	.SETS FILE CANSF
	.SETS DEFFIL "SYSGEN"
	.SETS DEFEXT "ANS"
	.GOSUB FILTST
	.SETS QNAM FIL
	.SETS CANSF FILE
	.IFF FILST .GOTO CRLOG
	.TESTFILE 'CANSF'
	.IF <FILERR> NE 1 .GOTO PICKWF
	;
	; ?SYSGEN-W-File already exists 'CANSF'
.CR40:
	;
	.ASK Q1 Do you want to create a new 'CANSF' file (N)?
	.IFF <ESCAPE> .GOTO CR50
	;
	; A file already exists with the  same  name as the answer file you
	; have  chosen  to  create.  If you still want to use this name for
	; your  output  answer  file, the  data  contained  in  the already
	; existing file of the same name will be lost.
	.GOTO CR40

.CR50:	.IFF Q1 .GOTO CRLOG

.;;
.;; Pick names for work files
.;;
.PICKWF:
	;
	;	...checking for protected output files.
	.SETS SYCND "SYSGEN.CND"
	.SETS DEVTBL "SYSGEN.TBL"
	.SETS MONBLD "SYSGEN.MON"
	.SETS DEVBLD "SYSGEN.DEV"
	.SETS SYSBLD "SYSGEN.BLD"
	.IFF ANS .GOTO PI6
	.SETS SYCND ANSNAM+".CND"
	.SETS DEVTBL ANSNAM+".TBL"
	.SETS MONBLD ANSNAM+".MON"
	.SETS DEVBLD ANSNAM+".DEV"
	.SETS SYSBLD ANSNAM+".BLD"
.PI6:	.IFF Q .GOTO PI7
	.SETS SYCND QNAM+".CND"
	.SETS DEVTBL QNAM+".TBL"
	.SETS MONBLD QNAM+".MON"
	.SETS DEVBLD QNAM+".DEV"
	.SETS SYSBLD QNAM+".BLD"
.PI7:	.SETS SYFIL SYCND
	.SETS DEVFIL DEVTBL

	.SETF NOPRO
	.SETS FILE SYCND
	.GOSUB FILTST
	.IFF FILST .GOTO PICKWF

	.SETS FILE DEVTBL
	.GOSUB FILTST
	.IFF FILST .GOTO PICKWF

.;; Check for output files protected
	.SETS FILE MONBLD
	.GOSUB FILTST
	.SETS FILE DEVBLD
	.GOSUB FILTST
	.SETS FILE SYSBLD
	.GOSUB FILTST

	.SETT NOPRO
	.SETS FILE "('SYCND','DEVTBL')"
	.GOSUB FLCHK
	.SETS FILE "('MONBLD','DEVBLD','SYSBLD')"
	.GOSUB FLCHK

	.IFT ANS .GOTO READA
	.GOTO MTYPE

.;;Test a filename for validity.
.;;Input: FILE-filename   DEFFIL-default file DEFEXT-default extension
.;;	  NOPRO = <FALSE> - dont check for protect file
.;;Output:  FILST = <TRUE> -> Good   FILST = <FALSE> -> Bad
.;;	    FILTYP = Filename without device specification
.;; It also checks to see if a protected file already exists with the
.;; given name.

.FILTST:
	.SETF FILST
	.TEST FILE ":"
	.IF <STRLEN> EQ 0 .GOTO NODEV
	.PARSE FILE ":." DEV FIL TYP
	.GOTO FL10

.NODEV:	.SETS DEV ""
	.PARSE FILE "." FIL TYP
.FL10:	.TEST DEV
	.IF <STRLEN> GT 3 .OR.IFF <ALPHAN> .GOTO FLBAD
	.TEST FIL
	.IF <STRLEN> EQ 0 .SETS FIL DEFFIL
	.IF <STRLEN> GT 6 .OR .IFF <ALPHAN> .GOTO FLBAD
	.TEST TYP
	.IF <STRLEN> EQ 0 .SETS TYP DEFEXT
	.IF <STRLEN> GT 3 .OR .IFF <ALPHAN> .GOTO FLBAD

.;; Filename is OK
	.IF DEV EQ "" .OR .IF DEV EQ "SY" .OR .IF DEV EQ "DK" .GOTO FL20
	.TESTDEVICE 'DEV'
	.TEST <EXSTRI> "LOD"
	.IF <STRLEN> <> 0 .GOTO FL20
	LOAD 'DEV'
	.IF <EXSTAT> EQ <SUCCES> .GOTO FL19

.FLBAD:	;
	; ?SYSGEN-E-Invalid filename: 'FILE'
	.RETURN

.FL19:	.IF LODDEV <> "" .SETS LODDEV LODDEV+","+DEV
	.IF LODDEV = "" .SETS LODDEV DEV
.FL20:	.SETT FILST
	.SETS FILTYP FIL+"."+TYP
	.SETS FILE FILTYP
	.IF DEV NE "" .SETS FILE DEV+":"+FILE
.FLCHK:
	.IFF NOPRO .RETURN
	DIR/PRO/FA/OU:SYSGEN.TMP 'FILE'
	.IF <EXSTAT> EQ <SUCCES> .GOTO FLOK
	;
	; ?SYSGEN-F-Input error 'FILE'
	.EXIT 4

.FLOK:	.OPENR SYSGEN.TMP
	.READ TEMPS
	.READ FILES
	.CLOSE
	.IF FILES EQ "" .RETURN
	;
	; ?SYSGEN-F-Protected file already exists 'FILES'
	.EXIT 4

.;;
.;; Determine what monitor(s) are to be generated
.;;
.MTYPE:
	.SETF BL	.; BL = true if BL selected (obsolete)
	.SETF SJ	.; SJ = true if SJ selected (obsolete)
	.SETF SB	.; SB = true if SB selected
	.SETF FB	.; FB = true if FB selected
	.SETF XM	.; XM = true if XM selected
	.SETF XB	.; XB = true if XB selected
	.SETF ZB	.; ZB = true if ZB selected
	.SETF ZM	.; ZM = true if ZM selected
	.SETF SBFB	.; SBFB = true if SB or FB selected (nothing else)
	.SETF FBXM	.; FBXM = true if FB or XM selected
	.SETF XBXM	.; XBXM = true if XB or XM selected
	.SETF XMONLY	.; XMONLY = true if only XM selected (nothing else)
	.SETF XBONLY	.; XBONLY = true if only XB selected (nothing else)
	;
	;
	; 'STARS'
	; 		MONITOR TYPE
	; 'STARS'
.Q5:
	.IFT PROCTS .GOTO Q10
	;
	.ASK [<TRUE>] SB 5.    Do you want the single-background (SB) monitor (Y)?
	.IFF <ESCAPE> .GOTO Q10
	;
	; SINGLE-BACKGROUND MONITOR:
	; The single-job (SB) monitor provides an environment  suitable for
	; developing  simple FORTRAN, PDP-11 "C", or BASIC applications.
	; The SB monitor includes  many  of the same features as the
	; foreground/background (FB) monitor--it supports all hardware
	; devices (except the memory management  unit),  all  programmed
	; requests  (except  .MRKT and .CMKT), and all the utility programs.
	; It offers the most features in the smallest size.  You can add
	; features during SYSGEN, but at the cost of increased monitor size.
	.GOTO Q5

.Q10:
	.SETS TEMPS "Y"
	.SETS TEMP "TRUE"
	.IFT PROCTS .SETS TEMPS "N"
	.IFT PROCTS .SETS TEMP "FALSE"
	;
	.ASK [<'TEMP'>] FB 10.   Do you want the foreground/background (FB) monitor ('TEMPS')?
	.IFF <ESCAPE> .GOTO Q15
	;
	; FOREGROUND/BACKGROUND MONITOR:
	; The foreground/background (FB) monitor  offers an extended set of
	; features that aid real-time or data acquisition applications.  In
	; addition to the foreground job capability, this  monitor supports
	; serialized  asynchronous  I/O  and additional programmed requests
	; (including .MRKT and .CMKT).
	.GOTO Q10

.Q15:
	.SETS TEMP "FALSE"
	.SETS TEMPS "N"
	.IFT CTS .SETS TEMP "TRUE"
	.IFT CTS .SETS TEMPS "Y"
	;
	.ASK [<'TEMP'>] XM 15.   Do you want the extended memory (XM) monitor ('TEMPS')?
	.IFF <ESCAPE> .GOTO Q20
	;
	; EXTENDED MEMORY MONITOR:
	; The extended memory (XM) monitor, which supports up to 2M words
	; of  memory, is  a  version  of  the FB monitor.  It requires KT11
	; hardware  (the memory management unit) and  the extended instruc-
	; tion  set (EIS).  The  XM  monitor supports additional programmed
	; requests  that allow you to extend a program''s logical addressing
	; space.  However, the XM monitor is larger than the FB monitor and
	; requires that the user service routine (USR) be resident.
	.GOTO Q15

.Q20:
	.SETS TEMP "FALSE"
	.SETS TEMPS "N"
	.IFT CTS .SETS TEMP "TRUE"
	.IFT CTS .SETS TEMPS "Y"
	;
	.ASK [<'TEMP'>] XB 20.   Do you want the extended background (XB) monitor ('TEMPS')?
	.IFF <ESCAPE> .GOTO Q25
	;
	; EXTENDED BACKGROUND MONITOR:
	; The extended background (XB) monitor, which supports up to 2M
	; words of  memory, is  a  single job version  of  the XM monitor.
	; It requires KT11 hardware  (the memory management unit) and  the
	; extended instruction  set (EIS).  The  XB  monitor supports
	; additional programmed requests that allow you to extend a
	; program''s logical addressing space.  However, the XB monitor is
	; larger than the FB monitor and requires that the user service
	; routine (USR) be resident.
	.GOTO Q20

.Q25:
	;
	.ASK [<FALSE>] ZM 25.   Do you want the Supervisor and I-D (ZM) monitor (N)?
	.IFF <ESCAPE> .GOTO Q30
	;
	; SUPERVISOR and I-D MONITOR:
	; The supervisor and I-D (ZM) monitor, which supports up to 2M
	; words of memory, is a version of the XM monitor.  It requires
	; KT11 hardware (the memory management unit) and the extended
	; instruction set (EIS).  The ZM monitor supports additional
	; programmed requests that allow you to extend a program''s
	; logical addressing space into User and Supervisor modes and
	; separated Instruction and Data spaces.  However, the ZM
	; monitor is larger than the XM monitor and requires that the
	; user service routine (USR) be resident.
	.GOTO Q25

.Q30:
	;
	.ASK [<FALSE>] ZB 30.   Do you want the Supervisor and I-D background (ZB) monitor (N)?
	.IFF <ESCAPE> .GOTO MO20
	;
	; SUPERVISOR and I-D BACKGROUND MONITOR:
	; The supervisor and I-D background (ZB) monitor, which
	; supports up to 2M words of memory, is a single job version
	; of the ZM monitor. It requires KT11 hardware (the memory
	; management unit) and the extended instruction set (EIS). The
	; ZB monitor supports additional programmed requests that
	; allow you to extend a program''s logical addressing into
	; User and Supervisor modes and separated Instruction and Data
	; space. However, the ZB monitor is larger than the FB monitor
	; and requires that the user service routine (USR) be
	; resident.
	.GOTO Q30

.MO20:
	.IFT FB .OR .IFT XM .SETT FBXM
	.IFT XB .OR .IFT XM .SETT XBXM
	.IFF SB .IFF FB .IFT XM .IFF XB .SETT XMONLY
	.IFF SB .IFF FB .IFT XB .IFF XM .SETT XBONLY
.;The following 2 statements go together
	.IFT SB .OR .IFT FB .SETT SBFB
	.IFT XM .OR .IFT XB .OR .IFT ZB .OR .IFT ZM .SETF SBFB
	.IFT SB .OR .IFT FBXM .OR .IFT XB .OR .IFT ZM .OR .IFT ZB .GOTO MONOP
	;
	; ?SYSGEN-E-No monitor requested
	;
	.ASK [<TRUE>] CONTIN Do you want to return to the monitor dialog (Y)?
	.IFF <ESCAPE> .GOTO MO30
	;
	; You must respond  yes  to  at least one of questions 1 through 3.
	; Each  SYSGEN  run must build at  least one monitor.   You  cannot
	; build device support without building a monitor.  Type "Y" if you
	; want  to  be  re-prompted  for  the monitor type.  If you want to
	; terminate the SYSGEN session type N.
	.GOTO MO20

.MO30:	.IFT CONTIN .GOTO Q5
	.EXIT

.;;
.;; Ask the monitor options
.;;
.MONOP:	;
	;
	; 'STARS'
	; 		MONITOR OPTIONS
	; 'STARS'
	.IFF SB .GOTO Q40

.Q35:
	.SETT TIME$R
	.IFT CTS .GOTO C5
	;
	.ASK TIME$R 35.   Do you want timer support in the SB monitor (N)?
	.IFF <ESCAPE> .GOTO C5
	;
	; SB TIMER SUPPORT OPTION:
	; The SB monitor normally does not include timer support.  You  can
	; include  this  support, which  enables you to use the .MRKT (mark
	; time) and .CMKT (cancel mark time) programmed requests.
	.GOTO Q35

.C5:	.IFT CHANGE .GOTO C6
.Q40:
	.SETS TEMP "FALSE"
	.SETS TEMPS "N"
	.IFT CTS .SETS TEMP "TRUE"
	.IFT CTS .SETS TEMPS "Y"
	;
	.ASK [<'TEMP'>] TIM$IT 40.   Do you want device time-out support ('TEMPS')?
	.IFF <ESCAPE> .GOTO C6
	;
	; DEVICE TIME-OUT SUPPORT OPTION:
	; The device time-out option permits device handlers to issue .MRKT
	; (mark time)  programmed  requests.   DECNET support requires this
	; option.
	.GOTO Q40

.C6:	.IFT TIM$IT .AND .IFT SB .SETT TIME$R
	.IFT CHANGE .GOTO CH20
	.IFF SB .GOTO Q50
.Q45:
	.SETT RDF$L
	.IFT CTS .GOTO C7
	;
	.ASK [<TRUE>] RDF$L 45.   Do you want an error message on system I/O errors (Y)?
	.IFF <ESCAPE> .GOTO C7
	;
	; ERROR MESSAGE ON SYSTEM I/O ERRORS OPTION:
	; The SB monitor normally halts if a fatal system I/O error occurs.
	; You  can  replace this halt with a system error message.  Digital
	; highly  recommends  this  option  if  the  system will be used by
	; anyone but the most experienced individuals.
	.GOTO Q45

.C7:	.IFT CHANGE .GOTO CH20
.Q50:
	.IFF FBXM .IFF ZM .GOTO Q65
	;
	.ASK SYT$K 50.   Do you want system job support (N)?
	.IFF <ESCAPE> .GOTO C8
	;
	; SYSTEM JOB OPTION:
	; The system  job  option  allows you to run up to eight simultane-
	; ously  active  jobs.  The error logger, the SPOOL program, VTCOM,
	; and  the  QUEUE  program  can be either foreground jobs or system
	; jobs.  If you want to run more than one simultaneously, or if you
	; want to run  any one along with a foreground job, you need system
	; job support.
	.GOTO Q50

.C8:	.IFT CHANGE .GOTO CH20
.Q55:
	.SETT SPC$PS
	.IFT CTS .GOTO C9
	;
	.ASK SPC$PS 55.   Do you want to use the .SPCPS request (N)?
	.IFF <ESCAPE> .GOTO C9
	;
	; SAVE/SET MAIN-LINE PC AND PS OPTION:
	; The  save/set  main-line  PC  and  PS  option  is a conditionally
	; assembled  programmed  request  for  the  FB, XM, ZM and ZB
	; monitors. The .SPCPS  request  changes the flow of control of
	; main-line code by saving the main-line code PC and PS and changing
	; the main-line PC to  a  new  value.  This  request  may  be  useful
	; in multi-user applications to control switching among users.
	.GOTO Q55

.C9:	.IFT CHANGE .GOTO CH20
.Q60:
	.IFF FBXM .IFF ZM .GOTO C10
	;
	.ASK SCCA$G 60.   Do you want global SCCA support (N)?
	.IFF <ESCAPE> .GOTO C10
	;
	; GLOBAL SCCA SUPPORT OPTION:
	; The  SCCA  programmed  request  inhibits  control/c''s  until  the
	; currently  running program exits.  Global SCCA support allows you
	; to issue a  programmed request that will inhibit control/c''s even
	; after a program  exits.  Control/c''s  will remain inhibited until
	; a  global SCCA programmed request is issued to explicitly turn it
	; off.
	.GOTO Q60

.C10:	.IFT CHANGE .GOTO CH20
	.SETT MTT$Y
	.IFT PROCTS .GOTO C11
.Q65:
	;
	.IFT CTS .ASK [<TRUE>] MTT$Y 65.   Do you want to use TSD with this monitor (Y)?
	.IFF CTS .ASK MTT$Y 65.   Do you want multiterminal support (N)?
	.IFF <ESCAPE> .GOTO C11
	.SETS TSD1 "  multiterminal   option"
	.IFT CTS .SETS TSD1 "TSD multiterminal option"
	.SETS TSD ""
	.IFT CTS .SETS TSD "TSD "
	;
	; 'TSD'MULTITERMINAL SUPPORT OPTION:
	; The 'TSD1'  lets  you  use  special  programmed
	; requests  to  do  I/O  to more than one terminal.  RT-11 normally
	; supports only one terminal  interfaced through the console (DL11)
	; which is  shared by both background and foreground jobs. You  can
	; select  multiterminal  support  for up to 16 terminals interfaced
	; through  a  choice  of  DL11,  DZ11  and  DH  series  interfaces.
	; Subsequent  questions  will  establish  the  number  and  type of
	; interfaces.
	.GOTO Q65

.C11:	.IFF MTT$Y .GOTO Q80
.Q70:
	.SETT MAT$S
	.IFT CTS .GOTO C12
	;
	.ASK [<TRUE>] MAT$S 70.   Do you want asynchronous terminal status (Y)?
	.IFF <ESCAPE> .GOTO C12
	;
	; ASYNCHRONOUS TERMINAL STATUS OPTION:
	; The  asynchronous  terminal status option provides a program with
	; the  updated  status  of  a  terminal  and modem.  When a program
	; attaches  a  terminal,  the program can supply a status word that
	; the  monitor  updates  as  changes  occur  in the terminal status
	; (double CTRL/C,  input  available, output  buffer  empty, carrier
	; present).  This support is required for MU BASIC applications.
	.GOTO Q70

.C12:	.IFT CHANGE .GOTO CH20
.Q75:
	;
	.ASK [<TRUE>] MTI$M 75.   Do you want multiterminal time-out support (Y)?
	.IFF <ESCAPE> .GOTO C13
	;
	; MULTITERMINAL TIME-OUT OPTION:
	; Multiterminal  time-out support  causes  the monitor to reset (at
	; regular  intervals)  any  terminal  that  may have gone off-line.
	; This  action  helps  to minimize the impact of static and similar
	; problems.  Digital  recommends  selecting  this  option  if  your
	; application requires maximum terminal availability.
	.GOTO Q75

.C13:	.IFF MTI$M .GOTO C13A
	.IFT TIM$IT .GOTO C13A
	;
	; ?SYSGEN-I-Device time-out support set on
	.SETT TIM$IT
.C13A:	.IFT CHANGE .GOTO CH20

.Q76:
	;
	.ASK [<FALSE>] MTY$HK 76.   Do you want multiterminal handler hooks support (N) ?
	.IFF <ESCAPE> .GOTO C14
	;
	; MULTITERMINAL HANDLER HOOKS OPTION:
	; The  RT-11  Multiterminal  service   can  include  optional  data
	; structures  and  code  that  allow device handlers to communicate
	; over multiterminal serial lines.
	.GOTO Q76
.C14:	.IFT CHANGE .GOTO CH20

.Q80:
	;
	.ASKN [10.:134.:40.] TTYOUT 80.   Enter the size of the output buffers (40):
	.SETD TTYOUT
	.IFF <ESCAPE> .GOTO C14
	;
	; OUTPUT RING BUFFER SIZE OPTION:
	; The RT-11 terminal service requires a set of output ring  buffers
	; for each supported terminal.  The  output ring is a buffer in the
	; monitor that  holds characters until the terminal can print them.
	; (A program  can  send characters faster than a terminal can print
	; them.)  The range for valid responses is from 10 to 134.
	.GOTO Q80

.C14:	.IFT CHANGE .GOTO CH20
.Q85:
	;
	.ASKN [74.:254.:134.] TTYIN 85.   Enter the size of the input buffers (134):
	.SETD TTYIN
	.IFF <ESCAPE> .GOTO C15
	;
	; INPUT RING BUFFER SIZE OPTION:
	; The  RT-11  terminal service requires a set of input ring buffers
	; for  each  terminal supported.  The input ring is a buffer in the
	; monitor  that  holds  the  characters that you type at a terminal
	; until a program  requests them.  You may want to change the input
	; ring size, in particular, since the size you need  depends on the
	; terminal''s  width  and the amount of type-ahead you expect.   The
	; range for valid responses is from 74 to 254.
	.GOTO Q85

.C15:	.IFT CHANGE .GOTO CH20
.Q90:
	.IFF XM .IFF XB .IFF ZM .IFF ZB .GOTO C16
	;
	.ASK [<TRUE>] XM$FET 90.   Do you want to use the .FETCH request under XM/XB, ZM/ZB (Y)?
	.IFF <ESCAPE> .GOTO C16
	;
	; .FETCH REQUEST OPTION:
	; If  you  choose .FETCH support under XM/XB or ZM/ZB, then
	; device handlers can be  fetched  by  user  background  programs.
	; .FETCH adds approximately 400. words to the resident monitor.
	.GOTO Q90

.C16:	.IFT CHANGE .GOTO CH20
.Q95:
	;
	.ASK ROL$OV 95.   Do you want end of month and year date rollover (N)?
	.IFF <ESCAPE> .GOTO C20
	;
	; MONTH ROLLOVER OPTION:
	; When  you  run a system continuously, over a long period of time,
	; you  normally have to reset the date and time at the beginning of
	; each month.  You can select a feature that automatically sets the
	; correct date and time. However, this option greatly increases the
	; size of the monitor.
	.GOTO Q95

.C20:	.IFT CHANGE .GOTO CH20
.Q100:
	;
	.ASK [<TRUE>] U$CL 100.  Do you want the user command linkage (Y)?
	.IFF <ESCAPE> .GOTO C21
	;
	; USER COMMAND LINKAGE OPTION:
	; The  user  command linkage allows you to define your own commands
	; which  can  be issued  in  a  format  similar to the standard DCL
	; commands.
	.GOTO Q100

.C21:	.IFT CHANGE .GOTO CH20
.Q105:
	;
	.ASK [<FALSE>] HSR$B 105.  Do you want high speed ring buffer support (N)?
	.IFF <ESCAPE> .GOTO C22
	;
	; HIGH SPEED RING BUFFER OPTION:
	; When  the  high  speed  ring  buffer  is  present,  all character
	; processing and interpretation is performed at  fork  level.   The
	; advantage of having the high speed ring buffer is that it  allows
	; short bursts of characters coming in at a very high rate. This is
	; useful  for  systems  with  VT100  or other terminals that report
	; their  status  by  sending  a  burst  of  information to the host
	; computer.  Use  of  the  high  speed  ring  buffer  is especially
	; recommended with a PDT.
	.GOTO Q105

.C22:	.IFT CHANGE .GOTO CH20

.;;
.;; Ask which KMON commands are needed
.;;
.Q110:
	;
	.ASK [<TRUE>] ANS 110.  Do you want all the keyboard monitor commands (Y)?
	.IFF <ESCAPE> .GOTO MP40
	;
	; KEYBOARD MONITOR COMMANDS OPTION:
	; The keyboard monitor commands option lets you choose the keyboard
	; monitor  commands  your generated monitor will support.  You will
	; probably  find  all  of  the  commands  useful.  However, you can
	; reduce  KMON  size  and assembly time if you select support for a
	; subset  of  the  available  commands.  You have a choice of three
	; subsets  (or  any  combination  of  subsets).  The  three command
	; subsets  you  can  choose  are: the UTILITY PROGRAM COMMANDS, the
	; LANGUAGE  COMMANDS,  and  the  MINIMAL  COMMANDS.  If you  do not
	; choose  the  complete  set of commands or any of the subsets, you
	; will be able to use only the RUN command.
	.GOTO Q110

.MP40:	.IFF ANS .GOTO MP50
	.SETT U$TIL
	.SETT L$ANG
	.SETT M$INI
	.GOTO C26

.MP50:	.SETS SYM "U$TIL 23."
	.SETS OPT "UTILITY"
.MP60:
	;
	.ASK [<TRUE>] 'SYM'	Do you want the 'OPT' subset (Y)?
	.IFF <ESCAPE> .GOTO MP100
	;
	; The following commands are included when the 'OPT' commands
	; are chosen:
	;
	.IF OPT <> "UTILITY" .GOTO MP70
	; BACKUP		BOOT		COPY		CREATE
	; DELETE		DIFFERENCES	DIRECTORY	DUMP
	; EDIT		FORMAT		INITIALIZE	PRINT
	; PROTECT	RENAME		SHOW		SQUEEZE
	; TYPE		UNPROTECT
	.GOTO MP90

.MP70:	.IF OPT <> "LANGUAGE" .GOTO MP80
	; COMPILE	DIBOL		EXECUTE
	; FORTRAN	LIBRARY		LINK		MACRO
	.GOTO MP90

.MP80:	; ABORT		ASSIGN		B		CLOSE
	; D		DATE		DEASSIGN	DISMOUNT
	; E		FRUN		GET		HELP
	; INSTALL		LOAD		MOUNT		R
	; REENTER		REMOVE		RESET		RESUME
	; RUN		SAVE		SET		SRUN
	; START		SUSPEND		TIME		UNLOAD
	; V		VRUN
.MP90:	;
	; Type  Y  if  you  want  support  for the 'OPT' subset of the
	; keyboard monitor commands.  Type N if you do  not want the subset
	; or  if  you  wish  to  specify individual commands by defining
	; system conditionals later during this SYSGEN session.
	.GOTO MP60

.MP100:	.IF OPT <> "UTILITY" .GOTO MP110
	.SETS SYM "L$ANG 24."
	.SETS OPT "LANGUAGE"
	.GOTO MP60

.MP110:	.IF OPT <> "LANGUAGE" .GOTO C26
	.SETS SYM "M$INI 25."
	.SETS OPT "MINIMAL"
	.GOTO MP60

.C26:	.IFT CHANGE .GOTO CH20

.;;
.;; Continue monitor options
.;;
.Q115:
	;
	.ASK CLK 115.  Do you want the optional 50 Hz clock support (N)?
	.IFF <ESCAPE> .GOTO C27
	;
	; 50 HZ CLOCK OPTION:
	; A line clock generates periodic interrupts to allow the system to
	; keep track of the time. The number of ticks per second depends on
	; the  power line frequency, 60 Hz or 50 Hz.  RT-11 assumes a 60 Hz
	; line frequency, but you can select support for a 50 Hz clock. The
	; 50 Hz  frequency has specialized uses and is the common frequency
	; in Europe.
	.GOTO Q115

.C27:	.SETN CLOCK 60.
	.IFT CLK .SETN CLOCK 50.
	.SETD CLOCK
	.IFT CHANGE .GOTO CH20
.Q120:
	.SETF KW11$P
	.IFT CTS .GOTO C30
	;
	.ASK KW11$P 120.  Do you want to use the KW11-P clock as the system clock (N)?
	.IFF <ESCAPE> .GOTO C30
	;
	; PROGRAMMABLE CLOCK AS SYSTEM CLOCK OPTION:
	; RT-11 normally  uses  a line clock for the system clock.  You can
	; substitute the KW11-P programmable clock as the system clock, but
	; the  KW11-P  will  not  then  be  available for program use.  The
	; programmable  clock  normally allows you to program interrupts at
	; preset intervals.
	.GOTO Q120

.C30:	.IFT CHANGE .GOTO CH20
.Q125:
	;
	.ASK [<TRUE>] STAR$T 125.  Do you want the startup indirect file (Y)?
	.IFF <ESCAPE> .GOTO C31
	;
	; STARTUP INDIRECT COMMAND FILE OPTION:
	; This  option  causes the bootstrap to execute an indirect command
	; file  (with  the name STRTxx.COM, where xx identifies the monitor)
	; when  starting  the  system.  An  indirect  command file contains
	; monitor  commands  that  the  monitor  processes (in the order in
	; which they appear) when the file is executed.  A startup indirect
	; command  file  is  particularly  useful  for  setting  up initial
	; conditions (for example, assigning the default device to the data
	; device, installing  a  device  into  the  system  tables when the
	; device  was  not  originally  built into the system, or running a
	; specific program).
	.GOTO Q125

.C31:	.IFT CHANGE .GOTO CH20
.Q130:
	.SETF FPU$11
	.IFT CTS .GOTO C32
	;
	.ASK FPU$11 130.  Do you want floating point support (N)?
	.IFF <ESCAPE> .GOTO C32
	;
	; FLOATING POINT OPTION:
	; If  your  configuration includes floating point hardware and your
	; application requires this feature, you should enable this option.
	; Floating  point hardware is available for many PDP-11 and Profes-
	; sional  300  series  processors.   This  is especially useful for
	; FORTRAN and BASIC users whose applications perform data manipula-
	; tions.
	.GOTO Q130

.C32:	.IFT CHANGE .GOTO CH20
.Q135:
	;
	.ASK MPT$Y 135.  Do you want memory parity support (N)?
	.IFF <ESCAPE> .GOTO C33
	;
	; MEMORY PARITY SUPPORT OPTION:
	; If your configuration includes memory parity hardware, you should
	; select  this  option.  Memory  parity  hardware checks for memory
	; errors  and  this  option enables RT-11 support for the hardware.
	; RT-11 issues an error message and supplies the location of access
	; when a memory error occurs.  If you have this hardware but do not
	; enable  this  support, the system halts when memory errors occur.
	; If you select error logging as well as memory parity support, the
	; error logger logs parity errors as well as device errors.
	.GOTO Q135

.C33:	.IFT CHANGE .GOTO CH20
.Q140:
	;
	.ASK [<FALSE>] PWF$L 140.  Do you want power failure messages (N)?
	.IFF <ESCAPE> .GOTO C34
	;
	; POWER FAILURE MESSAGE OPTION:
	; The  monitor  normally  halts  on power recovery startup  after a
	; power failure.  You can elect to have the monitor print a message
	; explaining that power failure caused the halt.  However, you must
	; not select this option if you have semiconductor memory, which is
	; volatile.
	.GOTO Q140

.C34:	.IFT CHANGE .GOTO CH20
.Q145:
	;
	.ASK BATC$H 145.  Do you want BATCH support (N)?
	.IFF <ESCAPE> .GOTO C35
	;
	; BATCH SUPPORT OPTION:
	; You can select support for the BATCH job control  language, which
	; allows  RT-11  to  operate  unattended.  Once you prepare a BATCH
	; stream, you  can  leave  it for an operator to start and run, and
	; the  BATCH  stream  will  execute  programs  or  monitor commands
	; without  your intervention.  Indirect command file support, which
	; offers  similar  capabilities, is  separately  available  in  all
	; monitors.  You  need  not select BATCH support to obtain indirect
	; command file support.
	.GOTO Q145

.C35:	.IFT CHANGE .GOTO CH20
.Q150:
	;
	.ASK ERL$G 150.  Do you want error logging (N)?
	.IFF <ESCAPE> .GOTO C36
	;
	; ERROR LOGGING OPTION:
	; The  error  logging  option creates the error logging (EL) system
	; job,  and  incorporates  error  logging  support  in  the  device
	; handlers.   Error  logging  reports  device,  memory  parity  (if
	; selected),  and  memory  cache  errors.  When  error  logging  is
	; enabled, most device handlers call EL on each successful transfer
	; and  on  each  error. The  EL  job retrieves information from the
	; handlers that is later available to you in summary report format.
	;
	; Timer support is required if you select error logging support.
	.GOTO Q150

.C36:	.IFF ERL$G .GOTO C39
	.IFF SB .GOTO Q155
	.IFT TIME$R .GOTO Q155
	;
	; ?SYSGEN-W-Timer support set on
	.SETT TIME$R
.Q155:
	;
	.ASKN [1.:22.:10.] ERL$U 155.  How many device units does error log job support (10)?
	.SETD ERL$U
	.IFF <ESCAPE> .GOTO C37
	;
	; NUMBER OF UNITS SUPPORTED BY ERROR LOGGING OPTION:
	; The  error  logger  can  handle up to 22 individual device units.
	; You can conserve space by reducing the number of units the logger
	; can  handle  to  the  specific  number  of supported units in the
	; target configuration.
	.GOTO Q155

.C37:	.IFDF DU$ERL .ERASE LOCAL DU$ERL
.Q160:
	.IFF ERL$G .GOTO C39
	;
	.ASK DUXERR 160.  Do you want MSCP error logging support for MSCP devices (N)?
	.IFF <ESCAPE> .GOTO C37A
	;
	; MSCP Error Logging Support enables full support of MSCP
	; error logging packets, which are returned by MSCP controllers.
	.GOTO Q160

.C37A:	.SETN DU$ERL 1
	.IFT DUXERR .SETN DU$ERL 2

.C38:	.IFDF MU$ERL .ERASE LOCAL MU$ERL
.Q165:
	;
	.ASK MUXERR 165.  Do you want TMSCP error logging support for TMSCP devices (N)?
	.IFF <ESCAPE> .GOTO C38A
	;
	; TMSCP Error Logging Support enables full support of TMSCP
	; error logging packets, which are returned by TMSCP controllers.
	.GOTO Q165

.C38A:	.SETN MU$ERL 1
	.IFT MUXERR .SETN MU$ERL 2

.C39:	.IFT CHANGE .GOTO CH20
.Q170:
	;
	.ASK UNI$64 170.  Do you want extended device-unit support (N)?
	.IFF <ESCAPE> .GOTO C40
	;
	; EXTENDED DEVICE-UNIT SUPPORT OPTION:
	; The extended device-unit support option adds monitor support for
	; extended-unit device handlers.  In addition to user written
	; extended-unit device handlers, the RT-11 handlers DU and LD may
	; each have up to 64 device-units.
	.GOTO Q170

.C40:	.IFF CHANGE .GOTO Q175
.;;
.;; A change was made to Monitor extended device-unit support.  If the DU
.;; and/or LD handlers were included in the GEN, re-ask the extended device-
.;; unit support questions for these handlers.
.;;
	.SETS DNM "DU"
	.IFT DU .GOSUB XUNIT
	.SETS DNM "LD"
	.IFT LD .GOSUB XUNIT
	.GOTO CH20

.Q175:
	.IFF FB .IFF XM .IFF ZM .GOTO C41
	.SETT OWN$ER
	;
	.ASK [<TRUE>] OWN$ER 175.  Do you want device ownership support (Y)?
	.IFF <ESCAPE> .GOTO C41
	;
	; DEVICE OWNERSHIP SUPPORT OPTION:
	; The device ownership support option controls the presence (or
	; absence) of the $OWNER table and support for it in the FB, XM
	; and ZM monitors.   If this option is selected, jobs may be assigned
	; exclusive use of a device''s unit(s), using the "LOAD
	; devname=jobname" KMON command. This option has no effect on
	; the SB, XB or the ZB monitors.
	.GOTO Q175

.C41:	.IFT CHANGE .GOTO CH20

.Q180:
	.SETF MQ$RES
	.IFF FB .IFF XM .IFF ZM .GOTO C42
	.SETT MQ$RES
	;
	.ASK [<TRUE>] MQ$RES 180.  Do you want the message handler resident in the monitor (Y)?
	.IFF <ESCAPE> .GOTO C42
	;
	; MESSAGE HANDLER RESIDENT/NONRESIDENT OPTION:
	; The Message Handler resident/nonresident option controls
	; whether the Message Handler is present or not present in
	; a multiple job monitor. It is normally resident in all
	; multiple job monitors. It is never resident in a single
	; job monitor.
	.GOTO Q180

.C42:	.IFT CHANGE .GOTO CH20
	.GOSUB USERPT

.;;
.;; Ask which devices are needed.
.;;
	;
	;
	; 'STARS'
	;		DEVICE OPTIONS
	; 'STARS'
	.SETS TXT "device name you want support for"
.Z28:
	;
	; Type <ESCAPE><RETURN> for help.
	; Type ?<RETURN> to list all devices.
	; Type .<RETURN> when device selection is complete.
	;
.Z29:
	;
	.DISABLE LOWERCASE
	.ASKS [0:2] DNM Enter the 'TXT' [dd]:
	.ENABLE LOWERCASE
	.IFF <ESCAPE> .GOTO DE10
	;
	; The device options let you select the peripheral devices that the
	; generated  system  will  support.  By  selecting  support  for  a
	; specific  device, you  make  the  device  known  to the monitor''s
	; device  tables,  and  SYSGEN  generates  a  device  handler named
	; xx.SYG, (where xx  is  the  physical device name) for the device.
	; If you do not select a  specific  device  at  this time, you will
	; have  to create the device handler separately and use the monitor
	; INSTALL command before you can access the device.
	;
	; The  following  is  a  list  of the valid RT-11 devices and their
	; associated  device  names.  SYSGEN  will  display the device name
	; list  each  time  you  type  a  question  mark  (?) followed by a
	; carriage  return  in  response  to  the device name question.  An
	; asterisk (*) will precede the device name if selected. Type a dot
	; when you have entered all the device names you want support for.
	;
	.IFT VT100 .ASK CONTIN Type RETURN to continue
	.GOSUB LIST
	.GOTO Z29

.;;
.;; Check device selected
.;;
.DE10:	.IF DNM = "?" .GOSUB LIST
	.IF DNM = "?" .OR .IF DNM = "" .GOTO Z29
	.IF DNM = "." .GOTO CUSTDV
	.TEST DEVSTR " "+DNM+" "
	.IF <STRLEN> NE 0 .GOTO DE20
	;
	; ?SYSGEN-E-Invalid device 'DNM':
	.GOTO Z29

.DE20:	.SETT 'DNM'
	.SETS TXT "next device name"
	.IFT CHANGE .SETS TXT "next device name to add/modify"
	.IF DNM = "DX" .OR .IF DNM = "DY" .GOSUB RXD
	.IF DNM = "DU" .GOSUB DUP
	.IF DNM = "DL" .GOSUB DLUN
	.IF DNM = "MT" .GOSUB MTF
	.IF DNM = "MM" .GOSUB MTF
	.IF DNM = "MS" .GOSUB MTF
	.IF DNM = "MU" .GOSUB MTF
	.IF DNM = "LP" .GOSUB LPC
	.IF DNM = "LS" .GOSUB LSC
	.IF DNM	= "XL" .GOSUB DXL
	.IF DNM = "SP" .GOSUB DSP
	.GOSUB XUNIT

	.IFT SBFB .AND .IF DNM = "NC" .GOTO XMONLY

	.IFT SBFB .AND .IF DNM = "NQ" .GOTO XMONLY
	.IFF SBFB .AND .IF DNM = "NQ" .GOSUB DNQ

	.IFT SBFB .AND .IF DNM = "NU" .GOTO XMONLY
	.IFF SBFB .AND .IF DNM = "NU" .GOSUB DNU
	.GOTO Z29

.XMONLY:;
	; ?SYSGEN-E-Ethernet handler support available for XM/XB, ZM/ZB only
	.SETF 'DNM'
	.GOTO Z29

.;;
.;; List the available devices
.;;
.LIST:
	;
	;
	.SETS DEF "* "
	.SETN CNT 1
.LISTER:
	.SETS DCOM2 ""
	.SETS AST1 "  "
	.SETS AST2 "  "
	.SETS DCOM1 DCM'CNT'
	.SETS DEV1 DCM'CNT'[1:2]
	.SETS DEV DEV1
	.INC CNT
	.IF CNT GT MAXDEV .GOTO LIST10
	.SETS DCOM2 DCM'CNT'
	.SETS DEV2 DCM'CNT'[1:2]
	.SETS DEV DEV2
	.IFT 'DEV2' .SETS AST2 DEF
.LIST10:.IFT 'DEV1' .SETS AST1 DEF
	;'AST1''DCOM1'   'AST2''DCOM2'
	.INC CNT
	.IF CNT LE MAXDEV .GOTO LISTER
	;
	.SETS AST1 DEF
	.SETS AST2 DEF
	.SETS COM "  User supplied device           "
	.SETT UDINIT
	.SETS UDFIND ""
.LIST20:
	.GOSUB FINDUD
	.IF UDEVNO EQ 0 .RETURN
	.SETS DCOM1 UD'UDEVNO'+COM
	.GOSUB FINDUD
	.IF UDEVNO NE 0 .SETS DCOM2 UD'UDEVNO'+COM
	.IF UDEVNO NE 0 .GOTO LIST30
	.SETS AST2 ""
	.SETS DCOM2 ""
.LIST30:;'AST1''DCOM1''AST2''DCOM2'
	.GOTO LIST20

.;;
.;; RX01, RX02
.;;
.RXD:
	.IF DNM = "DX" .SETS DEV "RX01"
	.IF DNM = "DY" .SETS DEV "RX02"
	;
	.ASK 'DNM'T$O 200.  Do you want support for a second 'DEV' controller (N)?
	.IFF <ESCAPE> .AND .IF DNM = "DY" .GOTO RX30
	.IFF <ESCAPE> .GOTO RX40
	.IF DNM <> "DX" .GOTO RX10
	;
	; The RX01 single-density flexible diskette subsystem supports only
	; two  drives  for  each  controller.  If your system contains four
	; diskette drives, a second controller governs the third and fourth
	; units, and you must select RT-11 support for it.
	.GOTO RXD

.RX10:	;
	; The  RX02  double-density  diskette  subsystem  supports only two
	; drives for each controller.  If your system contains four drives,
	; a  second  controller governs the third and fourth units, and you
	; must select RT-11 support for it.
	.GOTO RXD

.RX30:
	;
	.ASK DY$DD 205.  Do you want RX02 double density only support (N)?
	.IFF <ESCAPE> .GOTO RX40
	;
	; The  RX02  diskette supports both single and double  densities by
	; default.  If  you  select  double-density  only  support, you can
	; slightly  improve  the  performance  and  reduce  the size of the
	; device handler.
	.GOTO RX30

.RX40:	.SETN DEFC 177170
	.SETS CN "R"
	.SETS VN "EC"
	.SETS NUM "first "
	.SETN DEFV 264
.RX50:
	;
	.ASKN [160000:177570:'DEFC'] 'DNM'$CS'CN' 210.  What is the CSR  address for the 'NUM''DEV' ('DEFC')?
	.IFF <ESCAPE> .GOTO RX60
	;
	; The valid range for the CSR address is from 160000 to 177570.
	.GOTO RX50

.RX60: 	.IF 'DNM'$CS'CN' = 'DNM'$CS'CN'/2*2 .GOTO RX65
	;
	; ?SYSGEN-W-Address not even
	.GOTO RX50
.RX65:
	;
	.ASKN [100:474:'DEFV'] 'DNM'$V'VN' 215.  What is the vector address for the 'NUM''DEV' ('DEFV')?
	.IFF <ESCAPE> .GOTO RX70
	;
	; The valid range for the vector address is from 100 to 474.
	.GOTO RX65

.RX70:	.IF 'DNM'$V'VN' = 'DNM'$V'VN'/2*2 .GOTO RX75
	;
	; ?SYSGEN-W-Address not even
	.GOTO RX65

.RX75:	.IFF 'DNM'T$O .RETURN
	.IF CN = "2" .RETURN
	.IF 'DNM'$CS'CN' <> DEFC .SETN DEFC 'DNM'$CS'CN'
	.IF 'DNM'$V'VN' <> DEFV .SETN DEFV 'DNM'$V'VN'
	.SETS CN "2"
	.SETS VN "C2"
	.SETS NUM "second "
	.IF DNM = "DX" .SETN DEFC DEFC+4
	.IF DNM = "DY" .SETN DEFC DEFC-20
	.SETN DEFV DEFV+4
	.IF DEFC LE 177570 .IF DEFC GE 160000 .GOTO RX75A
	;
	; ?SYSGEN-F-Next default CSR address out of range ('DEFC')
	; ...Restarting query sequence for this device
	;
	.GOTO RXD

.RX75A: .IF DEFV LE 474 .IF DEFV GE 100 .GOTO RX50
	;
	; ?SYSGEN-F-Next default vector address out of range ('DEFV')
	; ...Restarting query sequence for this device
	;
	.GOTO RXD

.;;
.;; RL01/2
.;;
.DLUN:
	;
	.ASKN [1.:4:2] DL$UN 220.  How many RL01/RL02 units are to be supported (2)?
	.IFF <ESCAPE> .RETURN
	;
	; Enter the  number  (decimal)  of RL01/RL02 units included in your
	; RL01/RL02 subsystem. The range of valid responses is from 1 to 4.
	.GOTO DLUN

.;;
.;; DU
.;;
.DUP:
	;
	.ASKN [1:4:1] DU$POR 225.  How many ports are to be supported (1)?
	.IFF <ESCAPE> .GOTO DUP10
	;
	; Enter  the  number  of ports you want the MSCP disk class handler
	; to support.  The range of valid responses is from 1 to 4.
	.GOTO DUP

.DUP10:	.SETN DU$UN DU$POR.
	.SETD DU$UN
	.SETN DEFC 172150
	.SETN DEFV 154
	.SETS NS "R"
	.SETS V "EC"
	.SETN C 1
	.SETS NUM C'C'
.DUP20:
	.IF NS = "R" .GOTO DUP30
	.SETN DEFC DEFC-4
	.IF DEFC >= 160000 .GOTO DUP25
	;
	; ?SYSGEN-F-Next default CSR address out of range ('DEFC')
	; ...Restarting query sequence for this device
	;
	.GOTO DUP

.DUP25:	.SETN DEFV DEFV-4
	.IF DEFV >= 100 .GOTO DUP27
	;
	; ?SYSGEN-F-Next default vector address out of range ('DEFV')
	; ...Restarting query sequence for this device
	;
	.GOTO DUP

.DUP27:	.SETS V "C"+"'C'"
	.INC C
	.SETS NUM C'C'
.DUP30:
	;
	.ASKN [160000:177570:'DEFC'] DU$CS'NS' 230.  What is the CSR (register) address for the 'NUM' port ('DEFC')?
	.IFF <ESCAPE> .GOTO DUP35
	;
	; Enter the CSR address (octal) of the 'NUM' port. The valid range
	; for CSR address is 160000 to 177570. The standard address is 'DEFC'.
	.GOTO DUP30

.DUP35:	.IF DU$CS'NS' = DU$CS'NS'/2*2 .GOTO DUP40
	;
	; ?SYSGEN-W-Address not even
	.GOTO DUP30

.DUP40:
	;
	.ASKN [100:474:'DEFV'] DU$V'V' 235.  What is the vector address for the 'NUM' port ('DEFV')?
	.IFF <ESCAPE> .GOTO DUP45
	;
	; Enter the vector address (octal) of the 'NUM' unit. The range for
	; valid responses is from 100 to 474.
	.GOTO DUP40

.DUP45:	.IF DU$V'V' = DU$V'V'/2*2 .GOTO DUP50
	;
	; ?SYSGEN-W-Address not even
	.GOTO DUP40

.DUP50:	.DEC DU$UN
	.IF DU$POR = 1 .GOTO DUP70
	.IF DU$UN  = 0 .GOTO DUP70
	.IF DU$CS'NS' <> DEFC .SETN DEFC DU$CS'NS'
	.IF DU$V'V' <> DEFV .SETN DEFV DU$V'V'
	.SETS NS "'C'"
	.GOTO DUP20

	; Question 240 (Multiple Port Booting: DU$BOO) has been
	; eliminated since DU$BOO is no longer used.

.DUP70:
	;

	.IFT XM .ASK [<TRUE>] DU$BBR 245.  Do you want support for DU initiated bad block replacement (Y)?
	.IFF XM .ASK [<FALSE>] DU$BBR 245.  Do you want support for DU initiated bad block replacement (N)?
	.IFF <ESCAPE> .RETURN
	;
	; Bad  block  replacement is a technique in which substitute blocks
	; are  provided  for blocks that have caused a read or write error.
	; If your system includes an RC25,  or RA series device, you should
	; request  support  for  DU initiated bad blocks.  Enter YES if you
	; want DU to perform the bad block replacement.
	.GOTO DUP70

.XUNIT:
	.TEST DEV64 DNM
	.IF <STRLEN> EQ 0 .RETURN
	.SETS DEFYN "N"
	.IFT UNI$64 .SETS DEFYN "Y"
	;
	.ASK [UNI$64] 'DNM'$N64 250.  Do you want extended device-unit support for handler 'DNM' ('DEFYN')?
	.IFF <ESCAPE> .GOTO XUN10
	;
	; Whether  or not you have selected extended device-unit support in
	; the monitor, the 'DNM' handler may be built with extended device-unit
	; Support.  However, this support will only become active when the 'DNM'
	; handler  is  running  under  a  monitor which has been built with
	; extended device-unit support.
	.GOTO XUNIT

.XUN10:
	.IFT 'DNM'$N64 .GOTO XUN20
	.SETN 'DNM'$UNI 8.
	.RETURN

.XUN20:	.SETS TEMPS DEV64[<STRLEN>+3:<STRLEN>+4]
	;
	.ASKN [8.:64.:'TEMPS'.] 'DNM'$UNI 255.  How many device-units should 'DNM' support ('TEMPS')?
	.SETD 'DNM'$UNI
	.IFF <ESCAPE> .RETURN
	;
	; Whether or not you have selected extended device-unit support for
	; the monitor, the 'DNM' handler is being built with Extended device-
	; unit support.  The 'DNM' handler may be built to manage up to 64
	; device-units.  Enter the number of device-units you wish 'DNM' to
	; support.  The minimum is 8. The default for 'DNM' is 'TEMPS'. The
	; maximum is 64.  Note that this support will only become active
	; when the 'DNM' handler is running under a monitor which has been
	; built with Extended Device-unit Support.
	.GOTO XUN10

.DSP:
	;
	.ASK [<TRUE>] SP$FLG 320.  Do you want support for banner pages (Y)?
	.IFF <ESCAPE> .RETURN
	;
	; Type  Y  if you want  banner page support to be included with the
	; spool handler.
	.GOTO DSP

.;;
.;; XL
.;;
.DXL:
	;
	.ASKN [160000:177570:176500] XL$CSR 325.  What is the CSR address for XL (176500)?
	.IFF <ESCAPE> .GOTO XL30
	;
	; Enter the CSR address (octal) of XL.
	.GOTO DXL

.XL30:	.IF XL$CSR = XL$CSR/2*2 .GOTO XL35
	;
	; ?SYSGEN-W-Address not even
	.GOTO DXL

.XL35:
	;
	.ASKN [100:474:300] XL$VEC 330.  What is the vector address for XL (300)?
	.IFF <ESCAPE> .GOTO XL40
	;
	; Enter the vector address (octal) of XL.
	.GOTO XL35

.XL40:	.IF XL$VEC = XL$VEC/2*2 .GOTO XL50
	;
	; ?SYSGEN-W-Address not even
	.GOTO XL35

.XL50:
	.IFF MTT$Y .GOTO XL70
	.IFF MTY$HK .GOTO XL70
	;
	.ASK [<FALSE>] XL$MTY 331.  Do you want XL to use the multiterminal hooks feature (N) ?
	.IFF <ESCAPE> .GOTO XL60
	;
	; If  you select YES,  code will be included in XL to allow the use
	; of a line in a multiterminal system.
	.GOTO XL50

.XL60:
	.IFF XL$MTY .GOTO XL70
	;
	.ASKN [1:16.:1] XL$LUN 332.  Which multiterminal line do you want XL to use (1) ?
	.IFF <ESCAPE> .GOTO XL70
	;
	; Enter  the  line  number of your multiterminal configuration that
	; you  want  XL  to use for input/output operations.   The range of
	; valid responses is 1 to 16.
	.GOTO XL60

.XL70:	.RETURN
.;;
.;; NQX
.;;
.DNQ:
	;
	.ASKN [160000:177570:174440] NQ$CSR 335.  What is the CSR address for NQX (174440)?
	.IFF <ESCAPE> .GOTO NQ30
	;
	; Enter the CSR address (octal) of NQX.
	.GOTO DNQ

.NQ30:	.IF NQ$CSR = NQ$CSR/2*2 .GOTO NQ35
	;
	; ?SYSGEN-W-Address not even
	.GOTO DNQ

.NQ35:
	;
	.ASKN [100:474:120] NQ$VEC 340.  What is the vector address for NQX (120)?
	.IFF <ESCAPE> .GOTO NQ40
	;
	; Enter the vector address (octal) of NQX.
	.GOTO NQ35

.NQ40:	.IF NQ$VEC = NQ$VEC/2*2 .RETURN
	;
	; ?SYSGEN-W-Address not even
	.GOTO NQ35
.;;
.;; NUX
.;;
.DNU:
	;
	.ASKN [160000:177570:174510] NU$CSR 345.  What is the CSR address for NUX (174510)?
	.IFF <ESCAPE> .GOTO NU30
	;
	; Enter the CSR address (octal) of NUX.
	.GOTO DNU

.NU30:	.IF NU$CSR = NU$CSR/2*2 .GOTO NU35
	;
	; ?SYSGEN-W-Address not even
	.GOTO DNU

.NU35:
	;
	.ASKN [100:474:120] NU$VEC 350.  What is the vector address for NUX (120)?
	.IFF <ESCAPE> .GOTO NU40
	;
	; Enter the vector address (octal) of NUX.
	.GOTO NU35

.NU40:	.IF NU$VEC = NU$VEC/2*2 .RETURN
	;
	; ?SYSGEN-W-Address not even
	.GOTO NU35

.;;
.;; MT, MS, MM, MU
.;;
.MTF:
	;
	.ASK [<TRUE>] 'DNM'$FSM 260.  Do you want the file-structured magtape handler (Y)?
	.IFF <ESCAPE> .GOTO MT10
	;
	; FILE-STRUCTURED MAGTAPE OPTION:
	; RT-11  magtape  support  is available in two forms.  The standard
	; form  is  file-structured magtape support, which uses a subset of
	; ANSI   file  format.   The  file-structured  handler  stores  and
	; retrieves  data  in  a  file format usable with most RT-11 system
	; programs.  The second form of magtape  support, hardware  handler
	; support,  omits  file  structuring  and  reads  and  writes  data
	; directly in variable length records.   While this handler is sig-
	; nificantly  smaller  than the file-structured handler, you cannot
	; use it with any system programs.  The file-structured handler can
	; also perform direct hardware functions.
	.GOTO MTF

.MT10:
	.SETN MAXMT 8.
	.SETN DEFMT 2
	.IF DNM = "MU" .SETN MAXMT 4
	.IF DNM = "MU" .SETN DEFMT 1
	;
	.ASKN [1.:'MAXMT'.:'DEFMT'] MTU 265.  How many magtape units are to be supported ('DEFMT')?
	.IFF <ESCAPE> .GOTO MT20
	;
	; NUMBER OF MAGTAPE UNITS OPTION:
	; The magtape  handler requires table space for each magtape  unit.
	; You can minimize the size of the magtape handler by limiting  the
	; number  of  units  it  can  simultaneously  handle  to the number
	; actually present on the target machine.
	.GOTO MT10

.MT20:	.SETN 'DNM'$UN MTU.
	.SETD 'DNM'$UN
	.IF DNM <> "MS" .AND .IF DNM <> "MU" .RETURN
	.IF DNM = "MS" .SETN DEFC 172522
	.IF DNM = "MS" .SETN DEFV 224
	.IF DNM = "MU" .SETN DEFC 174500
	.IF DNM = "MU" .SETN DEFV 260
	.SETS NS "R"
	.SETS V "EC"
	.SETN C 0
	.SETS NUM C1

.MT30:
	;
	.ASKN [160000:177570:'DEFC'] 'DNM'$CS'NS' 270.  What is the address of the 'NUM' unit ('DEFC')?
	.IFF <ESCAPE> .GOTO MT40
	;
	; Each  unit  requires  two  contiguous  bus  addresses  for status
	; registers.   Enter  the  address (octal) of the 'NUM' unit.   The
	; range of valid responses is from 160000 to 177570.
	.GOTO MT30

.MT40:	.IF 'DNM'$CS'NS' = 'DNM'$CS'NS'/2*2 .GOTO MT45
	;
	; ?SYSGEN-W-Address not even
	.GOTO MT30

.MT45:
	;
	.ASKN [100:474:'DEFV'] 'DNM'$V'V' 275.  What is the vector address of the 'NUM' unit ('DEFV')?
	.IFF <ESCAPE> .GOTO MT50
	;
	; Enter the vector address (octal) of the 'NUM' unit. The range for
	; valid responses is from 100 to 474.
	.GOTO MT45

.MT50:	.IF 'DNM'$V'V' = 'DNM'$V'V'/2*2 .GOTO MT50A
	;
	; ?SYSGEN-W-Address not even
	.GOTO MT45

.MT50A:	.DEC MTU
	.IF MTU = 0 .RETURN
	.IF 'DNM'$CS'NS' <> DEFC .SETN DEFC 'DNM'$CS'NS'
	.IF 'DNM'$V'V' <> DEFV .SETN DEFV 'DNM'$V'V'
	.IF C <> 0 .GOTO MT60
	.IF DNM = "MS" .SETN DEFV 300
	.IF DNM = "MU" .SETN DEFV 340
	.SETS E "C"
	.SETS NUM C2
	.INC C
	.GOTO MT70

.MT60:	.SETN DEFV 'DNM'$V'V'+4
	.INC C
	.SETN TEMPN C+1
	.SETS NUM C'TEMPN'
.MT70:	.SETN DEFC DEFC+4
	.SETS V E+"'C'"
	.SETS NS "'C'"
	.IF DEFC LE 177570 .IF DEFC GE 160000 .GOTO MT70A
	;
	; ?SYSGEN-F-Next default CSR address out of range ('DEFC')
	; ...Restarting query sequence for this device
	;
	.GOTO MTF

.MT70A: .IF DEFV LE 474 .IF DEFC GE 100 .GOTO MT30
	;
	; ?SYSGEN-F-Next default vector address out of range ('DEFV')
	; ...Restarting query sequence for this device
	;
	.GOTO MTF

.;;
.;; LP, LS
.;;
.LPC:
	.IFT PROCTS .GOTO LSC
	.IFT CTS .GOTO CTSLP
	;
	.ASK LPC 280.  Does your printer have a nonstandard vector or CSR (N)?
	.IFF <ESCAPE> .GOTO LP10
	;
	; The standard line printer vector address is 200 and  the standard
	; CSR  address  is 177514.  If your printer is installed at another
	; vector or CSR address, specify the correct values.
	.GOTO LPC

.LP10:
	.IFF LPC .RETURN
	;
	.ASKN [160000:177570:177514] LP$CSR 285.  What is the CSR address for the printer (177514)?
	.IFF <ESCAPE> .GOTO LP20
	;
	; Respond  with  the  address  of the control register for the line
	; printer. The range for valid responses is from  160000 to 177570.
	.GOTO LP10

.LP20:	.IF LP$CSR = LP$CSR/2*2 .GOTO LP20A
	;
	; ?SYSGEN-W-Address not even
	.GOTO LP10

.LP20A:
	;
	.ASKN [100:474:200] LP$VEC 290.  What is the vector address for the printer (200)?
	.IFF <ESCAPE> .GOTO LP30
	;
	; Respond with the vector address for  the line printer.  The range
	; for valid responses is from 100 to 474.
	.GOTO LP20A

.LP30:	.IF LP$VEC = LP$VEC/2*2 .RETURN
	;
	; ?SYSGEN-W-Address not even
	.GOTO LP20A

.LSC:
	.IFF PROCTS .GOTO LS1
	.SETT LS$PC
	.SETN LS$CSR 173400
	.SETN LS$VEC 220
	.GOTO LS20

.LS1:	.IFT CTS .GOTO CTSLP
	;
	.ASK [<FALSE>] LS$PC 295.  Do you want support for the PC300 printer port (N)?
	.IFF <ESCAPE> .GOTO LS5
	;
	; Type  Y if you will be using the LS handler with the PC300 series
	; of personal computers.
	.GOTO LSC

.LS5:	.SETN DEFC 176500
	.SETN DEFV 300
.LS5A:
	;
	.ASKN [160000:177570:'DEFC'] LS$CSR 300.  What is the CSR for the serial line printer ('DEFC')?
	.IFF <ESCAPE> .GOTO LS10
	;
	; Respond with the address of  the  control register for the serial
	; line  printer.   The  range for valid responses is from 160000 to
	; 177570.
	.GOTO LS5A

.LS10:	.IF LS$CSR = LS$CSR/2*2 .GOTO LS10A
	;
	; ?SYSGEN-W-Address not even
	.GOTO LS5A

.LS10A:
	;
	.ASKN [60:474:'DEFV'] LS$VEC 305.  What is the vector for the serial line printer ('DEFV')?
	.IFF <ESCAPE> .GOTO LS20
	;
	; Respond with the vector address for the serial line printer.  The
	; range for valid responses is from 100 to 474.
	.GOTO LS10A

.LS20:	.IF LS$VEC = LS$VEC/2*2 .GOTO LS30
	;
	; ?SYSGEN-W-Address not even
	.GOTO LS10A

.LS30:
	.IFF MTT$Y .GOTO LS50
	.IFF MTY$HK .GOTO LS50
	;
	.ASK [<FALSE>] LS$MTY 306.  Do you want LS to use the multiterminal hooks feature (N) ?
	.IFF <ESCAPE> .GOTO LS40
	;
	; If  you select YES,  code will be included in LS to allow the use
	; of a line in a multiterminal system.
	.GOTO LS30

.LS40:
	.IFF LS$MTY .GOTO LS50
	;
	.ASKN [1:16.:1] LS$LUN 307.  Which multiterminal line do you want LS to use (1) ?
	.IFF <ESCAPE> .GOTO LS50
	;
	; Enter  the  line  number of your multiterminal configuration that
	; you  want  LS  to use for input/output operations.   The range of
	; valid responses is 1 to 16.
	.GOTO LS40

.LS50:	.RETURN

.CTSLP:
	.SETF LPP
	.SETF LQP
	.SETF LRP
	.SETF LSP
	.SETF LPS
	.SETF LQS
	.SETF LRS
	.SETF LSS
	;
	.ASK [<TRUE>] ANS 295.  Do you want serial line printer support (Y)?
	.IFF <ESCAPE> .GOTO CTLP10
	;
	;Respond with Y if you want any serial line printer support.
	.GOTO CTSLP

.CTLP10:
	.IFT ANS .SETT TIM$IT
	;
	.ASKN [0:4:1] LPNUM 300.  How many (serial & parallel) line printers (1)?
	.IFF <ESCAPE> .GOTO CTLP20
	;
	;Enter the total number of line printers you want support for.
	.GOTO CTLP10

.;;DFAULT SYMBOLS = DF+(C=CSR,V=VECTOR)+(P=PARALLEL,S=SERIAL)+NUMBER

.CTLP20:.SETS DFCP1 "177514"
	.SETS DFVP1 "200"
	.SETS DFCS1 "176500"
	.SETS DFVS1 "300"
	.SETS DFCP2 "164004"
	.SETS DFVP2 "170"
	.SETS DFCS2 "176510"
	.SETS DFVS2 "310
	.SETS DFCP3 "164014"
	.SETS DFVP3 "174
	.SETS DFCS3 "176520"
	.SETS DFVS3 "320"
	.SETS DFCP4 "164024"
	.SETS DFVP4 "270"
	.SETS DFCS4 "176530"
	.SETS DFVS4 "330"
	.SETF SWIT
	.SETN CNT 1
.CTLP22:
	.IF CNT GT LPNUM .RETURN
	.SETS NUM C'CNT'
	.SETT PAR
	.SETS TYP "P"
	.IFF ANS .GOTO CTLP30

.CTLP25:
	;
	.ASK [<TRUE>] PAR 305.  Is the 'num' line printer parallel (Y)?
	.IFF <ESCAPE> .GOTO CTLP30
	;
	;Respond with YES if your 'num' line printer is a parallel printer.
	.GOTO CTLP25

.CTLP30:.IFF PAR .SETS TYP "S"
	.SETS TEMPS LP'CNT'
	.SETT L'TEMPS''TYP'
.CTLP70:
	.SETS DFC DFC'TYP''CNT'
	.SETS DFV DFV'TYP''CNT'
	;
	.ASKN [160000:177570:'DFC'] LPC 310.  What is the CSR address for this printer ('DFC')?
	.IFF <ESCAPE> .GOTO CTLP73
	;
	; Respond with the CSR address for the line printer.  The range for
	; valid  responses  is from 160000 to 177570.  The default response
	; is 'DFC'.
	.GOTO CTLP70

.CTLP73:.IF LPC = LPC/2*2 .GOTO CTLP7A
	;
	; ?SYSGEN-W-Address not even
	.GOTO CTLP70

.CTLP7A:
	;
	.ASKN [100:474:'DFV'] LPV 315.  What is the vector address for this printer ('DFV')?
	.IFF <ESCAPE> .GOTO CTLP74
	;
	; Respond  with the vector address for the line printer.  The range
	; for valid  responses is from 100 to 474.  The default response is
	; 'DFV'.
	.GOTO CTLP7A

.CTLP74:.IF LPV = LPV/2*2 .GOTO CTLP7B
	;
	; ?SYSGEN-W-Address not even
	.GOTO CTLP7A

.CTLP7B:
	.SETS LPID LPID'CNT'
	.OPEN L'TEMPS''TYP'.MAC
	.IF <FILERR> EQ <SUCCES> .GOTO CTLP77
	;
	;?CTSGEN-F-Error creating L'TEMPS''TYP'
	.EXIT 4

.CTLP77:.IFF SWIT .GOTO CTLP80
	.SETN LPC L'TEMPS''TYP'CSR
	.SETN LPV L'TEMPS''TYP'VEC

.CTLP80:.ENABLE DATA
.MCALL	.DRDEF
	.DRDEF	L'TYP','LPID',WONLY$,0,'LPC','LPV',DMA=NO
.DISABLE DATA

	.CLOSE
	.IFT SWIT .RETURN
	.SETN L'TEMPS''TYP'CSR 'LPC'
	.SETN L'TEMPS''TYP'VEC 'LPV'
	.INC CNT
	.GOTO CTLP22

.;;
.;; Allow for user-provided device handlers
.;;
.CUSTDV:
	;
	.ASK UDEV Do you want to add support for any of your own devices (N)?
	.IFF <ESCAPE> .GOTO U10
	;
	; SYSGEN  will  generate  commands  to  assemble  and link any user
	; supplied device handlers.  SYSGEN  also  adds the device names to
	; the system device tables in DEVTBL.MAC.
	.GOTO CUSTDV

.U10:	.IFF UDEV .GOTO C50
	.SETS TXT "device name you want support for"
	;
	; Type <ESCAPE><RETURN> for help.
	; Type ?<RETURN> to list all devices.
	; Type .<RETURN> when device specification is complete.
	;
.U15:
	;
	.DISABLE LOWERCASE
	.ASKS [0:2] UDTEMP Enter the 'TXT' [dd]:
	.ENABLE LOWERCASE
	.IFF <ESCAPE> .GOTO U20
	;
	; Enter the 2 character device name for the device for which you
	; are supplying a device handler. The name must be alphabetic.
	.GOTO U15

.U20:	.SETS TXT "next device name"
	.IF UDTEMP EQ "?" .GOSUB LIST
	.IF UDTEMP EQ "" .OR .IF UDTEMP EQ "?" .GOTO U15
	.IF UDTEMP EQ "." .GOTO C50
.;
.; Test for valid alphanumeric device name
.;
	.TEST UDTEMP
	.IFT <ALPHAN> .GOTO U30
	;
	; ?SYSGEN-E-Invalid device 'UDTEMP':
	.GOTO U15

.U30:	.SETT UDINIT
	.SETS UDFIND UDTEMP
	.GOSUB FINDUD
	.IF UDEVNO NE 0 .GOTO U40
	.SETN UDEVNO UDNDF
	.SETS UD'UDEVNO' UDTEMP
	.INC UDEVCT
.U40:
	;
	.ASK BUD'UDEVNO' Does your device contain RT-11 style set option overlay (N)?
	.IFF <ESCAPE> .GOTO U15
	;
	; Type Y if you want your device linked with SETOVR at /BOUND:512.
	.GOTO U40

.C50:	.IFT CHANGE .GOTO CH100

.Q355:
	;
	.ASKN [0.:32.:0] EMPTY 355.  How many extra device slots do you want (0)?
	.IFF <ESCAPE> .GOTO C161
	;
	; EXTRA DEVICE SLOT OPTION:
	; SYSGEN  allocates  space  in  the  monitor  for  only the devices
	; specified.    You  can  allocate  additional  space by requesting
	; empty device slots.   Allocate one empty slot for each device you
	; intend to add to the system after it is built.  Also keep in mind
	; that  the  number  of logical device assignments you will be able
	; to  make in the running system is equal to  the number of devices
	; plus  empty  device slots in the system you have generated.   You
	; may  need  to  allocate  extra  device  slots  for logical device
	; assignment  purposes.   The range of valid responses is from 0 to
	; 32.
	.GOTO Q355

.C161:	.IFT CHANGE .GOTO CH20

.;;
.;; Terminal interface options
.;;
	.IFF MTT$Y .GOTO C192
	.IFF PROCTS .GOTO DLTR
	.SETN DLNUM 1
	.SETN DLMDM 0
	.SETN DLC$0 177560
	.SETN DLV$0 60
	.SETF DZM
	.SETN DZ11$N 0
	.SETF DHM
	.SETN DH11$N 0
	.GOTO C192

.DLTR:
	;
	;
	; 'STARS'
	; 		TERMINAL INTERFACE OPTIONS
	; 'STARS'
.Q360:
	;
	.ASK A Do you want an introduction to terminal interface options (N)?
	.IFF <ESCAPE> .AND .IFF A .GOTO TRST
	.IFF <ESCAPE> .AND .IFT A .GOTO TR10
	;
	; The  introduction  explains  the DL interfaces supported by RT-11
	; and how SYSGEN assigns the terminal numbers.
	.GOTO Q360

.TR10:	;
	; The terminal interface options section allows you to select RT-11
	; support for up to 17 (decimal) serial asynchronous lines selected
	; from  the  interfaces  installed  in  your  system.    Interfaces
	; supported include those from the DL, DZ and DH series.
	;
	; DL  interfaces  supported  by  RT-11 include the DLV11,  DLV11-E,
	; DLV11-F,  DLV11-J,  and  the  DL11  series.   RT-11 also supports
	; DL11-E and DLV11-E interfaces, with modem capabilities.
	;
	; The  dialog  asks first for the number of local DL11 lines,  then
	; the  number  of remote DL11 lines.   The total number of DL lines
	; supported  may  not exceed 8 lines.   Subsequent sections request
	; the number of local and remote DZ and DH lines.  The total of all
	; local and all remote lines may not exceed 17 (decimal).
	;
	; SYSGEN  assigns  logical unit numbers (LUNs) beginning with local
	; DL11  lines,  then remote DL11 lines.   It then proceeds with any
	; local DZ and remote DZ lines.   It finishes with any local DH and
	; remote  DH lines.   This order of assignment is permanent and you
	; cannot change its order.
	.IFF VT100 .GOTO TR15
	;
	.ASK CONTIN Type return to continue
.TR15:	;
	; After SYSGEN has established the number of lines of each type, it
	; must  establish  the CSR and vector addresses for each line.  The
	; first  such  question  corresponds  to  the first local line (the
	; console),   the  second to the second local line, etc., until all
	; local  lines are accounted for.  At that point, the next question
	; applies to the first remote line, the second to the second remote
	; line, etc., until  all remote lines are accounted for.
	;
	; If your interfaces are DL11-W interfaces, they should be at REV E
	; or higher.  If they are not, an Engineering Change Order (ECO DEC
	; -O-LOG  M7856-S0002)  must  be  applied  to the M7856 module. The
	; field  service  representative  who installs your hardware should
	; apply the ECO, if necessary.
.TRST:
	;
	.ASKN [1.:8.:1] DLNUM 360.  Support for how many local DL11 lines, including the console (1) ?
	.IFF <ESCAPE> .GOTO TR16
	;
	; Enter  the  total number of LOCAL DL11 terminals included in  the
	; target configuration.  Since the console is always a local  DL11,
	; the  response  is  never less than 1.  Do not include REMOTE DL11
	; lines in this number. Remote DL11 lines are specified in the next
	; question.  The range for valid responses is from 1 to 8.
	.GOTO TRST

.TR16:
	.SETN LOC DLNUM
	.SETN DLMDM 0
	.SETN DLLINE 8.-DLNUM
	.IF DLLINE EQ 0 .GOTO TR20
	;
	.ASKN [0.:'DLLINE'.:0.] DLMDM 365.  How many remote DL11 lines are to be supported (0)?
	.IFF <ESCAPE> .GOTO TR20
	;
	; Enter the total number of REMOTE  DL11  terminals included in the
	; target configuration.  Do not include LOCAL  DL11  lines  in this
	; number.  The range for valid responses is from 0 to 'DLLINE'.
	.GOTO TR16

.TR20:	.SETN CNT DLNUM+DLMDM
	.SETS IDENT "first (console)"
	.SETN DEFC 177560
	.SETN DEFV 60
	.SETN C 0
.TR25:
	;
	.ASKN [160000:177570:'DEFC'] DLC$'C' 370.  What is the CSR for the 'IDENT' DL11 ('DEFC')?
	.IFF <ESCAPE> .GOTO TR26
	;
	; Enter the  address  (octal) of the DL11 interface.  The range for
	; valid responses is from 160000 to 177570.
	.GOTO TR25

.TR26:
	;
	.ASKN [60:474:'DEFV'] DLV$'C' 375.  What is the vector for the 'IDENT' DL11 ('DEFV')?
	.IFF <ESCAPE> .GOTO TR30
	;
	; Enter  the vector address  (octal)  of the DL11 interface for the
	; console  terminal.   The  range for valid responses is from 60 to
	; 474.
	.GOTO TR26

.TR30:	.IF C EQ 0 .GOTO TR35
	.SETN DEFC DLC$'C'
	.SETN DEFV DLV$'C'
.TR35:	.SETN DEFC DEFC+10
	.SETN DEFV DEFV+10
	.INC C
	.IF C = 1 .SETN DEFC 176500
	.IF C = 1 .SETN DEFV 300
	.IF LOC = 0 .GOTO TR40
	.DEC LOC
	.IF LOC <> 0 .SETS IDENT "next (local)"
	.IF LOC <> 0 .GOTO TR35A
	.SETN DEFC 175610
	.SETN REM DLMDM+1
	.SETS IDENT "next (remote)"

.TR35A:	.IF DEFC LE 177570 .IF DEFC GE 160000 .GOTO TR35B
	;
	; ?SYSGEN-F-Next default address out of range ('DEFC')
	; ...Restarting query sequence for this device
	;
	.GOTO DLTR

.TR35B:	.IF DEFV LE 474 .IF DEFV GE 60 .GOTO TR40
	;
	; ?SYSGEN-F-Next default vector address out of range ('DEFV')
	; ...Restarting query sequence for this device
	;
	.GOTO DLTR

.TR40:	.IF LOC <> 0 .GOTO TR25
	.DEC REM
	.IF REM <> 0 .GOTO TR25

.TR45:
	.SETN DZ11$N 0
	.SETN DZ11$L 0
	.SETN DZ11$M 0
	;
	.ASK DZM 380.  Do you want DZ series multiplexor support (N)?
	.IFF <ESCAPE> .GOTO TR46
	;
	; You  can select RT-11 support for one DZ11-A or DZ11-C eight-line
	; multiplexor   with  an  additional  DZ11-B  or  DZ11-D eight-line
	; multiplexor, for a maximum of 16 lines.   Or  you can  select one
	; to four  DZV11 or DZQ11 four-line multiplexors.  Modem support is
	; available on remote lines, but is limited to Bell 103 type modems
	; or equivalent.  RT-11 support  for modems  requires the modems to
	; operate in auto-answer mode.  Therefore, the "common carrier" and
	; "clear to send"  options   must   have   been  installed  (during
	; manufacture or installation).    Type  Y  if  your  configuration
	; includes a DZ11 or DZV11/DZQ11 multiplexor.
	.GOTO TR45

.TR46:
	.IFF DZM .GOTO TR200
	;
	.ASK [<TRUE>] DZ11 385.  Do you want DZ11 multiplexor support (Y)?
	.IFF <ESCAPE> .GOTO TR50
	;
	; Type Y if your configuration includes a DZ11 multiplexor
	.GOTO TR46

.TR50:	.SETF DZV$11
	.IFF DZ11 .SETT DZV$11
	.IFT DZ11 .GOTO TR55
	;
	;DZV11 or DZQ11 four-line multiplexor support is assumed.
.TR55:
	.SETN DZLIM 2
	.IFT DZV$11 .SETN DZLIM 4
	;
	.ASKN [1.:'DZLIM':1] DZCNT 390.  How many DZ multiplexors are to be supported (1)?
	.IFF <ESCAPE> .GOTO TR60
	;
	; Enter the number of DZ multiplexors in the target configuration.
	.GOTO TR55

.TR60:	.SETN DZ11$N DZCNT.
	.SETN DZLINE 17.-DLNUM-DLMDM
.TR61:
	;
	.ASKN [0.:'DZLINE'.:1] DZ11$L 395.  How many local DZ lines are to be supported altogether (1)?
	.IFF <ESCAPE> .GOTO TR62
	;
	; Enter the  total  number  (decimal)  of  DZ  lines that are local
	; terminals.  The range for valid responses is from 0 to 'DZLINE'.
	.GOTO TR61

.TR62:
	.SETN DZLINE DZLINE-DZ11$L
	.IF DZLINE EQ 0 .GOTO TR80
.TR62A:
	;
	.ASKN [0.:'DZLINE'.:0] DZ11$M 400.  How many remote DZ lines are to be supported altogether (0)?
	.IFF <ESCAPE> .GOTO TR80
	;
	; Enter  the  total  number  (decimal)  of DZ lines that are remote
	; terminals.  The range for valid responses is from 0 to 'DZLINE'.
	.GOTO TR62A

.TR70:	;
	;The interface  vectors  and  CSR  addresses  are  assigned to  the
	;floating device region and vary with each installation.
	.RETURN

.TR80:	.IF DZ11$M <> 0 .SETT TIM$IT
	.SETN C 1
	.SETN DEFC 160100
	.IFNDF DEFV .SETN DEFV 300
.TR90:
	.IF C GT DZCNT .GOTO TR105
	.SETS NUM C'C'
	.SETS D HEXSTR['C':'C']
.TR95:
	;
	.ASKN [160000:177570:'DEFC'] DZCS$'D' 405.  What is the CSR for the 'NUM' DZ multiplexor ('DEFC')?
	.IFF <ESCAPE> .GOTO TR96
	;
	; Enter  the  CSR  address for the 'NUM' DZ multiplexor.  The valid
	; range is 160000-177570.
	.GOTO TR95

.TR96:
	;
	.ASKN [60:474:'DEFV'] DZVC$'D' 410.  What is the vector for the 'NUM' DZ multiplexor ('DEFV')?
	.IFF <ESCAPE> .GOTO TR100
	;
	; Enter the vector address for the 'NUM' DZ multiplexor.  The valid
	; range is from 60 to 474.
	.GOTO TR96

.TR100:	.SETN DEFC DZCS$'D'
	.SETN DEFV DZVC$'D'
	.INC C
	.SETN DEFC DEFC+10
	.SETN DEFV DEFV+10
.;	.IF DEFV GT 320 .SETN DEFV DEFV+10
	.IF DEFC LE 177570 .IF DEFC GE 160000 .GOTO TR101
	;
	; ?SYSGEN-F-Next default CSR address out of range ('DEFC')
	; ...Restarting query sequence for this device
	;
	.GOTO TR45

.TR101:	.IF DEFV LE 474 .IF DEFC GE 60 .GOTO TR90
	;
	; ?SYSGEN-F-Next default vector address out of range ('DEFV')
	; ...Restarting query sequence for this device
	;
	.GOTO TR45

.TR105:
	;
	.ASKN [0.:9600.:300.] BAUD 415.  What baud rate do you want your lines initialized to (300)?
	.IFF <ESCAPE> .GOTO TR110
	;
	; The  lines must be initialized to a specific baud rate.   You can
	; select 9600, 4800, 2400, 1200, 300, 150, or 110 baud.
	.GOTO TR105

.TR110:	.SETN DZST$P 0
	.IF BAUD = 9600. .SETN DZSP$D 7000
	.IF BAUD = 4800. .SETN DZSP$D 6000
	.IF BAUD = 2400. .SETN DZSP$D 5000
	.IF BAUD = 1200. .SETN DZSP$D 3400
	.IF BAUD = 300.  .SETN DZSP$D 2400
	.IF BAUD = 150.  .SETN DZSP$D 2000
	.IF BAUD = 110.  .SETN DZSP$D 1000
	.IF BAUD = 110.  .SETN DZST$P 40
	.IFDF DZSP$D .GOTO TR110A
	;
	; ?SYSGEN-E-Invalid baud rate.
	.GOTO TR105

.;
.; Dump some DZ-specific temporary symbols
.;
.; Note: Don't dump DEFV
.;

.TR110A:
	.IFDF DZLINE .ERASE LOCAL DZLINE
	.IFDF DZLIM .ERASE LOCAL DZLIM
	.IFDF DZCNT .ERASE LOCAL DZCNT
	.IFDF DEFC .ERASE LOCAL DEFC
.;	.IFDF DEFV .ERASE LOCAL DEFV
	.IFDF NUM .ERASE LOCAL NUM
	.IFDF BAUD .ERASE LOCAL BAUD
	.IFDF C .ERASE LOCAL C
	.IFDF D .ERASE LOCAL D

.;;
.;; DH support questions
.;;

.TR200:
	.SETN DH11$N 0
	.SETN DH11$L 0
	.SETN DH11$M 0
	;
	.ASK DHM 420.  Do you want DH series multiplexor support (N) ?
	.IFF <ESCAPE> .GOTO TR201
	;
	; You  can  select RT-11 support for one CXA16,  CXB16,  CXF32,  or
	; DHF11, or up to two CXY08, DHQ11 or DHV11 multiplexors.
	;
	; Enter YES if your  configuration includes one of the above-listed
	; interfaces.
	.GOTO TR200
.;;
.TR201:
	.IFF DHM .GOTO C192
	.SETN DHLINE 17.-DLNUM-DLMDM
	.IFT DZM .SETN DHLINE DHLINE-DZ11$L-DZ11$M
	.IF DHLINE GT 0 .GOTO TR201A
	;
	; ?SYSGEN-W-Limit of 17 terminals already reached
	.SETF DHM
	.GOTO C192
.TR201A:
	;
	.ASKN [1:'DHLINE'.:1] DH11$N 425.  How many DH series multiplexors are to be supported (1) ?
	.IFF <ESCAPE> .GOTO TR202
	;
	; Enter  the  number  of  DH  series  multiplexors  in  the  target
	; configuration.  The range of valid responses is from 1 to 2.
	.GOTO TR201A
.;;
.TR202:
	;
	.ASKN [0:'DHLINE'.:1] DH11$L 430.  How many local DH lines are to be supported (1) ?
	.IFF <ESCAPE> .GOTO TR203
	;
	; Enter the total number (decimal) of DH lines that are to be local
	; terminals.  The range of valid responses is from 0 to 'DHLINE'.
	.GOTO TR202
.;;
.TR203:
	.SETN DHLINE DHLINE-DH11$L
	.IF DHLINE EQ 0 .GOTO TR204
.TR203A:
	;
	.ASKN [0:'DHLINE'.:0] DH11$M 435.  How many remote DH lines are to be supported (0) ?
	.IFF <ESCAPE> .GOTO TR204
	;
	; Enter  the  total  number  (decimal)  of  DH lines that are to be
	; remote terminals.  The range of valid responses is from 0 to 'DHLINE'.
	.GOTO TR203A
.;;
.TR204:	.IF DH11$M <> 0 .SETT TIM$IT
	.SETN CTRL 1
	.SETN DEFC 160440
	.IFNDF DEFV .SETN DEFV 300
	.SETN DHLINE DH11$L+DH11$M
.TR204A:
	.IF CTRL GT DH11$N .GOTO TR208
	.SETS NUM C'CTRL'
	.SETS D HEXSTR['CTRL':'CTRL']
.TR204B:
	;
	.ASKN [160000:177570:'DEFC'] DHCS$'D' 440.  What is the CSR for the 'NUM' DH multiplexor ('DEFC') ?
	.IFF <ESCAPE> .GOTO TR205
	;
	; Enter  the  CSR address for the 'NUM' DH multiplexor.   The valid
	; range is 160000-177570.
	.GOTO TR204B
.;;
.TR205:
	;
	.ASKN [60:474:'DEFV'] DHVC$'D' 445.  What is the vector for the 'NUM' DH multiplexor ('DEFV') ?
	.IFF <ESCAPE> .GOTO TR206
	;
	; Enter the vector address for the 'NUM' DH multiplexor.  The valid
	; range is from 60-474.
	.GOTO TR205
.;;
.TR206:
	;
	.DISABLE LOWERCASE
	.ASKS DHTYPE 450.  What type is the 'NUM' DH series multiplexor ?
	.ENABLE LOWERCASE
	.IFF <ESCAPE> .GOTO TR206A
	;
	; Enter  the  type of DH multiplexor.   Valid responses are from the
	; following list:
	;
	;	CXA16	CXB16	CXF32	CXY08
	;	DHF11	DHQ11	DHV11	DHU11
	;
	; The  CXF32  and DHF11 interfaces provide 32 lines, but RT-11 will
	; only support the first 16 (decimal) lines on these interfaces.
	.GOTO TR206
.;;
.TR206A:
	.SETN DHSZ$'D' 0
	.IF DHTYPE EQ "CXA16" .SETN DHSZ$'D' 16.
	.IF DHTYPE EQ "CXB16" .SETN DHSZ$'D' 16.
	.IF DHTYPE EQ "CXF32" .SETN DHSZ$'D' 32.
	.IF DHTYPE EQ "CXY08" .SETN DHSZ$'D' 8.
	.IF DHTYPE EQ "DHF11" .SETN DHSZ$'D' 32.
	.IF DHTYPE EQ "DHQ11" .SETN DHSZ$'D' 8.
	.IF DHTYPE EQ "DHU11" .SETN DHSZ$'D' 16.
	.IF DHTYPE EQ "DHV11" .SETN DHSZ$'D' 8.
	.IF DHSZ$'D' NE 0 .GOTO TR206B
	;
	; ?SYSGEN-E-Invalid multiplexor type
	.GOTO TR206
.TR206B:
	.IF DHSZ$'D' LE 16. .GOTO TR207
	;
	; ?SYSGEN-I-Only 16. channels supported on 'DHTYPE'
	.SETN DHSZ$'D' 16.
.;;
.TR207:
	.SETN DHTEMP DHSZ$'D'
	.IF DHLINE LE DHSZ$'D' .SETN DHTEMP DHLINE
	;
	.ASKN [0:'DHTEMP'.:'DHTEMP'.] DHUS$'D' 455.  How many lines are to be supported on the 'NUM' DH multiplexor ('DHTEMP') ?
	.IFF <ESCAPE> .GOTO TR207A
	;
	; Enter  the  number  of lines to be used on the 'NUM' multiplexor.
	; Valid range of responses is from 0 to 'DHTEMP'.
	.GOTO TR207
.;;
.TR207A:
	.SETN DHLINE DHLINE-DHUS$'D'
	.SETN DEFC DHCS$'D'
	.SETN DEFV DHVC$'D'
	.INC CTRL
	.SETN DEFC DEFC+20
	.SETN DEFV DEFV+10
	.IF DEFC LE 177570 .IF DEFC GE 160000 .GOTO TR207B
	;
	; ?SYSGEN-F-Next default CSR address out of range ('DEFC')
	; ...Restarting query sequence for this section
	;
	.GOTO TR200
.TR207B:.IF DEFV LE 474 .IF DEFV GE 60 .GOTO TR204A
	;
	; ?SYSGEN-F-Next default vector address out of range ('DEFV')
	; ...Restarting query sequence for this section
	;
	.GOTO TR200
.;;
.TR208:
	;
	.ASK ANS 460.  Do you want to set initial baud rates on a line-by-line basis (N) ?
	.IFF <ESCAPE> .GOTO TR208A
	;
	; You  may  select  an initial baud rate for all lines on DH-series
	; interfaces,  or  specify  initial  baud  rates  on a line-by-line
	; basis.
	;
	; Enter  YES if  you  wish  to  specify  the default baud rate on a
	; line-by-line basis.
	.GOTO TR208
.TR208A:
	.IFT ANS .GOTO TR210
.;;
.TR209:
	;
	.ASKN [0:38400.:9600.] BAUD 465.  To what baud rate do you want your DH lines initialized (9600) ?
	.IFF <ESCAPE> .GOTO TR209A
	.GOSUB DHSPHL
	.GOTO TR209
.TR209A:
	.SETN OBAUD BAUD
	.GOSUB DHSPCK
	.IF BAUD NE OBAUD .GOTO TR209B
	;
	; ?SYSGEN-E-Invalid baud rate
	.GOTO TR209
.TR209B:
	.SETN DHSP$D 'BAUD'
	.GOTO TR211
.;;
.TR210:
	.SETN CTRL 1
	.SETN LINE 1
.TR210A:
	.SETS D HEXSTR['CTRL':'CTRL']
	.SETS M HEXSTR['LINE':'LINE']
	.SETS CSTR C'CTRL'
	.SETS LSTR C'LINE'
	.IF DHUS$'D' EQ 0 .GOTO TR210D
	;
	.ASKN [0:38400.:9600.] BAUD 470.  Baud rate for the 'LSTR' line of the 'CSTR' multiplexor (9600) ?
	.IFF <ESCAPE> .GOTO TR210B
	.GOSUB DHSPHL
	.GOTO TR210A
.TR210B:
	.SETN OBAUD BAUD
	.GOSUB DHSPCK
	.IF BAUD NE OBAUD .GOTO TR210C
	;
	; ?SYSGEN-W-Invalid baud rate
	.GOTO TR210A
.TR210C:
	.SETN DH$B'D''M' 'BAUD'
	.INC LINE
	.IF LINE LE DHUS$'D' .GOTO TR210A
	.SETN LINE 1
.TR210D:
	.INC CTRL
	.IF CTRL LE DH11$N .GOTO TR210A
.;;
.TR211:
	.IFNDF DHSP$D .SETN DHSP$D 7000	.;Default baud rate
	.SETN DHLE$N 8.			.;Character length
	.SETN DHST$P 1.			.;Stop code units
.;
.; Now dump some DH-specific temporary symbols
.;
	.IFDF DHLINE .ERASE LOCAL DHLINE
	.IFDF DHTYPE .ERASE LOCAL DHTYPE
	.IFDF DHTEMP .ERASE LOCAL DHTEMP
	.IFDF CTRL .ERASE LOCAL CTRL
	.IFDF DEFC .ERASE LOCAL DEFC
	.IFDF DEFV .ERASE LOCAL DEFV
	.IFDF BAUD .ERASE LOCAL BAUD
	.IFDF OBAUD .ERASE LOCAL OBAUD
	.IFDF CSTR .ERASE LOCAL CSTR
	.IFDF LSTR .ERASE LOCAL LSTR
	.IFDF D .ERASE LOCAL D
	.IFDF M .ERASE LOCAL M
	.GOTO C192
.;;
.; DHSPHL
.;	Provides a common help frame for DH baud rate specification
.DHSPHL:
	;
	; The  lines  must be initialized to a specific baud rate.  You can
	; select a rate from the following list:
	;
	;	50	75	110	134.5*	150	300
	;	600	1200	1800	2000	2400	4800
	;	7200	9600	19200	38400
	;
	; * for 134.5 baud, specify 134 in response to the question.
	.RETURN
.;;
.; DHSPCK
.;	Verifies that the baud rate passed in BAUD is a valid baud
.;	rate for a DH series interface.  Returns BAUD altered for
.;	the appropriate speed mask, or unchanged if invalid.
.;
.DHSPCK:
	.IF BAUD EQ 38400. .SETN BAUD 5400
	.IF BAUD EQ 19200. .SETN BAUD 7400
	.IF BAUD EQ 9600. .SETN BAUD 7000
	.IF BAUD EQ 7200. .SETN BAUD 6400
	.IF BAUD EQ 4800. .SETN BAUD 6000
	.IF BAUD EQ 2400. .SETN BAUD 5000
	.IF BAUD EQ 2000. .SETN BAUD 4400
	.IF BAUD EQ 1800. .SETN BAUD 4000
	.IF BAUD EQ 1200. .SETN BAUD 3400
	.IF BAUD EQ 600. .SETN BAUD 3000
	.IF BAUD EQ 300. .SETN BAUD 2400
	.IF BAUD EQ 150. .SETN BAUD 2000
	.IF BAUD EQ 134. .SETN BAUD 1400
	.IF BAUD EQ 110. .SETN BAUD 1000
	.IF BAUD EQ 75. .SETN BAUD 400
	.IF BAUD EQ 50. .SETN BAUD 0
	.RETURN

.;;
.;; User defined system conditionals
.;;
.USERPT:
	;
	.ASK USERP 185.  Do you want to define any other system conditionals (N)?
	.IFF <ESCAPE> .GOTO UP10
	;
	; Some  of  the conditionals which the monitors and device handlers
	; use  are not set as a result of the SYSGEN questions.  An example
	; is PDT$OP, which causes the system to be built with code which is
	; optimal  for  a  PDT.  Respond  with  Y  if  you  want any system
	; conditionals to be included in your system conditional file which
	; are not normally defined through SYSGEN.
	.GOTO USERPT

.UP10:	.IFF USERP .RETURN
.UP11:
	.SETS TXT ""
	;
	; Enter system conditional definition in the form
	;	symbol = value
	;
	; Type <ESCAPE><RETURN> for help.
	; Type ?<RETURN> to list user system conditional definitions.
	; Type .<RETURN> when all user system conditionals have been defined.
	;
.UP20:
	.INC UPNO
.UP21:
	;
	.ASKS [1] TEMPS 190.  Enter the 'TXT'system conditional and value:
	.IFF <ESCAPE> .GOTO UP30
	;
	; Enter  the system conditional definition as you want it to appear
	; in the system conditional (.CND) file.  For example:
	; PDT$OP = 1		; Generate PDT optimal code
	.GOTO UP21

.UP30:	.IF TEMPS EQ "." .GOTO UPCH
	.IF TEMPS NE "?" .GOTO UP40
	;
	; User defined system conditionals:
	;
	.SETN TEMPN 1
.UP35:
	.IFNDF UP1 ; none
	.IFNDF UP'TEMPN' .GOTO UP21
	.SETS TEMPS UP'TEMPN'
	;'TEMPS'
	.INC TEMPN
	.GOTO UP35

.UP40:	.SETS UP'UPNO' TEMPS
	.SETS TXT "next "
	.GOTO UP20

.UPCH:	.IFF CHANGE .RETURN

.C192:	.IFT CHANGE .GOTO CH20

	.GOTO CHANG

.;;
.;; Read in an answer file
.;;
.READA:	.IFNDF ANSFIL .GOTO CHANG
.;; Sett switch for cts-300 lp handlers
	.ERASE LOCAL UDEVCT
	.IFT CTS .SETT SWIT
	.OPENR #0 'ANSFIL'
	;
	;        ...reading in answer file.
.RDLIN:
	.READ #0 STRING
	.IFF <EOF> .'STRING'
	.IFF <EOF> .GOTO RDLIN
	.PURGE #0

	.IFDF CLOCK .SETD CLOCK
	.IFDF TTYOUT .SETD TTYOUT
	.IFDF TTYIN .SETD TTYIN
	.IFDF EMPTY .SETD EMPTY
	.IFDF ERL$U .SETD ERL$U
	.IFDF DLNUM .SETD DLNUM
	.IFDF DZ11$L .SETD DZ11$L
	.IFDF DZ11$M .SETD DZ11$M
	.IFDF DH11$L .SETD DH11$L
	.IFDF DH11$M .SETD DH11$M
	.IFDF LD$UNI .SETD LD$UNI
	.IFDF DU$UNI .SETD DU$UNI
	.IFDF DU$ERL .SETD DU$ERL
	.IFDF MU$ERL .SETD MU$ERL
	.IFDF LS$LUN .SETD LS$LUN
	.IFDF XL$LUN .SETD XL$LUN

.;This is for compatability with V5 answer files:
	.IFNDF PCDZ .SETF PCDZ
	.IFNDF DZ .SETF DZ
	.SET'DZ' DZM		.;DZ in answer file means DZ11
				.;DZM internally means DZ11
	.SET'PCDZ' DZ		.;PCDZ in answer file means device DZ
				.;DZ internally means device DZ

.;This is for compatability with V5.5 answer files:
	.IFNDF BL .SETF BL
	.IFDF SJ .IFNDF SB .GOSUB LB100	.;Must use .GOSUB, can't put it all on
	.IFNDF SJ .SETF SJ		.; 1 line
	.IFNDF SB .SETF SB
	.IFNDF XB .SETF XB
	.IFNDF ZB .SETF ZB
	.IFNDF ZM .SETF ZM
	.IFNDF XBONLY .SETF XBONLY
	.IFNDF XBXM .SET'XM' XBXM
	.IFNDF MQ$RES .SETT MQ$RES
	.IFNDF MTY$HK .SETF MTY$HK
	.IFNDF LS$MTY .SETF LS$MTY
	.IFNDF XL$MTY .SETF XL$MTY
	.IFNDF DH .SETF DH		.;Default for pre-V5.6 .ANS files
	.SET'DH' DHM			.;DH in answer file means DH11
					.;DHM internally means DH11
	.IFF DHM .SETN DH11$N 0.
.;The following 2 statements go together
	.IFT SB .OR .IFT FB .SETT SBFB
	.IFT XM .OR .IFT XB .OR .IFT ZB .OR .IFT ZM .SETF SBFB
	.GOTO UDIN05

.LB100: .SET'SJ' SB
	.RETURN

.UDIN05:
.;
.; Initialize UDEVCT (user device count), if undefined
.;
	.IFDF UDEVCT .GOTO CHANG
	.SETN TEMPCT 0
	.SETT UDINIT
	.SETS UDFIND ""
.UDIN10:
	.GOSUB FINDUD
	.IF UDEVNO EQ 0 .GOTO UDIN20
	.INC TEMPCT
	.GOTO UDIN10

.UDIN20:
	.SETN UDEVCT TEMPCT

.;;
.;; Allow user to change responses
.;;
.;; Note - if you add or remove any numbered SYSGEN question, change
.;; the table at label .CH23:.  This checks the validity of questions.
.;; If you don't change it, SYSGEN will fail.
.;;
.CHANG:
	.IFT NOQ .GOTO SYCND
	;
	.ASK CHANGE Do you want to change any of your responses (N)?
	.IFF <ESCAPE> .GOTO CH10
	;
	; Responses have  been  obtained  for  all of the SYSGEN  questions.
	; You  are  now  given  an  opportunity to make minor changes to the
	; monitor options which you have selected or to remove support for a
	; device  or  add  support  for  a device.  If you have made a large
	; number of errors in this SYSGEN session it is recommended that you
	; restart the SYSGEN dialog.
	.GOTO CHANG

.CH10:	.IFF CHANGE .GOTO SYCND
	.SETS TXT ""
	.GOTO CH21

.CH20:
	.SETS TXT " more"
.CH21:
	;
	.ASK CHMON Do you want to change'TXT' monitor option responses (N)?
	.IFF <ESCAPE> .GOTO CH22
	;
	; You  may  make changes to most of the dialog questions concerning
	; the options to be assembled into the monitor.  You may not change
	; the monitor types to be SYSGENed. Also, you may not add or remove
	; multiterminal  support.  To make these  changes, you must restart
	; the SYSGEN dialog.
	.GOTO CH21

.CH22:
	.IFF CHMON .GOTO CH70
	;
	.ASKN [0:470.:0] CHNUM What question number do you want re-asked?
	.IFF <ESCAPE> .GOTO CH23
	;
	; Respond with the number which precedes the question that  you wish
	; to have re-asked.
	;
	; The  monitor option questions which you may change are:
	;
	;  35.  SB timer support			105.  High speed ring buffer
	;  40.  Device timeout support		110.  Keyboard monitor commands
	;  45.  System I/O error messages	115.  50 Hz clock
	;  50.  System job support		120.  KW11-P as system clock
	;  55.  .SPCPS request			125.  Startup command file
	;  60.  Global SCCA support		130.  Floating point support
	;  70.  Asynchronous terminal status	135.  Memory parity support
	;  75.  Multiterminal timeout support	140.  Power failure message
	;  80.  Output buffer size		145.  Batch support
	;  85.  Input buffer size		150.  Error logging
	;  90.  .FETCH request under X, Z mon	170.  Extended device-unit support
	;  95.  Month and year rollover support	175.  Device ownership support
	; 100.  User command linkage		355.  Number of empty device slots
	;
	; If  you  do  not  want  to  modify  any additional monitor option
	; responses, type <RETURN>.
	.GOTO CH22

	.;; Check if they are asking for an existing question number
.CH23:	.IF CHNUM EQ 0 .GOTO CH70
	.TEST " 5 10 15 20 25 30 35 40 45 50 55 60 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 65 70 75 80 85 90 95 100 105 110 115 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 120 125 130 135 140 145 150 155 160 165 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 170 175 180 185 190 200 205 210 215 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 220 225 230 235 240 245 250 255 260 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 265 270 275 280 285 290 295 300 305 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 310 315 320 325 330 335 340 345 350 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 355 360 365 370 375 380 385 390 395 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 400 405 410 415 420 425 430 435 440 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	.TEST " 445 450 455 460 465 470 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CH25	.;Branch if match found
	;
	; Invalid question number 'CHNUM'
	; Please try again.
	.GOTO CH20

.CH25:
	.IF CHNUM GT 30. .GOTO CH30
	;
	; You  may  not  modify which monitor types are to be built.  To do
	; this you must re-start the SYSGEN session.
	.GOTO CH20

.CH30:	.IF CHNUM NE 65. .GOTO CH35
	;
	; You may not add or remove multiterminal  support.  To do this you
	; must restart the SYSGEN session.
	.GOTO CH20

.CH35:	.IF CHNUM LT 200. .OR .IF CHNUM GT 354. .GOTO CH40
	;
	; You may not change any responses  concerning  devices.   You will
	; be  given  an opportunity to remove support  for a device or have
	; the  questions  concerning  a  specific device re-asked after you
	; have completed making changes to the monitor option questions.
	.GOTO CH20

.CH40:	.IFF CTS .GOTO CH44
	.TEST " 35 45 55 75 120 130 " " 'CHNUM' "
	.IF <STRLEN> EQ 0 .GOTO CH44
	;
	; When  generating  a  CTS-300 system the response to this question
	; may not be changed.
	.GOTO CH20

.CH44:	.DISABLE OCTAL

	.;;If its a KMON question re-ask all the KMON questions.
	.IF CHNUM GE 110. .IF CHNUM LE 114. .SETN CHNUM 110.

	.;;If its an error log question start with 1st EL question.
	.IF CHNUM GE 150. .IF CHNUM LE 165. .SETN CHNUM 150.

	.;;If its concerning Multiterms, ask all multiterm questions.
	.IF CHNUM GE 360. .SETN CHNUM 360.

	.;;Check whether question is valid for selected monitor(s).
	.;;
	.IF CHNUM GT 180. .IF CHNUM LE 199. .GOTO CHER1

	.;;Check for invalid BL monitor question numbers
	.IFF BL .GOTO CH45
	.IF CHNUM LT 80. .GOTO CHER1
	.IF CHNUM EQ 120. .GOTO CHER1
	.IF CHNUM GE 135. .GOTO CHER1

	.;;Check for SB Only questions when not building SB monitor
.CH45:	.IFT SB .GOTO CH47
	.IF CHNUM EQ 35. .GOTO CHER1
	.IF CHNUM EQ 45. .GOTO CHER1

	.;;Check for XM/XB, ZM/ZB Monitor Only questions when not building these monitors
.CH47:	.IFF SBFB .GOTO CH50
	.IF CHNUM EQ 90. .GOTO CHER1

	.;;Check for FB/XM/ZM Only conditionals when not building FB, XM or ZM
.CH50:	.IFT FBXM .OR .IFT ZM .GOTO CH55
	.TEST " 50 55 60 150 175 " " 'CHNUM' "
	.IF <STRLEN> NE 0 .GOTO CHER1

	.;;Check for multiterminal questions when not building multiterminal
.CH55:	.IFT MTT$Y .GOTO CH60
	.IF CHNUM EQ 70. .OR .IF CHNUM EQ 75. .GOTO CHER1
	.IF CHNUM GE 360. .GOTO CHER1

.CH60:
.CH65:	.IF CHNUM NE 360. .GOTO CH66
	;
	; All terminal interface options must be answered again.
.CH66:	.ENABLE OCTAL
	.GOTO Q'CHNUM'

.CHER1:	.ENABLE OCTAL
	;
	; The  dialog  question  you  have  selected  is  invalid  for  the
	; monitor(s)  being  built,  or for  your response to the query for
	; multiterminal support.
	.GOTO CH20

.CH70:
	;
	.ASK CHANGE Do you want to change your device support (N)?
	.IFF <ESCAPE> .GOTO CH71
	;
	; Type  "Y"  if  you want to remove, add, or modify support for any
	; devices.
	.GOTO CH70

.CH71:	.IFF CHANGE .GOTO CH100
	.SETS TXT "device"
.CHDEV:
	;
	.ASK DEVREM Do you want to remove support for any 'TXT' (N)?
	.IFF <ESCAPE> .GOTO CH80
	;
	; You are now given an opportunity to remove support for any device
	; for which support was requested.
	.GOTO CHDEV

.CH80:	.IFF DEVREM .GOTO CH90
	.SETS TXT "more devices"
	;
	.DISABLE LOWERCASE
	.ASKS [0:2] DVREM What device do you NOT want supported?
	.ENABLE LOWERCASE
	.IFF <ESCAPE> .GOTO CH85
	;
	; If  you  previously asked to have a device supported, but you now
	; do  not  want  support for a device, type the two letter name for
	; that device.
	.GOTO CH86

.CH85:	.IF <STRLEN> EQ 0 .GOTO CHDEV
	.TEST DEVSTR " "+DVREM+" "
	.IF <STRLEN> NE 0 .GOTO CH87
	.SETT UDINIT
	.SETS UDFIND DVREM
	.GOSUB FINDUD
	.IF UDEVNO EQ 0 .GOTO CH859
	.ERASE LOCAL UD'UDEVNO'
	.DEC UDEVCT
	.GOTO CH871

.CH859:	;
	; 'DVREM' is not a valid RT-11 device or a user supplied device.
.CH86:	;
	.ASK [<TRUE>] LSTD Do you want a list of available devices (Y)?
	.IFT LSTD .GOSUB LIST
	.GOTO CHDEV

.CH87:	.SETF 'DVREM'
.CH871:	;
	;'DVREM' will not be supported.
	.GOTO CHDEV

.CH90:
	;
	;Do you want to add support for any device or have the questions
	.ASK DEVCHG  for any device re-asked (N)?
	.IFF <ESCAPE> .GOTO CH95
	;
	; SYSGEN  will  give  you  an  opportunity  to add support for both
	; Digital supported  devices and your own devices.  Type "Y" if you
	; want  to add support for any device or change your response to  a
	; question relating to a device.
	.GOTO CH90

.CH95:	.IFF DEVCHG .GOTO CH100
.CH96:
	;
	.ASK [<TRUE>] DIGITL Do you want to add/modify a Digital supported device (Y)?
	.IFF <ESCAPE> .GOTO CH97
	;
	; Type "Y" if you want  to  add  support  for any Digital supported
	; device or have questions related to any  such  device re-asked.
	.GOTO CH96

.CH97:	.IFF DIGITL .GOTO CUSTDV
	.SETS TXT "device name to add/modify"
	.GOTO Z28

.CH100:
	;
	.ASK CHANGE Do you want to define or redefine any system conditionals (N)?
	.IFF <ESCAPE> .GOTO CH988
	;
	; Type "Y" if you want to define additional system conditionals.  If
	; you want to change the value of a conditional, redefine it, and it
	; will assume the new value.
	.GOTO CH100

.CH988:	.IFF CHANGE .GOTO SYCND
	.;Skip through already defined user system conditionals.
	.SETN UPNO 1
.CH989:
	.IFNDF UP'UPNO' .GOTO CH99
	.INC UPNO
	.GOTO CH989

.CH99:	.DEC UPNO
	.GOTO UP11

.;;
.;;	Using previously created answer file, cts-300, create lxp and lxs
.;;	macro files for x.DEV file.
.;;
.CRTMAC:
	.SETN CNT 1
	.SETT SWIT
.GO1:
	.IF CNT GT LPNUM .GOTO GO90
	.SETT PAR
	.SETS TYP "P"
.GO5:
	.SETS TEMPS LP'CNT'
	.IFT L'TEMPS''TYP' .GOSUB CTLP7B
	.IFF PAR .GOTO GO10
	.SETF PAR
	.SETS TYP "S"
	.GOTO GO5

.GO10:	.INC CNT
	.GOTO GO1

.GO90:	.SETF SWIT
	.RETURN
.;;
.;; Subroutine to generate copyright for output files
.;;
.COPRIT:
'P'
'P' Copyright (c) 'CPRTYR' by Mentec, Inc., Nashua, NH.
'P' All rights reserved
'P'
'P' This software is furnished under a license for use only on a
'P' single computer system and  may  be  copied  only  with  the
'P' inclusion of the above copyright notice.  This software,  or
'P' any other copies thereof, may not be provided  or  otherwise
'P' made available to any other person except for  use  on  such
'P' system and to one who agrees to these license  terms.  Title
'P' to  and  ownership of the software shall at all times remain
'P' in Mentec, Inc.
'P'
'P' The information in this document is subject to change without
'P' notice and should not be construed as a commitment by Digital
'P' Equipment Corporation, or Mentec, Inc.
'P'
'P' Digital and Mentec  assume  no  responsibility for the use or
'P' reliability of its software on equipment which is not supplied
'P' by Digital  or Mentec,  and listed  in the  Software  Product
'P' Description.
'P'
	.RETURN

.;;
.;; Create system conditional file SYSGEN.MAC
.;;
.SYCND:	.IFNDF MTI$M .SETF MTI$M
	.IFNDF TIM$IT .SETF TIM$IT
	.IFNDF SB .SETF SB
	.IFF MTI$M .GOTO SCND1
	.IFT TIM$IT .GOTO SCND1
	;
	; ?SYSGEN-I-Device time-out support set on
	.SETT TIM$IT
.SCND1: .IFT TIM$IT .AND .IFT SB .SETT TIME$R
	.IFT SWIT .GOSUB CRTMAC
	.OPEN #0 'SYCND'
	.SETS WRFTXT "file"
	.IFT Q .SETS WRFTXT "and answer files"
	;
 	;        ...writing system conditional 'WRFTXT'.

	.ENABLE DATA #0
.SBTTL	'SYFIL' RT-11 'PATLEV' System Conditional File Created '<DATE4Y>' '<TIME>'

;SYSGEN Edit Level = 'PATLEV'
;+
.DISABLE DATA #0

	.SETS P ".DATA #0 ;"
	.GOSUB COPRIT
	.DATA #0

	.IFT GENSYS .DATA #0 SYSG$N	= 1		;Indicate sysgened monitor
	.IFF Q .GOTO G5
	.OPEN #1 'CANSF'
	.DATA #1 ; SYSGEN 'PATLEV' Answer File Created  '<DATE4Y>'  '<TIME>'
	.SETS P ".DATA #1 ;"
	.GOSUB COPRIT

	.ENABLE DATA #1
SET'BL' BL			.;Baseline monitor
SET'SB' SB			.;Single background monitor
SET'FB' FB			.;Foreground/Background monitor
SET'XM' XM			.;Extended memory monitor
SET'XB' XB			.;Extended background monitor
SET'ZB' ZB			.;Supervisor I-D background monitor
SET'ZM' ZM			.;Supervisor I-D monitor
SET'FBXM' FBXM		.;FB or XM
SET'XBXM' XBXM		.;XB or XM
SET'XMONLY' XMONLY		.;XM only
SET'XBONLY' XBONLY		.;XB only
SET'CTS' CTS		.;CTS-300 SYSGEN
SET'PROCTS' PROCTS		.;Professional CTS-300 SYSGEN
.DISABLE DATA #1

.G5:	.SETS ARG "TIM$IT,Device time out"
	.GOSUB SET

	.SETS ARG "TIME$R,SB timer support"
	.GOSUB SET

	.SETS ARG "RDF$L,System I/O error messages,GENIF0"
	.GOSUB SET

	.SETS ARG "SYT$K,System job support"
	.GOSUB SET

	.SETS ARG "SPC$PS,Save/set main-line PC and PS support"
	.GOSUB SET

	.SETS ARG "SCCA$G,Global SCCA support"
	.GOSUB SET

	.SETS ARG "MTT$Y,Multiterminal support"
	.GOSUB SET

	.IFF MTT$Y .GOTO G8
	.SETS ARG "MAT$S,Asynchronous terminal status"
	.GOSUB SET

	.SETS ARG "MTI$M,Terminal time out"
	.GOSUB SET

	.SETS ARG "MTY$HK,Multiterminal hooks support"
	.GOSUB SET

.G8:	.SETS ARG "XM$FET,.FETCH support under XM/XB, ZM/ZB"
	.GOSUB SET

	.IFNDF TTYOUT .GOTO G10
	.SETS COM "Size of the output buffers"
	.DATA #0 TTYOUT	= 'TTYOUT'.		;'COM'
	.IFT Q .DATA #1 SETN TTYOUT 'TTYOUT'.		.;'COM'

.G10:	.IFNDF TTYIN .GOTO G20
	.SETS COM "Size of the input buffers"
	.DATA #0 TTYIN	= 'TTYIN'.		;'COM'
	.IFT Q .DATA #1 SETN TTYIN 'TTYIN'.		.;'COM'

.G20:	.SETS ARG "ROL$OV,Month rollover support"
	.GOSUB SET

	.SETS ARG "U$CL,User command linkage"
	.GOSUB SET

	.SETS ARG "HSR$B,High speed ring buffer support"
	.GOSUB SET

	.SETS ARG "U$TIL,Utility commands,GENIF0"
	.GOSUB SET

	.SETS ARG "L$ANG,Language commands,GENIF0"
	.GOSUB SET

	.SETS ARG "M$INI,Minimal commands,GENIF0"
	.GOSUB SET

	.IFNDF CLOCK .GOTO G30
	.SETS COM "Power line frequency"
	.DATA #0 CLOCK	= 'CLOCK'.		;'COM'
	.IFT Q .DATA #1 SETN CLOCK 'CLOCK'.		.;'COM'

.G30:	.SETS ARG "RTE$M,RTEM-11 Support"
	.GOSUB SET

	.SETS ARG "UNI$64,Extended device-unit support"
	.GOSUB SET

	.SETS ARG "OWN$ER,Device ownership support,GENIF0"
	.GOSUB SET

	.SETS ARG "KW11$P,Use KW11-P clock as system clock"
	.GOSUB SET

	.SETS ARG "STAR$T,Startup command file"
	.GOSUB SET

	.SETS ARG "FPU$11,Floating point support"
	.GOSUB SET

	.SETS ARG "MPT$Y,Memory parity support"
	.GOSUB SET

	.SETS ARG "PWF$L,Power fail"
	.GOSUB SET

	.SETS ARG "BATC$H,Batch support"
	.GOSUB SET

	.SETS ARG "ERL$G,Error log support"
	.GOSUB SET

	.IFNDF ERL$G .SETF ERL$G
	.IFF ERL$G .GOTO G37
	.SETS COM "Number of units to be logged"
	.DATA #0 ERL$U	= 'ERL$U'.		;'COM'
	.IFT Q .DATA #1 SETN ERL$U 'ERL$U'.		.;'COM'

.G37:	.SETS ARG "MQ$RES,MQ resident"
	.GOSUB SET

.G40:	.IFF Q .GOTO G45

	.SETN CNT 1
.G43:
	.SETS DCOM DCM'CNT'[1:2]
	.TEST DCM'CNT'
	.SETS DC DCM'CNT'[5:'<STRLEN>']
	.IF DCOM NE "DZ" .GOTO G43A
	.IFT 'DCOM' .DATA #1 SETT PCDZ		.;'DC'
	.IFF 'DCOM' .DATA #1 SETF PCDZ		.;'DC'
	.GOTO G43B

.G43A:	.IFT 'DCOM' .DATA #1 SETT 'DCOM'			.;'DC'
	.IFF 'DCOM' .DATA #1 SETF 'DCOM'			.;'DC'
.G43B:	.INC CNT
	.IF CNT LE RTDEVS  .GOTO G43

	.DATA #1 SETN UDEVCT 'UDEVCT'		.;User handler count
	.SETT UDINIT
	.SETS UDFIND ""
.G43C:
	.GOSUB FINDUD
	.IF UDEVNO EQ 0 .GOTO G44
	.SETS TEMPS UD'UDEVNO'
	.DATA #1 SETS UD'UDEVNO' "'TEMPS'"		.;User supplied handler
	.IFNDF BUD'UDEVNO' .SETF BUD'UDEVNO'
	.SETL BUDTMP BUD'UDEVNO'
	.DATA #1 SET'BUDTMP' BUD'UDEVNO'		.;User handler /BOUND:512. option
	.GOTO G43C

.G44:	.IFNDF LPNUM .SETN LPNUM 0
	.SETS TEMPS "CTS-300 Line printer"
	.SETS TEMPSP "Number of CTS-300 Printers"

	.ENABLE DATA #1
SET'LPP' LPP		.;'TEMPS'
SET'LQP' LQP		.;'TEMPS'
SET'LRP' LRP		.;'TEMPS'
SET'LSP' LSP		.;'TEMPS'
SET'LPS' LPS		.;'TEMPS'
SET'LQS' LQS		.;'TEMPS'
SET'LRS' LRS		.;'TEMPS'
SET'LSS' LSS		.;'TEMPS'
SETN LPNUM 'LPNUM'		.;'TEMPSP'
.DISABLE DATA #1

	.SETS TEMPS "Status register for CTS-300 printer"
	.SETS TEMPSP "Vector for CTS-300 printer"

	.IFNDF LPPCSR .GOTO G44A
	.DATA #1 SETN LPPCSR 'LPPCSR'	.;'TEMPS'

.G44A:	.IFNDF LPPVEC .GOTO G44B
	.DATA #1 SETN LPPVEC 'LPPVEC'		.;'TEMPSP'

.G44B:	.IFNDF LQPCSR .GOTO G44C
	.DATA #1 SETN LQPCSR 'LQPCSR'	.;'TEMPS'

.G44C:	.IFNDF LQPVEC .GOTO G44D
	.DATA #1 SETN LQPVEC 'LQPVEC'		.;'TEMPSP'

.G44D:	.IFNDF LRPCSR .GOTO G44E
	.DATA #1 SETN LRPCSR 'LRPCSR'	.;'TEMPS'

.G44E:	.IFNDF LRPVEC .GOTO G44F
	.DATA #1 SETN LRPVEC 'LRPVEC'		.;'TEMPSP'

.G44F:	.IFNDF LSPCSR .GOTO G44G
	.DATA #1 SETN LSPCSR 'LSPCSR'	.;'TEMPS'

.G44G:	.IFNDF LSPVEC .GOTO G44H
	.DATA #1 SETN LSPVEC 'LSPVEC'		.;'TEMPSP'

.G44H:	.IFNDF LPSCSR .GOTO G44I
	.DATA #1 SETN LPSCSR 'LPSCSR'	.;'TEMPS'

.G44I:	.IFNDF LPSVEC .GOTO G44J
	.DATA #1 SETN LPSVEC 'LPSVEC'		.;'TEMPSP'

.G44J:	.IFNDF LQSCSR .GOTO G44K
	.DATA #1 SETN LQSCSR 'LQSCSR'	.;'TEMPS'

.G44K:	.IFNDF LQSVEC .GOTO G44L
	.DATA #1 SETN LQSVEC 'LQSVEC'		.;'TEMPSP'

.G44L:	.IFNDF LRSCSR .GOTO G44M
	.DATA #1 SETN LRSCSR 'LRSCSR'	.;'TEMPS'

.G44M:	.IFNDF LRSVEC .GOTO G44N
	.DATA #1 SETN LRSVEC 'LRSVEC'		.;'TEMPSP'

.G44N:	.IFNDF LSSCSR .GOTO G44O
	.DATA #1 SETN LSSCSR 'LSSCSR'	.;'TEMPS'

.G44O:	.IFNDF LSSVEC .GOTO G45
	.DATA #1 SETN LSSVEC 'LSSVEC'		.;'TEMPSP'

.G45:	.IFF DX .GOTO G50
	.SETS ARG "DXT$O,Second RX01 controller support"
	.GOSUB SET

	.SETS COM "Status register for first RX01"
	.DATA #0 DX$CSR	= 'DX$CSR'	;'COM'
	.IFT Q .DATA #1 SETN DX$CSR 'DX$CSR'	.;'COM'

	.SETS COM "Vector for first RX01"
	.DATA #0 DX$VEC	= 'DX$VEC'		;'COM'
	.IFT Q .DATA #1 SETN DX$VEC 'DX$VEC'		.;'COM'

	.IFF DXT$O .GOTO G50
	.SETS COM "Status register for second RX01"
	.DATA #0 DX$CS2	= 'DX$CS2'	;'COM'
	.IFT Q .DATA #1 SETN DX$CS2	'DX$CS2'	.;'COM'

	.SETS COM "Vector for second RX01"
	.DATA #0 DX$VC2	= 'DX$VC2'		;'COM'
	.IFT Q .DATA #1 SETN DX$VC2 'DX$VC2'		.;'COM'

.G50:	.IFF DY .GOTO G60
	.SETS ARG "DY$DD,RX02 double density only"
	.GOSUB SET

	.SETS ARG "DYT$O,Second RX02 controller support"
	.GOSUB SET

	.SETS COM "Status register for first RX02"
	.DATA #0 DY$CSR	= 'DY$CSR'	;'COM'
	.IFT Q .DATA #1 SETN DY$CSR 'DY$CSR'	.;'COM'

	.SETS COM "Vector for first RX02"
	.DATA #0 DY$VEC	= 'DY$VEC'		;'COM'
	.IFT Q .DATA #1 SETN DY$VEC 'DY$VEC'		.;'COM'

	.IFF DYT$O .GOTO G60
	.SETS COM "Status register for second RX02"
	.DATA #0 DY$CS2	= 'DY$CS2'	;'COM'
	.IFT Q .DATA #1 SETN DY$CS2 'DY$CS2'	.;'COM'

	.SETS COM "Vector for second RX02"
	.DATA #0 DY$VC2	= 'DY$VC2'		;'COM'
	.IFT Q .DATA #1 SETN DY$VC2 'DY$VC2'		.;'COM'

.G60:	.IFF DL .GOTO G90
	.SETS COM "Number of RL01/RL02 units"
	.DATA #0 DL$UN	= 'DL$UN'.		;'COM'
	.IFT Q .DATA #1 SETN DL$UN 'DL$UN'.		.;'COM'

.G90:	.IFF DU .GOTO G95
	.SETS COM "Number of MSCP ports"
	.DATA #0 DU$POR	= 'DU$POR'		;'COM'
	.IFT Q .DATA #1 SETN DU$POR 'DU$POR'		.;'COM'

	.SETS ARG "DU$N64,Extended device-unit support for DU"
	.GOSUB SET

	.SETS COM "Number of DU device-units supported"
	.DATA #0 DU$UNI	= 'DU$UNI'.		;'COM'
	.IFT Q .DATA #1 SETN DU$UNI 'DU$UNI'.		.;'COM'

	.IFNDF DU$ERL .GOTO G901
	.IF DU$ERL EQ 0 .GOTO G901
	.SETS COM "MSCP error logging support"
	.IF DU$ERL EQ 1 .SETS COM "No 'COM'"
	.DATA #0 DU$ERL	= 'DU$ERL'.		;'COM'
	.IFT Q .DATA #1 SETN DU$ERL 'DU$ERL'.		.;'COM'

.G901:	.SETS COMC "Status register for "
	.SETS COMV "Vector of "
	.SETS COM2 " MSCP port"
	.DATA #0 DU$CSR	= 'DU$CSR'	;'COMC''C1''COM2'
	.DATA #0 DU$VEC	= 'DU$VEC'		;'COMV''C1''COM2'
	.IFF Q .GOTO G911
	.DATA #1 SETN DU$CSR 'DU$CSR'	.;'COMC''C1''COM2'
	.DATA #1 SETN DU$VEC 'DU$VEC'		.;'COMV''C1''COM2'

.G911:	.IF DU$POR EQ 1 .GOTO G999
	.DATA #0 DU$CS1	= 'DU$CS1'	;'COMC''C2''COM2'
	.DATA #0 DU$VC1	= 'DU$VC1'		;'COMV''C2''COM2'
	.IFF Q .GOTO G912
	.DATA #1 SETN DU$CS1 'DU$CS1'	.;'COMC''C2''COM2'
	.DATA #1 SETN DU$VC1 'DU$VC1'		.;'COMV''C2''COM2'

.G912:	.IF DU$POR EQ 2 .GOTO G999
	.DATA #0 DU$CS2	= 'DU$CS2'	;'COMC''C3''COM2'
	.DATA #0 DU$VC2	= 'DU$VC2'		;'COMV''C3''COM2'
	.IFF Q .GOTO G993
	.DATA #1 SETN DU$CS2 'DU$CS2'	.;'COMC''C3''COM2'
	.DATA #1 SETN DU$VC2 'DU$VC2'		.;'COMV''C3''COM2'

.G993:	.IF DU$POR EQ 3 .GOTO G999
	.DATA #0 DU$CS3	= 'DU$CS3'	;'COMC''C4''COM2'
	.DATA #0 DU$VC3	= 'DU$VC3'		;'COMV''C4''COM2'
	.IFF Q .GOTO G999
	.DATA #1 SETN DU$CS3 'DU$CS3'	.;'COMC''C4''COM2'
	.DATA #1 SETN DU$VC3 'DU$VC3'		.;'COMV''C4''COM2'

.G999:	.SETS ARG "DU$BBR,MSCP Bad Block Replacement,GENIF0"
	.GOSUB SET

.G95:	.IFF SP .GOTO G100
	.SETS ARG "SP$FLG,Spool banner page support"
	.GOSUB SET

.G100:	.IFF MT .GOTO G110
	.SETS ARG "MT$FSM,TM11 file-structured support"
	.GOSUB SET

	.SETS COM "Number of TM11 units"
	.DATA #0 MT$UN	= 'MT$UN'.		;'COM'
	.IFT Q .DATA #1 SETN MT$UN 'MT$UN'.		.;'COM'

.G110:	.IFF MM .GOTO G120
	.SETS ARG "MM$FSM,TJU16 file-structured support"
	.GOSUB SET

	.SETS COM "Number of TJU16 units"
	.DATA #0 MM$UN 	= 'MM$UN'.		;'COM'
	.IFT Q .DATA #1 SETN MM$UN 'MM$UN'.		.;'COM'

.G120:	.SETS COMC "Status register of "
	.SETS COMV "Vector of "
	.IFF MS .GOTO G129
	.SETS ARG "MS$FSM,TS11 file-structured support"
	.GOSUB SET

	.SETS COM "Number of TS11 units"
	.DATA #0 MS$UN	= 'MS$UN'.		;'COM'
	.IFT Q .DATA #1 SETN MS$UN 'MS$UN'.		.;'COM'

	.DATA #0 MS$CSR	= 'MS$CSR'	;'COMC''C1' TS11
	.DATA #0 MS$VEC	= 'MS$VEC'		;'COMV''C1' TS11
	.IFF Q .GOTO G121
	.DATA #1 SETN MS$CSR 'MS$CSR'	.;'COMC''C1' TS11
	.DATA #1 SETN MS$VEC 'MS$VEC'   	.;'COMV''C1' TS11

.G121:	.IF MS$UN EQ 1 .GOTO G129
	.DATA #0 MS$CS1	= 'MS$CS1'	;'COMC''C2' TS11
	.DATA #0 MS$VC1	= 'MS$VC1'		;'COMV''C2' TS11
	.IFF Q .GOTO G122
	.DATA #1 SETN MS$CS1 'MS$CS1'	.;'COMC''C2' TS11
	.DATA #1 SETN MS$VC1 'MS$VC1'		.;'COMV''C2' TS11

.G122:	.IF MS$UN EQ 2 .GOTO G129
	.DATA #0 MS$CS2	= 'MS$CS2'	;'COMC''C3' TS11
	.DATA #0 MS$VC2	= 'MS$VC2'		;'COMV''C3' TS11
	.IFF Q .GOTO G123
	.DATA #1 SETN MS$CS2 'MS$CS2'	.;'COMC''C3' TS11
	.DATA #1 SETN MS$VC2 'MS$VC2'		.;'COMV''C3' TS11

.G123:	.IF MS$UN EQ 3 .GOTO G129
	.DATA #0 MS$CS3	= 'MS$CS3'	;'COMC''C4' TS11
	.DATA #0 MS$VC3	= 'MS$VC3'		;'COMV''C4' TS11
	.IFF Q .GOTO G124
	.DATA #1 SETN MS$CS3 'MS$CS3'	.;'COMC''C4' TS11
	.DATA #1 SETN MS$VC3 'MS$VC3'		.;'COMV''C4' TS11

.G124:	.IF MS$UN EQ 4 .GOTO G129
	.DATA #0 MS$CS4	= 'MS$CS4'	;'COMC''C5' TS11
	.DATA #0 MS$VC4	= 'MS$VC4'		;'COMV''C5' TS11
	.IFF Q .GOTO G125
	.DATA #1 SETN MS$CS4 'MS$CS4'	.;'COMC''C5' TS11
	.DATA #1 SETN MS$VC4 'MS$VC4'		.;'COMV''C5' TS11

.G125:	.IF MS$UN EQ 5 .GOTO G129
	.DATA #0 MS$CS5	= 'MS$CS5'	;'COMC''C6' TS11
	.DATA #0 MS$VC5	= 'MS$VC5'		;'COMV''C6' TS11
	.IFF Q .GOTO G126
	.DATA #1 SETN MS$CS5 'MS$CS5'	.;'COMC''C6' TS11
	.DATA #1 SETN MS$VC5 'MS$VC5'		.;'COMV''C6' TS11

.G126:	.IF MS$UN EQ 6 .GOTO G129
	.DATA #0 MS$CS6	= 'MS$CS6'	;'COMC''C7' TS11
	.DATA #0 MS$VC6	= 'MS$VC6'		;'COMV''C7' TS11
	.IFF Q .GOTO G127
	.DATA #1 SETN MS$CS6 'MS$CS6'	.;'COMC''C7' TS11
	.DATA #1 SETN MS$VC6 'MS$VC6'		.;'COMV''C7' TS11

.G127:	.IF MS$UN EQ 7 .GOTO G129
	.DATA #0 MS$CS7	= 'MS$CS7'	;'COMC''C10' TS11
	.DATA #0 MS$VC7	= 'MS$VC7'		;'COMV''C10' TS11
	.IFF Q .GOTO G129
	.DATA #1 SETN MS$CS7 'MS$CS7'	.;'COMC''C10' TS11
	.DATA #1 SETN MS$VC7 'MS$VC7'		.;'COMV''C10' TS11

.G129:	.IFF MU .GOTO G130
	.SETS ARG "MU$FSM,TMSCP Magtape file-structured support"
	.GOSUB SET

	.SETS COM "Number of TMSCP Magtape units"
	.DATA #0 MU$UN 	= 'MU$UN'.		;'COM'
	.IFT Q .DATA #1 SETN MU$UN 'MU$UN'.		.;'COM'

	.DATA #0 MU$CSR	= 'MU$CSR'	;'COMC''C1' MSCP Tape
	.DATA #0 MU$VEC	= 'MU$VEC'		;'COMV''C1' MSCP Tape
	.IFF Q .GOTO G129A
	.DATA #1 SETN MU$CSR 'MU$CSR'	.;'COMC''C1' MSCP Tape
	.DATA #1 SETN MU$VEC 'MU$VEC'   	.;'COMV''C1' MSCP Tape

.G129A:	.IF MU$UN EQ 1 .GOTO G129D
	.DATA #0 MU$CS1	= 'MU$CS1'	;'COMC''C2' MSCP Tape
	.DATA #0 MU$VC1	= 'MU$VC1'		;'COMV''C2' MSCP Tape
	.IFF Q .GOTO G129B
	.DATA #1 SETN MU$CS1 'MU$CS1'	.;'COMC''C2' MSCP Tape
	.DATA #1 SETN MU$VC1 'MU$VC1'		.;'COMV''C2' MSCP Tape

.G129B:	.IF MU$UN EQ 2 .GOTO G129D
	.DATA #0 MU$CS2	= 'MU$CS2'	;'COMC''C3' MSCP Tape
	.DATA #0 MU$VC2	= 'MU$VC2'		;'COMV''C3' MSCP Tape
	.IFF Q .GOTO G129C
	.DATA #1 SETN MU$CS2 'MU$CS2'	.;'COMC''C3' MSCP Tape
	.DATA #1 SETN MU$VC2 'MU$VC2'		.;'COMV''C3' MSCP Tape

.G129C:	.IF MU$UN EQ 3 .GOTO G129D
	.DATA #0 MU$CS3	= 'MU$CS3'	;'COMC''C4' MSCP Tape
	.DATA #0 MU$VC3	= 'MU$VC3'		;'COMV''C4' MSCP Tape
	.IFF Q .GOTO G129D
	.DATA #1 SETN MU$CS3 'MU$CS3'	.;'COMC''C4' MSCP Tape
	.DATA #1 SETN MU$VC3 'MU$VC3'		.;'COMV''C4' MSCP Tape

.G129D:	.IFNDF MU$ERL .GOTO G130
	.IF MU$ERL EQ 0 .GOTO G130
	.SETS COM "TMSCP error logging support"
	.IF MU$ERL EQ 1 .SETS COM "No 'COM'"
	.DATA #0 MU$ERL	= 'MU$ERL'.		;'COM'
	.IFT Q .DATA #1 SETN MU$ERL 'MU$ERL'.		.;'COM'

.G130:	.IFF XL .GOTO G135
	.DATA #0 XL$CSR	= 'XL$CSR'	;XL CSR
	.DATA #0 XL$VEC	= 'XL$VEC'		;XL Vector
	.IFF Q .GOTO G130A
	.DATA #1 SETN XL$CSR 'XL$CSR'	.;XL CSR
	.DATA #1 SETN XL$VEC 'XL$VEC'		.;XL Vector
.G130A:	.IFNDF XL$MTY .SETF XL$MTY
	.SETS ARG "XL$MTY,XL Multiterminal handler hooks"
	.GOSUB SET
	.IFF XL$MTY .GOTO G135
	.DATA #0 XL$LUN	= 'XL$LUN'.		;XL Multiterminal hook LUN
	.IFF Q .GOTO G135
	.DATA #1 SETN XL$LUN 'XL$LUN'.		.;XL Multiterminal hook LUN

.G135:	.IFF NQ .GOTO G137
	.DATA #0 NQ$CSR	= 'NQ$CSR'	;NQX CSR
	.DATA #0 NQ$VEC	= 'NQ$VEC'		;NQX Vector
	.IFF Q .GOTO G137
	.DATA #1 SETN NQ$CSR 'NQ$CSR'	.;NQX CSR
	.DATA #1 SETN NQ$VEC 'NQ$VEC'		.;NQX Vector

.G137:	.IFF NU .GOTO G139
	.DATA #0 NU$CSR	= 'NU$CSR'	;NUX CSR
	.DATA #0 NU$VEC	= 'NU$VEC'		;NUX Vector
	.IFF Q .GOTO G139
	.DATA #1 SETN NU$CSR 'NU$CSR'	.;NUX CSR
	.DATA #1 SETN NU$VEC 'NU$VEC'		.;NUX Vector

.G139:	.IFT CTS .IFF PROCTS .GOTO G141
	.SETS ARG "LS$PC,LS PC300 support"
	.GOSUB SET

	.IFF LP .OR .IFNDF LP$CSR .GOTO G140
	.DATA #0 LP$CSR	= 'LP$CSR'	;Line printer CSR
	.DATA #0 LP$VEC	= 'LP$VEC'		;Line printer vector
	.IFF Q .GOTO G140
	.DATA #1 SETN LP$CSR 'LP$CSR'	.;Line printer CSR
	.DATA #1 SETN LP$VEC 'LP$VEC'		.;Line printer vector

.G140:	.IFF LS .OR .IFNDF LS$CSR .GOTO G141
	.DATA #0 LS$CSR	= 'LS$CSR'	;Serial LP CSR
	.DATA #0 LS$VEC	= 'LS$VEC'		;Serial LP vector
	.IFF Q .GOTO G140A
	.DATA #1 SETN LS$CSR 'LS$CSR'	.;Serial LP CSR
	.DATA #1 SETN LS$VEC 'LS$VEC'		.;Serial LP vector
.G140A:	.IFNDF LS$MTY .SETF LS$MTY
	.SETS ARG "LS$MTY,LS Multiterminal handler hooks"
	.GOSUB SET
	.IFF LS$MTY .GOTO G141
	.DATA #0 LS$LUN	= 'LS$LUN'.		;LS Multiterminal hook LUN
	.IFF Q .GOTO G141
	.DATA #1 SETN LS$LUN 'LS$LUN'.		.;LS Multiterminal hook LUN

.G141:	.IFF LD .GOTO G150
	.SETS ARG "LD$N64,Extended device-unit support for LD"
	.GOSUB SET

	.SETS COM "Number of LD device-units supported"
	.DATA #0 LD$UNI	= 'LD$UNI'.		;'COM'
	.IFT Q .DATA #1 SETN LD$UNI 'LD$UNI'.		.;'COM'

.G150:	.IFT Q .DATA #1 SETN EMPTY 'EMPTY'.		.;Empty device slots

	.SETN UPNO 1
.G161:
	.IFNDF UP'UPNO' .GOTO G200
	.SETS TEMPS UP'UPNO'
	.DATA #0 'TEMPS'
	.IFT Q .DATA #1 SETS UP'UPNO' "'TEMPS'"
	.INC UPNO
	.GOTO G161

.;;
.;; Do system conditional file (SYSGEN.CND) and answer file for multiterminal
.;;
.G200:	.IFF MTT$Y .GOTO G500
	.SETS COM "Number of local DL11 interfaces"
	.DATA #0 DL11$L	= 'DLNUM'.		;'COM'
	.IFT Q .DATA #1 SETN DLNUM 'DLNUM'.		.;'COM'

	.SETS COM "Number of remote DL11-E lines"
	.DATA #0 DL11$M	= 'DLMDM'.		;'COM'
	.IFT Q .DATA #1 SETN DLMDM 'DLMDM'.		.;'COM'

	.SETN DL11$N DLNUM+DLMDM
	.SETS COM "Total number of DL11 lines"
	.DATA #0 DL11$N	= 'DL11$N'.		;'COM'
	.IFT Q .DATA #1 SETN DL11$N 'DL11$N'.		.;'COM'

	.DATA #0 DLC$0	= 'DLC$0'	;'COMC''C1' DL11 (Console)
	.DATA #0 DLV$0	= 'DLV$0'		;'COMV''C1' DL11 (Console)
	.IFF Q .GOTO G221
	.DATA #1 SETN DLC$0 'DLC$0'	.;'COMC''C1' DL11
	.DATA #1 SETN DLV$0 'DLV$0'   	.;'COMV''C1' DL11

.G221:	.IF DL11$N EQ 1 .GOTO G230
	.DATA #0 DLC$1	= 'DLC$1'	;'COMC''C2' DL11
	.DATA #0 DLV$1	= 'DLV$1'		;'COMV''C2' DL11
	.IFF Q .GOTO G222
	.DATA #1 SETN DLC$1 'DLC$1'	.;'COMC''C2' DL11
	.DATA #1 SETN DLV$1 'DLV$1'		.;'COMV''C2' DL11

.G222:	.IF DL11$N EQ 2 .GOTO G230
	.DATA #0 DLC$2	= 'DLC$2'	;'COMC''C3' DL11
	.DATA #0 DLV$2	= 'DLV$2'		;'COMV''C3' DL11
	.IFF Q .GOTO G223
	.DATA #1 SETN DLC$2 'DLC$2'	.;'COMC''C3' DL11
	.DATA #1 SETN DLV$2 'DLV$2'		.;'COMV''C3' DL11

.G223:	.IF DL11$N EQ 3 .GOTO G230
	.DATA #0 DLC$3	= 'DLC$3'	;'COMC''C4' DL11
	.DATA #0 DLV$3	= 'DLV$3'		;'COMV''C4' DL11
	.IFF Q .GOTO G224
	.DATA #1 SETN DLC$3 'DLC$3'	.;'COMC''C4' DL11
	.DATA #1 SETN DLV$3 'DLV$3'		.;'COMV''C4' DL11

.G224:	.IF DL11$N EQ 4 .GOTO G230
	.DATA #0 DLC$4	= 'DLC$4'	;'COMC''C5' DL11
	.DATA #0 DLV$4	= 'DLV$4'		;'COMV''C5' DL11
	.IFF Q .GOTO G225
	.DATA #1 SETN DLC$4 'DLC$4'	.;'COMC''C5' DL11
	.DATA #1 SETN DLV$4 'DLV$4'		.;'COMV''C5' DL11

.G225:	.IF DL11$N EQ 5 .GOTO G230
	.DATA #0 DLC$5	= 'DLC$5'	;'COMC''C6' DL11
	.DATA #0 DLV$5	= 'DLV$5'		;'COMV''C6' DL11
	.IFF Q .GOTO G226
	.DATA #1 SETN DLC$5 'DLC$5'	.;'COMC''C6' DL11
	.DATA #1 SETN DLV$5 'DLV$5'		.;'COMV''C6' DL11

.G226:	.IF DL11$N EQ 6 .GOTO G230
	.DATA #0 DLC$6	= 'DLC$6'	;'COMC''C7' DL11
	.DATA #0 DLV$6	= 'DLV$6'		;'COMV''C7' DL11
	.IFF Q .GOTO G227
	.DATA #1 SETN DLC$6 'DLC$6'	.;'COMC''C7' DL11
	.DATA #1 SETN DLV$6 'DLV$6'		.;'COMV''C7' DL11

.G227:	.IF DL11$N EQ 7 .GOTO G230
	.DATA #0 DLC$7	= 'DLC$7'	;'COMC''C10' DL11
	.DATA #0 DLV$7	= 'DLV$7'		;'COMV''C10' DL11
	.IFF Q .GOTO G230
	.DATA #1 SETN DLC$7 'DLC$7'	.;'COMC''C10' DL11
	.DATA #1 SETN DLV$7 'DLV$7'		.;'COMV''C10' DL11

.G230:	.IFT Q .DATA #1 SET'DZM' DZ			.;DZ series multiplexor support
	.SETS COM "Number of DZ series multiplexors"
	.DATA #0 DZ11$N	= 'DZ11$N'.		;'COM'
	.IFT Q .DATA #1 SETN DZ11$N 'DZ11$N'		.;'COM'

	.IFF DZM .GOTO G400
	.SETS COM "Number of Local DZ lines"
	.DATA #0 DZ11$L	= 'DZ11$L'.		;'COM'
	.IFT Q .DATA #1 SETN DZ11$L 'DZ11$L'.		.;'COM'

	.SETS COM "Number of Remote DZ lines"
	.DATA #0 DZ11$M	= 'DZ11$M'.		;'COM'
	.IFT Q .DATA #1 SETN DZ11$M 'DZ11$M'.		.;'COM'

	.SETS ARG "DZV$11,DZV11/DZQ11 multiplexor support,GENIF0"
	.GOSUB SET

	.DATA #0 DZCS$0	= 'DZCS$0'	;'COMC''C1' DZ series multiplexor
	.DATA #0 DZVC$0	= 'DZVC$0'		;'COMV''C1' DZ series multiplexor
	.IFF Q .GOTO G321
	.DATA #1 SETN DZCS$0 'DZCS$0'	.;'COMC''C1' DZ series multiplexor
	.DATA #1 SETN DZVC$0 'DZVC$0'   	.;'COMV''C1' DZ series multiplexor

.G321:	.IF DZ11$N EQ 1 .GOTO G330
	.DATA #0 DZCS$1	= 'DZCS$1'	;'COMC''C2' DZ series multiplexor
	.DATA #0 DZVC$1	= 'DZVC$1'		;'COMV''C2' DZ series multiplexor
	.IFF Q .GOTO G322
	.DATA #1 SETN DZCS$1 'DZCS$1'	.;'COMC''C2' DZ series multiplexor
	.DATA #1 SETN DZVC$1 'DZVC$1'		.;'COMV''C2' DZ series multiplexor

.G322:	.IF DZ11$N EQ 2 .GOTO G330
	.DATA #0 DZCS$2	= 'DZCS$2'	;'COMC''C3' DZV11/DZQ11 multiplexor
	.DATA #0 DZVC$2	= 'DZVC$2'		;'COMV''C3' DZV11/DZQ11 multiplexor
	.IFF Q .GOTO G323
	.DATA #1 SETN DZCS$2 'DZCS$2'	.;'COMC''C3' DZV11/DZQ11 multiplexor
	.DATA #1 SETN DZVC$2 'DZVC$2'		.;'COMV''C3' DZV11/DZQ11 multiplexor

.G323:	.IF DZ11$N EQ 3 .GOTO G330
	.DATA #0 DZCS$3	= 'DZCS$3'	;'COMC''C4' DZV11/DZQ11 multiplexor
	.DATA #0 DZVC$3	= 'DZVC$3'		;'COMV''C4' DZV11/DZQ11 multiplexor
	.IFF Q .GOTO G330
	.DATA #1 SETN DZCS$3 'DZCS$3'	.;'COMC''C4' DZV11/DZQ11 multiplexor
	.DATA #1 SETN DZVC$3 'DZVC$3'		.;'COMV''C4' DZV11/DZQ11 multiplexor

.G330:	.DATA #0 DZSP$D	= 'DZSP$D'		;Baud rate
	.IFT Q .DATA #1 SETN DZSP$D 'DZSP$D'	.;Baud rate
	.DATA #0 DZST$P	= 'DZST$P'		;Stop unit
	.IFT Q .DATA #1 SETN DZST$P 'DZST$P'		.;Stop unit

.G400:	.IFT Q .DATA #1 SET'DHM' DH			.;DH11 series multiplexor support
	.SETS COM "Number of DH series multiplexors"
	.DATA #0 DH11$N	= 'DH11$N'.		;'COM'
	.IFT Q .DATA #1 SETN DH11$N 'DH11$N'.		.;'COM'

	.IFF DHM .GOTO G500
	.SETS COM "Number of Local DH lines"
	.DATA #0 DH11$L	= 'DH11$L'.		;'COM'
	.IFT Q .DATA #1 SETN DH11$L 'DH11$L'.		.;'COM'

	.SETS COM "Number of Remote DH lines"
	.DATA #0 DH11$M	= 'DH11$M'.		;'COM'
	.IFT Q .DATA #1 SETN DH11$M 'DH11$M'.		.;'COM'

	.DATA #0 DHLE$N	= 'DHLE$N'.		;Character length
	.IFT Q .DATA #1 SETN DHLE$N 'DHLE$N'.		.;Character length
	.DATA #0 DHST$P	= 'DHST$P'.		;Stop code units
	.IFT Q .DATA #1 SETN DHST$P 'DHST$P'.		.;Stop code units
	.DATA #0 DHSP$D	= 'DHSP$D'		;Default baud rate
	.IFT Q .DATA #1 SETN DHSP$D 'DHSP$D'	.;Default baud rate

.G410:	.SETN CTRL 1
.G420:
	.SETS CSTR C'CTRL'
	.SETS D HEXSTR['CTRL':'CTRL']
	.SETN DHTMPC DHCS$'D'
	.SETN DHTMPV DHVC$'D'
	.SETN DHTMPS DHSZ$'D'
	.SETN DHTMPU DHUS$'D'
	.DATA #0 DHCS$'D'	= 'DHTMPC'	;'COMC''CSTR' DH series multiplexor
	.DATA #0 DHVC$'D'	= 'DHTMPV'		;'COMV''CSTR' DH series multiplexor
	.DATA #0 DHSZ$'D'	= 'DHTMPS'.		;Lines available on 'CSTR' DH series multiplexor
	.DATA #0 DHUS$'D'	= 'DHTMPU'.		;Lines used on 'CSTR' DH series multiplexor
	.IFF Q .GOTO G430
	.DATA #1 SETN DHCS$'D' 'DHTMPC'	.;'COMC''CSTR' DH series multiplexor
	.DATA #1 SETN DHVC$'D' 'DHTMPV'		.;'COMV''CSTR' DH series multiplexor
	.DATA #1 SETN DHSZ$'D' 'DHTMPS'.		.;Lines available on 'CSTR' DH series multiplexor
	.DATA #1 SETN DHUS$'D' 'DHTMPU'.		.;Lines used on 'CSTR' DH series multiplexor

.G430:	.SETN LINE 1
.G435:
	.SETS LSTR C'LINE'
	.SETS M HEXSTR['LINE':'LINE']
	.IFNDF DH$B'D''M' .GOTO G440
	.SETN DHTMPB DH$B'D''M'
	.DATA #0 DH$B'D''M'	= 'DHTMPB'		;Baud rate of 'LSTR' line
	.IFT Q .DATA #1 SETN DH$B'D''M' 'DHTMPB'	.;Baud rate of 'LSTR' line
.G440:	.INC LINE
	.IF LINE LE DHUS$'D' .GOTO G435
	.INC CTRL
	.IF CTRL LE DH11$N .GOTO G420
	.ERASE LOCAL D M
	.ERASE LOCAL CTRL CSTR LSTR
	.ERASE LOCAL DHTMPC DHTMPV DHTMPS DHTMPU DHTMPB
.G500:
	.CLOSE #0
	.CLOSE #1
	.GOTO BUILD

.;;SET: This procedure generates a TRUE/FALSE conditional to the
.;;     system conditional file (SYSGEN.CND).
.;;	 It also generates a line to the answer file.
.;;	Input:
.;;	  A character string to be parsed, in the format:
.;;	    "COND,COM,GENFL"
.;;	      where
.;;		CNDL is the name of the conditional
.;;		COM  is the comment to be used if the CNDL is TRUE
.;;		GENFL, if defined -> gen a line to SYCND even if CNDL = 0
.SET:
	.PARSE ARG "," CNDL COM GENFL
	.IFNDF 'CNDL' .RETURN
	.IFT 'CNDL' .DATA #0 'CNDL'	= 1		;'COM'
	.IFF 'CNDL' .IF GENFL NE "" .DATA #0 'CNDL'	= 0		;'COM'

	.;;Now do the answer file
	.IFF Q .RETURN
	.IFF 'CNDL' .GOTO SETT1
	.DATA #1 SETT 'CNDL'		.;'COM'
	.RETURN

.SETT1:	.DATA #1 SETF 'CNDL'		.;No 'COM'
	.RETURN

.;;
.;; Get devices for MONBLD
.;;
.BUILD:
.;
.; First, we'll dump some un-needed symbols
.;
	.ERASE LOCAL DCM1 DCM2 DCM3 DCM4 DCM5 DCM6 DCM7
	.ERASE LOCAL DCM10 DCM11 DCM12 DCM13 DCM14 DCM15 DCM16 DCM17
	.ERASE LOCAL DCM20 DCM21 DCM22 DCM23 DCM24 DCM25 DCM26 DCM27
	.ERASE LOCAL C1 C2 C3 C4 C5 C6 C7 C10
	.ERASE LOCAL C11 C12 C13 C14 C15 C16 C17 C20
	.ERASE LOCAL LP1 LP2 LP3 LP4 LPID1 LPID2 LPID3 LPID4
	.ERASE LOCAL COM COMC TEMPS TEMPSP TXT
	.ERASE LOCAL CTSMAX DEVSTR DEV64 DEVBND HEXSTR
.;
	.SETS DOUT$ <SYDISK>+"'<SYUNIT>'"
	.SETS DMAP$ DOUT$
	.SETS DIN$ <SYDISK>
	.IF <SYDISK> <> "DW" .SETS DIN$ DIN$+"1"
	.IF <SYDISK> = "DW" .SETS DIN$ DIN$+"0"
	.SETS OUT$ DOUT$
	.SETS MAP$ DMAP$
	.SETS IN$ DIN$
	.IF <SYUNIT> EQ 1 .SETS IN$ <SYDISK>+"0"
	;
	;
	; 'STARS'
	;	DEVICE ASSIGNMENTS AND SYSGEN CLEANUP
	; 'STARS'
.PHSRC:
	.SETT SAV
	.SETT KEEPWK
	.IFT NOQ .GOTO SYBLD
	.DISABLE LOWERCASE
	;
	.ASKS [0:3:DIN$] IN$ What is the name of the source input device [xxn] ('DIN$')?
	.IFF <ESCAPE> .GOTO PHCK1
	.GOSUB PHHLP
	.GOTO PHSRC

.PHCK1:	.SETS DEV IN$
.PHOUT:
	;
	.ASKS [0:3:DOUT$] OUT$ What is the name of the binary output device [xxn] ('DOUT$')?
	.IFF <ESCAPE> .GOTO PHCK2
	.GOSUB PHHLP
	.GOTO PHOUT

.PHCK2:	.SETS DEV OUT$
.PHMAP:
	;
	.ASKS [0:3:DMAP$] MAP$ What is the name of the map output device [xxn] ('DMAP$')?
	.IFF <ESCAPE> .GOTO PHCK3
	.GOSUB PHHLP
	.GOTO PHMAP

.PHCK3:	.SETS DEV MAP$
	.ENABLE LOWERCASE
.OBJS:
	.SETF SAV
	.IFT PROCTS .SETT KEEPWK
	.IFT CTS .GOTO SYBLD
	;
	.ASK [<TRUE>] SAV Do you want to retain the system OBJs (Y)?
	.IFF <ESCAPE> .GOTO DELWK
	;
	; RETAIN SYSTEM OBJS:
	; The  indirect  command  files  that  the SYSGEN program generates
	; delete  the object modules  (from which the system is built) when
	; the object modules are no longer needed.  This measure serves  to
	; conserve disk space while the system is being built. However, the
	; object  modules are often useful later when you patch the system.
	; If your output device has sufficient free space, you may elect to
	; retain all system object modules for future use.
	.GOTO OBJS

.DELWK:
.DELWK1:
	;
	.ASK [<TRUE>] KEEPWK Do you want to retain the work files (Y)?
	.IFF <ESCAPE> .GOTO SYBLD
	;
	; RETAIN SYSGEN WORK FILES:
	; SYSGEN  creates  five files which are used for the system builds.
	; These  are  the 3 indirect command files ('SYSBLD', 'MONBLD',
	; and 'DEVBLD'), and the 2 source conditional files ('SYCND'
	; and 'DEVTBL').  If you wish to have these files deleted after
	; the system  build  procedure,  'SYSBLD',  is  run, type "N" and
	; these work files will not be retained.
	.GOTO DELWK1

.PHHLP:
	;
        ; SYSTEM BUILD:
	; The SYSGEN assembling and linking process requires a source input
	; device  and  a  binary output device, as well as an output device
	; for monitor link maps.  The name  you  specify  can  be  either a
	; physical or logical name (for example, RK1, DU4, BLD, etc.).  For
	; more explanation, see the RT-11 SYSTEM GENERATION GUIDE.
	.RETURN

.;;
.;; Create SYSBLD (xxxxxx.BLD)
.;;
.SYBLD:	;
 	;        ...writing build files.
	.OPEN #3 'SYSBLD'
	.IF <FILERR> EQ 1 .GOTO S10
	;
	; ?SYSGEN-F-Error creating 'SYSBLD'
	.EXIT 4

.S10:	.ENABLE DATA #3
!SYSGEN Edit Level = 'PATLEV'
!	'SYSBLD' Created '<DATE4Y>'  '<TIME>'
.DISABLE DATA

	.SETS P ".DATA #3 !"
	.GOSUB COPRIT
	.DATA #3

	.DATA #3 $@'MONBLD'
	.DATA #3 $@'DEVBLD'
	.IFF KEEPWK .DATA #3 DEL/NOQUERY ('SYCND','DEVTBL','MONBLD','DEVBLD','SYSBLD')
	.CLOSE #3

.;;
.;; Create MONBLD (xxxxxx.MON)
.;;
	.SETS INDWRN "!DO NOT RUN THIS FILE THROUGH IND.  TO EXECUTE THIS FILE TYPE: $@"
	.SETF BSF
	.IFT BL .OR .IFT SB .OR .IFT FB .SETT BSF
	.SETF XZ
	.IFT XM .OR .IFT XB .OR .IFT ZM .OR .IFT ZB .SETT XZ
	.SETF TAPE
	.IFT MT .OR .IFT MM .OR .IFT MS .OR .IFT MU .SETT TAPE
	.SETF FSM
	.IFT MT$FSM .OR .IFT MM$FSM .OR .IFT MS$FSM .OR .IFT MU$FSM .SETT FSM
	.SETT DEL
	.IFT SAV .SETF DEL
	.OPEN #3 'MONBLD'
	.IF <FILERR> EQ 1 .GOTO M10
	;
	; ?SYSGEN-F-Error creating 'MONBLD'
	.EXIT 4

.M10:	.SETS MTT ""
	.SETS MAC "MAC/OB:OBJ:"
	.SETS L "/CR/LIS:LST:"
	.SETS SYC "+'SYFIL'+EDTG+"
	.SETS TRMTBL ""
	.IFT MTT$Y .SETS TRMTBL "+TRMTBL"

	.ENABLE DATA #3
!SYSGEN Edit Level = 'PATLEV'
!       'MONBLD' Created  '<DATE4Y>'  '<TIME>'
.DISABLE DATA

	.SETS P ".DATA #3 !"
	.GOSUB COPRIT

	.ENABLE DATA #3

!'STARS'
'INDWRN''MONBLD'
!'STARS'

.DISABLE DATA

	.IFT NOQ .GOTO M15

	.ENABLE DATA #3
ASSIGN 'IN$' SRC
ASSIGN 'OUT$' BIN
ASSIGN 'MAP$' MAP
ASSIGN 'OUT$' OBJ
.DISABLE DATA #3

.M15:	.IFF BL .GOTO M20
	.IFF LST .DATA #3 'MAC'KMBL SRC:(SJ'SYC'KMON+KMOVLY)
	.IFT LST .DATA #3 'MAC'KMBL'L'KMBL SRC:(SJ'SYC'KMON+KMOVLY)
	.IFF LST .DATA #3 'MAC'RMBL SRC:(SJ'SYC'USR+RMONSJ)
	.IFT LST .DATA #3 'MAC'RMBL'L'RMBL SRC:(SJ'SYC'USR+RMONSJ)
	.IFF LST .DATA #3 'MAC'TBBL SRC:(SJ'SYC''DEVFIL')
	.IFT LST .DATA #3 'MAC'TBBL'L'TBBL SRC:(SJ'SYC''DEVFIL')
	.IFF LST .DATA #3 'MAC'BTBL SRC:(SJ'SYC'BSTRAP)
	.IFT LST .DATA #3 'MAC'BTBL'L'BTBL SRC:(SJ'SYC'BSTRAP)

	.ENABLE DATA #3
LINK/EXE:BIN:RT11BL.TM2/BOU:1000/MAP:BIN:RT11BL.TM5/SYM:BIN:RT11BL.TM3/PRO
OBJ:RMBL
OBJ:KMBL,TBBL//
OVLY0
LINK/EXE:BIN:RT11BL.TM1/MAP:BIN:RT11BL.TM4 OBJ:BTBL,BIN:RT11BL.TM3
R MONMRG
BIN:RT11BL.SYG,MAP:RT11BL.MAP=BIN:RT11BL.TM1,RT11BL.TM2,RT11BL.TM4,RT11BL.TM5
^C
DEL BIN:RT11BL.TM(1,2,3,4,5)
.DISABLE DATA #3

	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(KM,RM,BT)BL.OBJ
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(TB)BL.OBJ

.M20:	.IFF SB .GOTO M30
	.IFF LST .DATA #3 'MAC'KMSB SRC:(SB'SYC'KMON+KMOVLY)
	.IFT LST .DATA #3 'MAC'KMSB'L'KMSB SRC:(SB'SYC'KMON+KMOVLY)
	.IFF LST .DATA #3 'MAC'USSB SRC:(SB'SYC'USR)
	.IFT LST .DATA #3 'MAC'USSB'L'USSB SRC:(SB'SYC'USR)
	.IFF LST .DATA #3 'MAC'RMSB SRC:(SB'SYC'RMON)
	.IFT LST .DATA #3 'MAC'RMSB'L'RMSB SRC:(SB'SYC'RMON)
	.IFF LST .DATA #3 'MAC'TBSB SRC:(SB'SYC''DEVFIL''TRMTBL')
	.IFT LST .DATA #3 'MAC'TBSB'L'TBSB SRC:(SB'SYC''DEVFIL''TRMTBL')
	.IFF LST .DATA #3 'MAC'BTSB SRC:(SB'SYC'BSTRAP)
	.IFT LST .DATA #3 'MAC'BTSB'L'BTSB SRC:(SB'SYC'BSTRAP)

	.IFF MTT$Y .GOTO M22
	.SETS MTT ",MESB,MISB"
	.IFF LST .DATA #3 'MAC'MESB SRC:(SB'SYC'MTTEMT)
	.IFT LST .DATA #3 'MAC'MESB'L'MESB SRC:(SB'SYC'MTTEMT)
	.IFF LST .DATA #3 'MAC'MISB SRC:(SB'SYC'MTTINT)
	.IFT LST .DATA #3 'MAC'MISB'L'MISB SRC:(SB'SYC'MTTINT)

.M22:	.ENABLE DATA #3
LINK/EXE:BIN:RT11SB.TM2/BOU:1000/MAP:BIN:RT11SB.TM5/SYM:BIN:RT11SB.TM3/PRO
OBJ:USSB
OBJ:RMSB
OBJ:KMSB'MTT',TBSB//
OVLY0
LINK/EXE:BIN:RT11SB.TM1/MAP:BIN:RT11SB.TM4 OBJ:BTSB,BIN:RT11SB.TM3
R MONMRG
BIN:RT11SB.SYG,MAP:RT11SB.MAP=BIN:RT11SB.TM1,RT11SB.TM2,RT11SB.TM4,RT11SB.TM5
^C
DEL BIN:RT11SB.TM(1,2,3,4,5)
.DISABLE DATA #3

	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(KM,US,RM)SB.OBJ
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(TB,BT)SB.OBJ
	.IFT DEL .IFT MTT$Y .DATA #3 DELETE/NOQ OBJ:(ME,MI)SB.OBJ

.M30:	.IFF FB .GOTO M40
	.IFF LST .DATA #3 'MAC'KMFB SRC:(FB'SYC'KMON+KMOVLY)
	.IFT LST .DATA #3 'MAC'KMFB'L'KMFB SRC:(FB'SYC'KMON+KMOVLY)
	.IFF LST .DATA #3 'MAC'USFB SRC:(FB'SYC'USR)
	.IFT LST .DATA #3 'MAC'USFB'L'USFB SRC:(FB'SYC'USR)
	.IFF LST .DATA #3 'MAC'RMFB SRC:(FB'SYC'RMON)
	.IFT LST .DATA #3 'MAC'RMFB'L'RMFB SRC:(FB'SYC'RMON)
	.IFF LST .DATA #3 'MAC'TBFB SRC:(FB'SYC''DEVFIL''TRMTBL')
	.IFT LST .DATA #3 'MAC'TBFB'L'TBFB SRC:(FB'SYC''DEVFIL''TRMTBL')
	.IFF LST .DATA #3 'MAC'BTFB SRC:(FB'SYC'BSTRAP)
	.IFT LST .DATA #3 'MAC'BTFB'L'BTFB SRC:(FB'SYC'BSTRAP)

	.IFF MTT$Y .GOTO M32
	.SETS MTT ",MEFB,MIFB"
	.IFF LST .DATA #3 'MAC'MEFB SRC:(FB'SYC'MTTEMT)
	.IFT LST .DATA #3 'MAC'MEFB'L'MEFB SRC:(FB'SYC'MTTEMT)
	.IFF LST .DATA #3 'MAC'MIFB SRC:(FB'SYC'MTTINT)
	.IFT LST .DATA #3 'MAC'MIFB'L'MIFB SRC:(FB'SYC'MTTINT)

.M32:	.ENABLE DATA #3
LINK/EXE:BIN:RT11FB.TM2/BOU:1000/MAP:BIN:RT11FB.TM5/SYM:BIN:RT11FB.TM3/PRO
OBJ:USFB
OBJ:RMFB
OBJ:KMFB'MTT',TBFB//
OVLY0
LINK/EXE:BIN:RT11FB.TM1/MAP:BIN:RT11FB.TM4 OBJ:BTFB,BIN:RT11FB.TM3
R MONMRG
BIN:RT11FB.SYG,MAP:RT11FB.MAP=BIN:RT11FB.TM1,RT11FB.TM2,RT11FB.TM4,RT11FB.TM5
^C
DEL BIN:RT11FB.TM(1,2,3,4,5)
.DISABLE DATA #3

	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(KM,US,RM)FB.OBJ
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(TB,BT)FB.OBJ
	.IFT DEL .IFT MTT$Y .DATA #3 DELETE/NOQ OBJ:(ME,MI)FB.OBJ

.M40:	.IFF XM .GOTO M45
	.IFF LST .DATA #3 'MAC'KMXM SRC:(XM'SYC'KMON+KMOVLY)
	.IFT LST .DATA #3 'MAC'KMXM'L'KMXM SRC:(XM'SYC'KMON+KMOVLY)
	.IFF LST .DATA #3 'MAC'USXM SRC:(XM'SYC'USR)
	.IFT LST .DATA #3 'MAC'USXM'L'USXM SRC:(XM'SYC'USR)
	.IFF LST .DATA #3 'MAC'RMXM SRC:(XM'SYC'RMON)
	.IFT LST .DATA #3 'MAC'RMXM'L'RMXM SRC:(XM'SYC'RMON)
	.IFF LST .DATA #3 'MAC'SBXM SRC:(XM'SYC'XMSUBS)
	.IFT LST .DATA #3 'MAC'SBXM'L'SBXM SRC:(XM'SYC'XMSUBS)
	.IFF LST .DATA #3 'MAC'TBXM SRC:(XM'SYC''DEVFIL''TRMTBL')
	.IFT LST .DATA #3 'MAC'TBXM'L'TBXM SRC:(XM'SYC''DEVFIL''TRMTBL')
	.IFF LST .DATA #3 'MAC'BTXM SRC:(XM'SYC'BSTRAP)
	.IFT LST .DATA #3 'MAC'BTXM'L'BTXM SRC:(XM'SYC'BSTRAP)

	.IFF MTT$Y .GOTO M42
	.SETS MTT ",MEXM,MIXM"
	.IFF LST .DATA #3 'MAC'MEXM SRC:(XM'SYC'MTTEMT)
	.IFT LST .DATA #3 'MAC'MEXM'L'MEXM SRC:(XM'SYC'MTTEMT)
	.IFF LST .DATA #3 'MAC'MIXM SRC:(XM'SYC'MTTINT)
	.IFT LST .DATA #3 'MAC'MIXM'L'MIXM SRC:(XM'SYC'MTTINT)

.M42:	.ENABLE DATA #3
LINK/EXE:BIN:RT11XM.TM2/BOU:1000/MAP:BIN:RT11XM.TM5/SYM:BIN:RT11XM.TM3/PRO
OBJ:USXM
OBJ:RMXM
OBJ:SBXM,KMXM'MTT',TBXM//
OVLY0
LINK/EXE:BIN:RT11XM.TM1/MAP:BIN:RT11XM.TM4 OBJ:BTXM,BIN:RT11XM.TM3
R MONMRG
BIN:RT11XM.SYG,MAP:RT11XM.MAP=BIN:RT11XM.TM1,RT11XM.TM2,RT11XM.TM4,RT11XM.TM5
^C
DEL BIN:RT11XM.TM(1,2,3,4,5)
.DISABLE DATA #3

	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(KM,US,RM)XM.OBJ
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(SB,TB,BT)XM.OBJ
	.IFT DEL .IFT MTT$Y .DATA #3 DELETE/NOQ OBJ:(ME,MI)XM.OBJ

.M45:	.IFF XB .GOTO M60
	.IFF LST .DATA #3 'MAC'KMXB SRC:(XB'SYC'KMON+KMOVLY)
	.IFT LST .DATA #3 'MAC'KMXB'L'KMXB SRC:(XB'SYC'KMON+KMOVLY)
	.IFF LST .DATA #3 'MAC'USXB SRC:(XB'SYC'USR)
	.IFT LST .DATA #3 'MAC'USXB'L'USXB SRC:(XB'SYC'USR)
	.IFF LST .DATA #3 'MAC'RMXB SRC:(XB'SYC'RMON)
	.IFT LST .DATA #3 'MAC'RMXB'L'RMXB SRC:(XB'SYC'RMON)
	.IFF LST .DATA #3 'MAC'SBXB SRC:(XB'SYC'XMSUBS)
	.IFT LST .DATA #3 'MAC'SBXB'L'SBXB SRC:(XB'SYC'XMSUBS)
	.IFF LST .DATA #3 'MAC'TBXB SRC:(XB'SYC''DEVFIL''TRMTBL')
	.IFT LST .DATA #3 'MAC'TBXB'L'TBXB SRC:(XB'SYC''DEVFIL''TRMTBL')
	.IFF LST .DATA #3 'MAC'BTXB SRC:(XB'SYC'BSTRAP)
	.IFT LST .DATA #3 'MAC'BTXB'L'BTXB SRC:(XB'SYC'BSTRAP)

	.IFF MTT$Y .GOTO M47
	.SETS MTT ",MEXB,MIXB"
	.IFF LST .DATA #3 'MAC'MEXB SRC:(XB'SYC'MTTEMT)
	.IFT LST .DATA #3 'MAC'MEXB'L'MEXB SRC:(XB'SYC'MTTEMT)
	.IFF LST .DATA #3 'MAC'MIXB SRC:(XB'SYC'MTTINT)
	.IFT LST .DATA #3 'MAC'MIXB'L'MIXB SRC:(XB'SYC'MTTINT)

.M47:	.ENABLE DATA #3
LINK/EXE:BIN:RT11XB.TM2/BOU:1000/MAP:BIN:RT11XB.TM5/SYM:BIN:RT11XB.TM3/PRO
OBJ:USXB
OBJ:RMXB
OBJ:SBXB,KMXB'MTT',TBXB//
OVLY0
LINK/EXE:BIN:RT11XB.TM1/MAP:BIN:RT11XB.TM4 OBJ:BTXB,BIN:RT11XB.TM3
R MONMRG
BIN:RT11XB.SYG,MAP:RT11XB.MAP=BIN:RT11XB.TM1,RT11XB.TM2,RT11XB.TM4,RT11XB.TM5
^C
DEL BIN:RT11XB.TM(1,2,3,4,5)
.DISABLE DATA #3

	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(KM,US,RM)XB.OBJ
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(SB,TB,BT)XB.OBJ
	.IFT DEL .IFT MTT$Y .DATA #3 DELETE/NOQ OBJ:(ME,MI)XB.OBJ

.M60:	.IFF ZM .GOTO M70
	.IFF LST .DATA #3 'MAC'KMZM SRC:(ZM'SYC'KMON+KMOVLY)
	.IFT LST .DATA #3 'MAC'KMZM'L'KMZM SRC:(ZM'SYC'KMON+KMOVLY)
	.IFF LST .DATA #3 'MAC'USZM SRC:(ZM'SYC'USR)
	.IFT LST .DATA #3 'MAC'USZM'L'USZM SRC:(ZM'SYC'USR)
	.IFF LST .DATA #3 'MAC'RMZM SRC:(ZM'SYC'RMON)
	.IFT LST .DATA #3 'MAC'RMZM'L'RMZM SRC:(ZM'SYC'RMON)
	.IFF LST .DATA #3 'MAC'SBZM SRC:(ZM'SYC'XMSUBS)
	.IFT LST .DATA #3 'MAC'SBZM'L'SBZM SRC:(ZM'SYC'XMSUBS)
	.IFF LST .DATA #3 'MAC'TBZM SRC:(ZM'SYC''DEVFIL''TRMTBL')
	.IFT LST .DATA #3 'MAC'TBZM'L'TBZM SRC:(ZM'SYC''DEVFIL''TRMTBL')
	.IFF LST .DATA #3 'MAC'BTZM SRC:(ZM'SYC'BSTRAP)
	.IFT LST .DATA #3 'MAC'BTZM'L'BTZM SRC:(ZM'SYC'BSTRAP)

	.IFF MTT$Y .GOTO M65
	.SETS MTT ",MEZM,MIZM"
	.IFF LST .DATA #3 'MAC'MEZM SRC:(ZM'SYC'MTTEMT)
	.IFT LST .DATA #3 'MAC'MEZM'L'MEZM SRC:(ZM'SYC'MTTEMT)
	.IFF LST .DATA #3 'MAC'MIZM SRC:(ZM'SYC'MTTINT)
	.IFT LST .DATA #3 'MAC'MIZM'L'MIZM SRC:(ZM'SYC'MTTINT)

.M65:	.ENABLE DATA #3
LINK/EXE:BIN:RT11ZM.TM2/BOU:1000/MAP:BIN:RT11ZM.TM5/SYM:BIN:RT11ZM.TM3/PRO
OBJ:USZM
OBJ:RMZM
OBJ:SBZM,KMZM'MTT',TBZM//
OVLY0
LINK/EXE:BIN:RT11ZM.TM1/MAP:BIN:RT11ZM.TM4 OBJ:BTZM,BIN:RT11ZM.TM3
R MONMRG
BIN:RT11ZM.SYG,MAP:RT11ZM.MAP=BIN:RT11ZM.TM1,RT11ZM.TM2,RT11ZM.TM4,RT11ZM.TM5
^C
DEL BIN:RT11ZM.TM(1,2,3,4,5)
.DISABLE DATA #3

	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(KM,US,RM)ZM.OBJ
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(SB,TB,BT)ZM.OBJ
	.IFT DEL .IFT MTT$Y .DATA #3 DELETE/NOQ OBJ:(ME,MI)ZM.OBJ

.M70:	.IFF ZB .GOTO M90
	.IFF LST .DATA #3 'MAC'KMZB SRC:(ZB'SYC'KMON+KMOVLY)
	.IFT LST .DATA #3 'MAC'KMZB'L'KMZB SRC:(ZB'SYC'KMON+KMOVLY)
	.IFF LST .DATA #3 'MAC'USZB SRC:(ZB'SYC'USR)
	.IFT LST .DATA #3 'MAC'USZB'L'USZB SRC:(ZB'SYC'USR)
	.IFF LST .DATA #3 'MAC'RMZB SRC:(ZB'SYC'RMON)
	.IFT LST .DATA #3 'MAC'RMZB'L'RMZB SRC:(ZB'SYC'RMON)
	.IFF LST .DATA #3 'MAC'SBZB SRC:(ZB'SYC'XMSUBS)
	.IFT LST .DATA #3 'MAC'SBZB'L'SBZB SRC:(ZB'SYC'XMSUBS)
	.IFF LST .DATA #3 'MAC'TBZB SRC:(ZB'SYC''DEVFIL''TRMTBL')
	.IFT LST .DATA #3 'MAC'TBZB'L'TBZB SRC:(ZB'SYC''DEVFIL''TRMTBL')
	.IFF LST .DATA #3 'MAC'BTZB SRC:(ZB'SYC'BSTRAP)
	.IFT LST .DATA #3 'MAC'BTZB'L'BTZB SRC:(ZB'SYC'BSTRAP)

	.IFF MTT$Y .GOTO M75
	.SETS MTT ",MEZB,MIZB"
	.IFF LST .DATA #3 'MAC'MEZB SRC:(ZB'SYC'MTTEMT)
	.IFT LST .DATA #3 'MAC'MEZB'L'MEZB SRC:(ZB'SYC'MTTEMT)
	.IFF LST .DATA #3 'MAC'MIZB SRC:(ZB'SYC'MTTINT)
	.IFT LST .DATA #3 'MAC'MIZB'L'MIZB SRC:(ZB'SYC'MTTINT)

.M75:	.ENABLE DATA #3
LINK/EXE:BIN:RT11ZB.TM2/BOU:1000/MAP:BIN:RT11ZB.TM5/SYM:BIN:RT11ZB.TM3/PRO
OBJ:USZB
OBJ:RMZB
OBJ:SBZB,KMZB'MTT',TBZB//
OVLY0
LINK/EXE:BIN:RT11ZB.TM1/MAP:BIN:RT11ZB.TM4 OBJ:BTZB,BIN:RT11ZB.TM3
R MONMRG
BIN:RT11ZB.SYG,MAP:RT11ZB.MAP=BIN:RT11ZB.TM1,RT11ZB.TM2,RT11ZB.TM4,RT11ZB.TM5
^C
DEL BIN:RT11ZB.TM(1,2,3,4,5)
.DISABLE DATA #3

	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(KM,US,RM)ZB.OBJ
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(SB,TB,BT)ZB.OBJ
	.IFT DEL .IFT MTT$Y .DATA #3 DELETE/NOQ OBJ:(ME,MI)ZB.OBJ

.M90:	.CLOSE #3

.;;
.;; Create DEVBLD (xxxxxx.DEV)
.;;
	.OPEN #3 'DEVBLD'
	.IF <FILERR> EQ 1 .GOTO D5
	;
	; ?SYSGEN-F-Error creating 'DEVBLD'
	.EXIT 4

.D5:	.ENABLE DATA #3
!SYSGEN Edit level = 'PATLEV'
!	'DEVBLD' Created  '<DATE4Y>'  '<TIME>'
.DISABLE DATA

	.SETS P ".DATA #3 !"
	.GOSUB COPRIT

	.ENABLE DATA #3

!'STARS'
'INDWRN''DEVBLD'
!'STARS'

.DISABLE DATA

	.IFT NOQ .GOTO D8

	.ENABLE DATA #3
ASSIGN 'IN$' SRC
ASSIGN 'OUT$' BIN
ASSIGN 'OUT$' OBJ
.DISABLE DATA #3

.D8:	.IFNDF BATC$H .SETF BATC$H
	.SET'BATC$H' BA
	.SETN UDEVNO 0
	.IFF BL .GOTO D10
	.IFT MTT$Y .GOTO D10
	.SETF GEN
	.SETT NXM
	.SETT TT
	.SETS DEV "TT"
	.GOSUB DEVGEN

.D10:	.IFF ERL$G .GOTO D20
	.IFF FB .IFF XM .IFF ZM .GOTO D15
	.IFF LST .DATA #3 'MAC'ELCOPY SRC:('SYFIL'+ELCOPY)
	.IFT LST .DATA #3 'MAC'ELCOPY'L'ELCOPY SRC:('SYFIL'+ELCOPY)
	.IFF LST .DATA #3 'MAC'ELINIT SRC:('SYFIL'+ELINIT)
	.IFT LST .DATA #3 'MAC'ELINIT'L'ELINIT SRC:('SYFIL'+ELINIT)
	.IFF LST .DATA #3 'MAC'ELTASK SRC:ELTASK
	.IFT LST .DATA #3 'MAC'ELTASK'L'ELTASK SRC:ELTASK

	.IFF LST .DATA #3 LINK/EXE:BIN:ERRLOG/FORE OBJ:(ELCOPY,ELTASK)
	.IFT LST .DATA #3 LINK/EXE:BIN:ERRLOG/FORE/MAP:LST:ERRLOG OBJ:(ELCOPY,ELTASK)
		 .DATA #3 LINK/EXE:BIN:'MAP' OBJ:ELINIT
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:(ELINIT.OBJ,ELCOPY.OBJ,ELTASK.OBJ)

.D15:	.IFF SB .IFF BL .GOTO D17
	.IFF LST .DATA #3 'MAC'EL SRC:('SYFIL'+EL)

	.IFT LST .DATA #3 'MAC'EL'L'EL SRC:('SYFIL'+EL)
		 .DATA #3 'LINK'EL.SYG'MAP' OBJ:EL
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:EL.OBJ

.D17:	.IFF XB .IFF ZB .GOTO D20
	.IFF LST .DATA #3 'MAC'ELX SRC:(XM+'SYFIL'+EL)

	.IFT LST .DATA #3 'MAC'ELX'L'ELX SRC:(XM+'SYFIL'+EL)
		 .DATA #3 'LINK'ELX.SYG'MAP' OBJ:ELX
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:ELX.OBJ

.D20:	.SETF NXM
	.SETF GEN
	.SETS DEV "LD"
	.GOSUB DEVGEN

	.SETS DEV "BA"
	.GOSUB DEVGEN

	.SETS DEV "DX"
	.GOSUB DEVGEN

	.SETS DEV "DY"
	.GOSUB DEVGEN

	.SETS DEV "VM"
	.GOSUB DEVGEN

	.SETS DEV "DZ"
	.GOSUB DEVGEN

	.SETS DEV "DW"
	.GOSUB DEVGEN

	.SETS DEV "SP"
	.GOSUB DEVGEN

	.SETS DEV "XL"
	.GOSUB DEVGEN

	.SETS DEV "XC"
	.GOSUB DEVGEN

	.SETS DEV "RK"
	.GOSUB DEVGEN

	.SETS DEV "DL"
	.GOSUB DEVGEN

	.SETS DEV "DU"
	.GOSUB DEVGEN

	.SETS DEV "DM"
	.GOSUB DEVGEN

	.SETS DEV "NQ"
	.GOSUB DEVGEN

	.SETS DEV "NC"
	.GOSUB DEVGEN

	.SETS DEV "NU"
	.GOSUB DEVGEN

	.IFF TAPE .GOTO D40
	.IFF FSM .GOTO D35
	.IFT BSF .IFF LST .DATA #3 'MAC'FSM SRC:('SYFIL'+FSM)
	.IFT BSF .IFT LST .DATA #3 'MAC'FSM'L'FSM SRC:('SYFIL'+FSM)
	.IFT XZ .IFF LST .DATA #3 'MAC'FSMX SRC:(XM+'SYFIL'+FSM)
	.IFT XZ .IFT LST .DATA #3 'MAC'FSMX'L'FSMX SRC:(XM+'SYFIL'+FSM)

.D35:	.SETS DEV "MT"
	.SETS MAGSRC "TM"
	.GOSUB MAGGEN

	.SETS DEV "MM"
	.SETS MAGSRC "TJ"
	.GOSUB MAGGEN

	.SETS DEV "MS"
	.SETS MAGSRC "TS"
	.GOSUB MAGGEN

	.SETS DEV "MU"
	.SETS MAGSRC "TU"
	.GOSUB MAGGEN

	.IFF FSM .GOTO D40
	.IFT DEL .IFT BSF .DATA #3 DELETE/NOQ OBJ:FSM.OBJ
	.IFT DEL .IFT XZ .DATA #3 DELETE/NOQ OBJ:FSMX.OBJ

.D40:	.IFT CTS .IFF PROCTS .GOTO D45
	.SETS DEV "LP"
	.GOSUB DEVGEN

	.SETS DEV "LS"
	.GOSUB DEVGEN

.D45:	.SETS DEV "NL"
	.GOSUB DEVGEN

	.SETS DEV "LPP"
	.GOSUB DVCTS

	.SETS DEV "LQP"
	.GOSUB DVCTS

	.SETS DEV "LRP"
	.GOSUB DVCTS

	.SETS DEV "LSP"
	.GOSUB DVCTS

	.SETS DEV "LPS"
	.GOSUB DVCTS

	.SETS DEV "LQS"
	.GOSUB DVCTS

	.SETS DEV "LRS"
	.GOSUB DVCTS

	.SETS DEV "LSS"
	.GOSUB DVCTS

	.SETT GEN
	.SETT UDINIT
	.SETS UDFIND ""
.D47:
	.GOSUB FINDUD
	.IF UDEVNO EQ 0 .GOTO D50
	.SETS DEV UD'UDEVNO'
	.IFNDF BUD'UDEVNO' .SETF BUD'UDEVNO'
	.GOSUB DEVGEN
	.GOTO D47

.D50:	.CLOSE	#3
	.GOTO DVTBL

.;; This is the generalized User Device Handler lookup routine
.;;
.;; Input:	UDINIT = TRUE -> Initialize search loop
.;; 		  or   = FALSE -> Continue search loop (find next)
.;;		UDFIND = The user device name to search for (string)
.;;		  or   = Null ("") to find next defined, non-blank entry
.;;		UDEVCT = Defined -> limit search loop to this many found
.;;		  or   = Undefined -> search to MAXUDV (currently 32.)
.;;
.;; Output:	UDEVNO = User device slot #, if found
.;;		       = 0, if not found
.;;		UDNDF  = First undefined or null slot # (for device add)
.FINDUD:
	.SETN UDEVNO 0
	.IFF UDINIT .GOTO FNDUD2
	.SETN UDNDF 0
	.SETN UDCURR 1
	.SETN UDFCNT 0
	.SETF UDINIT
.FNDUD2:
	.IF UDEVNO NE 0 .OR .IF UDCURR GT MAXUDV .RETURN
	.IFNDF UDEVCT .GOTO FNDUD4
	.IF UDEVCT EQ 0 .GOTO FNDUD4
	.IF UDEVCT LE UDFCNT .RETURN

.FNDUD4:.IFNDF UD'UDCURR' .GOTO FNDUD6
	.IF UD'UDCURR' EQ "" .GOTO FNDUD6
	.TEST UD'UDCURR'
	.IFF <ALPHAN> .GOTO FNDUD6
	.IF UDFIND NE "" .IF UDFIND NE UD'UDCURR' .GOTO FNDUD8
	.SETN UDEVNO UDCURR
	.INC UDFCNT
	.GOTO FNDUD8

.FNDUD6:.IF UDNDF EQ 0 .SETN UDNDF UDCURR
.FNDUD8:.INC UDCURR
	.GOTO FNDUD2

.;; This generates statements to assemble and link a handler. (Not magtape).
.;;
.;; Input:	DEV = The name of the device, for example, "DX".
.;;		NXM = TRUE -> No XM handler
.;;		GEN = TRUE -> Generate it whether or not it was selected
.DEVGEN:
	.SETS BND ""
	.TEST DEVBND " "+DEV+" "
	.IF <STRLEN> NE 0 .SETS BND "/BOUNDARY:512."
	.IF UDEVNO EQ 0 .GOTO DV3
	.IFT BUD'UDEVNO' .SETS BND "/BOUNDARY:512."
.DV3:	.SETS DEVMAC DEV
	.IFT PROCTS .IF DEV EQ "LP" .SETS DEVMAC "LS"
	.IFT GEN .GOTO DV5
	.IFF 'DEV' .RETURN

.DV5:	.IFF BL .IFF SB .IFF FB .GOTO DV10
	.IF DEV = "NQ" .OR .IF DEV = "NC" .OR .IF DEV = "NU" .GOTO DV10
	.IFF LST .DATA #3 'MAC''DEV' SRC:('SYFIL'+'DEVMAC')
	.IFT LST .DATA #3 'MAC''DEV''L''DEV' SRC:('SYFIL'+'DEVMAC')
	 .DATA #3 'LINK''DEV'.SYG'MAP''BND' OBJ:'DEV'
	.IF BND NE "" .DATA #3 SETOVR
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:'DEV'.OBJ
.DV10:	.IFF XBXM .IFF ZM .IFF ZB .OR .IFT NXM .RETURN

	.IFF LST .DATA #3 'MAC''DEV'X SRC:(XM+'SYFIL'+'DEVMAC')
	.IFT LST .DATA #3 'MAC''DEV'X'L''DEV'X SRC:(XM+'SYFIL'+'DEVMAC')
	.DATA #3 'LINK''DEV'X.SYG'MAP''BND' OBJ:'DEV'X
	.IF BND NE "" .DATA #3 SETOVR
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:'DEV'X.OBJ
	.RETURN

.;; This generates statements to assemble and link a CTS LP handler.
.;; Input:
.;;		DEV = The name of the device, for example, "LRP"
.DVCTS:
	.IFF 'DEV' .RETURN
	.SETS TEMPS DEV[3:3]
	.SETS DV DEV[1:2]
	.IFF SB .IFF FB .GOTO CG10

	.ENABLE DATA #3
'MAC''DEV' SRC:('SYFIL'+'DEV'+L'TEMPS'.CTS)
'LINK''DV'.SYG OBJ:'DEV'
DELETE/NOQ OBJ:'DEV'.OBJ
.DISABLE DATA #3

.CG10:	.IFF XBXM .IFF ZB .IFF ZM .RETURN

	.ENABLE DATA #3
'MAC''DV'X SRC:(XM+'SYFIL'+'DEV'+L'TEMPS'.CTS)
'LINK''DV'X.SYG OBJ:'DV'X
DELETE/NOQ OBJ:'DV'X.OBJ
.DISABLE DATA #3

	.RETURN

.;; This generates statements to assemble and link a magtape handler.
.;; Input:
.;;		DEV = The name of the device, for example, "MT".
.;;	     MAGSRC = The source file to be used, for example, "TM".
.MAGGEN:
	.SETS BND ""
	.TEST DEVBND " "+DEV+" "
	.IF <STRLEN> NE 0 .SETS BND "/BOUNDARY:512."
	.IFF 'DEV' .RETURN

	.IFF BL .IFF SB .IFF FB .GOTO T10
	.IFF LST .DATA #3 'MAC''DEV' SRC:('SYFIL'+'MAGSRC')
	.IFT LST .DATA #3 'MAC''DEV''L''DEV' SRC:('SYFIL'+'MAGSRC')
	.IFT 'DEV'$FSM .DATA #3 'LINK''DEV'.SYG'MAP''BND' OBJ:('DEV',FSM)
	.IFF 'DEV'$FSM .DATA #3 'LINK''DEV'HD.SYG'MAP''BND' OBJ:'DEV'
	.IF BND NE "" .DATA #3 SETOVR
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:'DEV'.OBJ

.T10:	.IFF XBXM .IFF ZB .IFF ZM .RETURN

	.IFF LST .DATA #3 'MAC''DEV'X SRC:(XM+'SYFIL'+'MAGSRC')
	.IFT LST .DATA #3 'MAC''DEV'X'L''DEV'X SRC:(XM+'SYFIL'+'MAGSRC')
	.IFT 'DEV'$FSM .DATA #3 'LINK''DEV'X.SYG'MAP''BND' OBJ:('DEV'X,FSMX)
	.IFF 'DEV'$FSM .DATA #3 'LINK''DEV'HDX.SYG'MAP''BND' OBJ:'DEV'X
	.IF BND NE "" .DATA #3 SETOVR
	.IFT DEL .DATA #3 DELETE/NOQ OBJ:'DEV'X.OBJ
	.RETURN

.;;
.;; Create DEVTBL.MAC
.;;
.DVTBL:	.OPEN #0 'DEVTBL'
	.IF <FILERR> EQ 1 .GOTO DVT10
	;
	; ?SYSGEN-F-Error creating 'DEVTBL'
	.EXIT 4

.DVT10:	.ENABLE DATA #0
	.TITLE	DEVTBL	System Device Tables
;SYSGEN Edit Level = 'PATLEV'
; 'DEVFIL' - System Device Tables - Created  '<DATE4Y>'  '<TIME>'
.DISABLE DATA

	.SETS P ".DATA #0 ;"
	.GOSUB COPRIT

	.ENABLE DATA #0

;+
; Access the DEVice macro, the device macro allocates sysgen dependent
; information into the various device tables.
;-

.LIBRARY "SRC:EDTL.MLB"

.ENABL	GBL

.MCALL	DEV

;+
; The following is the declaration of the system device tables.  Edit here
; to add a device to the system.  Each device is inserted using the DEV
; MACRO.  NOTE:  Monitor internal devices must be the first in the tables!
;-

$SLOT	== 0		;COUNT OF NUMBER OF DEVICES
 ;
DEV	TT,4			;MUST BE FIRST DEVICE
DEV				;MUST BE SECOND, SYSTEM DEVICE SLOT
.IF EQ SB
.MCALL	.DSCDF
.DSCDF
DEV	MQ,SPECL$!42!HNDLR$
.ENDC
.IF EQ RTE$M
.IF NE MMG$T
DEV	UB
.ENDC
DEV	PI
.ENDC

.DISABLE DATA #0

	.IFT RK .DATA #0 DEV	RK
	.IFT DL .DATA #0 DEV	DL
	.IFT DU .DATA #0 DEV	DU
	.IFT DY .DATA #0 DEV	DY
	.IFT DM .DATA #0 DEV	DM
	.IFT DX .DATA #0 DEV	DX
	.IFT VM .DATA #0 DEV	VM
	.IFT DZ .DATA #0 DEV	DZ
	.IFT DW .DATA #0 DEV	DW
	.IFT SP .DATA #0 DEV	SP
	.IFT XL .DATA #0 DEV	XL
	.IFT XC	.DATA #0 DEV	XC
	.IFT NC	.DATA #0 DEV	NC
	.IFT NQ	.DATA #0 DEV	NQ
	.IFT NU	.DATA #0 DEV	NU
	.IFT MT .DATA #0 DEV	MT
	.IFT MM .DATA #0 DEV	MM
	.IFT MS .DATA #0 DEV	MS
	.IFT MU .DATA #0 DEV	MU

	.IFF LP .GOTO LPZ
	.IFF CTS .OR .IFT PROCTS .DATA #0 DEV	LP

.LPZ:	.IFF LS .GOTO LPZ1
	.IFF CTS .OR .IFT PROCTS .DATA #0 DEV	LS

.LPZ1:	.IFF CTS .OR .IFT PROCTS .GOTO DT20
	.IFT LPP .DATA #0 DEV	LP
	.IFT LPS .DATA #0 DEV	LP
	.IFT LQP .DATA #0 DEV	LQ
	.IFT LQS .DATA #0 DEV	LQ
	.IFT LRP .DATA #0 DEV	LR
	.IFT LRS .DATA #0 DEV	LR
	.IFT LSP .DATA #0 DEV	LS
	.IFT LSS .DATA #0 DEV	LS

.DT20:	.IFT BATC$H .DATA #0 DEV	BA,4
	.IFT NL .DATA #0 DEV	NL

	.SETT UDINIT
	.SETS UDFIND ""
.DT25:
	.GOSUB FINDUD
	.IF UDEVNO EQ 0 .GOTO DT40
	.SETS TEMPS UD'UDEVNO'
	.DATA #0 DEV	'TEMPS'
	.GOTO DT25

.DT40:	.ENABLE DATA #0
.IF NE	'EMPTY'.
.REPT	'EMPTY'.
DEV
.ENDR
.ENDC
.PSECT	UNAM1$
DKASSG:: .RAD50	/DK0/
SYASSG:: .RAD50	/SY0/
.PSECT	UNAM2$
.RAD50	/DK /
.RAD50	/SY /
 ;.PSECT	STAT$
 ;.WORD	0,0			;FOR MESSAGE CHANNEL
.PSECT	ENTRY$
.WORD	-1			;TABLE TERMINATOR
.IF NE	UNI$64
.PSECT	PNAM2$
.WORD	0			;Space for wildcard assignment "*"
.ENDC	;NE UNI$64
.IF NE	MMG$T			;Terminate XM interrupt table.
.IF NE  XM$FET
.PSECT	DVINT$
$DVITT::JSR	PC,INTPRO	;These 2 words in table save many later
.WORD	-1
.ENDC	;NE XM$FET
.ENDC	;NE MMG$T

.DISABLE DATA #0

	.IFF MTT$Y .DATA #0 .END
	.CLOSE	#0
	.OPEN SYSGEN.TMP
	.DATA TEMP DATA
	.CLOSE
	DELETE SYSGEN.TMP
	.IF <EXSTAT> EQ <SUCCES> .GOTO ENDMES
	;
	; ?SYSGEN-W-Output error SYSGEN.TMP
	.EXIT 4

.ENDMES:.IF LODDEV <> "" UNLOAD 'LODDEV'
	;
	; To  build  an entire system, mount the source and binary volumes,
	; copy the files 'SYCND', 'DEVTBL', EDTL.MLB, SYSTEM.MLB, and
	; the sources for any user supplied device handlers to the source
	; volume.  The RT-11 utility program MONMRG.SAV must be present
	; on the system disk, in order to build the monitors.  To build
	; both the monitors and the device handlers, type $@'SYSBLD'.
	; To build just the monitors, type $@'MONBLD'.  To build just
	; the device handlers, type $@'DEVBLD'. For more information,
	; read the RT-11 SYSTEM GENERATION GUIDE.
	;
	; END OF SYSGEN PROGRAM --
	.EXIT
