	;
	;	D O B . C M D
	;
	; VERSION 01
	;
	; TOM GETZINGER  03-NOV-80
	;
	; THIS COMMAND FILE GENERATES THE OBJECT FILE DISASSEMBLER
	.OPEN DOB.HLP
.ENABLE DATA
DOB is  an  object  module  disassembler,  which  will  create  a
MACRO-11  source file from any object module.  It will operate on
either standard object modules, or object module libraries.

The output from DOB can be reassembled directly.  The only errors
that  should be generated will be 'Z' type errors.  The resultant
object module should be identical to the original object  module,
if the original object module was generated by MACRO-11.

The command syntax is as follows:
DOB> output/sw,temp=input/sw
*CONCATENATION
If the input file is a concatenated object module, only  the
first  module  is disassembled.  The program could easily be
modified to disassemble  all  modules,  but  since  MACRO-11
doesn't  do  stacked  assembles,  the  resultant source file
would have to be broken up.
*DEFAULTS
The output filename must be specified. The output extension 
defaults to .MAC.    The input file must also be specified,
the extension defaulting to .OBJ.    The temp file defaults 
to SY:TEMPnn.TMP where nn is the current job number. SY: is
the default disk for all files. 
*LABELS
Labels take on one of three forms.  If the location is defined as
a  global  symbol, the global symbol name is used.  When defining
such a symbol, a check is made to see if more than one symbol  is
defined  for  the same location.  If there is, each global symbol
is written to the output file on a seperate line, followed  by  a
colon.   Only  the  last symbol is actually used on the line with
the disassembled code.  If the  location  is  not  defined  as  a
global  symbol,  the  symbol  name takes on one of two forms.  If
there are less than 14 psects in the object  module,  the  symbol
name  consists of an alphabetic character, followed by five octal
digits.  The octal digits consist of the low 5  octal  digits  of
the address.  The character is generated by using 'A' and 'B' for
the first psect, 'C' and 'D' for the second, and so  forth.   The
lower  letter is used for addresses in the range 0-77777, and the
higher for addresses in the range '100000-177777'.  If there  are
more  than 13 psects, the symbol name is generated by using a two
character psect identifier, followed by four hex digits  indicat-
ing the address.  The psect identifier is generated by taking the
psect number (0-255) and breaking it into two parts  by  dividing
by ten.  The result of the division is used to generate the first
character (0=A,1=B,...) and the remainder is used for the  second
(0=0,1=1,...). 
*SWITCHES
There are currently four valid switches for the  input  filespec:
"/LB",  "/EI", "/FI", and "/FP".  The "/LB" switch indicates that
the input file is an object library.  The switch value is from  1
to  6  RADIX-50  characters  indicating  the  name  of the module
to  be  disassembled.    An   example   of   this  is  "DOB> TI:= 
[1,1]SYSLIB/LB:.GET".    The  default   extension  for the  input
file is either ".OBJ" or ".OLB",  depending  on  whether  or  not
there is a "/LB" switch.

The remaining input filespec  switches  indicate  which  optional
instruction sets to use.  The default is to use them all.  "/-EI"
indicates that EIS instructions are not really  instructions  and
should  be  disassembled as ".WORD xxxxx".  "/-FI" indicates that
FIS instructions are not really instructions.   "/-FP"  indicates
that FPP instructions are not really instructions.

There are two valid switches for the output filespec:  "/AS"  and
"/RA".   These  switches indicate what additional formats to dump
the code, other than instruction.  "/AS" indicates that the  code
should  be dumped in ASCII.  "/RA" indicates that the code should
be dumped in RAD50.  If either of these options is selected,  the
values  of  the  instruction is dumped in the specified format as
comments.
*TEMP_FILE
The temp file is  used  for  internal  information,  and  usually
doesn't   need   to   be  specified.   The  default  filespec  is
"SY:TEMPnn.TMP" where nn is the current job number.  This file is
deleted at logout. The only reason a filespec would ever be given
for this  would be to cause this file to go to a  different  disk
than  the default, since this could be a rather large file.  This
file contains 16 blocks for each psect in the object module.

The following changes were made to the program DOB by Tom Getzinger to make
the program output listings more readable and to handle several changes made to
the object file format since the original writing of DOB.

The changes were made by:
	Harry Herman

The changes will be listed as they are refered to in the source listings

				hah
    Fix the processing of the .END statement to save the transfer
address if specified.  A line of code was apparently missing in GSD2.MAC.

				hah001
    Print instructions of the form:

	EMT	global
	    or
	TRAP	global

in the proper format.  Previously, DOB would split the entry into two
bytes and display them as:

	.BYTE	210
	.BYTE	global	(for EMT)
	    or
	.BYTE	211
	.BYTE	global	(for TRAP)

This involved adding a routine in DASM3 to check each instruction that
was broken into two bytes to see if the high byte was a 210(8) or 211(8)
with a second byte that was flagged as relocated.  If the above conditions
were met and the insrtuctions were at consecutive addresses, they are
printed as EMTs or TRAPs, else they are printed as .BYTEs.

				hah002
    Handle the new RLD entry called 'Additive Relocation'.  This entry
simply adds a specified constant to the base of the LIBR if this is a
LIBR.STB file that is being processed, or adds the constant to the base of
the program if it isnt a LIBR.STB.  I simply substitute a symbol called
		'LIB.BASE'
for the entry and add in, or subtract the specified constant.  Note that
LIB.BASE is a pseudosymbol and will not yeild the correct results if the file
is reassembled with MACRO-11.  It is informational only.  MACRO-11 is not
capable of producing the correct object module entry and LIB.BASE is not defined
anywhere, so it would come out as an unresolved global.
    Changes were made in DASM3, DISOP3, RLD2, RLD3, RODATA and EQUATE to handle
this.

				hah003
    Convert all numbers greater than 170000(8) to negative numbers.  I picked
170000 arbitrarily as a number that would seldom interfere with most bitmasks
and most (but not all) addressing.  Most programs do not directly address
locations in APR 7 (addresses 160000-177777) since that is generally reserved
for the I/O page, and only RSX privileged programs can directly access the
I/O page (or RSTS programs with PEEK and POKE syscalls).  Basically any time
a constant is to be printed, I check to see if the value is > 170000.  If so,
I replace the existing plus sign with a minus sign, and then negate the value
and reprint it as a positive magnitude.  For example,  the value 177777 octal
will now be printed as -1 instead of 177777.  This makes looking up error
values for RSX error messages much easier and also negative indexes show up
as negative intead of as large 'positive' indexes.  The only drawback is in
taking apart LIBR .STB files that were built for the upper APRs, as all
globals defined in the LIBR at addresses greater than 170000 will now print
as negative numbers.
    The modules CLENUP, DISOP3 and RLD3 were modified to accomplish this.

				hah004
    Handle the new .PSECT declaration attributes of SAVe and LIBrary.  Note
that MACRO-11 cannot process the LIB attribute as that is only created by
TKB when creating STB files for LIBRs and COMMONs.  A note is printed with
each PSECT declaration that uses the LIBrary attribute to say that the module
cannot be reassembled with MACRO-11 since MACRO-11 will give a syntax error
if the LIB arguement is used with the .PSECT declaration.  The disassembly does
continue though, so that you can see the rest of the information (autoload
vectors, symbol definitions, segment descriptors, internal symbol declarations,
etc.) that are contained in the .STB file.
    The only change was to GSD2.

				hah005
    Mofify PASS2 to ignore the ISD entries for now.  A future incomplete
modification will actually take apart the ISD entries as documented with the
TKB manual that came with RSTS v8.0.  However, for now the ISDs are simply
ignored instead of aborting DOB as it used to.

				hah006
    Handle the library base symbol in the complex expression evaluation.  See
hah002 for an explination of how it was handled.  The modules modified were
DCOM and EQUATE.

				hah007
    Add the PSECT '. ABS.' if it was not defined after the END OF GSD record
is reached.  This was necessary because overlaid LIBR .STB files reference
the PSECT without declaring the PSECT.
    The module modified was PASS1.

				hah008
    For each global symbol entry in the GSD, check to see if it is a definition
or a reference.  If it is only a reference, print a comment to that effect.
This allows quicker identification of unresolved globals as opposed to the
globals declared in the module.
    The module modified was GSD2.

				hah009
    Added support for ISD entries created by TKB for .STB files.  Rest
of ISD entries will be added as time permits.  Created new module called
ISD3, and modified PASS3 to call ISD3 instead of ignoring the record.
.DISABLE DATA
	.CLOSE
	.OPEN DOB.RNO
.ENABLE DATA
.RM 70;.LM 5
.TITLE DOB - OBJECT MODULE DISASSEMBLER
.CH GENERAL DESCRIPTION
DOB is an object module disassembler, which will create a
MACRO-11 source file from any object module.
It will operate on either standard object modules, or object module
libraries.
.B 1
The output from DOB can be reassembled directly.  The only errors that
should be generated will be 'Z' type errors.
The resultant object module should be identical to the original object
module, if the original object module was generated by MACRO-11.
.CH COMMAND SYNTAX
.lm 5
The command syntax is as follows:
.lm 10;.nf
DOB> output/sw,temp=input/sw
.lm 5;.f;.b
There are currently four valid switches for the input filespec: "/LB",
"/EI", "/FI", and "/FP".
The "/LB" switch indicates that the input file is an object library. The switch
value is from 1 to 6 RAD50 characters indicating the name of the module
to disassemble. An example of this is "DOB TI:=[1,1]SYSLIB/LB:.GET".
The default extension for the input file is either ".OBJ" or ".OLB", depending
on whether or not there is a "/LB" switch.
.b
The remaining input filespec switches indicate which optional instruction
sets to use.  The default is to use them all. "/-EI" indicates that EIS
instructions are not really instructions and should be disassembled as
".WORD xxxxx". "/-FI" indicates that FIS instructions are not really
instructions. "/-FP" indicates that FPP instructions are not really
instructions.
.b
There are two valid switches for the output filespec: "/AS" and "/RA".
These switches indicate what additional formats to dump the code, other
than instruction. "/AS" indicates that the code should be dumped in ASCII.
"/RA" indicates that the code should be dumped in RAD50.  If either of these
options is selected, the values of the instruction is dumped in the specified
format as comments.
.b
The default extension for the output filespec is ".MAC".
.b
The temp file is used for internal information, and usually doesn't need
to be specified.  The default filespec is "SY:BITMAP.TMP". This file
is temporary, and is deleted when finished with.  The only reason a
filespec would ever be given for this, would be to cause this file to
go to a different disk than the default, since this could be a rather
large file.  This file contains 16 blocks for each psect in the object
module.
.CH IMPLEMENTATION NOTES
.lm 5
The command file, "DOB.CMD", assembles and builds the disassembler.
There are a few things that may be changed in the task build command
file, "DOBTKB.CMD". See the file itself for those items.
.b
This disassembler consists of five phases: GETCMD, PASS1, PASS2, PASS3,
and CLENUP.
.b
GETCMD gets the command line, and parses it. It opens all the files, and
if the input is an object library points to the corrent object module.
.b
PASS1 is the first pass through the object module. This pass looks only at
the global symbol directory records.
During this pass the PSECT table is built,
which consists of the psect name, length,
and current address (which is initialized to zero).  A count is kept of the
number of global symbols so that the size of the global symbol table will be
known.  After passing through the object module, free memory is initialized.
Free memory is used for three things. The first item is the psect table, which
starts immediately after the end of used memory, and contains as many entries
as there are PSECTs. The next item is the global symbol table, which is
allocated immediately after the psect table, and contains all global symbol
definitions. This table is allocated after pass 1, and filled in during pass 2.
The remainder of free memory is a dynamic memory pool, which is used to
hold the code during passes 2 and 3, in a linked list.
.b
PASS2 is the second pass through the object module. This pass generates the
'.TITLE', '.IDENT', and '.GLOBL' records, and '.PSECT' definition records.
The global symbol table, which was allocated in pass 1, is filled in now.
This pass examines the instructions and builds a bitmap of all referenced
locations in all psects. These bitmaps are kept in the temporary file.
.b
PASS3 is the third and last pass through the object module. This pass
disassembles the intructions, and writes them to the output file.
After disassembling an instruction, the bitmap for the current PSECT is
examined to see if any byte of the instruction was referenced elsewhere
in the object module. If so, a label is placed at the beginning of the line.
If any byte of the instruction was referenced other than the first byte,
then after the line has been written to the output file, equates are
generated to define the necessary labels.
.b
Labels take on one of three forms. If the location is defined as a global
symbol, the global symbol name is used. When defining such a symbol, a
check is made to see if more than one symbol is defined for the same
location. If there is, each global symbol is written to the output file
on a seperate line, followed by a colon. Only the last symbol is actually
used on the line with the disassembled code.  If the location is not
defined as a global symbol, the symbol name takes on one of two forms.
If there are less than 14 psects in the object module, the symbol name
consists of an alphabetic character, followed by five octal digits. The
octal digits consist of the low 5 octal digits of the address. The character
is generated by using 'A' and 'B' for the first psect, 'C' and 'D' for the
second, and so forth.  The lower letter is used for addresses in the range
0-77777, and the higher for addresses in the range '100000-177777'. If
there are more than 13 psects, the symbol name is generated by using a
two character psect identifier, followed by four hex digits indicating the
address. The psect identifier is generated by taking the psect number (0-255)
and breaking it into two parts by dividing by ten. The result of the
division is used to generate the first character (0=A,1=B,...) and the
remainder is used for the second (0=0,1=1,...). This may sound confusing
and unnecessarily complex, but it was the best scheme I could come up with.
The best thing to do is to see it in operation, and that may clear up a
lot of questions.
.b
CLENUP is the final phase. During this phase, any symbols that have not
yet been defined, are. Also, all psects are extended, if they need to be.
The reason symbols might not have been defined is due to '.BLKB' or '.BLKW'
pseudo-instructions, or disassembling code which isn't actually code.
The last thing done is to write the '.END' record.
.CH KNOWN PROBLEMS
.lm 5
This program still has a few bugs, problems, limitations, and other
undesirable features, most of which will be cleared up in later
versions. These are as follows.
.lm 10;.b
.i -4
1)##It requires EIS. This shouldn't be too hard to fix, and
will be in the next version.
.i -4
2)##It should work fine for almost all MACRO-11 object modules, but might
still have problems with object modules created by various compilers,
since they sometimes take short-cuts, when generated object code, that
weren't taken into consideration when designing this.  These problems will
be fixed as they show up.
.i -4
3)##The output file, when reassembled can generate 'Z' errors.  In the next
version there will be a '/NOZ' switch that will cause these instructions
to be disassembled as '.WORD xxx'.
.i -4
4)##The error handling is horrendous and should be totally revamped in the
next version.
.i -4
5)##If the input file is a concatenated object module, only the first module
is disassembled.  The program could easily be modified to disassemble all
modules, but since MACRO-11 doesn't do stacked assembles, the resultant
source file would have to be broken up.
.lm 5;.b
If you have any comments, suggested enhancements, fixes, bugs that need
fixes, or just have questions about the program, please don't hesitate
to contact me.  The more input I have output this program, the better
I can make later versions of it.
.b
.lm 30;.nf
Tom Getzinger
.DISABLE DATA
	.CLOSE
	.ENABLE SUBSTITUTION
	;
	.OPEN DOBMAC.TMP
.ENABLE DATA
; THIS COMMAND FILE ASSEMBLES THE OBJECT FILE DISASSEMBLER
;
ADDLBL,ADDLBL/-SP=ADDLBL
ADDTXT,ADDTXT/-SP=ADDTXT
APPEND,APPEND/-SP=APPEND
CLENUP,CLENUP/-SP=CLENUP
DASM2,DASM2/-SP=DASM2
DASM3,DASM3/-SP=DASM3
DCOM,DCOM/-SP=DCOM
DINS2,DINS2/-SP=DINS2
DINS3,DINS3/-SP=DINS3
DISOBJ,DISOBJ/-SP=DISOBJ
DISOP2,DISOP2/-SP=DISOP2
DISOP3,DISOP3/-SP=DISOP3
DMPTXT,DMPTXT/-SP=DMPTXT
EQUATE,EQUATE/-SP=EQUATE
ERROR,ERROR/-SP=ERROR
GET,GET/-SP=GET
GETCMD,GETCMD/-SP=GETCMD
GSD2,GSD2/-SP=GSD2
INIT,INIT/-SP=INIT
ISD3,ISD3/-SP=ISD3
LDBTMP,LDBTMP/-SP=LDBTMP
PASS1,PASS1/-SP=PASS1
PASS2,PASS2/-SP=PASS2
PASS3,PASS3/-SP=PASS3
PSCNUM,PSCNUM/-SP=PSCNUM
RLD2,RLD2/-SP=RLD2
RLD3,RLD3/-SP=RLD3
RLSTXT,RLSTXT/-SP=RLSTXT
RODATA,RODATA/-SP=RODATA
RWDATA,RWDATA/-SP=RWDATA
SELECT,SELECT/-SP=SELECT
SETREF,SETREF/-SP=SETREF
TXTOUT,TXTOUT/-SP=TXTOUT
TXT2,TXT2/-SP=TXT2
TXT3,TXT3/-SP=TXT3
.DISABLE DATA
	.CLOSE
	;
	MAC @DOBMAC.TMP
	;
LBR DOB/CR
LBR DOB/IN=ADDLBL,ADDTXT,APPEND,CLENUP,DASM2,DASM3,DCOM,DINS2,DINS3,DISOBJ
LBR DOB/IN=DISOP2,DISOP3,DMPTXT,EQUATE,ERROR,GET,GETCMD,GSD2,INIT,LDBTMP,PASS1
LBR DOB/IN=PASS2,PASS3,PSCNUM,RLD2,RLD3,RLSTXT,RODATA,RWDATA,SELECT,SETREF
LBR DOB/IN=TXTOUT,TXT2,TXT3,ISD3
	;
	PIP *.obj;*/de
	PIP *.*/PU/LD
	;
	.OPEN DOBTKB.TMP
.ENABLE DATA
;
;	D O B T K B . C M D
;
; VERSION 01
;
; TOM GETZINGER  03-NOV-80
;
; THIS COMMAND FILE LINKS THE OBJECT DISASSEMBLER.
;
; FOR RSX11M, REMOVE THE "/MU" FROM THE FOLLOWING LINE
;
DOB/-FP,DOB/-WI/-SP/ma/CR,DOB=DOB/MP
;
TASK=...DOB
;
ASG=SY:1	; OUTPUT FILE
ASG=SY:2	; TEMPORARY FILE
ASG=SY:3	; INPUT FILE
ASG=TI:4	; COMMAND FILE
ASG=TI:5	; MESSAGE LUN
;
; THE FOLLOWING LINE ALLOCATES DYNAMIC MEMORY.
; IF YOU APPEAR TO BE RUNNING OUT, JUST INCREASE IT.
; IT SHOULD BE ENOUGH FOR MOST PURPOSES AS IS.
;
EXTTSK=14000
;
/
.DISABLE DATA
	.CLOSE
	.OPEN DOB.ODL
.ENABLE DATA
;
;	D O B . O D L
;
; VERSION 01
;
; TOM GETZINGER  03-NOV-80
;
; THIS IS THE ODL FOR THE NON-OVERLAYED VERSION OF THE
; OBJECT FILE DISASSEMBLER.
;

	.ROOT	DOB/LB:DISOBJ-DOB/LB

	.END
.DISABLE DATA
	.CLOSE
	;
	TKB @DOBTKB.TMP
	DEL *.TMP;*
	DEL *.ODL;*
	PUR *.*/LD
	;
	; READY.
