	PROGRAM SEND_MESSAGE
	
C	SEND_MESSAGE was originated in 1980.
C 	This is a total rewrite, done in May 1988 by Dale E. Coy,
C 		Los Alamos National Laboratory
C	The original documentation is included below, for historical 
C 		interest.
C 
C 	Define the symbol SEND := $disk[directory]SEND
C 	Install SEND with WORLD and OPER privilege for general use.
C 
C Simple Syntax:
C	SEND UserName Any text to be sent.  (will uppercase text).
C	SEND UserName "Any text to be sent."  (sends quotes and all).
C 
C 	SEND UserName		(will prompt for text, and not uppercase
C					the text before sending).
C 
C 	SEND			(will prompt for usernames and text).
C 
C 		"UserName" may be any comma-delimited list of usernames
C 			and/or terminal names.  Terminal names MUST be
C 			followed by a ':' (e.g., TTA0:).  Otherwise, they
C 			will be interpreted as usernames.
C 
C 	If SEND cannot send the message to its destination, it will ask
C 		if you want to send the message by VMS Mail.
C 
C Switches:
C 	Switches may appear anyplace in the command line.
C 
C 	/MAIL	- Don't ask, just send by mail if not by SEND.
C 	/NOMAIL - Don't ask, and don't send by mail.
C 	/ALLUSERS - Send to all users logged in.
C 		Note: It is "normal" for 1 user (probably Operator)
C 		to have disabled SEND messages.
C 	/ALL or /ALLTERMS - Send to all non-autobaud terminals.
C 	In general, the last qualifier on the command line "wins".
C 	Obviously, /ALLx cannot be combined with terminals or usernames.
C 		Any text on the command line with /ALLx is sent as
C 		part of the message.
C 
C Notes:
C 	SEND will send its message to a specific user on another node 
C 		of a Cluster.  However, it does not "know" about the
C 		user (or the results), so it can't tell you about anything
C 		except the local node.  (Maybe this will change with VMS 5.0).
C 	"Temporarily not receiving messages" means, for example, that the
C 		user has done something like SHOW NETWORK and then a 
C 		hold-screen on the terminal.
C 	If the user has pressed hold-screen while at the VMS prompt, 
C 		SEND thinks the message has been delivered.  The user will
C 		not see the message until hold-screen is pressed again.
C 	Users may disable receiving SEND messages by entering:
C 		SET BROADCAST=NOUSER1
C 	Account and system parameters may limit message length to less
C 		than the 16350 character limit of SEND.
C 
C 
C 
C 	For previous users of SEND, new features are:
C 		Multiple destinations (more than 2) now work properly.
C 		Only 1 message is sent, rather than several.
C 		Messages can be up to around 16,300 characters.
C 		Now works across a cluster (kinda).
C 		No longer "hangs" (times out).
C 		Improved information and error handling.
C 		New qualifiers /ALL, /ALLTERMS, /ALLUSERS
C  
C-----------  Original Documentation Follows ---------------------------
C 
C	Program SEND_MESSAGE
C SYSTEM:     VAX/VMS v 2.1
C FACILITY:   general utility program
C LANGUAGE:   FLECS & VAX/VMS FORTRAN
C AUTHOR:     Rick Floyd
C DATE:       2-Jan-80
C Note:  MAJOR Changes by M. Edward (Ted) Nieland to update to
C	 VMS V4.x and added new features.  Totally coverted to
C	 VAX/VMS FORTRAN at that time.
C Changes by Dale E. Coy (various dates) to fix bugs, make SEND do one
C 	message instead of several, use structures for system calls, 
C 	etc., etc.
C;-
C
C****PURPOSE: SEND allows a user to send a message to another terminal.
C
C****RESTRICTIONS:  Must be installed with OPER privilege. Although SEND
C		will recognize terminals on remote systems, an attempt
C		to send a message to a remote terminal will, under VAX/VMS
C		v 2.1, result in an error.
C
C****CALLING SEQUENCE:  
C		Define the symbol
C			SEND:==$USER$EXE:SEND
C		and then use as
C			SEND terminal_id message
C		e.g.,
C			SEND TTB6: Are you done?
C		If the message contains special characters, it should
C		be enclosed in quotes ("). If the terminal_id and message are
C		omitted, they will be prompted for.
C
C****ERROR MESSAGES: Error messges are produced using SYS$PUTMSG and
C		have the form
C			%SEND-c-abbreviation-message text
C
C****RESOURCES:
C	LIBRARIES:   none
C	OTHER SUBR:  all in this module.
C	DATA CHANNELS: SYS$INPUT for input and SYS$OUTPUT for prompting. The
C			message is output on the specified terminal.
C	DISK FILES:  none
C	DEVICES:     as above
C	SGAS:        none
C	EVENT FLAGS: none
C	SYSTEM DIR:  LIB$GET_FOREIGN, SYS$TRNLOG, SYS$BRDCST,
C		SYS$GETDEV, SYS$GETJPI, LIB$GET_INPUT, LIB$PUT_OUTPUT,
C		SYS$PUTMSG, LIB$INSV
C
C****NOTES:  
C	1.  As mentioned above, SEND will accept a  specification
C	    for a terminal on a remote node, but the send will fail
C	    because SYS$BRDCST will not broadcast to a terminal on a
C	    remote node (at least if it is a non-VMS node).
C	    I don't know if DEC will expand SYS$BRDCST to
C	    do this, but in case they do...
C	2.  The terminal_id must specify an actual physical terminal. The
C	    colon is optional(NO LONGER AFTER UPDATE 8/26/85).
C;-
C	Updates:
C		10/17/85 Updated to VMS V 4.x using SYS$BRKTHRU and 
C			to use broadcast class USER1.  Also allowed to
C			use usernames in addition to terminal IDs.  Also
C			allow username/terminal ID and message to be read 
C			in with command line using LIB$GET_FOREIGN.  
C			Changed SYS$TRNLOG to SYS$TRNLNM.  Allow a list
C			destinations to be entered, separated by commas.
C
C			Updated to allow choice of having message sent
C			by MAIL if Username was specified and message 
C			could not be sent by SYS$BREAKTHRU.  Qualifier
C			/NOMAIL will prevent this option.
C
C		Changes by Ted Nieland
C
C 	Updated 17-NOV-1987 to better format output, allow for 32-char
C 	usernames.   Dale E. Coy
C 
C 	Updated May 1988 -
C 		Send one message, rather than several.
C 		Accept up to approximately 16,300 characters of input.
C 		Misc. Cleanups and error handling.
C 
C	To set up command use:
C
C		$ Send :== $ {disk}:[{directory}]SEND.EXE
C
C	This executable needs to be installed with OPER privledge to be used
C	by all system users.
C>
	Character*16350 MsgBuf
	Character*256 User_Input
	Character*255 Wholist
	Integer*4 MsgBuf_End
	Integer*4 Line_Length
	Integer*4 WhoList_Length, Who_Length
	Integer*4 Timeout  /5/
	
	Character*2 CRLF
	CHARACTER*52 WHO
	
	Character*50 Terminal_Name
	Integer*2 Terminal_Len
	
	Character*8 TimeBuf
	Character*32 UserBuf
	
	Logical MailIt	/.FALSE./
	Logical Ask	/.TRUE./
	Logical All_Terms	/.FALSE./
	Logical All_Users	/.FALSE./
	Logical To_UserName	/.FALSE./
	Logical Tell_Mail  	/.TRUE./
	Logical Blank_Line	/.FALSE./
	
	Character*80 Out_Str
	Integer*2 Out_Str_Length
	
	INTEGER*2 J_Len 
	
	Integer*2 IOSB(4)
	Integer*2 Brk_Status, Terms_Notified, Terms_Not_Notified
	Integer*2 Terms_Refused
	Equivalence (IOSB(1), Brk_Status)
	Equivalence (IOSB(2), Terms_Notified)
	Equivalence (IOSB(3), Terms_Not_Notified)
	Equivalence (IOSB(4), Terms_Refused)
	
	Character*8 Switch
	Character*3 Resp
	Character*10 NodeName
	Integer*2 NodeName_Length
	
	Integer*4 Send_Type, Status
	
	Integer*4 Brk_Flags	/0/
	Byte Brk_Lines_To_Erase
	Equivalence (Brk_Lines_To_Erase, Brk_Flags)
	
	Integer*4 SYS$Brkthruw, SYS$TrnLnm, SYS$GetJPI, SYS$GetMsg,
	1	Lib$Get_Foreign
	
	
	
	Include '($LNMDEF)'
	Include '($JPIDEF)'
	Include '($SSDEF)'
	Include '($BRKDEF)'
	Include '($SYIDEF)'
C
C	Flags for LIB$SPAWN:
C
	PARAMETER NOWAIT = 1		!(0) If set, don't wait for command.
	PARAMETER NOCLISYM = 2		!(1) If set, don't copy CLI symbols.
	PARAMETER NOLOGNAM = 4		!(2) If set, don't copy logical names.
C 
	Structure /TrnLnm_Item_List/
	  Integer*2 BufLen
	  Integer*2 Code		/LNM$_String/
	  Integer*4 Dst_Address
	  Integer*4 Length_Address
	  Integer*4 End_List		/0/
	End Structure

	Record /TrnLnm_Item_List/ T_ItmLst

C ----------------------------------------------------------------------
C 
	CRLF = Char(13)//Char(10)
	Brk_Flags = Brk$M_Cluster
C 		Other options could be used, with varying results.
C 		The Brk$M_Cluster option alone seems preferable
CX	Brk_Flags = Brk$M_Cluster + Brk$M_Screen + Brk$M_Bottom
CX	Brk_Flags = Brk$M_Cluster + Brk$M_Screen 
CX	Brk_Lines_To_Erase = 1
	
C
C	Find out which terminal is now in use
C
	
	T_ItmLst.BufLen			=	LEN(Terminal_Name)
	T_ItmLst.Dst_Address		=	%LOC(Terminal_Name)
	T_ItmLst.Length_Address		=	%LOC(Terminal_Len)
	
	Terminal_Name = ' '		! Clear it out first - TrnLNM doesn't
	Status = SYS$TrnLnm(LNM$M_Case_Blind, 'LNM$PROCESS_TABLE', 
	1	'SYS$INPUT',, T_ItmLst)
	If(.NOT.Status) GoTo 160

	K=INDEX(Terminal_Name,'_')
	MsgBuf_End = Terminal_Len - K + 9	! Includes Inserted Space
	
	MsgBuf(1:1)=Char(7)  ! Ring Bell
	MsgBuf(2:7)=' From '
	MsgBuf(8:MsgBuf_End)=Terminal_Name(K:Terminal_Len) !Terminal name
	
C
C	Find out process name and other process information
C
	Status = Lib$GetJpi(JPI$_UserName,,,,UserBuf ,J_Len)
	If(.NOT.Status) GoTo 160
	
	Call STR$Trim (UserBuf, UserBuf, J_Len)
	MsgBuf(MsgBuf_End+1:MsgBuf_End+J_Len) = 
	1		UserBuf(:J_Len) 	! Process name
	MsgBuf_End = MsgBuf_End + J_Len
	
	Call Time (TimeBuf)
	MsgBuf(MsgBuf_End+1:MsgBuf_End+15)='  at '//TimeBuf  ! Time
	MsgBuf(MsgBuf_End+16:MsgBuf_End+17) = CRLF
	MsgBuf_End = MsgBuf_End + 17
C
C ----------------------------------------------------------------------
C	Get command line
C
	Call LIB$Get_Foreign
	1	(User_Input,'Terminal IDs: OR Usernames - ',Line_Length,)
C
C	If length is zero, then no additional input was given.
C
	
20	If (Line_Length .EQ. 0) then
		If (All_Users .OR. All_Terms) GoTo 40
		Status = Lib$Get_Input 
	1	   (User_Input,'Terminal IDs: OR Usernames - ',Line_Length,)
		If (.NOT.Status) GoTo 9999
		If ((Line_Length .EQ. 0) .OR. (User_Input(1:1) .EQ. '?')) then
		  Print *, ' Specify destination Username(s) or Terminal:(s)'
		  GoTo 20
		Else
		  Call Str$UpCase (User_Input, User_Input)
		End If
	End If
	
C 
C 		Get this in compressed form
C 
	Call Str$Trim (User_Input, User_Input, Line_Length)
	Do While (Line_Length .GT. 0)
	  KK = Index(User_Input(:Line_Length), '  ')
	  If (KK .LE. 0) then
	    If (User_Input(1:1) .EQ. ' ') then
	      User_Input = User_Input(2:Line_Length)
	    Else
	      GoTo 30
	    End If
	  Else
	    User_Input(KK+1:) = User_Input (KK+2:)
	  End If
	  Line_Length = Line_Length - 1
	End Do
	GoTo 9999
	
	
C
C	Check for Qualifiers /MAIL or /NOMAIL or /ALLUSERS or /ALLTERMS
C
	
30	KK = Index (User_Input(:Line_Length), '/')
	If (KK .GT. 0) then
		KL1 = Index(User_Input(KK:),' ')
		KL2 = Index(User_Input(KK+1:),'/') + 1
		If (KL2 .LE. 1) then
			KL = KL1
		Else
			KL = MIN (KL1, KL2)
		End If
		Switch = User_Input(KK:KK+KL-1)
		User_Input (KK:) = User_Input (KK+KL-1:)
		Line_Length = Line_Length - (KL-1)
		If (Switch .EQ. '/MAIL') then
		    	If ((.NOT. All_Users) .AND. (.NOT. All_Terms))
	1			MailIt = .TRUE.
			Ask = .FALSE.
		Else If (Switch .EQ. '/NOMAIL') then
			MailIt = .FALSE.
			Ask = .FALSE.
		Else If (Switch(1:5) .EQ. '/ALLU') then
			All_Users = .TRUE.
			Tell_Mail = .FALSE.
			MailIt = .FALSE.
			Ask = .FALSE.
		Else If (Switch(1:5) .EQ. '/ALLT') then
			All_Terms = .TRUE.
			Tell_Mail = .FALSE.
			MailIt = .FALSE.
			Ask = .FALSE.
		Else If (Switch(1:4) .EQ. '/ALL') then
			All_Terms = .TRUE.
			Tell_Mail = .FALSE.
			MailIt = .FALSE.
			Ask = .FALSE.
		Else
			Print *, ' Incorrect Switch ',Switch, ' Ignored'
		End If
		If (Line_Length .LE. 0) GoTo 40
		If (User_Input(:Line_Length) .EQ. ' ') GoTo 40
		GoTo 30
	Else			! No Switches Left
	    If (All_Terms .OR. All_Users) then
		If (Line_Length .LE. 0) GoTo 40
		If (User_Input(:Line_Length) .EQ. ' ') GoTo 40
		MsgBuf (MsgBuf_End+1:MsgBuf_End+Line_Length) 
	1			= User_Input(:Line_Length)
		MsgBuf (MsgBuf_End+Line_Length+1:MsgBuf_End+Line_Length+2) 
	1			= CRLF
		MsgBuf_End = MsgBuf_End+Line_Length+2
		GoTo 80
	    Else
		If (Line_Length .LE. 0) GoTo 20
		If (User_Input(:Line_Length) .EQ. ' ') GoTo 20
C 		Otherwise, fall out of this block into the next one.
	    End If
	End If
	
C
C	Find end of first parameter (USERNAME or Terminal ID)
C
	KK = Index(User_Input(:Line_Length), ' ')
	If (KK .GT. 0) then
		WhoList = User_Input(:KK)
		WhoList_Length = KK-1
		KL = Line_Length - KK
		MsgBuf (MsgBuf_End+1:MsgBuf_End+KL) 
	1			= User_Input(KK+1:Line_Length)
		MsgBuf (MsgBuf_End+KL+1:MsgBuf_End+KL+2) = CRLF
		MsgBuf_End = MsgBuf_End+KL+2
		GoTo 80
	Else
		WhoList = User_Input(:Line_Length)
		WhoList_Length = Line_Length
		GoTo 40			!Prompt for Input
	End If
	
40  	Print *,
	1' Enter Message Lines:            (2 Blank Lines or Ctrl-Z to end)'
	Print *,' '
	
60	Read (5,5080,End=80,Err=70) Line_Length, User_Input
5080	FORMAT(Q,A)
	If ((MsgBuf_End + Line_Length) .GT. 16350) then
		Print *, ' Maximum Message Size has been Exceeded'
		GoTo 80
	End If
	If (Line_Length .LE. 0) then
		If (Blank_Line) then
			MsgBuf_End = MsgBuf_End-2
			GoTo 80
		Else
			Blank_Line = .TRUE.
			MsgBuf (MsgBuf_End+1:MsgBuf_End+2) = CRLF
			MsgBuf_End = MsgBuf_End+2
			GoTo 60
		End If
	Else
		Blank_Line = .FALSE.
	End If
	MsgBuf (MsgBuf_End+1:MsgBuf_End+Line_Length) = User_Input(:Line_Length)
	MsgBuf (MsgBuf_End+Line_Length+1:MsgBuf_End+Line_Length+2) = CRLF
	MsgBuf_End = MsgBuf_End+Line_Length+2
	GoTo 60
	
70	Print *, ' The maximum line length is 132. '//
	1 ' Your last line was "lost".  Continue after:'
	Print *, User_Input(:Line_Length)
	GoTo 60
	
80	Continue
C 
C 	All_Users and/or All_Terminals
C 
	If (All_Users) then
CX		Timeout = Timeout * 2
		Send_Type = BRK$C_ALLUSERS
	
C		Send the message
	
		Status=SYS$BRKTHRUW(,MsgBuf(:MsgBuf_End-2),,
	1		%VAL(Send_Type),IOSB,%VAL(32),
	2		%Val(Brk_Flags),%VAL(BRK$C_USER1),
	3		%Val(Timeout),,)
CX		    PRINT *, Status, IOSB
CX		Timeout = Timeout / 2
		All_Users = .FALSE.	
	
	      If (Terms_Notified .GT. 0) then
	
		NodeName = ' '
		Call Lib$GetSYI (SYI$_NodeName,,NodeName,NodeName_Length)
		If ((NodeName_Length .LE. 0) .OR. (NodeName .EQ. ' ')) then
			NodeName = 'this node.'
			NodeName_Length = 10
		Else
			NodeName_Length = NodeName_Length + 1
			NodeName(NodeName_Length:) = '.'
		End If
		Call Lib$Sys_Fao 
	1	  (' Your message has been sent to !UW user!%S on !AS',
	2	  Out_Str_Length, Out_Str,
	3	  %Val(Terms_Notified),NodeName(:NodeName_Length))
		Print *, Out_Str(:Out_Str_Length)
	      End If
	
	      If (Brk_Status .EQ. 1) then
	    	If ((Terms_Not_Notified + Terms_Refused) .EQ. 0) then
			GoTo 4090			! AllTerms?
	        Else
		  GoTo 4080			! Unnotified Handler
	        End If
	      Else If (Brk_Status .EQ. SS$_DevOffLine) then
		  GoTo 4080			! Unnotified Handler
	      Else
	        Call SYS$GETMSG(%VAL(Brk_Status),
	1		Line_Length,User_Input,%VAL(1),)
	        Print *, ' Direct SEND failed.  Error was "',
	1		User_Input(:Line_Length),'."'
		GoTo 4090				! AllTerms
	      End If
	
4080	      If (Terms_Not_Notified .GT. 0) then
		Call Lib$Sys_Fao 
	1	  (' !UW user!%S are temporarily not receiving messages.',
	2	  Out_Str_Length, Out_Str,
	3	  %Val(Terms_Not_Notified))
		Print *, Out_Str(:Out_Str_Length)
	      End If
	      If (Terms_Refused .GT. 0) then
		If (Terms_Refused .EQ. 1) then
		   Print *, ' 1 user has disabled SEND messages.'
		Else
		  Call Lib$Sys_Fao 
	1	    (' !UW users have disabled SEND messages.',
	2	    Out_Str_Length, Out_Str,  %Val(Terms_Refused))
		  Print *, Out_Str(:Out_Str_Length)
		End If
	      End If
	End If				! End of All Users Section
	
4090	If (All_Terms) then
CX		Timeout = Timeout * 2
		Send_Type = BRK$C_ALLTERMS
	
C		Send the message
	
		Status=SYS$BRKTHRUW(,MsgBuf(:MsgBuf_End-2),,
	1		%VAL(Send_Type),IOSB,%VAL(32),
	2		%Val(Brk_Flags),%VAL(BRK$C_USER1),
	3		%Val(Timeout),,)
CX		    PRINT *, Status, IOSB
CX		Timeout = Timeout / 2
		All_Terms = .FALSE.	
	
	      If (Terms_Notified .GT. 0) then
	
		NodeName = ' '
		Call Lib$GetSYI (SYI$_NodeName,,NodeName,NodeName_Length)
		If ((NodeName_Length .LE. 0) .OR. (NodeName .EQ. ' ')) then
			NodeName = 'this node.'
			NodeName_Length = 10
		Else
			NodeName_Length = NodeName_Length + 1
			NodeName(NodeName_Length:) = '.'
		End If
		Call Lib$Sys_Fao 
	1	 (' Your message has been sent to !UW terminal!%S on !AS',
	2	  Out_Str_Length, Out_Str,
	3	  %Val(Terms_Notified),NodeName(:NodeName_Length))
		Print *, Out_Str(:Out_Str_Length)
	     End If
	
	     If (Brk_Status .EQ. 1) then
	    	If ((Terms_Not_Notified + Terms_Refused) .EQ. 0) then
			GoTo 100			! Other Users
	        Else
		  GoTo 4095			! Unnotified Handler
	        End If
	     Else If (Brk_Status .EQ. SS$_DevOffLine) then
		  GoTo 4095			! Unnotified Handler
	     Else
	        Call SYS$GETMSG(%VAL(Brk_Status),
	1		Line_Length,User_Input,%VAL(1),)
	        Print *, ' Direct SEND failed.  Error was "',
	1		User_Input(:Line_Length),'."'
		GoTo 100				! Other Users
	     End If
	
4095	     If (Terms_Not_Notified .GT. 0) then
		If (Terms_Not_Notified .EQ. 1) then
		   Print *, ' 1 terminal is temporarily not receiving messages.'
		Else
		Call Lib$Sys_Fao 
	1	  (' !UW terminals are temporarily not receiving messages.',
	2	  Out_Str_Length, Out_Str,
	3	  %Val(Terms_Not_Notified))
		Print *, Out_Str(:Out_Str_Length)
		End If
	     End If
	     If (Terms_Refused .GT. 0) then
		If (Terms_Refused .EQ. 1) then
		   Print *, ' 1 terminal has disabled SEND messages'//
	1	     ' or is set to AutoBaud.'
		Else
		  Call Lib$Sys_Fao 
	1	    (' !UW terminals have disabled SEND messages'//
	2	     ' or are set to AutoBaud.',
	3	    Out_Str_Length, Out_Str,  %Val(Terms_Refused))
		  Print *, Out_Str(:Out_Str_Length)
		End If
	     End If
	
	End If
C
C	Break up destination list into separate destinations and 
C	SEND to each one.  Loop until completed
C
100	IComma = 0
	Do While (IComma .LT. WhoList_Length)
		Tell_Mail = .TRUE.
		IStart = IComma + 1
		Who_Length = Index(WhoList(IStart:WhoList_Length),',') - 1
		If (Who_Length .LT. 0) Who_Length = 
	1		WhoList_Length - IStart + 1
		Who = WhoList(IStart:IStart + Who_Length - 1)
		IComma = IStart + Who_Length
	

C
C	If the destination has a colon with it, assume it is a 
C	terminal and not a username and set the appropriate BRKTHRU flag
C
	If (Index(Who,'::').NE.0) then	! Node
		Send_Type = BRK$C_USERNAME
		To_UserName = .TRUE.
		Print *, ' Message cannot be sent to a network terminal ',
	1		Who(1:Who_Length)
		GoTo 200
	
	Else If (INDEX(WHO,':').EQ.0) then
		Send_Type = BRK$C_USERNAME
		To_UserName = .TRUE.
	Else
		Send_Type = BRK$C_DEVICE
		To_UserName = .FALSE.
	EndIf
C
C	Send the message
C
	
	Status=SYS$BRKTHRUW(,MsgBuf(:MsgBuf_End-2),
	1	WHO(1:Who_Length),
	2	%VAL(Send_Type),IOSB,%VAL(32),
	3	%Val(Brk_Flags),%VAL(BRK$C_USER1),
	4	%Val(Timeout),,)
CX	PRINT *, Status, IOSB
	
	If (.NOT. Status) then		! We don't know how else to handle it 
		Brk_Status = Status
		GoTo 160
	End If
	
C	Equivalence (IOSB(1), Brk_Status)
C	Equivalence (IOSB(2), Terms_Notified)
C	Equivalence (IOSB(3), Terms_Not_Notified)
C	Equivalence (IOSB(4), Terms_Refused)
	
	If (Terms_Notified .GT. 0) then
	    If (To_UserName) then
		Call Lib$Sys_Fao 
	1	  (' Your message has been sent to !AS on !UW terminal!%S.',
	2	  Out_Str_Length, Out_Str,
	3	  Who(:Who_Length),%Val(Terms_Notified))
		Print *, Out_Str(:Out_Str_Length)
	    Else	! Sent to a specific terminal
		Call Lib$Sys_Fao 
	1	  (' Your message has been sent to terminal !AS ',
	2	  Out_Str_Length, Out_Str,
	3	  Who(:Who_Length))
		Print *, Out_Str(:Out_Str_Length)
	    End If
	End If

	If (Brk_Status .EQ. 1) then
	    If ((Terms_Not_Notified + Terms_Refused) .EQ. 0) then
		GoTo 999			! End of Who Loop
	    Else
		GoTo 150			! Unnotified Handler
	    End If
	Else If (Brk_Status .EQ. SS$_DevOffLine) then
		GoTo 150			! Unnotified Handler
	Else
		GoTo 160			! Misc. Error Handler
	End If
C 
C 		Handle situations with unnotified things.
C 
150	If (To_UserName) then
	    If ((Terms_Notified + Terms_Not_Notified + Terms_Refused) 
	1		.EQ. 0) then
		NodeName = ' '
		Call Lib$GetSYI (SYI$_NodeName,,NodeName,NodeName_Length)
		If ((NodeName_Length .LE. 0) .OR. (NodeName .EQ. ' ')) then
			NodeName = 'this node.'
			NodeName_Length = 10
		Else
			NodeName_Length = NodeName_Length + 1
			NodeName(NodeName_Length:) = '.'
		End If
		Print *,' User ',Who(:Who_Length),
	1		' is not logged in on ',NodeName(:NodeName_Length)
	        GoTo 200
	    End If
	    If (Terms_Not_Notified .GT. 0) then
		Call Lib$Sys_Fao 
	1	  (' User !AS is temporarily not receiving messages'//
	2		' on !UW terminal!%S.',
	3	  Out_Str_Length, Out_Str,
	4	  Who(:Who_Length),%Val(Terms_Not_Notified))
		Print *, Out_Str(:Out_Str_Length)
	    End If
	    If (Terms_Refused .GT. 0) then
		Call Lib$Sys_Fao 
	1	  (' User !AS has disabled SEND messages'//
	2		' on !UW terminal!%S.',
	3	  Out_Str_Length, Out_Str,
	4	  Who(:Who_Length),%Val(Terms_Refused))
		Print *, Out_Str(:Out_Str_Length)
	    End If
	    GoTo 200		! Check if we should mail it.
	Else			! To individual terminal
	    If (Terms_Not_Notified .GT. 0) then
		Call Lib$Sys_Fao 
	1	  (' Terminal !AS is temporarily not receiving messages.',
	2	  Out_Str_Length, Out_Str, Who(:Who_Length))
		Print *, Out_Str(:Out_Str_Length)
	    End If
	    If (Terms_Refused .GT. 0) then
		Call Lib$Sys_Fao 
	1	  (' Terminal !AS has disabled SEND messages'//
	2	     ' or is set to AutoBaud.',
	3	  Out_Str_Length, Out_Str,  Who(:Who_Length))
		Print *, Out_Str(:Out_Str_Length)
	    End If
	    GoTo 999	! End of Who Loop
	End If
	
	GoTo 999	! End of Who Loop
C
C 		Misc. Error Handler
C	If a "strange" error occured, get the proper error message
C
	
160	Call SYS$GETMSG(%VAL(Brk_Status),Line_Length,User_Input,%VAL(1),)
	Print *, ' Direct SEND failed.  Error was "',
	1	User_Input(:Line_Length),'."'
	Print *, ' Message was not sent to ',Who(:Who_Length)
	
200	If (Send_Type .EQ. BRK$C_USERNAME) then
	    If (Ask) then
		TYPE 5200
5200	FORMAT
	1 ('  Do you wish this message sent by VMS Mail? (Y/N) [Y]'$)
5101		READ(5,10,ERR=999,End=999) J_Len,Resp
10	FORMAT(Q,A3)
C
C     Affirmative responses
C
		If (J_Len .LE. 0) GoTo 5500
		Call Str$UpCase (Resp, Resp)
		If (Resp(1:1) .EQ. 'Y' .OR. Resp(1:1) .EQ. 'T') GoTo  5500
		If (Resp(1:2) .EQ.'OK') GoTo 5500
C
C     Negative responses
C
		If (Resp(1:1) .EQ. 'N') GoTo 999	! End of Who Loop
C
C	Invalid response
C
		GoTo 200
	
	    Else If (MailIt) then
5500		Print *, ' Sending message by VMS Mail.....'
		OPEN(UNIT=8,FILE='SYS$LOGIN:SEND.MAI',DISP='KEEP',
	1		Status='NEW',CARRIAGECONTROL='LIST')

		MStart = Index(MsgBuf,CRLF) + 2
		If (MStart .LE. 2) GoTo 5070
5050		If (MStart .GT. MsgBuf_End) GoTo 5070
		MLength = Index(MsgBuf(MStart:),CRLF)
		If (MLength .GT. 1) then
			Write (8,1020) MsgBuf(MStart:MStart + MLength -2)
1020				Format (A)
			MStart = MStart + MLength + 1
			GoTo 5050
		Else If (MLength .EQ. 1) then
			Write (8,1020)			! Blank Line
			MStart = MStart + 2
			GoTo 5050
		Else					! No CRLF Found
			GoTo 5070
		End If

5070		CLOSE(UNIT=8)
		Status = LIB$DELETE_LOGICAL('SYS$INPUT',)
		Status = LIB$SPAWN( 
	1		'$ MAIL/SUBJECT="SEND Utility message" '//
	2		'SYS$LOGIN:SEND.MAI '//
	3		WHO(1:Who_Length),,,NOCLISYM+NOLOGNAM)
		If (.NOT.Status) 
	1		Print *,' MAIL attempt failed.'//
	2		'  Message not sent to ',Who(:Who_Length)
		Call Lib$Delete_File ('SYS$LOGIN:SEND.MAI')
	Else
		If (Tell_Mail) 
	1	Print *, ' Message has Not been sent to ',Who(:Who_Length),
	2			' by VMS Mail.'
	EndIf
	
	EndIf
999	EndDO
	
9999	End
                                                                                                                                                                                                  