#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#include <stdio.h>
#include "asm.h"

#define  R_WORD	0	/* 16 bit */
#define	 R_BYTE 01

#define	 R_AREA	0	/* Base type */
#define  R_SYM	02

#define	 R_NORM	0	/* PC adjust */
#define	 R_PCR	04

#define	 R_DEF	00	/* Global def. */
#define	 R_REF	01	/* Global ref. */
#define	 R_REL	00	/* Relocatable */
#define  R_ABS	02	/* Absolute */
#define  R_GBL	00	/* Global */
#define  R_LCL	04	/* Local */

#define	 NTXT	16
#define	 NREL	16

char	 txt[NTXT];
char	 rel[NREL];

char	*txtp = { &txt[0] };
char	*relp = { &rel[0] };

/*
 * Output absolute byte.
 */
outab(b)
{
	if (pass == 2) {
		outlst(b);
		if (oflag) {
			outchk(1, 0);
			*txtp++ = lobyte(b);
		}
	}
	++dot->s_addr;
}

/*
 * Output absolute word.
 * Low then high.
 */
outaw(w)
{
	if (pass == 2) {
		outlst(lobyte(w));
		outlst(hibyte(w));
		if (oflag) {
			outchk(2, 0);
			*txtp++ = lobyte(w);
			*txtp++ = hibyte(w);
		}
	}
	dot->s_addr += 2;
}

/*
 * Output relocatable byte.
 */
outrb(esp, pcrf)
register struct expr *esp;
{
	register n, r;

	if (pass == 2) {
		outlst(esp->e_addr);
		if (oflag) {
			if (esp->e_flag==0 && esp->e_base.e_ap==NULL) {
				outchk(1, 0);
				*txtp++ = lobyte(esp->e_addr);
			} else {
				outchk(1, 4);
				*txtp++ = lobyte(esp->e_addr);
				r = R_BYTE;
				if (pcrf)
					r |= R_PCR;
				if (esp->e_flag) {
					n = esp->e_base.e_sp->s_ref;
					r |= R_SYM;
				} else
					n = esp->e_base.e_ap->a_ref;
				*relp++ = r;
				*relp++ = txtp - txt - 1;
				*relp++ = lobyte(n);
				*relp++ = hibyte(n);
			}
		}
	}
	++dot->s_addr;
}

/*
 * Output relocatable word.
 * Low then high.
 */
outrw(esp, pcrf)
register struct expr *esp;
{
	register n, r;

	if (pass == 2) {
		outlst(lobyte(esp->e_addr));
		outlst(hibyte(esp->e_addr));
		if (oflag) {
			if (esp->e_flag==0 && esp->e_base.e_ap==NULL) {
				outchk(2, 0);
				*txtp++ = lobyte(esp->e_addr);
				*txtp++ = hibyte(esp->e_addr);
			} else {
				outchk(2, 4);
				*txtp++ = lobyte(esp->e_addr);
				*txtp++ = hibyte(esp->e_addr);
				r = R_WORD;
				if (pcrf)
					r |= R_PCR;
				if (esp->e_flag) {
					n = esp->e_base.e_sp->s_ref;
					r |= R_SYM;
				} else
					n = esp->e_base.e_ap->a_ref;
				*relp++ = r;
				*relp++ = txtp - txt - 2;
				*relp++ = lobyte(n);
				*relp++ = hibyte(n);
			}
		}
	}
	dot->s_addr += 2;
}

/*
 * Output a byte to the listing
 * buffer.
 */
outlst(b)
{
	if (cp < &cb[NCODE])
		*cp++ = b;
}

outchk(nt, nr)
{
	register struct area *ap;

	if (txtp+nt > &txt[NTXT] || relp+nr > &rel[NREL]) {
		if (txtp > &txt[2]) {
			fprintf(ofp, "T");
			out(txt, txtp-txt);
			fprintf(ofp, "\n");
			txtp = txt;
			if (relp > rel) {
				fprintf(ofp, "R");
				out(rel, relp-rel);
				fprintf(ofp, "\n");
				relp = rel;
			}
		}
	}
	if (txtp == txt) {
		*txtp++ = lobyte(dot->s_addr);
		*txtp++ = hibyte(dot->s_addr);
		if ((ap = dot->s_area) != NULL) {
			*relp++ = R_WORD|R_AREA;
			*relp++ = 0;
			*relp++ = lobyte(ap->a_ref);
			*relp++ = hibyte(ap->a_ref);
		}
	}
}

/*
 * Walk through the symbol table and the
 * area list and put out the global
 * symbol information at the front of the
 * relocatable file. This routine is also
 * responsible for setting up the ref.
 * numbers in the symbols and areas.
 */
outgsd()
{
	register struct area *ap;
	register struct sym  *sp;
	register i;
	int narea, nglob, rn;

	narea = 0;
	ap = areap;
	while (ap != NULL) {
		ap->a_ref = narea;
		++narea;
		ap = ap->a_ap;
	}
	nglob = 0;
	for (i = 0; i < NHASH; ++i) {
		sp = symhash[i];
		while (sp != NULL) {
			if ((sp->s_flag&S_GBL) != 0)
				++nglob;
			sp = sp->s_sp;
		}
	}
	fprintf(ofp, "H %d areas %d global symbols\n", narea, nglob);
	/*
	 * Global relocatables.
	 */
	rn = 0;
	ap = areap;
	while (ap != NULL) {
		outarea(ap);
		for (i=0; i<NHASH; ++i) {
			sp = symhash[i];
			while (sp != NULL) {
				if (sp->s_area==ap && (sp->s_flag&S_GBL)!=0) {
					sp->s_ref = rn;
					++rn;
					outsym(sp);
				}
				sp = sp->s_sp;
			}
		}
		ap = ap->a_ap;
	}
	/*
	 * Global references and absolutes.
	 */
	for (i=0; i<NHASH; ++i) {
		sp = symhash[i];
		while (sp != NULL) {
			if (sp->s_area==NULL && (sp->s_flag&S_GBL)!=0) {
				sp->s_ref = rn;
				++rn;
				outsym(sp);
			}
			sp = sp->s_sp;
		}
	}
}

/*
 * Output the relocatable item defining
 * an area.
 */
outarea(ap)
register struct area *ap;
{
	register char *p;
	register c;

	fprintf(ofp, "A ");
	p = &ap->a_sp->s_id[0];
	while (p < &ap->a_sp->s_id[NCPS] && (c = *p++))
		putc(c, ofp);
	fprintf(ofp, " size %o flags %o\n", ap->a_size, ap->a_flag);
}

/*
 * Output the relocatable item describing a
 * global symbol.
 */
outsym(sp)
register struct sym *sp;
{
	register char *p;
	register c;

	fprintf(ofp, "S ");
	p = &sp->s_id[0];
	while (p < &sp->s_id[NCPS] && (c = *p++))
		putc(c, ofp);
	fprintf(ofp, " %s", sp->s_type==S_NEW ? "Ref" : "Def");
	fprintf(ofp, "%06o\n", sp->s_addr);
}

out(p, n)
register char *p;
register n;
{
	while (n--)
		fprintf(ofp, " %03o", (*p++)&0377);
}

/*
 * Extract low half of a word.
 */
lobyte(n)
{
	return (n&0377);
}

/*
 * Extract high half of a word.
 */
hibyte(n)
{
	return ((n>>8)&0377);
}
                                                                                                                              