#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Modifications Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * Copyright (c) 1978 Charles H. Forsyth
 */

/*
 * lex -- dfa construction routines
 */

#include <stdio.h>
#include "lexlex.h"

/*
 * Build the dfa
 * from the nfa
 */
dfabuild()
{
	struct trans *trp;
	struct nfa **vec, **tp, *np, *temp[MAXNFA+1];
	int a, i;
	struct set **sp, *stack[MAXDFA], **spp, *xp;
	struct move *dp;
	struct dfa *state;
	struct xset *xs, *xse;

/*
 * Simulate an
 * epsilon transition
 * from nfa state 0
 * to the initial states
 * of the machines for each
 * translation.
 */
	nfa[0].n_char = EPSILON;
	vec = lalloc(i = (transp-trans)+1, sizeof(*vec), "dfabuild");
	vec[0] = nfa;
	for (a = 1, trp = trans; trp < transp; trp++)
		vec[a++] = trp->t_start;
	sp = eclosure(newset(vec, i, 1));
	free(vec);

/*
 * From state 0, which is
 * now stacked, all further
 * dfa states will be derived.
 */
	sp->s_flag |= ADDED;
	spp = stack;
	*spp++ = sp;
	while (spp > stack) {
		sp = *--spp;
		for (a = 0; a < NCHARS; a++)
			insets[a] = 0;
		xse = sets;
		for (i = 0; i < sp->s_len; i++)
			xse = addset(sp->s_els[i], xse);
		state = newdfa();
		sp->s_state = state;
		state->df_name = sp;
		if (lldebug) {
			fprintf(lexlog, "build state %d ", state-dfa);
			pset(sp, 1);
			fprintf(lexlog, "\n");
		}
		state->df_ntrans = xse-sets;
		for (xs = sets; xs < xse; xs++) {
			a = xs->x_char&0377;
			tp = temp;
			for (i = 0; i < sp->s_len; i++)
				if ((np = sp->s_els[i])->n_char==a ||
				    np->n_char==CCL &&
				    np->n_ccl[a/NBPC]&(1<<(a%NBPC)))
					add(temp, &tp, np->n_succ[0]);
			xp = newset(temp, tp-temp, 1);
			xp = eclosure(xp);
			if (lldebug) {
				fprintf(lexlog, "\t%c\t", a);
				pset(xp, 1);
				fprintf(lexlog, "\n");
			}
			xs->x_set = xp;
			if (xp->s_state==0 && (xp->s_flag&ADDED)==0) {
				xp->s_flag |= ADDED;
				if (spp >= stack+MAXDFA) {
					error("dfabuild: stack overflow");
					exit(1);
				}
				*spp++ = xp;
			}
		}
		state->df_default = defalt(state, &xse);
		setbase(state, stbase(xse), xse);
	}
}

/*
 * If an nfa state is not
 * already a member of the vector
 * `base', add it.
 */
add(base, tpp, np)
struct nfa ***tpp, **base, *np;
{
	register struct nfa **tp;

	for (tp = base; tp < *tpp; tp++)
		if (*tp == np)
			return;
	*(*tpp)++ = np;
}

/*
 * Add the character(s)
 * on which state `np'
 * branches to the transition
 * vector.
 */
addset(np, xse)
register struct nfa *np;
struct xset *xse;
{
	register a;
	register char *ccl;

	if ((a = np->n_char) < NCHARS)
		xse = addxset(a, xse);
	if (a != CCL)
		return(xse);
	ccl = np->n_ccl;
	for (a = 0; a < NCHARS; a++)
		if (ccl[a/NBPC]&(1<<(a%NBPC)))
			xse = addxset(a, xse);
	return(xse);
}

/*
 * Add a character to the
 * transition vector, if it
 * isn't there already.
 */
addxset(a, xse)
register a;
struct xset *xse;
{
	register struct xset *xs;
	register int	temp;

/*
 * VMS native doesn't do this correctly:
 *	if (insets[a]++)
 */
	temp = insets[a];
	insets[a] += 1;
	if (temp)
		return(xse);
	xs = xse++;
	xs->x_char = a;
	xs->x_set = NULL;
	xs->x_defsame = 0;
	return(xse);
}
                                                                                                                                                                                                                                                    