#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#

#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 

#ifdef rt11
#define	RT_RMON		054	/* Work area starting address		*/
#define	RT_LOGTBL	014	/* Logical name table			*/
#define RT_MODE		004	/* Mode word for opens			*/

struct	{
	char	*pointer;	/* For addressing into the work area	*/
};

struct	{
	int	integer;
};
#endif

rs_open(channel, name, omode)
int		channel;	/* Channel number for open		*/
char		*name;		/* File name string			*/
char		*omode;		/* Mode "r", "a", or "w" only		*/
/*
 * Open a file, return error code -- zero for success.
 * Sorry, you must supply the channel.
 */
{
	register	char	*p;
	register	int	errcode;

retry:	clrfqx();
	xrb.xrlen	= strlen(name);	/* Length of the file name	*/
	xrb.xrbc	= xrb.xrlen;	/* Another copy of the length	*/
	xrb.xrloc	= name;		/* Name starting address	*/
	xrb.xrblk	= 44;		/* 44 byte logical name table	*/
#ifdef rt11
	p = RT_RMON->pointer + RT_LOGTBL;
	xrb.xrtime	= p;		/* Save start of logical table	*/
#endif
	if ((errcode = rstsys(_FSS)) != 0)
		return(-1);
	firqb.fqfil	= channel * 2;
	firqb.fqfun	= (*omode == 'w') ? CREFQ : OPNFQ;
/*
 * Force clustersize to zero (bug somewhere in RSTS)
 */
	firqb.fqclus	= 0;		/* ?? Bug ??			*/
	errcode = rstsys(CALFIP);
	if (*omode == 'a' && errcode == 5) {
		omode = "w";
		goto retry;
	}
	return(errcode);
}
        