/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#
/*
 *			F I X D O C
 *
 * Because of bugs in RSTS/E RNO.TSK and VMS "Standard Runoff", this
 * filter must be applied to C library documentation.  It is executed as
 *
 *	mcr fixdoc <infile >outfile
 *
 * It is specific to the documentation standards (page size 80 columns).
 * Note that, on RT11, the input stream is reopened "u" to avoid
 * dropping naked <CR>'s (for overstriking).
 *
 * On VMS, the title lines are output "<FF>text...".
 *
 */
#include <stdio.h>

#define PAGESIZE	72	/* .right margin 72			*/

char	line[1025];
char	out[1025];


main(argc, argv)
int		argc;
char		*argv[];
{
	register char	*lp;			/* Line pointer		*/
	register char	*op;			/* Output pointer	*/
	register int	c;			/* Random character	*/
	char		*from;			/* Marker in line	*/
	char		*hack_start;		/* You'll see		*/

#ifdef	rt11
	/*
	 * This is needed to preserve the naked carriage-return
	 * that runoff uses for underlining.
	 */
	iovtoa(stdin, line);
	if (freopen(line, "rn", stdin) == NULL)
		error("Can't reopen \"%s\"\n", line);
#endif
	while (gets(line) != NULL) {
		hack_start = lp = line;
		/*
		 * Form feed?
		 */
		if (*lp == '\f') {
			putchar('\f');
			hack_start = ++lp;	/* Skip over col 1 <FF>	*/
		}
		while ((c = *lp) == ' ' || c == '\t')
			lp++;			/* Leading blanks	*/
		if (c != '[' || lp[1] != '[')	/* "[[text ..."		*/
			goto nogood;
		from = &lp[2];			/* "text..."		*/
		while ((c = *++lp) && c != ']'); /* "... ]]"		*/
		if (c == 0 || lp[1] != ']')
			goto nogood;
		op = copy(out, from, lp - from);
		*op = 0;
		lp += 2;
		while ((c = *lp) && c <= ' ')
			lp++;			/* "[[text]]   Page"	*/
		if (tolower(c) != 'p'
				|| tolower(lp[1]) != 'a'
				|| tolower(lp[2]) != 'g'
				|| tolower(lp[3]) != 'e'
				|| lp[4] != ' ')
			goto nogood;
		printf("%s%?s\n", out, PAGESIZE - (op - out) + 1, lp);
		continue;

nogood:		puts(hack_start);
	}
}

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 