#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 *		c p y r i t
 *
 * prepend cpyrit text to all .C and .H programs
 *
 * Execute by
 *
 *	cpyrit {-e} *.c *.h
 *
 * The -e flag erases copyrights that were inserted by cpyrit
 *
 * Output extensions are
 *	*.c	->	*.cpc
 *	*.h	->	*.cph
 */
#
# include <stdio.h>

char *cpyrit[] {
	"#",
	"/*",
	" *",
	" *",
	" * The  information  in  this  document  is  subject  to  change",
	" * without  notice  and  should not be construed as a commitment",
	" * by Digital Equipment Corporation or by DECUS.",
	" * ",
	" * Neither Digital Equipment Corporation, DECUS, nor the authors",
	" * assume any responsibility for the use or reliability of  this",
	" * document or the described software.",
	" * ",
	" * 	Copyright (C) 1980, DECUS",
	" * ",
	" * ",
	" * General permission to copy or modify, but not for profit,  is",
	" * hereby  granted,  provided that the above copyright notice is",
	" * included and reference made to  the  fact  that  reproduction",
	" * privileges were granted by DECUS.",
	" *",
	" */",
	"",	
	0,
};

#define	MAX_NAMES	400

int		debug;
int		erase;
char		*model;
char		*pattern;
char		*wild_spec;
char		*out_spec;
char		fullname[81];
char		filename[81];
char		line[133];		/* Input text line		*/
char		*text[MAX_NAMES];	/* store file names here	*/
char		**ttop = text;		/* Top of text pointer		*/


FILE		*infd;

main(argc, argv)
int		argc;
char		*argv[];
{

	register int		c;
	register int		i;
	register char		*ap;

	if (argv[1][0] == '?' && argv[1][1] == 0) {
		help();
		exit();
	}
	for (i = 1; i < argc; i++) {
		if (*(ap = argv[i]) == '-') {
			while ((c = tolower(*++ap)) != 0) {
				switch (c) {
				case 'd':
					debug++;
					break;

				case 'e':
					erase++;
					break;

				default:
					bug("W", "Unknown switch '%c'\n",
							c);
					break;
				}
			}
		}
		else {
			wild_spec = argv[i];
			ttop = text;
			if (process() > 0)
				doit();
		}
	}
}


process()
/*
 * Find files, return how many
 */
{
	register int		count;		/* Count files		*/

	if (debug)
		fprintf(stderr, "Wild card spec = \"%s\"\n", wild_spec);
	if ((infd = fwild(wild_spec, "r")) == NULL) {
		bug("E", "Can't open \"%s\"\n", wild_spec);
		return(0);
	}
	for (count = 0; fnext(infd) != NULL; count++) {
		setname(infd);
		if (debug)
			fprintf(stderr, "Curr file = \"%s\"\n", fullname);
		save(fullname);
	}
	if (debug)
		fprintf(stderr, "%d files processed\n\n", count);
	if (count == 0)
		bug("W", "No files matched \"%s\"\n", wild_spec);
	return(count);
}

doit()
{
	register char	**textp;
	register char	**ip;
	register char	*op;
	char		c;
	FILE		*ifd;
	FILE		*ofd;
	char		outname[81];
	char		*cpystr();

	for (textp = text; textp < ttop; textp++) {
		if (debug)
			fprintf(stderr, "reopening \"%s\"\n", *textp);
		if ((ifd = fopen(*textp, "r")) == NULL) {
			bug("E", "Can't reopen \"%s\"\n", *textp);
			continue;
		}
		op = cpystr(outname, *textp);		
		while (op > &outname && *--op != '.');
		if (*op != '.') {
			bug("E", "No extension in \"%s\"\n", outname);
			goto idone;
		}
		if (op[1] != 0 && op[2] != 0) {
			bug("W", "Long extension in \"%s\", ignored\n",
					outname);
			goto idone;
		}
		c = op[1];
		op = cpystr(op, ".CP");
		*op++ = c;
		*op = 0;
		if (debug)
			fprintf(stderr, "Outfile = \"%s\"\n", outname);
		if ((ofd = fopen(outname, "w")) == NULL) {
			bug("E", "Can't open output file \"%s\"\n",
					outname);
			goto idone;
		}
		if (erase) {
			if (fgetss(line, sizeof line, ifd) == NULL)
				goto odone;
			if (streq(line, "#") == 0) {
				bug("W", "Not done by cpyrit, file \"%s\"\n",
					*textp);
				fmkdl(ofd);
				goto idone;
			}
			if (fgetss(line, sizeof line, ifd) == NULL
			  || streq(line, "/*") == NULL) {
				bug("W", "Not done by cpyrit, file \"%s\"\n",
					*textp);
				fmkdl(ofd);
				goto idone;
			}
			while (fgetss(line, sizeof line, ifd) &&
				streq(line, " */") == 0);
		}
		else {
			for (ip = cpyrit; *ip != 0; ip++) {
				fputss(*ip, ofd);
			}
		}
		while (fgetss(line, sizeof line, ifd))
			fputss(line, ofd);
odone:		fclose(ofd);
idone:		fclose(ifd);
	}
}

setname(fd)
FILE 		*fd;
/*
 * Build file name
 */
{
	register char		*wp;
	register int		c;
	char			work[81];

	iovtoa(fd, work);
	wp = work;
#ifdef __UNDEFINED__
	/*
	 * Skip over device name
	 */
	while ((c = *wp) && c != ':')
		wp++;
	if (c)	wp++;
	else	wp = work;
	/*
	 * Skip over [UIC] or [PPN] if present
	 */
	if (*wp == '[' || *wp == '(') {
		while ((c = *wp++) && c != ']' && c != ')')
		if (c == 0) {
			fprintf(stderr, "?GETCMD-bad file name \"%s\"\n",
					work);
			wp--;
		}
	}
#endif
	cpystr(fullname, wp);
	/*
	 * Don't include version
	 */
	for (wp = fullname; (c = *wp) && c != ';'; wp++);
	*wp = 0;
}

save()
/*
 * Save fullname, add it to the text area (in sorted order)
 */
{
	register char	**textp;
	register char	**insert;
	register int	i;

	for (textp = text; textp < ttop; textp++) {
		if ((i = strcmp(*textp, fullname)) == 0) {
			fprintf("?GETCMD-E-Duplicate file name \"%s\"\n",
				fullname);
			return;
		}
		else if (i > 0)
			break;
	}
	insert = textp;
	textp = ttop;
	if (++ttop >= &text[MAX_NAMES])
		error("?GETCMD-F-Too many file names, %d max.\n", MAX_NAMES);

	while (textp >= insert) {
		textp[1] = *textp;
		textp--;
	}
	if ((*insert = malloc(strlen(fullname) + 1)) == NULL)
		error("?GETCMD-F-No room for \"%s\"\n", fullname);
	cpystr(*insert, fullname);
}

help()
/*
 * Give good help
 */
{
	register char	**dp;

	fprintf(stderr, "cpyrit *.c *.h\n");
}

usage(s)
char	*s;
{
	bug("E", "%s.  For help, cpyrit ?\n", s);
	exit(1);
}

bug(severity, s)
char		*severity;
char		*s;
/*
 * Error messages
 */
{
	fprintf(stderr, "%c-CPYRIT-%s-%r",
		(*severity == 'W') ? '%' : '?', severity, &s);
}
                           