X-NEWS: eisner vmsnet.pdp-11: 602
Relay-Version: VMS News - V6.1 30/1/93 VAX/VMS V5.5-2; site eisner.decus.org
Path: eisner.decus.org!noc.near.net!howland.reston.ans.net!ira.uka.de!rz.uni-karlsruhe.de!usenet@rz
Newsgroups: vmsnet.pdp-11
Subject: Source: RX50 formatter
Message-ID: <1s1ag9$17i@nz12.rz.uni-karlsruhe.de>
From: DAHMS@ifk20.mach.uni-karlsruhe.de (Heribert Dahms)
Date: 2 May 1993 20:21:29 GMT
Distribution: world
Organization: University of Karlsruhe, FRG (Dept. of Mechanical Engineering)
NNTP-Posting-Host: ifk29.mach.uni-karlsruhe.de
Mime-Version: 1.0
Content-Type: text/plain; charset=iso-8859-1
Content-Transfer-Encoding: 8bit
X-News-Reader: VMS NEWS 1.20
Lines: 252

Several people wanted the source for the RX50 formatter, here it is.
I have asked the author and got the permission to post it. His address follows:
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+ proGIS Softwareentwicklung, Simulationssysteme, Beratung   +
+        Germany - 51oo Aachen, Jakobstrasse 181             +
+ E-Mail: andreas@didymus.rmi.de VOICE: (49) 241 403 446     +
+                                  FAX: (49) 241 403 407     +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

It is commented in german, so I give some hints.
I compiled it on a PC/AT with Borland's Turbo C 2.0 without problems.
Specify which is the 5.25" drive as #DEFINE DRIVE with 0 = A: and 1 = B: etc.
Compile without testing for stack overflow.
You can use cheap noname diskettes, but I wouldn't archive important data
on it. File transfer is no problem. I use 2D or 4D/96tpi diskettes, not HD.



/***************************************************************************/
/* RX50-Format auf PC erzeugen. Autor: A. Fassl, proGIS, 0241/403446 - 1-91*/
/***************************************************************************/
/* Hardware: AT-Kompatibler mit 5 1/4"- High-Density Laufwerk              */
/***************************************************************************/
/* Aufruf:                                                                 */
/* decforma                     Formatierung ohne Verify                   */
/* decforma -v                  Nur Verify                                 */
/* decforma -v -f               Formatierung und Verify                    */
/***************************************************************************/
/* WICHTIG: Compileroption "Test stack overflow" abschalten                */
/***************************************************************************/
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#define TURBO_C  1              /* Fuer Borland Turbo-C */
#define QUICK_C  0              /* Fuer Microsoft Quick-C */
#define MAX_RETRIES  3          /* Maximale Anzahl Wiederholungen */
#define SEKTOREN 10             /* Anzahl Sektoren */
#define SPUREN   79             /* Anzahl Spuren (Tracks) */
#define KOEPFE   1              /* Anzahl Schreib-/Lesekpfe */
#define BPS      2              /* Bytes pro Sektor */
#define STARTSEKTOR 1           /* Startsektor */
#define TYPE     4
#define TRUE     1
#define FALSE    0
#define DRIVE    0              /* A: = 0   Kodierung des Laufwerks*/
#define VERSION  1.0
struct f_pack
      {
      unsigned char track;
      unsigned char head ;
      unsigned char sector;
      unsigned char bps  ;
      } ad_field[SEKTOREN];
void interrupt (*old_param_table)();
unsigned char param_table_10[11] =
        { 0xdf,         /* step rate */
          0x02,         /* load time */
          0x25,         /* motor off time */
          BPS,          /* 2 = 512 BPS */
          SEKTOREN,     /* Sektoranzahl */
          0x02,         /* GAP */
          0xff,         /* data lenght */
          0x2e,         /* Gap Size */
          0xf6,         /* Fillpattern beim Formatieren */
          0x0f,         /* head settle time */
          0x08          /* motor start time */
          };
char **xargv;
int  xargc;
int verify(int,int);
int formatiere(int,int);
void reset_drive(void);
/**************************************************************/
/* Umprogrammierung des 1.2 MB Laufwerks A:                   */
/**************************************************************/
void reset_drive()
{
typedef union { long adresse;
                unsigned char far *wert;
              } pointer;
pointer         bios_zeiger;
bios_zeiger.adresse = ( (long) 0x40<<16) + (0x90+DRIVE);
*bios_zeiger.wert   = 0x57;              /* 01010111 */
#if TURBO_C
setvect(30 , (void far interrupt (*)())param_table_10);
#endif
#if QUICK_C
_dos_setvect(30, (void far interrupt *)param_table_10);
#endif
}
/***************************************************************************/
/* Formatierroutine                                                        */
/***************************************************************************/
int formatiere(Spur,Kopf)
int Spur,Kopf;
{
union  REGS regs;
struct SREGS sregs;
int scount;
void far *pAdField;
printf("\r Formatiere  Spur %2d   ",Spur);
reset_drive();  /* Disklaufwerk umprogrammieren */
for (scount=STARTSEKTOR-1;scount<SEKTOREN;scount++) /* Sektortabelle erst. */
{
ad_field[scount].track  = (unsigned char)Spur;      /* Aktuelle Spur */
ad_field[scount].head   = (unsigned char)Kopf;      /* Diskettenseite */
ad_field[scount].bps    = (unsigned char)BPS;       /* Bits pro Sektor */
ad_field[scount].sector = (unsigned char)scount+1;  /* Sektornummerierung */
}
regs.h.ah       = (unsigned char)0x05;         /* Format */
regs.h.al       = (unsigned char)SEKTOREN;     /* Sektoren */
regs.h.ch       = (unsigned char)Spur;         /* Aktuelle Spur */
regs.h.dh       = Kopf;                        /* Seite */
regs.h.dl       = DRIVE;                       /* Laufwerk */
regs.h.cl       = (unsigned char)SEKTOREN;     /* Anzahl Sektoren */
pAdField = ad_field;
sregs.es        = FP_SEG ( pAdField );         /* Segmentadresse */
regs.x.bx       = FP_OFF ( pAdField );         /* Segmentoffset */
int86x(0x13,&regs,&regs,&sregs);   /* Interrupt 0x13 aufrufen */
return(regs.h.ah);
}
/***************************************************************************/
/* Verifizierungsroutine                                                   */
/***************************************************************************/
int verify(Spur,Kopf)
int Spur,Kopf;
{
union           REGS regs;
printf("\r Verifiziere Spur %2d",Spur);
regs.h.ah       = (unsigned char)0x04;         /* Verify */
regs.h.al       = (unsigned char)SEKTOREN;     /* 10 Sektoren */
regs.h.ch       = (unsigned char)Spur;         /* Aktuelle Spur */
regs.h.cl       = (unsigned char)1;            /* Startsektor */
regs.h.dh       = (unsigned char)Kopf;
regs.h.dl       = DRIVE;            /* Laufwerk A: = 0 */
int86(0x13,&regs,&regs);
return regs.h.ah;
}
/***************************************************************************/
/* Kurze Bedienungsanleitung ausgeben                                      */
/***************************************************************************/
void usage(char *name)
{ printf("\nAufruf des Programms:\n\n");
  printf("%s <return>        --- Formatierung\n",name);
  printf("%s -f <return>     --- Formatierung\n",name);
  printf("%s -v <return>     --- Nur Disk verifizieren\n",name);
  printf("%s -v -f <return>  --- Disk formatieren u. verifizieren\n",name);
}
/***************************************************************************/
/* Argumentstring zerlegen                                                 */
/***************************************************************************/
char *dosgetarg(int pos)
{   if ((pos <0) || (pos >= xargc))
           return NULL;
    return(xargv[pos]);
}
/***************************************************************************/
/* Hauptprogramm                                                           */
/***************************************************************************/
void main(argc,argv)
int     argc;
char   *argv[];
{
int             verify_ja       = FALSE; /* Default: Keine Verifizierung */
int             format_ja       = TRUE;  /* Default: Nur formatieren */
int             fehler          = FALSE; /* Fehler beim Aufruf? */
int             tcount;                  /* Trackcounter */
int             verifyresult;
char            *aptr;
int             zaehl=1,retries,defekt=0;
xargv = (char **)argv;
xargc =  argc;
printf("RX50-Format --- (Copyright 1991 A. Fassl) Version %4.2f 1-91 (0241-403446)\n",VERSION);
/******************* Parameter berprfen **********************************/
while (zaehl< xargc)
        { aptr = dosgetarg (zaehl);
        if (*aptr == '-') {             /* param arg */
                        aptr++;
                        switch (*aptr)
                        {
                        case 'v': verify_ja = TRUE; zaehl++;
                                  format_ja = FALSE;
                         break;
                        case 'h': fehler = TRUE; zaehl++;
                                  usage(argv[0]);
                         break;
                        case 'f': format_ja = TRUE; zaehl++;
                         break;
                        case '\0': zaehl++;
                         break;
                        default :  zaehl++; fehler = TRUE;
                                  usage(argv[0]);
                         break;
                        }
             }
        }
if (fehler) printf("Programmabbruch! \n");
else {
#if TURBO_C
    old_param_table = getvect(30); /* Alte Parameter retten */
#endif
#if QUICK_C
    old_param_table = _dos_getvect(30);
#endif
    for (tcount=0;tcount<=SPUREN;tcount++)  /* Beginn Formatschleife */
          {
          if (format_ja)                    /* Formatierroutine */
             if (formatiere(tcount,KOEPFE-1)!=0)
                {
                printf("\n\n Format-Error. Retrying...\n");
                for (retries=0;retries<MAX_RETRIES;retries++)
                    {                       /* Weitere Versuche */
                    if (formatiere(tcount,KOEPFE-1)!=0)
                       defekt=1;
                    else {defekt=0;break;};
                    };
                if (defekt) exit(-1); /* Formatierfehler */
                }  /* Ende Formatroutine */
          }  /* Ende Formatschleife */
    for (tcount=0;tcount<=SPUREN;tcount++)  /* Beginn Verifyschleife */
       {
         if (verify_ja)                     /* Verifizierroutine */
         if (((verifyresult = verify(tcount,KOEPFE-1)) != 0)&&
              (verifyresult != 6))
                {
                printf("\n\nVerify-Error %d\n", verifyresult);
                for (retries=0;retries<MAX_RETRIES;retries++)
                    {                       /* Weitere Versuche */
                    if (verify(tcount,KOEPFE-1)!=0)
                       {
                       formatiere(tcount,KOEPFE-1);
                       defekt=1;
                       }
                    else
                        { defekt=0;break; };
                    };
                if (defekt) exit(-1); /* Verifizierungsfehler */
                } /* Ende Verify-Routine */
       }  /* Ende Verifyschleife */
    }
#if TURBO_C      /* Alten Zustand wiederherstellen */
setvect(30,old_param_table);
#endif
#if QUICK_C
_dos_setvect(30,old_param_table);
#endif
printf("\n\nRX50-Format beendet.\n");
}
/***************************************************************************/


Bye, Heribert (dahms@ifk20.mach.uni-karlsruhe.de)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         