#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#include <stdio.h>
#include "asm.h"

main(argc, argv)
char *argv[];
{
	register char *p;
	register c, i;
	struct area *ap;
	struct tsym *tp;
	char *fn;
	FILE *afile();

	fn = NULL;
	for (i=1; i<argc; ++i) {
		p = argv[i];
		if (*p == '-') {
			++p;
			while (c = *p++)
				switch(c) {

				case 'g':
				case 'G':
					++gflag;
					break;

				case 'l':
				case 'L':
					++lflag;
					break;

				case 'o':
				case 'O':
					++oflag;
					break;

				default:
					usage();
				}
		} else
			fn = p;
	}
	if (fn == NULL)
		usage();
	sfp = afile(fn, dsft, 0);
	if (lflag)
		lfp = afile(fn, "lst", 1);
	if (oflag)
		ofp = afile(fn, "rel", 1);
	syminit();
	for (pass=0; pass<3; ++pass) {
		if (gflag && pass == 1)
			symglob();
		if (oflag && pass == 2)
			outgsd();
		flevel = 0;
		tlevel = 0;
		line = 0;
		page = 0;
		lop  = NLPP;
		rewind(sfp);
		ap = areap;
		while (ap != NULL) {
			ap->a_fuzz = 0;
			ap->a_size = 0;
			ap = ap->a_ap;
		}
		fuzz = 0;
		minit();
		dot->s_addr = 0;
		dot->s_area = dda->s_addr;
		/*
		 * Reset f-b table.
		 */
		if (pass != 0) {
			for (i=0; i<10; ++i) {
				tsymp[i].tp_bp = NULL;
				tsymp[i].tp_fp = tsymp[i].tp_lfp;
			}
		}
		while (getline()) {
			++line;
			cp = cb;
			ep = eb;
			ip = ib;
			eflag = 0;
			setexit();
			if (eflag == 0)
				asm();
			if (pass == 2) {
				diag();
				list();
			}
		}
		newdot(dot->s_area); /* Flush area info */
		if (flevel || tlevel)
			err('i');
	}
	if (oflag)
		outchk(HUGE, HUGE);  /* Flush */
}

asm()
{
	register struct sym *sp;
	register struct tsym *tp;
	register c;
	struct tsymp *tsp;
	struct area  *ap;
	struct expr e1;
	char id[NCPS];
	char *p;
	int d, n, uaf, uf;

	laddr = dot->s_addr;
	lmode = SLIST;
loop:
	while ((c = getnb()) == ';')
		;
	if (c == 0 || c == '/')
		return;
	if (ctype[c] == DIGIT) {
		if (get() != ':')
			qerr();
		if (flevel)
			goto loop;
		tsp = &tsymp[c-'0'];
		if (pass == 0) {
			tp = (struct tsym *) new(sizeof(struct tsym));
			tp->t_fp = NULL;
			tp->t_area = dot->s_area;
			tp->t_addr = dot->s_addr;
			if (tsp->tp_lfp == NULL)
				tsp->tp_lfp = tp; else
				tsp->tp_llp->t_fp = tp;
			tsp->tp_llp = tp;
		} else {
			tp = tsp->tp_fp;
			if (pass == 1) {
				fuzz = tp->t_addr - dot->s_addr;
				tp->t_area = dot->s_area;
				tp->t_addr = dot->s_addr;
			} else
				phase(tp->t_area, tp->t_addr);
		}
		tp = tsp->tp_fp;
		tsp->tp_bp = tp;
		tsp->tp_fp = tp->t_fp;
		goto loop;
	}
	if (ctype[c] != LETTER) 
		qerr();
	getid(id, c);
	c = getnb();
	if (c == ':') {
		if (flevel)
			goto loop;
		sp = lookup(id, 1);
		if (sp == dot)
			err('.');
		if (pass == 0)
			if (sp->s_type!=S_NEW && (sp->s_flag&S_ASG)==0)
				sp->s_flag |= S_MDF;
		if (pass != 2) {
			fuzz = sp->s_addr - dot->s_addr;
			sp->s_type = S_USER;
			sp->s_area = dot->s_area;
			sp->s_addr = dot->s_addr;
		} else {
			if ((sp->s_flag&S_MDF) != 0)
				err('m');
			phase(sp->s_area, sp->s_addr);
		}
		lmode = ALIST;
		goto loop;
	}
	if (c == '=') {
		expr(&e1, 0);
		if (flevel)
			goto loop;
		sp = lookup(id, 1);
		if (sp == dot) {
			if (e1.e_flag || e1.e_base.e_ap != dot->s_area)
				err('.');
			if (e1.e_addr < dot->s_addr)
				err('-');
		} else if (sp->s_type!=S_NEW && (sp->s_flag&S_ASG)==0)
			err('m');
		sp->s_type = S_USER;
		sp->s_area = e1.e_base.e_ap;
		sp->s_addr = laddr = e1.e_addr;
		sp->s_flag |= S_ASG;
		lmode = ALIST;
		goto loop;
	}
	unget(c);
	lmode = flevel ? SLIST : CLIST;
	if ((sp = lookup(id, 0)) == NULL) {
		err('o');
		return;
	}
	switch (sp->s_type) {

	case S_BYTE:
	case S_WORD:
		do {
			expr(&e1, 0);
			if (flevel == 0) {
				if (sp->s_type == S_BYTE)
					outrb(&e1, 0);
				else
					outrw(&e1, 0);
			}
		} while ((c = getnb()) == ',');
		unget(c);
		break;

	case S_ASCII:
	case S_ASCIZ:
		if ((d = getnb()) == '\0')
			qerr();
		while ((c = getmap(d)) >= 0)
			if (flevel == 0)
				outab(c);
		if (sp->s_type==S_ASCIZ && flevel==0)
			outab(0);
		break;

	case S_BLK:
		expr(&e1, 0);
		if (flevel)
			break;
		if (e1.e_flag || e1.e_base.e_ap!=NULL)
			err('a');
		else
			dot->s_addr += e1.e_addr*sp->s_addr;
		lmode = SLIST;
		break;

	case S_TITLE:
		p = tb;
		if (c = getnb()) {
			do {
				if (p < &tb[NTIT-1])
					*p++ = c;
			} while (c = get());
		}
		*p = 0;
		unget(c);

	case S_PAGE:
		lop = NLPP;
		lmode = NLIST;
		break;

	case S_GLOBL:
		do {
			getid(id, -1);
			if (flevel == 0) {
				sp = lookup(id, 1);
				sp->s_flag |= S_GBL;
			}
		} while ((c = getnb()) == ',');
		unget(c);
		lmode = SLIST;
		break;

	case S_DAREA:
		getid(id, -1);
		uaf = 0;
		if ((c = getnb()) == ',') {
			++uaf;
			uf = absexpr();
		} else
			unget(c);
		if (flevel)
			break;
		sp = lookup(id, 1);
		if (sp->s_type == S_NEW) {
			if ((sp->s_flag&S_GBL) != 0)
				aerr();
			ap = (struct area *) new(sizeof(struct area));
			sp->s_type = S_AREA;
			sp->s_addr = ap;
			ap->a_ap = areap;
			areap = ap;
			ap->a_sp = sp;
			ap->a_size = 0;
			ap->a_fuzz = 0;
			ap->a_flag = uaf ? uf : (A_D|A_PRV|A_CON);
			newdot(ap);
		} else  if (sp->s_type == S_AREA) {
			ap = sp->s_addr;
			if (uaf && uf != ap->a_flag)
				aerr();
			newdot(ap);
		} else
			aerr();
		lmode = SLIST;
		break;

	case S_IF:
		n = absexpr();
		if (flevel==0 && n==0)
			++tlevel;
		else
			++flevel;
		lmode = ALIST;
		laddr = n;
		break;

	case S_ELSE:
		if (tlevel) {
			--tlevel;
			++flevel;
		} else if (flevel) {
			if (flevel == 1) {
				++tlevel;
				--flevel;
			}
		} else
			err('i');
		lmode = SLIST;
		break;

	case S_ENDIF:
		if (tlevel)
			--tlevel;
		else if (flevel)
			--flevel;
		else
			err('i');
		lmode = SLIST;
		break;

	default:
		machine(sp);
	}
	goto loop;
}

FILE *
afile(fn, ft, wf)
char *fn;
char *ft;
{
	register char *p1, *p2;
	register c;
	FILE *fp;
	char fb[40];

	p1 = fn;
	while (c = *p1) {
		if (c == ';') {
			*p1 = 0;
			break;
		}
		++p1;
	}
	p1 = fn;
	p2 = fb;
	while ((c = *p1++) && c != '.')
		*p2++ = c;
	*p2++ = '.';
	p1 = ft;
	while (*p2++ = *p1++)
		;
	if ((fp = fopen(fb, wf?"w":"r")) == NULL) {
		fprintf(stderr, "%s: cannot %s.\n", fb, wf?"create":"open");
		exit(1);
	}
	return (fp);
}

newdot(nap)
register struct area *nap;
{
	register struct area *oap;

	oap = dot->s_area;
	oap->a_fuzz = fuzz;
	oap->a_size = dot->s_addr;
	fuzz = nap->a_fuzz;
	dot->s_area = nap;
	dot->s_addr = nap->a_size;
	if (oflag && pass==2)
		outchk(HUGE, HUGE);
}

usage()
{
	fprintf(stderr, "Usage: as [-glo] file\n");
	exit(1);
}

phase(ap, a)
struct addr *ap;
addr_t a;
{
	if (ap != dot->s_area || a != dot->s_addr)
		err('p');
}
                                                                                                                                            