#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#
/*
 *		C O O K I E
 *
 * Print a random cookie.  Usage:
 *
 *	cookie [options]
 *
 * Where options are:
 *
 *	-N	Output N cookies.
 *	N	Output the Nth cookie.
 *	-a	Output all cookies in entry order.
 *	-v	Video mode -- Format for a VT52 or VT100
 *	-vt52	Explicitly format for a VT52 or VT100 in VT52 mode
 *	-vt100	Explicitly format for a VT100 in ANSI mode
 *	-c	Continuous -- give lots of random cookies
 *
 * This program can be compiled into two flavors of cookie:
 *
 *	"small"	cookie uses an in-memory text file (about 600 cookies)
 *		that is suitable for high-performance RT11 systems.
 *
 *	"big"	cookie uses a disk file based text file that can
 *		easily store 60000 or more cookies.  Currently, it
 *		contains about 5200 cookies.
 *
 * To configure cookie, define either (but not both)
 *
 *	SMALL	for the small version
 *	BIG	for the big version (default)
 *
 * When changing cookies, note that SMALL cookie.c must be recompiled after
 * running mkcook.  BIG cookie need only be bullt by running mkcook.
 *
 * File formats for big cookie (defined in mkcook.c) are as follows:
 *
 *	Record 1:
 *		int	rsxflag;	-- 0 for RT11, 1 for RSX
 *		long	ncookie;	-- number of cookies
 *		int	nindex;		-- Dimension of index table
 *		int	subindex;	-- Number of subindex entries
 *		int	sindex;		-- Size of index table
 *		char	date[26];	-- When file created.
 *
 *	Record 2:
 *		long	main_index[nindex];
 *					-- Record number of each
 *						subindex entry.
 *
 *	Record 3 .. nindex+2
 *		long	sub_index[nindex];
 *					-- Record number of each
 *						cookie.
 *
 * Thus, to find cookie N, proceed as follows:
 *
 *	Read record 1.
 *	Allocate space for top_index[] and sub_index[]
 *	Read record 2 into top_index.
 *
 *	Read top_index[N / nindex] into sub_index.
 *	Read sub_index[N % nindex] -- it has the cookie.
 *
 * If only one cookie is needed, top_index[] and sub_index[] may
 * overlay the text buffer.  Assuming a text buffer size of 2048 bytes,
 * the index table may be dimensioned (2047 / sizeof (long)) (== 256)
 * and the maximum number of cookies equals 256 * 256 == 65536.
 *
 * In this cookie, top_index[] is read once into it's own storage.
 * Sub_index overlaps the text buffer.
 *
 * Docook uses the following search list to locate the cookie file:
 *	[]cookie.fil
 *	public:cookie.fil
 *	pub:cookie.fil
 *	sys$public:cookie.fil
 *	games:cookie.fil
 *	sys$games:cookie.fil
 *	_dbb1:[game]cookie.fil	-- hack for PHENIX::
 */

#include <stdio.h>

#ifdef	BIG
#ifdef	SMALL
#error	Can't have both BIG and SMALL defined
#endif
#else
#ifndef	SMALL
#define	BIG			/* Neither defined, assume BIG		*/
#endif
#endif

#ifdef vms
extern double	rand();
#else
extern int	rand();
extern long	seed;
#endif

#define	EOS	0
#define	VT52	(64+1)
#define	VT100	(96+1)


int	doall		= 0;
int	video		= 0;
int	continuous	= 0;
int	linecount	= 0;
int	cur_line	= 0;
char	*old_buff	= NULL;
char	sc_buff[121];
char	temp_text[81];

#ifdef	BIG

FILE		*cookfd;
char		*cookfile[] {		/* Cookie search list		*/
	"cookie.fil",
	"public:cookie.fil",
	"pub:cookie.fil",
	"sys$public:cookie.fil",
	"games:cookie.fil",
	"sys$games:cookie.fil",
	"_dbb1:[game]cookie.fil",
	NULL,
};

struct header {
	int	rsxflag;	/* 1 if RSX mode		*/
	long	ncookie;	/* Number of cookies		*/
	int	nindex;		/* Dimension of index[]		*/
	int	subindex;	/* Number of subindex entries	*/
	int	sindex;		/* Sizeof index for alloc	*/
	char	date[28];	/* Date cookie file built	*/
} header;

#define	NCOOKIES	(header.ncookie)

#define	TEXTSIZE	2048
#define	INDEXMAX	(TEXTSIZE / sizeof (long))

union {
	char text[TEXTSIZE];		/* Cookies stored here		*/
	long index[INDEXMAX];		/* Cookie sub index entries	*/
} t;

/*
 * If only one cookie is needed, topindex[] can be overlayed over t.index[]
 */

long	topindex[INDEXMAX];		/* Top index entries		*/

#endif

#ifdef	SMALL

#include "cookie.h"
#define	NCOOKIES	(((sizeof ctext)) / (sizeof (char *)))

union	{				/* For an error message		*/
	char	text[81];
} t;

#endif


main(argc, argv)
int		argc;
char		*argv[];
{

	register int	howmany;		/* How many to do	*/
	register char	*ap;
	long		which;
	long		atol();

	which = 0;
	while (argc > 1) {
		ap = argv[1];
		if (isdigit(*ap) || (*ap == '-' && isdigit(ap[1])))
			which = atol(ap);
		else if (*ap != '-')
			fprintf(stderr, "?Unknown command \"%s\"\n", ap);
		else for (ap++; *ap; ap++) {
			switch (tolower(*ap)) {

			case 'a':
				doall++;
				break;

			case 'c':
				continuous++;
				break;

			case 'v':
				if (tolower(ap[1]) == 't') {
					video = atoi(&ap[2]);
					if (video == 52)
						scsettype(65);
					else if (video == 100)
						scsettype(97);
					else
						fprintf(stderr,
							"?Unknown video \"%s\"\n",
							ap);
					while (*ap)
						ap++;
				}
				video = sctype();
				if (video)
					scset(sc_buff, sizeof sc_buff,
						&old_buff);
				break;

			default:
				fprintf(stderr,
					"?Unknown option '%c'\n", *ap);
			}
		}
		argc--;
		argv++;
	}

	init();					/* Setup random number	*/
#ifdef	BIG
	setup_cookie();
#endif
	if (video)
		scerpg(1, 1);
	if (doall) {
		for (which = 1; which <= NCOOKIES; which++) {
			docookie(which);
		}
	}
	if (continuous)
		which = -1;
	if (which > 0) {
		if (which > NCOOKIES) {
			sprintf(t.text,
				"Misfortune: there are only %ld cookies.",
				NCOOKIES);
			output(which, t.text);
		}
		else
			docookie(which);
	}
	else {
		if ((howmany = -which) == 0)
			howmany = 1;
		while (howmany-- > 0) {
#ifdef vms
			which = (rand() * header.ncookie);
#else
			which = rand(0);
			which *= rand(0);
			which %= NCOOKIES;
#endif
			docookie(which + 1);
			if (continuous)
				howmany = 1;
			if (howmany > 0)
				sleep((linecount * linecount) + 2);
		}
	}
	if (video)
		scput(old_buff);
}


init()
/*
 * Initialize random number generator
 */
{
	union {
		long	lvec;			/* For time of day	*/
		int	ivec[2];
	} tbuf;
	register int	i;
	register int	j;

	time(&tbuf.lvec);			/* Setup random number	*/
#ifdef	vms
	srand(tbuf.ivec[0] ^ tbuf.ivec[1]);	/* generator		*/
	j = rand() * 32768.0;			/* Move a random	*/
	i = rand() * 32768.0;			/* Distance into the	*/
#else
	seed	= tbuf.lvec;
	j	= rand(0);
	i	= rand(0);
#endif
	i	= i ^ (~tbuf.ivec[0] ^ tbuf.ivec[1]);
						/* random number	*/
	i	= (j ^ i) & 15;			/* generator		*/
	do {					/* call rand() 1 .. 16	*/
		rand();				/* times.		*/
	} while (i-- > 0);
}

#ifdef	BIG

setup_cookie()
/*
 * Initialize cookie file, finding it in the search list
 */
{
	register char	**namep;

	if (cookfd == NULL) {
		for (namep = cookfile; *namep != NULL; namep++) {
			if ((cookfd = fopen(*namep, "rnu")) != NULL)
				break;
		}
		if (cookfd == NULL)
			error("Can't open cookie file\n");
	}
	if (fget(&header, sizeof header, cookfd) != sizeof header
			|| ferr(cookfd)) {
		error("?Can't read header record, code = %06o\n", $$ferr);
	}
#define WHO	1
#define OS	"RSX11-M"
#ifndef	rsx
#define	WHO	0
#define OS	"RT-11"
#endif
	if (header.rsxflag != WHO)
		error("Cookie file was not built on %s\n", OS);
	if (fget(&topindex, header.sindex, cookfd) != header.sindex
			|| ferr(cookfd))
		error("Couldn't read top-level index, error code = %06o\n",
			$$ferr);
}
#endif

docookie(which)
long		which;
/*
 * Read and output the Nth cookie.  Note: 1-origin addressing
 */
{
#ifdef	BIG

	long		index;
	int		bytect;
	register int	i;

	which--;
	i = which / header.nindex;

	if (i >= header.subindex)
		error("Bug: Gone too far, index = %d, max = %d\n",
				i, header.subindex);
	index = topindex[i];

	if (fseek(cookfd, index, 0) != 0)
		error("Can't seek to top_index at %ld, error = %06o\n",
				index, $$ferr);
	if ((bytect = fget(&t.index, header.sindex, cookfd))
				!= header.sindex || ferr(cookfd))
		error("Can't read top_index at %ld, error = %06o\n",
				index, $$ferr);
	i = which % header.nindex;
	index = t.index[i];
	if (fseek(cookfd, index, 0) != 0) {
		fprintf(stderr, "?Can't seek to cookie at %ld, code = %06o\n",
				index, $$ferr);
		error("?Requesting cookie %ld, max = %ld\n",
				which, header.ncookie);
		return;
	}
	bytect = fget(&t.text, sizeof t.text, cookfd);
	if (bytect == 0 || feof(cookfd) || ferr(cookfd)) {
		error("?Can't read cookie at %ld, read %d bytes, error = %06o\n",
				index, bytect, $$ferr);
	    return;
	}
	output(which + 1, &t.text);
#endif
#ifdef	SMALL
	output(which + 1, ctext[which]);
#endif
}


/*
 * Beware -- if this is, say, 78, the operating system will count
 * screen formatting characters and mess up.
 */

#define	RMARGIN		72
#define	CCAUTHOR	48
#define MAXAUTHOR	(RMARGIN - CCAUTHOR - 2)

static char	outbuf[RMARGIN + 2];
static char	*outp = outbuf;

output(which, text)
long		which;
register char	*text;
/*
 * Output one cookie
 */
{
	register char	*tp;

	startoutput(which);
	do {
		for (tp = text; *tp != EOS && *tp != '\n';)
			tp++;
		out1(text, tp);
		text = tp + 1;
	} while (*tp != EOS);
	endoutput();
}


out1(from, to)
char		*from;		/* First byte to output			*/
register char	*to;		/* Just past the last line		*/
/*
 * Output a line, handle author stuff
 */
{
	register int	ccpos;
	register char	*tp;

	for (tp = from; tp < to && *tp != '\t';)
		tp++;
	ccpos = out2(from, tp, 0);
	if (*tp == '\t') {
		tp++;
		if ((to - tp) < MAXAUTHOR) {
			/*
			 * The author will fit.  Do we need a newline?
			 */
			if (ccpos >= CCAUTHOR) {
				ccpos = outs();
			}
			while (ccpos < CCAUTHOR) {
				*outp++ = '\t';
				ccpos += (8 - (ccpos & 7));
			}
		}
		else {
			/*
			 * The author won't fit.
			 */
			if (ccpos + (to - tp) >= RMARGIN) {
				ccpos = outs();
			}
		}
		out2(tp, to, ccpos);
	}
	outs();
}


out2(from, to, ccpos)
register char	*from;
register char	*to;
int		ccpos;
/*
 * Stuff characters into the buffer, manage carriage control position
 */
{
	register char	*tp;
	int		newpos;

	while (from < to) {
		newpos = (to - from) + ccpos;
		if (newpos < RMARGIN) {
			/*
			 * It all fits
			 */
			while (from < to)
				*outp++ = *from++;
			return(newpos);
		}
		else {
			/*
			 * Do a partial line
			 */
			tp = from + (RMARGIN - ccpos);
			while (*tp != ' ' && tp > from) tp--;
			while (*tp == ' ' && tp > from) tp--;
			tp++;
			while (from < tp)
				*outp++ = *from++;
			ccpos = outs();
		}
	}
}

outs()
/*
 * Dump the buffer, return zero to reinitialize ccpos
 */
{
	*outp = EOS;
	if (video) {
		scerln(cur_line, 1);
		scout(0, 0, outbuf);
		cur_line++;
	}
	else	puts(outbuf);
	outp = outbuf;
	linecount++;
	return(0);
}


startout(which)
long	which;
/*
 * Initialize output
 */
{

	register char	*timebuf;

	if (video) {
		sprintf(temp_text, "%ld", which);
		timebuf = ctime(0);
		scerln(1, 1);
		if (video == VT52) {
			/*
			 * VT52
			 */
			scout(1, 27, timebuf);
			scerln(2, 1);
			scout(4, 36, temp_text);
		}
		else {
			/*
			 * VT100
			 */
			scout(1, 8, "\233#3");	/* Double high		*/
			scout(0, 0,  timebuf);	/* Top half		*/
			scerln(2, 1);
			scout(2, 8, "\233#4");	/* Double high		*/
			scout(0, 0, timebuf);	/* Bottom half		*/
			scerln(4, 1);
			scout(4, 18, "\233#6");	/* Double wide		*/
			scout(0, 0, temp_text);
		}
		cur_line = 6;			/* Start of cookie text	*/
	}
	linecount = 0;				/* For subsequent sleep	*/
}


endoutput()
/*
 * Clear the rest of the screen
 */
{
	if (video) {
		scerpg(0, 0);
		scout(0, 0, NULL);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                        