#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * bas1.c
 */
#include <stdio.h>
#include "bas.h"

#define	AUTO	0
#define LIST	1
#define LOAD	2
#define NAME	3
#define NEW	4
#define PACK	5
#define RESEQ	6
#define RUN	7
#define SAVE	8
#define PRINT	9
#define LET	10

static	char	*ctab[] = {
	"auto",
	"list",
	"load",
	"name",
	"new",
	"pack",
	"reseq",
	"run",
	"save",
	"print",
	"let",
	NULL
};

static	auton	= 100;
static	autoi	= 10;

char	cb[NCB];
char	fb[NFILE];
struct	text *lp;
struct	text *text;
char	*cp;
FILE	*slfp;

main(argc, argv)
char *argv[];
{
	register struct text *tp;
	register c;
	int h, l;

	if (argc > 1) {
		qflag = 1;
		load(argv[1]);
		run();
		exit(0);
	}

	do {
		eflag = 0;
		lp = NULL;
		setexit();
	} while (eflag);

	while (getline()) {
		if ((c=get()) == 0)
			continue;
		if (isdigit(c)) {
			insert(getln(c));
			continue;
		}
		--cp;
		switch(match(ctab)) {

		case AUTO:
			if (isdigit(c=get())) {
				auton = getln(c);
				if ((c=get()) == ',') {
					autoi = getn(-1);
					c = get();
				}
			}
			if (c != 0)
				what();
			for (;;) {
				chlno(auton);
				tp = text;
				while (tp!=NULL && tp->t_lno<auton)
					tp = tp->t_fp;
				if (tp!=NULL && tp->t_lno==auton)
					err("Auto hit");
				printf("%04d ", auton);
				if (getline()==0 || get()==0)
					break;
				--cp;
				insert(auton);
				auton += autoi;
			}
			break;

		case LIST:
			l = MINLNO-1;
			h = MAXLNO+1;
			if (isdigit(c=get())) {
				l = h = getln(c);
				if ((c=get()) == ',') {
					h = getln(-1);
					c = get();
				}
			}
			if (c!=0 || l>h)
				what();
			tp = text;
			while (tp!=NULL && tp->t_lno<l)
				tp = tp->t_fp;
			while (tp!=NULL && tp->t_lno<=h) {
				if (cflag) {
					cflag = 0;
					break;
				}
				outext(tp, stdout);
				tp = tp->t_fp;
			}
			break;

		case LOAD:
			filename();
			load(fb);
			break;

		case NAME:
			if (fb[0] != 0)
				printf("%s\n", fb);
			break;

		case NEW:
			new();
			break;

		case RUN:
			run();
			break;

		case SAVE:
			filename();
			if ((slfp=fopen(fb, "w")) == NULL)
				err("Cannot create file");
			tp = text;
			while (tp != NULL) {
				outext(tp, slfp);
				tp = tp->t_fp;
			}
			fclose(slfp);
			break;

		case PRINT:
			print();
			break;

		case LET:
			let();
			break;

		default:
			what();
		}
	}
}

insert(n)
{
	register struct text *p1, *p2, *p3;

	p1 = NULL;
	p2 = text;
	while (p2!=NULL && p2->t_lno<n) {
		p1 = p2;
		p2 = p2->t_fp;
	}
	if (p2->t_lno == n) {
		p3 = p2;
		p2 = p2->t_fp;
		free(p3);
		if (p1 == NULL)
			text = p2;
		else
			p1->t_fp = p2;
	}
	if (get() != 0) {
		--cp;
		p3 = alloc(sizeof(*p3) + strlen(cp) + 1);
		if (p3 == -1)
			err("No core");
		if (p1 == NULL)
			text = p3;
		else
			p1->t_fp = p3;
		p3->t_fp = p2;
		p3->t_lno = n;
		concat(p3->t_text, cp, NULL);
	}
}

what()
{
	err("What");
}

new()
{
	register struct text *fp, *tp;

	tp = text;
	while (tp != NULL) {
		fp = tp->t_fp;
		free(tp);
		tp = fp;
	}
	text = NULL;
/*
	clrsym();
*/
}

load(f)
char *f;
{
	register c, n;

	new();
	if ((slfp=fopen(f, "r")) == NULL)
		err("Not found");
	while (fgets(cb, slfp) != NULL) {
		cp = cb;
		if (!isdigit(c=get()))
			err("Not numbered");
		insert(getln(c));
	}
	fclose(slfp);
}

filename()
{
	register char *p;
	register c;

	if ((c=get()) == 0) {
		if (fb[0] == 0)
			err("No file");
		return;
	}
	p = fb;
	do {
		if (p < &fb[NFILE-1])
			*p++ = c;
	} while (c = *cp++);
	*p = 0;
}

outext(tp, fp)
register struct text *tp;
FILE *fp;
{
	fprintf(fp, "%04d %s\n", tp->t_lno, tp->t_text);
}

getline()
{
	register char *p;
	register c;

	p = cb;
	while ((c=getchar())!=EOF && c!='\n')
		if (p < &cb[NCB-1])
			*p++ = c;
	if (c == EOF)
		return (0);
	*p = 0;
	cp = cb;
	return (1);
}
            