/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#
/*
 *			U N I Q . C
 *
 * Read a file, outputting unique (or non-unique) lines.
 *
 * Usage:
 *	uniq ?		for help
 *	uniq [-Mode] [-Nfields] [+Nletters] [infile [outfile]]
 *
 * See documentation[] for more information.
 *
 * Updated for the new Decus compiler, 28-Apr-80
 *
 */

char	*documentation[] {
"Uniq reads an input file, writing each unique line.",
"Usage:	uniq [-Mode] [-N_fields] [+N_letters] [infile [outfile]]",
"",
"Where:",
"",
" -u	Only print unique lines.",
" -d	Only print duplicate lines.",
" -c	Print the number of times each line occurred along with the line.",
" -N	Skip over the first N words before checking for uniqueness",
" +N	Skip over the first N letters (in the indicated field)",
"",
"A word is defined as \"optional spaces or tabs\" followed by text up to",
"the first space, tab, or end of line.",
"",
"If no file names are given, input and output are stdin and stdout",
"",
#ifdef vms
"To use on vms (native mode), define \"uniq :== $disk:[account]uniq\",",
"",
#endif
0 };

#include <stdio.h>

#define	BUFSIZE		1024		/* Buffer size (max. line)	*/
int	skip_fields = 0;		/* Number of fields to skip	*/
int	skip_letters = 0;		/* Number of letters to skip	*/
int	linecount;			/* How many repetitions		*/
int	mode = 0;			/* Mode byte, if any		*/
int	line1[BUFSIZE];			/* Input buffer 1		*/
int	line2[BUFSIZE];			/* Input buffer 2		*/

FILE	*infd;				/* Input file			*/
FILE	*outfd;				/* Output file			*/

		
main(argc, argv)
int	argc;		/* Number of arguments				*/
char	*argv[];	/* Argument buffer pointer			*/
{
	register char	*argp;		/* Argument pointer		*/
	register char	c;		/* Temp character		*/
	register char	*lp;		/* Line buffer pointer		*/
	char		*getline();
	char		*check();

	infd = stdin;			/* Assume no in/out files	*/
	outfd = stdout;

	if (argc <= 1 || argv[1][0] == '?') {
		help();
		exit();
	}
	while (argc > 1 && (c = *(argp = argv[1])) == '-' || c == '+') {
		++argp;
		switch (c) {

		case '+':	skip_letters = atoi(argp);
				break;

		case '-':	if ((c = *argp) >= '0' && c <= '9')
					skip_fields = atoi(argp);
				else
					mode = (c >= 'A' && c <= 'Z') ?
						c + ('a' - 'A') : c;
				break;
		}
		argc--;
		argv++;
	}
	if (argc > 1) {
		if ((infd = fopen(argv[1], "r")) == NULL) {
			printf("?Can't open input file \"%s\"\n", argv[1]);
			exit(1);
		}
		argc--;
		argv++;
	}
	if (argc > 1) {
		if ((outfd = fopen(argv[1], "w")) == NULL) {
			printf("?Can't open output file \"%s\"\n", argv[1]);
			exit(1);
		}
	}

/*
 * Here we go
 */
	if ((lp = getline(line2)) == 0) {	/* Prime the pump	*/
		fclose(infd);
		fclose(outfd);
		exit();
	}

	for (;;) {
		lp = check(line1, line2, lp);
		lp = check(line2, line1, lp);
	}
}


char *check(new, old, oldpos)
char	*new;		/* New line read here				*/
char	*old;		/* Old line resides here			*/
char	*oldpos;	/* Start of field in old line			*/
/*
 * Read lines as long as new == old.  Return a pointer to the field to
 * test in new.  Exit the program on end of file.
 */
{
	register char	*lp;		/* Random line pointer		*/
	char		*getline();

	linecount = 0;
	for (;;) {
		linecount++;
		if ((lp = getline(new)) == 0) {
			output(old);
			fclose(infd);
			fclose(outfd);
			exit();
		}
		if (!equals(oldpos, lp))
			break;
	}
	output(old);
	return(lp);
}

equals(old, new)
char	*old;		/* Compare this field				*/
char	*new;		/* Against this field				*/
/*
 * Return zero if they don't match.  If they do, return 1.
 */
{
	register char	*op;
	register char	*np;
	register char	c;

	op = old;
	np = new;
	while ((c = *op++) == *np++) {
		if (c == 0) {
			return(1);
		}
	}
	return(0);
}

output(line)
char	*line;		/* What to output				*/
/*
 * Output this line.
 */
{
	switch (mode) {
	case 'u':	if (linecount > 1)
				return;
			break;

	case 'd':	if (linecount > 1)
				break;
			return;

	case 'c':	fprintf(outfd, "%4d ", linecount);
			break;
	}
	fprintf(outfd, "%s", line);
}

char *getline(line)
char	*line;		/* Buffer to read into				*/
/*
 * Read a line. return 0 on end of file.  If not end of file, return
 * a pointer to the first byte of the field to check.
 */
{
	register int	count;
	register char	c;
	register char	*lp;

	if (fgets(line, BUFSIZE, infd) == NULL)
		return(0);
	lp = line;
	for (count = 0; count++ < skip_fields;) {
		while ((c = *lp) == ' ' || c == '\t') lp++;
		while ((c = *lp) != ' ' && c != '\t') {
			if (c == 0)
				return(lp);
			else	lp++;
		}
	}
	for (count = 0; count++ < skip_letters; lp++) {
		if (*lp == 0) break;
	}
	return(lp);
}

help()
/*
 * Give good help
 */
{
	register char	**dp;

	for (dp = documentation; *dp; dp++)
		printf("%s\n", *dp);
}
                                                                                                                                                        