#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * cd [file ...]
 *
 * Fwild test program
 *
 */
#include <stdio.h>
#ifdef rt11
/*
 * RT11 wild card buffer
 */
struct rt_wild {
	int	w_dev;		/* Dev name in rad50			*/
	char	w_name[12];	/* Match file name			*/
	int	w_savst[5];	/* Savestatus area			*/
	int	w_dseg;		/* Current directory segment		*/
	int	w_dent;		/* Next entry to search			*/
	int	w_esiz;		/* Size of directory entry in bytes.	*/
};
#endif

char	name[81];
char	file_name[81];

main(argc, argv)
char *argv[];
{
	register int	i, tf;
	int		gotcha;

	tf = 0;
	if (argc < 2) {
		for (;;) {
			printf("* ");
			if (gets(name) == NULL)
				exit();
			process(name);
		}
	} else
		for (i = 1; i < argc; ++i) {
			process(argv[i]);
		}
}

process(text)
char	*text;
{
	register int	gotcha;
	register FILE	*fd;

	printf("fwild(\"%s\")\n", text);
	if ((fd = fwild(text, "r")) == NULL) {
		printf("\"%s\": illegal file name\n", text);
		return;
	}
	for (gotcha = 0; fnext(fd) != NULL; gotcha++) {
		iovtoa(fd, file_name);
		printf("** fwild found \"%s\"\n", file_name);
	}
	if (gotcha == 0)
		printf("\"%s\": cannot open (%d)\n", text, $$ferr);
}

dumpwild(who, fd)
char	*who;
FILE	*fd;
/*
 * Dump wild buffer (for native RT11 only)
 */
{
#ifdef rt11
	register struct rt_wild	*wp;
	extern int		$$rsts;
	register int		i;
	register char		*cp;
	char			buf[11];

	if ($$rsts == 0) {
		printf("\n%s\n", who);
		wp = fd->io_wild;
		if (wp == NULL) {
			printf("(No wild buffer)\n");
			return;
		}
		r50toa(buf, &(wp->w_dev), 1);
		printf("device  [%06o], \"%.3s\"\n", wp->w_dev, buf);
		printf("pattern \"%s\"\n", &wp->w_name);
		printf("dir seg = %06o, %d\n", wp->w_dseg, wp->w_dseg);
		printf("dir ent = %06o, %d\n", wp->w_dent, wp->w_dent);
		printf("dir esz = %06o, %d\n", wp->w_esiz, wp->w_esiz);
	}
#endif
}
                                    