#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#include <stdio.h>
#include <rsts.h>

static char *fqname[] {
	"IOSTS ",
	"FQJOB ",
	"FQERNO",
	"FQPPN ",
	"FQNAM1",
	"      ",
	"FQEXT ",
	"FQSIZ ",
	"FQBUFL",
	"FQMODE",
	"FQFLAG",
	"FQPFLG",
	"FQDEV ",
	"FQDEVN",
	"FQCLUS",
	"FQNENT"
};	

dumpfqb()
/*
 * Dump the firqb, restore it after dumping.
 */
{
	register int		*xp;
	register int		temp;
	register int		offset;
	struct rsts_xrb		myxrb;
	struct rsts_firqb	myfqb;
	char			r50buf[4];

	getxrb(&myxrb);
	getfqb(&myfqb);
	offset = 0;
	for (xp = &(myfqb.firqb_errorcode); xp <= &(myfqb.fqnent);) {
		r50toa(r50buf, xp, 1);
		r50buf[3] = 0;
		temp = *xp++;
		printf("firqb+%02o = %06o %03o %03o\t%3s\t%s\n",
			offset * 2, temp, (temp >> 8) & 0377, temp & 0377,
			r50buf, fqname[offset]);
		offset++;
	}
	putfqb(&myfqb);
	putxrb(&myxrb);
}
                           