{$W-}
(************************************************
 *                                              *
 *   PASRUF ROUTINE SOURCE CODE                 *
 *                                              *
 *   PROGRAMMED BY:                             *
 *      MICHELLE FERAUD   V1A 04/06/79          *
 *	TRW DSSG				*
 *	R2 / 1170				*
 *	ONE SPACE PARK				*
 *	REDONDO BEACH, CA  90278		*
 *                                              *
 ************************************************)
 
PROGRAM PASRUF (SOURCE, DESTINATION);
 
 
(*#############################################################
          PASRUF(SOURCE, DESTINATION: TEXT)                  
##############################################################*)
 
(*GENERAL DATA TYPES*)
 
CONST LINELENGTH = 132;
TYPE LINE = ARRAY[1..LINELENGTH] OF CHAR;
 
CONST FF = CHR(12); (*PAGE EJECT CHAR*)
      NL = CHR(10); (*END OF LINE CHAR*)
      ZR = CHR(0);  (*END OF STRING CHAR*)
 
(*COMMAND STRING DATA TYPES*)
 
TYPE TYPEOFLINE = (COMMAND,TEXTUAL);
 
CONST COMMANDSIZE = 3; (*MAX VALID CHARS IN COMMAND STRING*)
TYPE  COMMANDSTRING = ARRAY[1..COMMANDSIZE] OF CHAR;
 
TYPEOFCOMMAND = (INVALID,BREAKC,SKIPC,BLANKC,INDENTC,PARAGRAPHC,
                 LISTC,LISTENTRYC,ENDLISTC,
                 PAGEC,TESTPAGEC,CENTERC,HEADLEVELC,JUSTIFYC,NOJUSTIFYC,
                 FILLC,NOFILLC,PERIODC,NOPERIODC,LEFTMARGINC,
                 RIGHTMARGINC,SPACINGC,PAGESIZEC,TITLEC,NUMBERC,
                 NONUMBERC,HEADERC,NOHEADERC,PARA1C,PARA2C,PARA3C,
                 PAGESIZE1C,PAGESIZE2C);
 
(*COMMAND LINE NUMERICAL ARGUMENTS*)
 
CONST NUMOFARGS = 3; (*MAX NUMBER OF NUMERICAL ARGUMENTS*)
TYPE  ARGARRAY = ARRAY[1..NUMOFARGS] OF INTEGER;
 
(*DEFAULT PARAMETERS*)
 
CONST DLEFTMARGIN  = 0;
      DRIGHTMARGIN = 60;
      DLINESPACING = 1;
      DPARAINDENT  = 5;
      DPARATESTPAGE= 0;
      DPAGESIZE    = 60;
 
(*RECORD FOR CONTAINING LIST LEVEL PARAMETERS*)
 
TYPE LISTRECORD = RECORD
                    NUMBER,
                    SPACING,
                    OFFSET: INTEGER
                  END;
 
VAR
 
(*FILE DECLARATIONS*)
SOURCE, DESTINATION: TEXT;
ENDOFFILE,
INITOK: BOOLEAN;
 
(*I/O BUFFER DECLARATIONS*)
INPUTLINE : LINE;
ILP       : INTEGER;   (*INPUT LINE POINTER*)
OUTPUTLINE: LINE;
OLP       : INTEGER;   (*OUTPUT LINE POINTER*)
 
(*TABLE OF COMMANDS*)
COMMANDTABLE: ARRAY[BREAKC..NOHEADERC] OF COMMANDSTRING;
 
(*FORMATTING PARAMETERS*)
LINE_COUNT,          (*CURRENT NUMBER OF LINES ON PAGE*)
PAGE_COUNT,          (*CURRENT NUMBER OF PAGES*)
LINE_SPACING,        (*SPACING BETWEEN LINES*)
PARA_SPACING,        (*SPACING BETWEEN PARAGRAPHS*)
PARA_INDENT,         (*PARAGRAPH INDENT SPACES*)
PARA_TESTPAGE,       (*ARGUMENT FOR TESTPAGE CALL BEFORE NEW PARAGRAPH*)
PAGE_SIZE,           (*NUMBER OF LINES PER PAGE*)
PAGE_CENTER,         (* CENTER POSITION ON CURRENT PAGE*)
LEFT_MARGIN,
RIGHT_MARGIN: INTEGER;
 
(*FORMATTING FLAGS*)
CENTERFLAG,
HEADERFLAG,
NUMBERFLAG,
PERIODFLAG,
FILLFLAG,
JUSTIFYFLAG: BOOLEAN;
 
(*PARAMETER INITIALIZATION PHASE*)
INITINGPARAMS: BOOLEAN;     (*STILL IN PARAMETER INIT PHASE?*)
 
(*THIS SET IS REPLACED BY A RANGE CHECK ON TYPEOFCOMMAND IN PROCEDURE RUNOFF*)
(* INITPARAMCOMMANDS: SET OF TYPEOFCOMMAND; *)
 
(*HEADER LEVEL DECLARATIONS*)
OLDHEADLEVEL: INTEGER;          (*LATEST LEVEL OF HEADER PROCESSED*)
LEVEL: ARRAY [1..5] OF INTEGER; (*CURRENT LEVEL NUMBERS FOR EACH LEVEL*)
 
(*LIST DECLARATIONS*)
LISTLEVEL: INTEGER;                   (*CURRENT LEVEL OF LIST (1..5)*)
LISTPARAM: ARRAY[1..5] OF LISTRECORD; (*PARAMETERS FOR EACH LEVEL OF LIST*)
 
(*FILL AND JUSTIFY DECLARATIONS*)
WORDBUFFER    : LINE;    (*CONTAINER FOR INPUT WORD*)
WORDBUFFERFULL,          (*IS WORD BUFFER FULL?*)
STARTOFLINE,             (*PHYSICAL START OF INPUT LINE?*)
ENDOFLINE,               (*PHYSICAL END OF INPUT LINE?*)
ENDOFSENTENCE : BOOLEAN; (*END OF SENTENCE? (. ? ! CHARS)*)
WORDLENGTH,              (*LENGTH OF WORD IN WORDBUFFER*)
WORDCOUNT,               (*NUMBER OF WORDS IN CURRENT OUTPUT LINE*)
SPACES,                  (*NUMBER OF SPACES IN OUTPUT LINE AFTER A WORD*)
DIRECTION     : INTEGER; (*SIDE TO ADD EXTRA BLANKS TO DURING JUSTIFY*)
 
CURRENT_TITLE: LINE;     (*CURRENT TITLE USED IN PAGE HEADER*)
 
(*THESE SETS ARE REPLACED BY FUNCTIONS THAT CHECK FOR THE APPROPRIATE CHARS*)
(*SENTENCE_ENDERS,
  DIGITS: SET OF CHAR*)
 
NULL_ARGUMENT: INTEGER; (*WHAT NON-EXISTANT NUMERICAL ARGUMENTS ARE SET TO*)
 
(*#############################
I/O BUFFER ROUTINES
#############################*)
 
FUNCTION GETCHAR: CHAR;
(*GET ONE CHAR FROM INPUT FILE*)
VAR C: CHAR;
BEGIN
  READ(SOURCE, C);
  GETCHAR := C
END; (*GETCHAR*)
 
PROCEDURE GETLINE;
(*GET ONE LINE FROM SOURCE FILE OR SIGNAL END OF FILE*)
VAR C: CHAR;
BEGIN
  IF EOF(SOURCE)
  THEN
    ENDOFFILE := TRUE
  ELSE
  BEGIN
    ILP := 0;
    REPEAT
      ILP := SUCC(ILP);
      C := GETCHAR;
      INPUTLINE[ILP] := C;
    UNTIL (C = NL) OR EOF(SOURCE) OR (ILP = LINELENGTH);
    ILP := 0;
  END;
END; (*GETLINE*)
 
PROCEDURE PUTCHAR(C: CHAR);
(*PUT ONE CHAR INTO OUTPUT FILE*)
BEGIN
  DESTINATION@ := C;
  PUT(DESTINATION);
END; (*PUTCHAR*)
 
PROCEDURE PUTLINE;
(*PUT CURRENT OUTPUTLINE TO OUTPUT FILE. LINE IS
 EXPECTED TO HAVE APPROPRIATE END-OF-LINE CHARACTER
 WHEN RECEIVED BY PUTLINE. ALSO KEEPS TRACK
 OF LINE COUNT (FOR PAGE SIZE CONTROL) AND
 STARTOFLINE FLAG (FOR FILL ROUTINES).*)
VAR I: INTEGER;
BEGIN
  IF OLP > LEFT_MARGIN
  THEN
  BEGIN
    FOR I := 1 TO OLP DO
      PUTCHAR(OUTPUTLINE[I]);
    OLP := LEFT_MARGIN;
    FOR I := 1 TO OLP DO
      OUTPUTLINE[I] := ' ';
    STARTOFLINE := TRUE;
    LINE_COUNT := SUCC(LINE_COUNT);
  END;
END; (*PUTLINE*)
 
(*#############################
COMMAND PARSE ROUTINES
#############################*)
 
FUNCTION IN_DIGITS(CH: CHAR): BOOLEAN;
(*PERFORMS SET OPERATION CH IN ['+','-','0'..'9']*)
BEGIN
  IF (CH = '+') OR (CH = '-') OR
     ((CH >= '0') AND (CH <= '9'))
  THEN
    IN_DIGITS := TRUE
  ELSE
    IN_DIGITS := FALSE;
END; (*IN_DIGITS*)
 
PROCEDURE SCANCOMMAND(VAR COMMANDTYPE: TYPEOFCOMMAND);
(*REMOVE COMMAND STRING FROM INPUT LINE AND SEARCH
 COMMAND TABLE FOR MATCHING COMMAND TYPE*)
VAR COMMANDLINE : COMMANDSTRING;
    COMMANDINDEX: TYPEOFCOMMAND;
    CLP         : INTEGER;
    FOUND       : BOOLEAN;
    C           : CHAR;
BEGIN
  FOR CLP := 1 TO COMMANDSIZE DO
    COMMANDLINE[CLP] := ' ';
  ILP := 2;  (*SKIP OVER "."*)
  CLP := 1;
  WHILE (INPUTLINE[ILP]<>' ') AND (INPUTLINE[ILP]<>NL) AND
        (CLP<= COMMANDSIZE) DO
  (*GET COMMAND STRING*)
  BEGIN
    C := INPUTLINE[ILP];
    IF (C >= 'a') AND (C <= 'z')
    THEN (*CHANGE LOWER CASE LETTER TO UPPER CASE*)
      C := CHR(ORD(C) - 32);
    COMMANDLINE[CLP] := C;
    ILP := SUCC(ILP);
    CLP := SUCC(CLP);
  END;
  COMMANDINDEX := BREAKC;
  FOUND := FALSE;
  WHILE (NOT FOUND) AND (COMMANDINDEX<=NOHEADERC) DO
  (*TABLE SEARCH*)
    IF COMMANDTABLE[COMMANDINDEX] = COMMANDLINE
    THEN
      FOUND := TRUE
    ELSE
      COMMANDINDEX := SUCC(COMMANDINDEX);
  IF FOUND
  THEN COMMANDTYPE := COMMANDINDEX
  ELSE COMMANDTYPE := INVALID;
END; (*SCANCOMMAND*)
 
FUNCTION SCANNUMBER: INTEGER;
(*CONVERT NUMERICAL ARGUMENT FROM CHARACTER STRING
 TO INTEGER*)
VAR NEGFLAG: BOOLEAN;
    NUM    : INTEGER;
BEGIN
  IF INPUTLINE[ILP] = '-'
  THEN
  BEGIN
    NEGFLAG := TRUE;
    ILP := SUCC(ILP);
  END
  ELSE
  BEGIN
    NEGFLAG := FALSE;
    IF INPUTLINE[ILP] = '+'
    THEN (*IGNORE + SIGN*)
      ILP := SUCC(ILP);
  END;
  NUM := 0;
  REPEAT (*NUMBER CONVERSION*)
    NUM := 10*NUM + (ORD(INPUTLINE[ILP]) - ORD('0'));
    ILP := SUCC(ILP);
  UNTIL NOT (IN_DIGITS(INPUTLINE[ILP]));
  (*UNTIL NOT(INPUTLINE[ILP] IN DIGITS);*)
  IF NEGFLAG
  THEN SCANNUMBER := -NUM
  ELSE SCANNUMBER :=  NUM;
END; (*SCANNUMBER*)
 
PROCEDURE SCANSTRING(VAR ARGLINE: LINE);
(*REMOVE STRING ARGUMENT FROM INPUT LINE*)
VAR ALP: INTEGER;
BEGIN
  ALP := 1;
  WHILE INPUTLINE[ILP]<>NL DO
  BEGIN
    ARGLINE[ALP] := INPUTLINE[ILP];
    ILP := SUCC(ILP);
    ALP := SUCC(ALP);
  END;
  ARGLINE[ALP] := ZR;
END; (*SCANSTRING*)
 
PROCEDURE SCANARGUMENTS(VAR ARG: ARGARRAY;
                         VAR ARGLINE: LINE);
(*REMOVE ARGUMENTS (IF ANY) FROM COMMAND INPUT LINE*)
VAR ARGNUMBER,
    I        : INTEGER;
    FINISHED : BOOLEAN;
BEGIN
  (*INITIALIZE ALL ARGUMENTS TO NULL SETTINGS*)
  FOR I := 1 TO NUMOFARGS DO
    ARG[I] := NULL_ARGUMENT;
  ARGLINE[1] := ZR;
  FINISHED := FALSE;
  ARGNUMBER := 1;
  WHILE NOT FINISHED DO
    IF INPUTLINE[ILP] = NL
    THEN
      FINISHED := TRUE
    ELSE
    BEGIN
      WHILE (INPUTLINE[ILP]=' ') OR (INPUTLINE[ILP]=',') DO
        ILP := SUCC(ILP);
      IF IN_DIGITS(INPUTLINE[ILP])
      (*IF INPUTLINE[ILP] IN DIGITS*)
      THEN (*NUMERICAL ARGUMENT*)
      BEGIN
        ARG[ARGNUMBER] := SCANNUMBER;
        ARGNUMBER := SUCC(ARGNUMBER);
      END
      ELSE (*STRING ARGUMENT*)
        SCANSTRING(ARGLINE);
    END;
END; (*SCANARGUMENTS*)
 
(*#############################
CHECK AND/OR SET PARAMETER
ROUTINES
#############################*)
 
PROCEDURE CHECKANDSET(COMMANDTYPE: TYPEOFCOMMAND;
                      VAR VALUE: INTEGER);
(*CHECK BOUNDS AND/OR SET PARAMETERS ACCORDING TO COMMAND
 ARGUMENT*)
VAR I: INTEGER;
BEGIN
  CASE COMMANDTYPE OF
 
    SKIPC, BLANKC: (*CHECK SKIP & BLANK ARGUMENT*)
      IF VALUE < 0
      THEN
        VALUE := 0;
 
    INDENTC: (*CHECK INDENT ARGUMENT*)
      IF LEFT_MARGIN+VALUE < 0
      THEN
        VALUE := LEFT_MARGIN
      ELSE
        IF LEFT_MARGIN+VALUE > RIGHT_MARGIN-1
        THEN
          VALUE := 0;
 
    PARA1C: (*IF NOT NULL RESET PARAGRAPH INDENT*)
      IF VALUE <> NULL_ARGUMENT
      THEN
        IF (LEFT_MARGIN+VALUE < 0) OR
           (LEFT_MARGIN+VALUE > RIGHT_MARGIN-1)
        THEN
          PARA_INDENT := DPARAINDENT
        ELSE
          PARA_INDENT := VALUE;
 
    PARA2C: (*IF NOT NULL RESET PARAGRAPH VERTICAL SPACING*)
      IF VALUE <> NULL_ARGUMENT
      THEN
        IF VALUE < 0
        THEN
          PARA_SPACING := (LINE_SPACING + 1) DIV 2
        ELSE
          PARA_SPACING := VALUE;
 
    PARA3C: (*IF NOT NULL RESET PARAGRAPH TEST_PAGE ARGUMENT*)
      IF VALUE <> NULL_ARGUMENT
      THEN
        IF VALUE < 0
        THEN
          PARA_TESTPAGE := DPARATESTPAGE
        ELSE
          PARA_TESTPAGE := VALUE;
 
    TESTPAGEC: (*CHECK TESTPAGE ARGUMENT*)
      IF NOT ((VALUE <> NULL_ARGUMENT) AND (VALUE >= 0))
      THEN
        VALUE := 0;
 
    CENTERC: (*SET PAGE CENTER*)
      IF (VALUE <> NULL_ARGUMENT) AND (VALUE >= 0)
      THEN
        PAGE_CENTER := VALUE DIV 2
      ELSE
        PAGE_CENTER := RIGHT_MARGIN DIV 2;
 
    HEADLEVELC: (*CHECK HEAD LEVEL ARGUMENT*)
      IF VALUE < 1
      THEN
        VALUE := 1
      ELSE
        IF VALUE > 5
        THEN
          VALUE := 5;
 
    LISTC: (*CHECK LIST ARGUMENTS*)
      IF VALUE < 0
      THEN
        VALUE := DLINESPACING;
 
    LEFTMARGINC: (*RESET LEFT MARGIN AND BLANK OUTPUTLINE UP TO LEFT MARGIN*)
    BEGIN
      IF (VALUE < 0) OR (VALUE >= RIGHT_MARGIN)
      THEN
        LEFT_MARGIN := DLEFTMARGIN
      ELSE
        LEFT_MARGIN := VALUE;
      FOR I := 1 TO LEFT_MARGIN DO
        OUTPUTLINE[I] := ' ';
      OLP := LEFT_MARGIN;
    END;
 
    RIGHTMARGINC: (*RESET RIGHT MARGIN*)
      IF (VALUE > LINELENGTH-1) OR (VALUE < LEFT_MARGIN)
      THEN
        RIGHT_MARGIN := DRIGHTMARGIN
      ELSE
        RIGHT_MARGIN := VALUE;
 
    SPACINGC: (*RESET LINE SPACING AND PARAGRAPH SPACING*)
    BEGIN
      IF (VALUE < 1) OR (VALUE > 5)
      THEN
        LINE_SPACING := DLINESPACING
      ELSE
        LINE_SPACING := VALUE;
      PARA_SPACING := (LINE_SPACING + 1) DIV 2;
    END;
 
    PAGESIZE1C: (*RESET PAGE SIZE*)
      IF VALUE < 11
      THEN
        PAGE_SIZE := DPAGESIZE
      ELSE
        PAGE_SIZE := VALUE;
 
    PAGESIZE2C: (*IF NOT NULL RESET RIGHT MARGIN*)
      IF VALUE <> NULL_ARGUMENT
      THEN
        IF (VALUE > LINELENGTH-1) OR (VALUE < LEFT_MARGIN)
        THEN
          RIGHT_MARGIN := DRIGHTMARGIN
        ELSE
          RIGHT_MARGIN := VALUE;
 
    NUMBERC: (*IF NOT NULL RESET PAGE COUNT*)
      IF VALUE <> NULL_ARGUMENT
      THEN
        IF VALUE > 0
        THEN
          PAGE_COUNT := VALUE - 1
        ELSE
          PAGE_COUNT := 0
 
  END; (*CASE*)
END; (*CHECKANDSET*)
 
PROCEDURE SETTITLE(SETTITLEARG: LINE);
(*REPLACE CURRENT TITLE WITH COMMAND STRING ARGUMENT*)
VAR CTP, STP: INTEGER;
BEGIN
  FOR CTP := 1 TO RIGHT_MARGIN DO
    CURRENT_TITLE[CTP] := ' ';
  CTP := LEFT_MARGIN + 1;
  STP := 1;
  WHILE (SETTITLEARG[STP]<>ZR) AND (CTP<=RIGHT_MARGIN) DO
  BEGIN
    CURRENT_TITLE[CTP] := SETTITLEARG[STP];
    CTP := SUCC(CTP);
    STP := SUCC(STP);
  END;
END; (*SETTITLE*)
 
PROCEDURE SETFLAG(COMMANDTYPE: TYPEOFCOMMAND;
                  FLAGVALUE  : BOOLEAN);
(*SET GLOBAL FLAGS*)
BEGIN
  CASE COMMANDTYPE OF
    CENTERC : CENTERFLAG := FLAGVALUE;
    HEADERC : HEADERFLAG := FLAGVALUE;
    NUMBERC : NUMBERFLAG := FLAGVALUE;
    PERIODC : PERIODFLAG := FLAGVALUE;
    FILLC   : FILLFLAG := FLAGVALUE;
    JUSTIFYC: JUSTIFYFLAG := FLAGVALUE
  END; (*CASE*)
END; (*SETFLAG*)
 
(*#############################
COMMAND PRIMATIVES
#############################*)
 
FUNCTION ATTOPOFPAGE: BOOLEAN;
(*IS CURRENT OUTPUTLINE THE FIRST LINE OF TEXT AFTER THE PAGE HEADER?*)
BEGIN
  ATTOPOFPAGE := (LINE_COUNT = 5);
END; (*ATTOPOFPAGE*)
 
FUNCTION TEST_PAGE(TESTPAGEARG: INTEGER): BOOLEAN;
(*ARE THERE TESTPAGEARG LINES LEFT ON THE CURRENT PAGE?*)
BEGIN
  TEST_PAGE := ((PAGE_SIZE-LINE_COUNT) >= TESTPAGEARG);
END; (*TEST_PAGE*)
 
PROCEDURE SKIPLINES(SKIPLINEARG: INTEGER);
(*INSERT SKIPLINEARG BLANK LINES INTO OUTPUT FILE*)
VAR I: INTEGER;
BEGIN
  IF SKIPLINEARG > 0
  THEN
    FOR I := 1 TO SKIPLINEARG DO
    BEGIN
      PUTCHAR(' ');
      PUTCHAR(NL);
      LINE_COUNT := SUCC(LINE_COUNT);
    END;
END; (*SKIPLINES*)
 
PROCEDURE PUTPAGEHEADER;
(*PUT CURRENT TITLE AND PAGE NUMBER INTO OUTPUT LINE AND PRINT*)
VAR PAGE_NUMBER: INTEGER;
BEGIN
  OUTPUTLINE := CURRENT_TITLE;
  IF NUMBERFLAG
  THEN (*TRANSLATE & OUTPUT PAGE NUMBER*)
  BEGIN
    OLP := RIGHT_MARGIN;
    PAGE_NUMBER := PAGE_COUNT;
    REPEAT
      OUTPUTLINE[OLP] := CHR((PAGE_NUMBER MOD 10) + 48);
      OLP := PRED(OLP);
      PAGE_NUMBER := PAGE_NUMBER DIV 10;
    UNTIL PAGE_NUMBER = 0;
  END;
  OUTPUTLINE[OLP] := ' '; OLP := PRED(OLP);
  OUTPUTLINE[OLP] := 'E'; OLP := PRED(OLP);
  OUTPUTLINE[OLP] := 'G'; OLP := PRED(OLP);
  OUTPUTLINE[OLP] := 'A'; OLP := PRED(OLP);
  OUTPUTLINE[OLP] := 'P';
  OLP := RIGHT_MARGIN + 1;
  OUTPUTLINE[OLP] := NL;
  PUTLINE;
END; (*PUTPAGEHEADER*)
 
PROCEDURE NEWPAGE;
(*GO TO TOP OF NEW PAGE AND PRINT PAGE HEADER*)
BEGIN
  PUTCHAR(FF);
  PAGE_COUNT := SUCC(PAGE_COUNT);
  LINE_COUNT := 0;
  IF HEADERFLAG
  THEN (*PRINTED PAGE HEADER*)
  BEGIN
    SKIPLINES(1);
    PUTPAGEHEADER;
    SKIPLINES(3);
  END
  ELSE (*BLANK PAGE HEADER*)
    SKIPLINES(5);
END; (*NEWPAGE*)
 
PROCEDURE MOVE_OLP(MOVE_OLPARG: INTEGER);
(*MOVE OUTPUT LINE POINTER FORWARD OR BACKWARD. A FORWARD
 MOVE BLANKS THE LINE UP TO THE NEW POSITION OF OLP*)
VAR I: INTEGER;
BEGIN
  IF MOVE_OLPARG > 0
  THEN
  BEGIN
    OLP := SUCC(OLP);
    FOR I := OLP TO OLP+MOVE_OLPARG-1 DO
      OUTPUTLINE[I] := ' ';
    OLP := OLP + MOVE_OLPARG - 1;
  END
  ELSE
    IF MOVE_OLPARG < 0
    THEN
      OLP := OLP + MOVE_OLPARG;
END; (*MOVE_OLP*)
 
PROCEDURE PUTHEADLEVEL(NEWHEADLEVEL: INTEGER;
                       HEADSTRING: LINE);
(*PUT HEADER LEVEL NUMBER AND HEADER LEVEL TITLE INTO OUTPUT LINE*)
VAR I,
    LEVELSOUT,
    LEVELNUM,
    NUMBER,
    CHARS,
    HSP: INTEGER;
BEGIN
  IF NEWHEADLEVEL < OLDHEADLEVEL
  THEN (*ZERO UNNEEDED HEAD LEVEL NUMBERS*)
    FOR I := NEWHEADLEVEL+1 TO OLDHEADLEVEL DO
      LEVEL[I] := 0;
  LEVEL[NEWHEADLEVEL] := SUCC(LEVEL[NEWHEADLEVEL]);
  IF NEWHEADLEVEL = 1
  THEN (*WILL PRINT FIRST 2 HEAD LEVEL NUMBERS*)
    LEVELSOUT := 2
  ELSE (*WILL PRINT SPECIFIED HEAD LEVEL NUMBERS*)
    LEVELSOUT := NEWHEADLEVEL;
  FOR LEVELNUM := 1 TO LEVELSOUT DO
  (*PRINT HEADER LEVEL NUMBERS*)
  BEGIN
    IF LEVELNUM <> 1
    THEN
      OUTPUTLINE[OLP] := '.';
    NUMBER := LEVEL[LEVELNUM];
    CHARS := 1;
    WHILE NUMBER > 9 DO
    BEGIN (*FIGURE NUMBER OF CHARS IN LEVEL NUMBER*)
      NUMBER := NUMBER DIV 10;
      CHARS := SUCC(CHARS);
    END;
    NUMBER := LEVEL[LEVELNUM];
    FOR I := OLP+CHARS DOWNTO OLP+1 DO
    BEGIN (*TRANSLATE LEVEL NUMBER INTO CHARS*)
      OUTPUTLINE[I] := CHR((NUMBER MOD 10) + 48);
      NUMBER := NUMBER DIV 10;
    END;
    OLP := OLP + CHARS + 1;
  END;
  OLDHEADLEVEL := NEWHEADLEVEL;
  IF HEADSTRING[1] <> ZR
  THEN (*PRINT HEADER LEVEL TITLE*)
  BEGIN
    OUTPUTLINE[OLP] := ' ';
    OLP := SUCC(OLP);
    OUTPUTLINE[OLP] := ' ';
    OLP := SUCC(OLP);
    HSP := 1;
    WHILE (HEADSTRING[HSP] <> ZR) AND
          (OLP <= RIGHT_MARGIN) DO
    BEGIN (*TRANSFER HEADER STRING TO OUTPUT LINE*)
      OUTPUTLINE[OLP] := HEADSTRING[HSP];
      OLP := SUCC(OLP);
      HSP := SUCC(HSP);
    END;
  END;
  OUTPUTLINE[OLP] := NL;
  PUTLINE;
END; (*PUTHEADLEVEL*)
 
PROCEDURE STARTLIST(VAR N: INTEGER);
(*INITIALIZE THIS LEVEL OF LIST*)
VAR NEWLEFTMARGIN: INTEGER;
BEGIN
  LISTLEVEL := SUCC(LISTLEVEL);
  WITH LISTPARAM[LISTLEVEL] DO
  BEGIN (*INIT A LIST LEVEL RECORD AND RESET LEFT MARGIN*)
    NUMBER := 0;
    SPACING := N;
    NEWLEFTMARGIN := LEFT_MARGIN + OFFSET;
    CHECKANDSET(LEFTMARGINC,NEWLEFTMARGIN);
  END;
END; (*STARTLIST*)
 
PROCEDURE PUTLISTNUMBER(LISTTYPE: TYPEOFCOMMAND);
(*TRANSLATE LIST ELEMENT NUMBER INTO CHARACTERS*)
VAR NUMBER: INTEGER;
BEGIN
  OUTPUTLINE[LEFT_MARGIN] := ' ';
  OUTPUTLINE[LEFT_MARGIN-1] := ' ';
  OUTPUTLINE[LEFT_MARGIN-2] := '.';
  NUMBER := LISTPARAM[LISTLEVEL].NUMBER;
  OLP := LEFT_MARGIN - 3;
  REPEAT
    OUTPUTLINE[OLP] := CHR((NUMBER MOD 10) + 48);
    NUMBER := NUMBER DIV 10;
    OLP := PRED(OLP);
  UNTIL NUMBER = 0;
  OLP := LEFT_MARGIN;
END; (*PUTLISTNUMBER*)
 
PROCEDURE LISTMEMBER(LISTTYPE: TYPEOFCOMMAND);
(*SPACE DOWN AND NUMBER A LIST ENTRY*)
BEGIN
  WITH LISTPARAM[LISTLEVEL] DO
  BEGIN
    IF TEST_PAGE(SPACING+1)
    THEN
      SKIPLINES(SPACING)
    ELSE
      NEWPAGE;
    NUMBER := SUCC(NUMBER);
  END;
  PUTLISTNUMBER(LISTTYPE);
END; (*LISTMEMBER*)
 
PROCEDURE STOPLIST;
(*TERMINATE THIS LEVEL OF LIST AND RESET TO PRIOR LIST LEVEL*)
VAR NEWLEFTMARGIN: INTEGER;
BEGIN
  WITH LISTPARAM[LISTLEVEL] DO
  BEGIN
    IF TEST_PAGE(SPACING+1)
    THEN
      SKIPLINES(SPACING)
    ELSE
      NEWPAGE;
    NEWLEFTMARGIN := LEFT_MARGIN - OFFSET;
    CHECKANDSET(LEFTMARGINC,NEWLEFTMARGIN);
  END;
  LISTLEVEL := PRED(LISTLEVEL);
END; (*STOPLIST*)
 
(*#############################
COMMAND ROUTINES
#############################*)
 
PROCEDURE WARNING;
(*INVALID COMMAND*)
VAR WLP: INTEGER;
BEGIN
  WRITELN(OUTPUT,'INVALID COMMAND');
  WLP := 0;
  REPEAT
    WLP := SUCC(WLP);
    WRITE(OUTPUT,INPUTLINE[WLP]);
  UNTIL INPUTLINE[WLP] = NL;
  BREAK(OUTPUT);
END; (*WARNING*)
 
PROCEDURE BREAKK;
BEGIN
  PUTLINE;
  IF TEST_PAGE(LINE_SPACING)
  THEN
    SKIPLINES(LINE_SPACING-1)
  ELSE
    NEWPAGE;
END; (*BREAKK*)
 
PROCEDURE SKIP(VAR N: INTEGER);
BEGIN
  CHECKANDSET(SKIPC,N);
  BREAKK;
  IF NOT ATTOPOFPAGE
  THEN
    IF TEST_PAGE((N+2) * LINE_SPACING)
    THEN
      SKIPLINES(N * LINE_SPACING)
    ELSE
      NEWPAGE;
END; (*SKIP*)
 
PROCEDURE BLANK(VAR N: INTEGER);
BEGIN
  CHECKANDSET(BLANKC,N);
  BREAKK;
  IF NOT ATTOPOFPAGE
  THEN
    IF TEST_PAGE(N + 2)
    THEN
      SKIPLINES(N)
    ELSE
      NEWPAGE;
END; (*BLANK*)
 
PROCEDURE INDENT(VAR N: INTEGER);
BEGIN
  CHECKANDSET(INDENTC,N);
  BREAKK;
  MOVE_OLP(N);
END; (*INDENT*)
 
PROCEDURE PARAGRAPH(VAR N,V,T: INTEGER);
BEGIN
  CHECKANDSET(PARA1C,N); (*INDENT*)
  CHECKANDSET(PARA2C,V); (*VERTICAL SPACING*)
  CHECKANDSET(PARA3C,T); (*TEST PAGE ARGUMENT*)
  BREAKK;
  IF TEST_PAGE(PARA_TESTPAGE)
  THEN
    BLANK(PARA_SPACING)
  ELSE
    NEWPAGE;
  MOVE_OLP(PARA_INDENT);
END; (*PARAGRAPH*)
 
PROCEDURE PAGE;
BEGIN
  BREAKK;
  IF NOT ATTOPOFPAGE
  THEN
    NEWPAGE;
END; (*PAGE*)
 
PROCEDURE TESTPAGE(VAR N: INTEGER);
BEGIN
  CHECKANDSET(TESTPAGEC,N);
  BREAKK;
  IF NOT TEST_PAGE(N)
  THEN
    NEWPAGE;
END; (*TESTPAGE*)
 
PROCEDURE CENTER(VAR N: INTEGER);
BEGIN
  CHECKANDSET(CENTERC,N);
  SETFLAG(CENTERC,TRUE);
END; (*CENTER*)
 
PROCEDURE HEADLEVEL(VAR N: INTEGER; HEADSTRING: LINE);
BEGIN
  CHECKANDSET(HEADLEVELC,N);
  BREAKK;
  IF NOT ATTOPOFPAGE
  THEN
    IF TEST_PAGE(9)
    THEN
      SKIPLINES(3)
    ELSE
      NEWPAGE;
  PUTHEADLEVEL(N,HEADSTRING);
END; (*HEADLEVEL*)
 
PROCEDURE JUSTIFY(FLAG: BOOLEAN);
BEGIN
  IF NOT INITINGPARAMS
  THEN
    BREAKK;
  SETFLAG(JUSTIFYC,FLAG);
END; (*JUSTIFY*)
 
PROCEDURE FILL(FLAG: BOOLEAN);
BEGIN
  IF NOT INITINGPARAMS
  THEN
    BREAKK;
  SETFLAG(FILLC,FLAG);
END; (*FILL*)
 
PROCEDURE PERIOD(FLAG: BOOLEAN);
BEGIN
  SETFLAG(PERIODC,FLAG);
END;
 
PROCEDURE LEFTMARGIN(VAR N: INTEGER);
BEGIN
 IF NOT  INITINGPARAMS
  THEN
    BREAKK;
  CHECKANDSET(LEFTMARGINC,N);
END; (*LEFTMARGIN*)
 
PROCEDURE RIGHTMARGIN(VAR N: INTEGER);
BEGIN
  IF NOT INITINGPARAMS
  THEN
    BREAKK;
  CHECKANDSET(RIGHTMARGINC,N);
END;
 
PROCEDURE SPACING(VAR N: INTEGER);
BEGIN
  IF NOT INITINGPARAMS
  THEN
    BREAKK;
  CHECKANDSET(SPACINGC,N);
END;
 
PROCEDURE PAGESIZE(VAR N,M: INTEGER);
BEGIN
  CHECKANDSET(PAGESIZE1C,N);
  CHECKANDSET(PAGESIZE2C,M);
END; (*PAGESIZE*)
 
PROCEDURE TITLE(TITLESTRING: LINE);
BEGIN
  SETTITLE(TITLESTRING);
END; (*TITLE*)
 
PROCEDURE NUMBER(VAR N: INTEGER);
BEGIN
  CHECKANDSET(NUMBERC,N);
  SETFLAG(NUMBERC,TRUE);
END; (*NUMBER*)
 
PROCEDURE NONUMBER;
BEGIN
  SETFLAG(NUMBERC,FALSE);
END; (*NONUMBER*)
 
PROCEDURE HEADER(FLAG: BOOLEAN);
BEGIN
  SETFLAG(HEADERC,FLAG);
END; (*HEADER*)
 
PROCEDURE LIST(VAR N: INTEGER);
BEGIN
  CHECKANDSET(LISTC,N);
  BREAKK;
  STARTLIST(N);
END; (*LIST*)
 
PROCEDURE LISTENTRY;
BEGIN
  BREAKK;
  LISTMEMBER(LISTENTRYC);
END; (*LISTENTRY*)
 
PROCEDURE ENDLIST;
BEGIN
  BREAKK;
  STOPLIST;
END; (*ENDLIST*)
 
(*#############################
TEXT PROCESSING ROUTINES
#############################*)
 
FUNCTION IN_SENTENCE_ENDERS(CH: CHAR): BOOLEAN;
(*PERFORMS SET OPERATION CH IN ['!','.','?']*)
BEGIN
  IF (CH = '!') OR (CH = '.') OR (CH = '?')
  THEN
    IN_SENTENCE_ENDERS := TRUE
  ELSE
    IN_SENTENCE_ENDERS := FALSE;
END; (*IN_SENTENCE_ENDERS*)
 
PROCEDURE PUTCENTERED;
(*CENTER TEXT FROM INPUT LINE*)
VAR NUMOFCHARS,
    LINE_CENTER,
    START_LINE: INTEGER;
BEGIN
  REPEAT (*FIND END OF INPUT LINE TEXT*)
    ILP := SUCC(ILP);
  UNTIL INPUTLINE[ILP] = NL;
  NUMOFCHARS := ILP - 1;
  (*FIND CENTER CHARACTER OF TEXT FROM INPUT LINE*)
  IF NUMOFCHARS MOD 2 = 0
  THEN
    LINE_CENTER := NUMOFCHARS DIV 2
  ELSE
    LINE_CENTER := (NUMOFCHARS DIV 2) + 1;
  (*FIND STARTING POINT ON OUTPUT LINE*)
  START_LINE := (PAGE_CENTER - LINE_CENTER) + 1;
  IF START_LINE < LEFT_MARGIN+1
  THEN (*READJUST STARTING POINT*)
    START_LINE := LEFT_MARGIN + 1;
  FOR OLP := LEFT_MARGIN+1 TO START_LINE-1 DO
  (*BLANK UP TO START OF CENTERED TEXT*)
    OUTPUTLINE[OLP] := ' ';
  OLP := START_LINE;
  ILP := 1;
  WHILE (INPUTLINE[ILP] <> NL) AND
        (OLP <= RIGHT_MARGIN) DO
  (*PUT CENTERED TEXT*)
  BEGIN
    OUTPUTLINE[OLP] := INPUTLINE[ILP];
    OLP := SUCC(OLP);
    ILP := SUCC(ILP);
  END;
  OUTPUTLINE[OLP] := NL;
END; (*PUTCENTERED*)
 
PROCEDURE GETWORD;
(*REMOVE A CONTIGUOUS GROUP OF CHARACTERS FROM INPUT LINE*)
VAR WBP: INTEGER;
BEGIN
    REPEAT (*SKIP OVER BLANKS*)
      ILP := SUCC(ILP);
    UNTIL INPUTLINE[ILP] <> ' ';
    IF INPUTLINE[ILP] <> NL
    THEN (*GET WORD*)
    BEGIN
      WORDBUFFERFULL := FALSE;
      WBP := 1;
      WHILE NOT WORDBUFFERFULL DO
        IF (INPUTLINE[ILP] = NL) OR (INPUTLINE[ILP] = ' ')
        THEN (*WORD HAS BEEN GOTTEN*)
        BEGIN
          WORDBUFFERFULL := TRUE;
          IF INPUTLINE[ILP] = NL
          THEN
            ENDOFLINE := TRUE
          ELSE
            ENDOFLINE := FALSE;
          WORDLENGTH := WBP - 1;
          IF IN_SENTENCE_ENDERS(WORDBUFFER[WORDLENGTH])
          (*IF WORDBUFFER[WORDLENGTH] IN SENTENCE_ENDERS*)
          THEN
            ENDOFSENTENCE := TRUE
          ELSE
            ENDOFSENTENCE := FALSE;
        END
        ELSE (*CONTINUE GETTING WORD*)
        BEGIN
          WORDBUFFER[WBP] := INPUTLINE[ILP];
          WBP := SUCC(WBP);
          ILP := SUCC(ILP);
        END;
    END
    ELSE (*AT END OF INPUT LINE & NO WORD HAS BEEN GOTTEN*)
    BEGIN
      WORDBUFFERFULL := FALSE;
      WORDLENGTH := 0;
    END;
END; (*GETWORD*)
 
FUNCTION SPACEREMAINING: BOOLEAN;
(*IS THERE ENOUGH ROOM LEFT IN OUTPUT LINE FOR CURRENT WORD?*)
BEGIN
  SPACEREMAINING := (RIGHT_MARGIN >=
                     (OLP - 1) + SPACES + WORDLENGTH);
END; (*SPACEREMAINING*)
 
PROCEDURE PUTWORD;
(*PUT CURRENT WORD INTO OUTPUT LINE. KEEPS TRACK OF WORD COUNT
 FOR JUSTIFY ROUTINE*)
VAR I,
    WBP: INTEGER;
BEGIN
  IF NOT STARTOFLINE
  THEN (*SPACING BETWEEN WORDS*)
    FOR I := 1 TO SPACES DO
    BEGIN
      OUTPUTLINE[OLP] := ' ';
      OLP := SUCC(OLP);
    END
  ELSE (*THIS IS THE FIRST WORD ON THE LINE*)
  BEGIN
    STARTOFLINE := FALSE;
    WORDCOUNT := 0;
    OLP := SUCC(OLP);
  END;
  FOR WBP := 1 TO WORDLENGTH DO
  (*COPY WORD INTO OUTPUT LINE*)
  BEGIN
    OUTPUTLINE[OLP] := WORDBUFFER[WBP];
    OLP := SUCC(OLP);
  END;
  OUTPUTLINE[OLP] := NL;
  WORDCOUNT := SUCC(WORDCOUNT);
END; (*PUTWORD*)
 
PROCEDURE FILL_ONE_LINE(VAR LINEFILLED: BOOLEAN);
(*FILL OUTPUT LINE FROM CURRENT INPUT LINE*)
VAR FINISHED: BOOLEAN;
BEGIN
  IF NOT WORDBUFFERFULL
  THEN
    GETWORD;
  LINEFILLED := FALSE;
  FINISHED := FALSE;
  WHILE NOT FINISHED DO
  BEGIN
    IF (WORDLENGTH <> 0) AND SPACEREMAINING
    THEN (*CONTINUE FILLING LINE*)
    BEGIN
      PUTWORD;
      IF ENDOFSENTENCE
      THEN (*SET SPACING BEFORE NEXT WORD*)
        SPACES := 2
      ELSE
        SPACES := 1;
      IF NOT ENDOFLINE
      THEN (*GET ANOTHER WORD*)
        GETWORD
      ELSE (*NO MORE WORDS IN THIS INPUT LINE*)
      BEGIN
        FINISHED := TRUE;
        WORDBUFFERFULL := FALSE;
      END
    END
    ELSE (*STOP FILLING LINE*)
    BEGIN
      FINISHED := TRUE;
      IF SPACEREMAINING
      THEN
        LINEFILLED := FALSE
      ELSE
        LINEFILLED := TRUE;
    END;
  END;
END; (*FILL_ONE_LINE*)
 
PROCEDURE JUSTIFY_LINE;
(*JUSTIFY OUTPUT LINE OUT TO RIGHT MARGIN
 ALGORITHM FROM SOFTWARE TOOLS(1976) BY KERNIGHAN & PLAUGER, PAGE 241*)
VAR I,
    EXTRA_SPACES,
    HOLE_COUNT,
    LEFTSIDE,
    RIGHTSIDE,
    BLANKS: INTEGER;
BEGIN
  (*COMPUTE NUMBER OF BLANKS THAT WILL HAVE TO BE INSERTED*)
  EXTRA_SPACES := (RIGHT_MARGIN + 1) - OLP;
  IF (EXTRA_SPACES > 0) AND (WORDCOUNT > 1)
  THEN
  BEGIN
    (*REVERSE PREVIOUS DIRECTION FOR INSERTING BLANKS*)
    DIRECTION := 1 - DIRECTION;
    (*COMPUTE NUMBER OF HOLES IN WHICH TO ADD BLANKS*)
    HOLE_COUNT := WORDCOUNT - 1;
    LEFTSIDE := OLP;
    RIGHTSIDE := RIGHT_MARGIN + 1;
    OLP := RIGHTSIDE;
    WHILE LEFTSIDE < RIGHTSIDE DO
    BEGIN (*JUSTIFY TEXT*)
      OUTPUTLINE[RIGHTSIDE] := OUTPUTLINE[LEFTSIDE];
      IF OUTPUTLINE[LEFTSIDE] = ' '
      THEN (*END OF WORD ENCOUNTERED*)
      BEGIN
        IF NOT (PERIODFLAG AND IN_SENTENCE_ENDERS(OUTPUTLINE[LEFTSIDE-1]))
        (*IF NOT (PERIODFLAG AND (OUTPUTLINE[LEFTSIDE-1] IN SENTENCE_ENDERS))*)
        THEN (*COMPUTE # OF EXTRA BLANKS TO INSERT*)
        BEGIN
          IF DIRECTION = 0
          THEN (*ADD EXTRA BLANKS ON RIGHT*)
            BLANKS := ((EXTRA_SPACES - 1) DIV HOLE_COUNT) + 1
          ELSE (*ADD EXTRA BLANKS ON LEFT*)
            BLANKS := EXTRA_SPACES DIV HOLE_COUNT;
          EXTRA_SPACES := EXTRA_SPACES - BLANKS;
          HOLE_COUNT := HOLE_COUNT - 1;
          FOR I := 1 TO BLANKS DO
          BEGIN (*INSERT EXTRA BLANKS*)
            RIGHTSIDE := PRED(RIGHTSIDE);
            OUTPUTLINE[RIGHTSIDE] := ' ';
          END;
        END;
      END;
      LEFTSIDE := PRED(LEFTSIDE);
      RIGHTSIDE := PRED(RIGHTSIDE);
    END;
  END;
END; (*JUSTIFY_LINE*)
 
PROCEDURE FILL_LINES;
(*FILL (AND JUSTIFY) ONE OR MORE OUTPUT LINES FROM CURRENT
 INPUT LINE*)
VAR LINEFILLED: BOOLEAN; (*HAS OUTPUT LINE BEEN FILLED*)
BEGIN
    FILL_ONE_LINE(LINEFILLED);
    WHILE LINEFILLED DO
    BEGIN
      IF JUSTIFYFLAG
      THEN
        JUSTIFY_LINE;
      BREAKK;
      FILL_ONE_LINE(LINEFILLED);
    END;
END; (*FILL_LINES*)
 
PROCEDURE COPYLINEASIS;
(*COPY INPUT LINE LITERALLY AS FOUND IN SOURCE FILE*)
VAR LINECOPIED: BOOLEAN;
BEGIN
  LINECOPIED := FALSE;
  WHILE NOT LINECOPIED DO
  BEGIN
    REPEAT
      OLP := SUCC(OLP);
      ILP := SUCC(ILP);
      OUTPUTLINE[OLP] := INPUTLINE[ILP];
    UNTIL (OLP=RIGHT_MARGIN) OR (INPUTLINE[ILP]=NL);
    IF INPUTLINE[ILP] = NL
    THEN (*INPUT LINE HAS BEEN COPIED*)
      LINECOPIED := TRUE
    ELSE (*INPUT LINE MAY BE TOO LONG; REMAINDER WILL GO ON NEXT LINE*)
    BEGIN
      IF INPUTLINE[ILP+1] = NL
      THEN (*LINE IS EXACTLY THE RIGHT SIZE*)
        LINECOPIED := TRUE;
      OLP := SUCC(OLP);
      OUTPUTLINE[OLP] := NL;
    END;
    BREAKK;
  END;
END; (*COPYLINEASIS*)
 
(*#############################
RUNOFF CONTROL ROUTINES
#############################*)
 
FUNCTION LINETYPE: TYPEOFLINE;
(*IS INPUT LINE A COMMAND OR TEXT?*)
BEGIN
  IF INPUTLINE[1] = '.'
  THEN
    LINETYPE := COMMAND
  ELSE
    LINETYPE := TEXTUAL;
END; (*LINETYPE*)
 
PROCEDURE DOCOMMAND;
(*INTERPRET COMMANDS AND PROCESS COMMAND ARGUMENTS*)
VAR COMMANDTYPE: TYPEOFCOMMAND;
    ARG        : ARGARRAY;
    ARGTEXT    : LINE;
BEGIN
  SCANCOMMAND(COMMANDTYPE);
  SCANARGUMENTS(ARG,ARGTEXT);
  CASE COMMANDTYPE OF
    BREAKC      : BREAKK;
    SKIPC       : SKIP(ARG[1]);
    BLANKC      : BLANK(ARG[1]);
    INDENTC     : INDENT(ARG[1]);
    PARAGRAPHC  : PARAGRAPH(ARG[1],ARG[2],ARG[3]);
    PAGEC       : PAGE;
    TESTPAGEC   : TESTPAGE(ARG[1]);
    CENTERC     : CENTER(ARG[1]);
    HEADLEVELC  : HEADLEVEL(ARG[1],ARGTEXT);
    JUSTIFYC    : JUSTIFY(TRUE);
    NOJUSTIFYC  : JUSTIFY(FALSE);
    FILLC       : FILL(TRUE);
    NOFILLC     : FILL(FALSE);
    PERIODC     : PERIOD(TRUE);
    NOPERIODC   : PERIOD(FALSE);
    LEFTMARGINC : LEFTMARGIN(ARG[1]);
    RIGHTMARGINC: RIGHTMARGIN(ARG[1]);
    SPACINGC    : SPACING(ARG[1]);
    PAGESIZEC   : PAGESIZE(ARG[1],ARG[2]);
    TITLEC      : TITLE(ARGTEXT);
    NUMBERC     : NUMBER(ARG[1]);
    NONUMBERC   : NONUMBER;
    HEADERC     : HEADER(TRUE);
    NOHEADERC   : HEADER(FALSE);
    LISTC       : LIST(ARG[1]);
    LISTENTRYC  : LISTENTRY;
    ENDLISTC    : ENDLIST;
    INVALID     : WARNING
  END; (*CASE*)
END; (*DOCOMMAND*)
 
PROCEDURE PROCESSTEXT;
(*FORMAT TEXT*)
BEGIN
  IF CENTERFLAG
  THEN
  BEGIN
    PUTCENTERED;
    SETFLAG(CENTERC,FALSE);
    BREAKK;
  END
  ELSE
    IF FILLFLAG
    THEN
      FILL_LINES
    ELSE
      COPYLINEASIS;
END; (*PROCESSTEXT*)
 
(*#############################
FILE HANDLING ROUTINES
#############################*)
 
PROCEDURE INITIALIZE;
BEGIN
  IF ARGC = 3
  THEN
    INITOK := TRUE
  ELSE
  BEGIN
    INITOK := FALSE;
    WRITELN('WRONG NUMBER OF ARGUMENTS');
  END;
END; (*INITIALIZE*)
 
PROCEDURE OPENFILES;
BEGIN
  RESET(SOURCE, ARGV[1]@, 2);
  REWRITE(DESTINATION, ARGV[2]@, 2);
END; (*OPENFILES*)
 
PROCEDURE CLOSEFILES;
BEGIN
  (* FLUSH OUTPUT FILE *)
  BREAK(DESTINATION);
  (* FILES CLOSE AUTOMATICALLY UPON PROGRAM EXIT *)
END; (*CLOSEFILES*)
 
PROCEDURE TERMINATE;
BEGIN
  IF NOT INITOK
  THEN
    WRITELN('PASRUF NOT EXECUTED');
END; (*TERMINATE*)
 
(*#############################
MAIN SEQUENCE
#############################*)
 
PROCEDURE INITRUNOFF;
VAR I: INTEGER;
    COMMANDINDEX: TYPEOFCOMMAND;
BEGIN
  LEFT_MARGIN  := DLEFTMARGIN;
  RIGHT_MARGIN := DRIGHTMARGIN;
  LINE_SPACING := DLINESPACING;
  PARA_INDENT  := DPARAINDENT;
  PARA_TESTPAGE:= DPARATESTPAGE;
  PAGE_SIZE    := DPAGESIZE;
  LINE_COUNT   := 0;
  PAGE_COUNT   := 0;
  PARA_SPACING := (LINE_SPACING + 1) DIV 2;
 
  CENTERFLAG   := FALSE;
  HEADERFLAG   := TRUE;
  NUMBERFLAG   := TRUE;
  PERIODFLAG   := TRUE;
  FILLFLAG     := TRUE;
  JUSTIFYFLAG  := TRUE;
 
  (*
  THESE COMMAND TYPES INFLUENCE FORMATTING PARAMETERS BEFORE
  TEXT PROCESSING STARTS
  INITPARAMCOMMANDS := [JUSTIFYC,NOJUSTIFYC,FILLC,NOFILLC,PERIODC,
                        NOPERIODC,LEFTMARGINC,RIGHTMARGINC,
                        SPACINGC,PAGESIZEC,TITLEC,NUMBERC,
                        NONUMBERC,HEADERC,NOHEADERC];
  *)
 
  OLDHEADLEVEL := 0;
  FOR I := 1 TO 5 DO
    LEVEL[I] := 0;
 
  LISTLEVEL := 0;
  LISTPARAM[1].OFFSET := 9;
  FOR I := 2 TO 5 DO
    LISTPARAM[I].OFFSET := 4;
 
  WORDBUFFERFULL := FALSE;
  ENDOFSENTENCE  := FALSE;
  STARTOFLINE := TRUE;
  ENDOFLINE := FALSE;
  DIRECTION := 0;
 
  FOR I := 1 TO LINELENGTH DO
    CURRENT_TITLE[I] := ' ';
 
  (*
  CHAR SETS USED IN TEXT AND ARGUMENT PROCESSING PHASES
  SENTENCE_ENDERS := ['!','.','?'];
  DIGITS := ['+','-','0','1','2','3','4','5','6','7','8','9'];
  *)
 
  NULL_ARGUMENT := -32767;
 
  ILP := 0;
  OLP := LEFT_MARGIN;
  FOR I := 1 TO LEFT_MARGIN DO
    OUTPUTLINE[I] := ' ';
 
  COMMANDTABLE[      BREAKC] := 'BR ';
  COMMANDTABLE[       SKIPC] := 'S  ';
  COMMANDTABLE[      BLANKC] := 'B  ';
  COMMANDTABLE[     INDENTC] := 'I  ';
  COMMANDTABLE[  PARAGRAPHC] := 'P  ';
  COMMANDTABLE[       PAGEC] := 'PG ';
  COMMANDTABLE[   TESTPAGEC] := 'TP ';
  COMMANDTABLE[     CENTERC] := 'C  ';
  COMMANDTABLE[  HEADLEVELC] := 'HL ';
  COMMANDTABLE[    JUSTIFYC] := 'J  ';
  COMMANDTABLE[  NOJUSTIFYC] := 'NJ ';
  COMMANDTABLE[       FILLC] := 'F  ';
  COMMANDTABLE[     NOFILLC] := 'NF ';
  COMMANDTABLE[     PERIODC] := 'PR ';
  COMMANDTABLE[   NOPERIODC] := 'NPR';
  COMMANDTABLE[ LEFTMARGINC] := 'LM ';
  COMMANDTABLE[RIGHTMARGINC] := 'RM ';
  COMMANDTABLE[    SPACINGC] := 'SP ';
  COMMANDTABLE[   PAGESIZEC] := 'PS ';
  COMMANDTABLE[      TITLEC] := 'T  ';
  COMMANDTABLE[     NUMBERC] := 'NM ';
  COMMANDTABLE[   NONUMBERC] := 'NNM';
  COMMANDTABLE[     HEADERC] := 'HD ';
  COMMANDTABLE[   NOHEADERC] := 'NHD';
  COMMANDTABLE[       LISTC] := 'LS ';
  COMMANDTABLE[  LISTENTRYC] := 'LE ';
  COMMANDTABLE[    ENDLISTC] := 'ELS';
 
END; (*INITRUNOFF*)
 
PROCEDURE RUNOFF;
VAR COMMANDTYPE: TYPEOFCOMMAND;
BEGIN
  GETLINE;
  INITINGPARAMS := TRUE;
  ENDOFFILE := FALSE;
  WHILE NOT ENDOFFILE AND INITINGPARAMS DO
  (*PROCESS THOSE COMMANDS THAT AFFECT THE VARIOUS PARAMETER
   AND FLAG SETTINGS*)
  BEGIN
    IF LINETYPE = COMMAND
    THEN
    BEGIN
      SCANCOMMAND(COMMANDTYPE);
      ILP := 0;
      IF (COMMANDTYPE >= JUSTIFYC) AND (COMMANDTYPE <= NOHEADERC)
      (*IF COMMANDTYPE IN INITPARAMCOMMANDS*)
      THEN (*THIS IS AN INITIALIZATION COMMAND*)
      BEGIN
        DOCOMMAND;
        GETLINE;
      END
      ELSE (*FIRST NON-INITITALIZATION COMMAND WILL END THIS PHASE*)
        INITINGPARAMS := FALSE;
    END
    ELSE (*FIRST TEXT LINE WILL END THIS PHASE*)
      INITINGPARAMS := FALSE;
  END;
  NEWPAGE; (*GOTO TOP OF FIRST PAGE*)
  WHILE NOT ENDOFFILE DO
  (*PROCEED WITH NORMAL SOURCE FILE PROCESSING*)
  BEGIN
    CASE LINETYPE OF
      COMMAND: DOCOMMAND;
      TEXTUAL: PROCESSTEXT
    END; (*CASE*)
    GETLINE;
  END;
END; (*RUNOFF*)
 
PROCEDURE TERMRUNOFF;
(*FLUSH THE CURRENT OUTPUTLINE BUFFER AND EJECT PAGE*)
BEGIN
  PUTLINE;
  PUTCHAR(FF);
END; (*TERMRUNOFF*)
 
(*#############################
MAIN PROGRAM
#############################*)
 
BEGIN
  INITIALIZE;
  IF INITOK THEN
  BEGIN
    OPENFILES;
    INITRUNOFF;
    RUNOFF;
    TERMRUNOFF;
    CLOSEFILES;
  END;
  TERMINATE;
END.
 