  program whetstonebenchmark(output);
TYPE
  array4real = ARRAY[1..4] OF real;
VAR
  t,t1,t2,x,y,z:real;
  values : ARRAY [1..10] OF real;
  i,j,k,l,n1,n2,n3,n4,n5,n6,n7,n8,
        n9,n10,n11:integer;
  x1,x2,x3,x4:real;
  e1:array4real;
  times : ARRAY [1..4] OF real;
  delta1,delta2,whetsec : real;
  sum,avg,stddev : real;
  count : integer;


  PROCEDURE pa(VAR e:array4real);
   BEGIN
     j:= 0;
     WHILE j < 6 DO
      BEGIN
	e[1] := (e[1]+e[2]+e[3]-e[4])*t;
	e[2] := (e[1]+e[2]-e[3]+e[4])*t;
	e[3] := (e[1]-e[2]+e[3]+e[4])*t;
	e[4] := (-e[1]+e[2]+e[3]+e[4])/t2;
	j := j + 1
      END
   END;
  PROCEDURE p0;
   BEGIN
     e1[j] := e1[k];
     e1[k] := e1[l];
     e1[l] := e1[j]
   END;
  PROCEDURE p3(x,y:real; VAR z:real);
  VAR
    x1,y1:real;
   BEGIN
     x1:=x;
     y1:=y;
     x1:=t*(x1+y1);
     y1:=t*(x1+y1);
     z:=(x1+y1)/t2
   END;

  PROCEDURE init;
   BEGIN
     t := 0.499975;
     t1 := 0.500025;
     t2 := 2.0;
     (* ESTABLISH EXECUTION FREQUENCIES *)
     n1  := 0 ;
     n2 := 12*i;
     n3 := 14*i;
     n4 := 345*i;
     n5 := 0;
     n6 := 210*i;
     n7 := 32*i;
     n8 := 899*i;
     n9 := 616*i;
     n10 := 0;
     n11 := 93*i;
   END;
  PROCEDURE timed;
    (* THIS IS THE PART THAT IS TIMED 
       FOR THE BENCHMARK *)
   BEGIN
     (*
      MODULE 1: SIMPLE IDENTIFIERS
      *)
     x1 := 1.0;
     x2 := -1.0;
     x3 := -1.0;
     x4 := -1.0;
     FOR i := 1 TO n1 DO
      BEGIN
	x1 := (x1+x2+x3-x4)*t;
	x2 := (x1+x2-x3+x4)*t;
	x3 := (x1-x2+x3+x4)*t;
	x4 := (-x1+x2+x3+x4)*t
      END;
     (* WRITELN(N1:4,N1:4,
        N1:4,X1,X2,X3,X4);  *)
     (*
      MODULE 2: ARRAY ELEMENTS
      *)
     e1[1] := 1.0;
     e1[2] :=-1.0;
     e1[3] :=-1.0;
     e1[4] :=-1.0;
     FOR i := 1 TO n2 DO
      BEGIN
	e1[1] := (e1[1]+e1[2]+e1[3]-e1[4])*t;
	e1[2] := (e1[1]+e1[2]-e1[3]+e1[4])*t;
	e1[3] := (e1[1]-e1[2]+e1[3]+e1[4])*t;
	e1[4] := (-e1[1]+e1[2]+e1[3]+e1[4])*t
      END;
     (* WRITELN(N2:4,N2:4,N2:4,E1[1],
        E1[2],E1[3],E1[4]);  *)
     (*
      MODULE 3: ARRAY AS PARAMETER
      *)
     FOR i := 1 TO n3 DO
     pa(e1);
     (* WRITELN(N3:4,N2:4,N2:4,E1[1],
        E1[2],E1[3],E1[4]);  *)
     (*
      MODULE 4: CONDITIONAL JUMPS
      *)
     j := 1;
     FOR i := 1 TO n4 DO
      BEGIN
	IF j = 1
	 THEN j := 2
	 ELSE j := 3;
	IF j > 2
	 THEN j := 0
	 ELSE j := 1;
	IF j < 1
	 THEN j := 1
	 ELSE j := 0
      END;
     (* WRITELN(N4:4,J:4,J:4,X1,X2,X3,X4);  *)
     (*
      MODULE 5: OMITTED
      *)
     (*
      MODULE 6: INTEGER ARITHMETIC
      *)
     j := 1;
     k := 2;
     l := 3;
     FOR i := 1 TO n6 DO
      BEGIN
	j := j*(k-j)*(l-k);
	k := l*k-(l-j)*k;
	l := (l-k)*(k+j);
	e1[l-1] := j+k+l;
	e1[k-1] := j*k*l
      END;
     (* WRITELN(N6:4,J:4,K:4,E1[1],E1[2],
        E1[3],E1[4]);  *)
     (*
      MODULE 7: TRIG FUNCTIONS
      *)
     x := 0.5;
     y := 0.5;
     FOR i := 1 TO n7 DO
      BEGIN
	x := t2*sin(x)*cos(x)/(cos(x+y)
             +cos(x-y)-1.0)*t;
	x := arctan(x);
	y := t2*sin(y)*cos(y)/(cos(x+y)
             +cos(x-y)-1.0)*t;
	y := arctan(y);
      END;
     (* WRITELN(N7:4,J:4,K:4,X,X,Y,Y);  *)
     (*
      MODULE 8: PROCEDURE CALLS
      *)
     x := 1.0;
     y := 1.0;
     z := 1.0;
     FOR i := 1 TO n8 DO
     p3(x,y,z);
     (* WRITELN(N8:4,J:4,K:4,X,Y,Z,Z);  *)
     (*
      MODULE 9: ARRAY REFERENCES
      *)
     j := 1;
     k := 2;
     l := 3;
     e1[1] := 1.0;
     e1[2] := 2.0;
     e1[3] := 3.0;
     FOR i := 1 TO n9 DO
     p0;
     (* WRITELN(N9:4,J:4,K:4,E1[1],
        E1[2],E1[3],E1[4]);  *)
     (*
      INTEGER ARITHMETIC
      *)
     j := 2;
     k := 3;
     FOR i := 1 TO n10 DO
      BEGIN
	j := j + k;
	k := j + k;
	j := k-j;
	k:= k - j - j
      END;
     (* WRITELN(N10:4,J:4,K:4,X1,X2,X3,X4);  *)
     (*
      MODULE 11: STANDARD FUNCTIONS
      *)
     x := 0.75;
     FOR i := 1 TO n11 DO
     x := sqrt(exp(ln(x)/t1));
     (* WRITELN(N11:4,J:4,K:4,X,X,X,X);  *)
   END;
  (*************************
   *  MAIN BODY OF PROGRAM  *
   *************************)
 BEGIN
   FOR count := 1 TO 10 DO
    BEGIN
      i := 10;
      init;
      times[1] := time;
      timed;
      times[2] := time;
      i := 20;
      init;
      times[3] := time;
      timed;
      times[4] := time;
      delta1 := (times[2] - times[1])*36000.0;
      delta2 := (times[4] - times[3])*36000.0;
      whetsec := 10000.0/(delta2 - delta1);
      values[count] := whetsec;
      write('RUN NO. ',count:2,
            ' ',whetsec:10:3,' ');
      write('THOUSANDS OF WHETSTONE ');
      writeln('INSTRUCTIONS PER SECOND')
    END;
   sum := 0.0;
   FOR count := 1 TO 10 DO
   sum := sum + values[count];
   avg := sum / 10.0;
   sum := 0;
   FOR count := 1 TO 10 DO
   sum := sum + (avg - values[count])
          *(avg - values[count]);
   stddev := sqrt(sum/10.0);
   writeln('MEAN: ',avg:10:3);
   writeln('STD. DEVIATION: ',stddev:10:3)
 END.
 