  Program TC ;
{$L-}
{$W-}
{	Brian Nelson
	Computer Services
	University of Toledo
	15-JUN-79


	T C . P A S

	A program to copy tape to tape, with or without two tape
	drives.


	Operating Sys	RSTS version 6C or 7.0
	Compiler:	RSTS  NBS Pascal V1.5F or later
	OTS:		RSTS Toledo OTS with the PASCAL callable
			macro input/output routines.


	  TC can do the following:


	  Copy any nine track tape to  another  using  two  tape
	  drives.  Tapes can be ASCII, EBCDIC , ect that written
	  with an 8 bit code (or 7 bit padded to  8),  i.e.,  no
	  DEC10 or Univac tapes.  


	  Copy any format nine track tape using one  tape  drive
	  by  creating  a  specially  formatted disk image dump.
	  The tape can be variable length blocks or fixed, since
	  all the information needed to re-construct the tape is
	  written to disk in variable length disk  records.   In
	  this  mode,  the  program can operate in two different
	  ways, the first being the above mentioned  generalized
	  copy,  and  the second being a highly optimized PDP 11
	  DOS tape copy facility which is capable  of  producing
	  tapes  at  hardware  speeds.  In this second tape/disk
	  copy mode, tape blocks are directly written to disk in
	  512  byte blocks with a file label index being kept in
	  the first 32 blocks of the tape image file.  This mode
	  of operation is also of use when creating distribution
	  copies of software (PASCAL, MINITAB,  ect)  as  it  is
	  three  to  four  times  faster  than using PIP to copy
	  files from a source disk to tape.  Multiple copies can
	  be  made  concurrently  using  two or more drives many
	  times faster than PIP  or  PRESERVE.   In  that  case,
	  better  operation  would result by alternating between
	  drives to be able to  write  while  rewinding.   As  a
	  note, TC will read/write the disk image file 32 blocks
	  at a time.  Thus the image file should have a  minimum
	  cluster of 32, or be contiguous.
	  In this mode, TC is similiar  to  the  RSX11M  program
	  TPC.  


	  TC can detach.  


	  While this is an aplication  that  would  normally  be
	  written  in MACRO and made a run time system, writting
	  it in PASCAL does tend to make it more  readable,  ect
	  at  the  expense  of  direct access to things like the
	  FIRQB, ect.


	  Disk data formats.

	  General variable length record case.


	  byte offset in record
	   
	     0 - 1      2 - N
	   
	   Byte count   Data record, of length given in byte
	   count.
	   
	   
	  The first record always contains a 22 byte header  re-
	  cord identifying the disk file as being created by TC,
	  and containing the data and time of creation.   }  
{	Operation:

	Dos format tape to disk image for single drive copy


	run (1,3) TC

	TC version 2
	Input  device ? MM0:
	Output device ? DB1:[2,3]JUNK.TC/CL:32
	Dos tape <Yes>? 
	Detach   <No> ? Yes

	Detaching ....



	.. Later on


	Att 16
	Termination   16000 records copied
		        255 files   copied
			  0 magtape errors.

	Ready


	... And then back to tape


	run (1,3) TC

	TC version 2
	Input  device ? DB1:[2,3]JUNK.TC
	Output device ? MM0:
	Dos tape <Yes>? 
	Density <800> ? 1600
	Detach   <No> ? Yes

	Detaching ....


	For non-DOS tape (IBM tape, ect) Type  'NO' for the DOS tape
	question. For tape to tape image, a tape drive name would have
	been specified for both input and output. For  RK05  to   RK05
	disk image copy, disk device names would have been supplied,
	etc.......


								}


   { Definitions for RSTS externalal routines to do :

	1. Random access block read
	2. Random access block write
	3. File open
	4. File create
	5. File close
	6. Return byte count of last i/o operation
	7. Do a UUO sys call
	8. Do a file name string scan
	9. Do the RSTS special MAGTAPE functions.
							}
   
   Const buffsize = 512 ;   { size of a DOS/DISK block }
	 buffcount = 32 ; { number of disk block buffers }
	 dos_labelsize  = 14 ; { size of a DOS tape label }
	 ansi_labelsize = 80 ;

   Type dskblock    = array [0..buffsize-1] of char ;
        buffer	    = array [1..buffcount] of dskblock ;
        sysresult   = array [1..30] of char ;
        filespec    = array [1..30] of char ;
        status      = record devindex, iomodflag : char end ;
   
   Procedure Getblk(var buff:dskblock; buffsize,lun,bnum:integer;
   		    var reterr:integer ) ; external ;
   
   procedure dattim( var sysdate,systime: array [1..9] of char );
		    external ;
   
   Procedure Putblk(var buff:dskblock; buffsize,lun,bnum:integer;
   		    var reterr:integer ) ; external ;
   
   Procedure Fopen( var filename:array [1..30] of char; lun:integer ;
		    var iostatus:status; var reterr:integer ); external;
   
   
   Procedure Fcreat(var filename:array [1..30] of char; lun:integer ;
		    var iostatus:status; var reterr:integer ); external;
   
   Procedure Fclose(lun:integer ; var reterr:integer); external;
   
   function  recount : integer; external ;
   
   procedure sys( var param,result:array [1..30] of char ;
   	          var reterr: integer ) ; external ;
   
   procedure FSS( var param,result:array [1..30] of char ;
   	          var reterr: integer ) ; external ;
   
   function  magtape(fun,arg,lun: integer ;
   		     var reterr : integer ) :integer;
   		     external;



  const	in_lun  = 7 ;
	out_lun = 8 ;
	nl      = chr(10) ;
	null	= chr(0)  ;
	ff      = chr(12) ;
	space	= chr(32) ;
	version	= '2' ;
	err_eof       = 11 ;
	err_datacheck = 13 ;
	magtape_rew   =  3 ;
	magtape_eof   =  2 ;
	devindex_disk = chr(0)  ;
	devindex_tty  = chr(2)  ;
	devindex_tu56 = chr(4)  ;
	devindex_lp   = chr(6)  ;
	devindex_cr   = chr(12) ;
	devindex_tape = chr(14) ;
	devindex_pk   = chr(16) ;
	devindex_flop = chr(18) ;
	devindex_null = chr(22) ;
	programname   = 'TC version  ' ;
	index_size    = buffsize * 6 ;
	first_cluster = buffcount + 1 ;
	filelabelsize  = 48   ;
	dkbuffsize      = buffsize * 4 ;


  Type
	varbuf    = record
		      bf : array [0..dkbuffsize - 1] of char ;
		      blknum : integer ;
		      xrbc   : integer ;
		      bufpnt : integer
		    end ;

  Var
     	tapebuff  : array [1..buffcount] of dskblock ;
	dkbuff    : varbuf  ;
	fileloc   : array [0..index_size-1] of integer ;
        indevice  : array [1..30] of char ;
	outdevice : array [1..30] of char ;
	sysdate   : array [1..9]  of char ;
	systime   : array [1..9]  of char ;
	ch	  : char ;
	buffernum : integer ;
	blocknum  : integer ;
	errcode   : integer ;
	iostatus  : array [1..15] of status ;
	i , j , k : integer ;
	bytecount : integer ;
	blockcount: integer ;
	errorcount: integer ;
	filecount : integer ;
	junk	  : integer ;
	dummy01   : integer ;
	detached  : boolean ;
	detachit  : boolean ;
	end_of_tape: boolean ;
	end_of_file: boolean ;
	dostape    : boolean ;
	ignore_datacheck: boolean ;
	intype , outtype : status ;




  procedure errprint( errnum:integer );
    var  errtxt ,sysparm : array [1..30] of char ;
    var  i ,errcode :integer ;
    begin
	for i := 1 to 30 do sysparm[i] := null;
	sysparm[1] := chr(6) ;
	sysparm[2] := chr(9) ;
	sysparm[3] := chr(errnum) ;
	sys( sysparm,errtxt,errcode ) ;
	for i := 3 to 30 do write(output,errtxt[i]) ;
	writeln
  end;

  Procedure Dataerror ;
    begin
	if not detached
	 then
	  begin
	   writeln('Magtape data error at record ',blockcount:6);
	   break(output)
	  end ;
	errorcount := succ( errorcount )
  end { dataerror } ;


  Procedure DETACH ;
    var sysp : array [1..30] of char ;
	i    : integer ;
    begin
	detached := false ;
	writeln(nl,'Detaching',ff) ; break( output ) ;
	for i := 1 to 30 do sysp[i] := null ;
	sysp[1] := chr(6) ;
	sysp[2] := chr(7) ;
	sys( sysp,sysp,i ) ;
	if i <> 0
	 then
	  begin
	   writeln('Can not detach ---  ');
	   errprint( i );
	   break( output )
	  end
	 else detached := true 
  end { DETACH } ;


  procedure read_filespec( var line:array [1..30] of char );
    var i : integer ;
        ch: char ;
    begin
	i := 0 ;
	repeat
	 read(input,ch);
	 if ch <> space then i := succ( i ) ;
	 if ( ( ch >= 'a' ) and ( ch <= 'z' ) )
	  then ch := chr( ord(ch) - 32 ) ;
	 line[i] := ch
	until ( ch = nl ) or ( i = 30 );
    	line[i] := null

  end  { read_filespec } ;


  Procedure OPENFILES ;

    Var sysp : array [1..30] of char ;

    begin
      errcode := -1 ;
      while errcode <> 0 do
       begin
	indevice[1] := null ;
	while indevice[1] = null do
	 begin
	  write('Input   device  ? ');
	  break(output);
	  read_filespec( indevice ) 
	end ;
	fopen( indevice,in_lun,iostatus[in_lun],errcode );
	intype := iostatus[in_lun] ;
	if errcode <> 0 then
	 begin
	  errprint( errcode ) ;
	  fclose( in_lun , dummy01 )
	 end 
      end;
      errcode := -1 ;
      while errcode <> 0 do
       begin
	outdevice[1] := null ;
	while outdevice[1] = null do
	 begin
	  write('Output  device  ? ');
	  break(output);
	  read_filespec( outdevice ) 
	end ;
	fss( outdevice,sysp,errcode ) ;
	if errcode = 0 then
	 begin
	  if     ( sysp[7] = null ) and ( sysp[8] = null )
	     and ( sysp[23]= 'D'  )
	      then
	       fopen(  outdevice, out_lun, outtype, errcode )
	      else
	       fcreat( outdevice, out_lun, outtype, errcode ) ;
	  iostatus[ out_lun ] := outtype
	 end ;
	if errcode <> 0 then
	 begin
	  errprint( errcode ) ;
	  fclose( out_lun , dummy01 )
	 end 
      end  
  End  { openfiles } ;




  Function Rewind( lun:integer ) : integer ;
    var junk, junk1  : integer ;
    begin
	junk := 0 ;
	if iostatus[lun].devindex = devindex_tape
	 then junk1 := magtape( 3,0,lun ,junk ) ;
	rewind := junk
  end { rewind } ;


  Function write_eof( lun:integer ) : integer ;
    var junk, junk1  : integer ;
    begin
	junk := 0 ;
	if iostatus[lun].devindex = devindex_tape
	 then junk1 := magtape( 2,0,lun ,junk ) ;
	write_eof := junk
  end { write_eof } ;


  Procedure Zero_tape( lun : integer ) ;

    Var junk,i : integer ;

    Begin
	junk := rewind( lun ) ;
	for i := 1 to 2 do junk := write_eof( lun ) ;
	junk := rewind( lun )
  end ;


  Function set_density( density , lun : integer ) : integer ;

    var junk, junk1  : integer ;
    begin
	junk := 0 ;
	if iostatus[lun].devindex = devindex_tape
	then
	 begin
	  zero_tape( lun ) ;
	  if density = 1600
	   then junk1 := magtape( 6,256,lun,junk )
	   else junk1 := magtape( 6,12 ,lun,junk ) 
	 end ;
	set_density := junk
  end { set_density } ;



  Procedure Check_density( lun : integer ) ;

    Var junk : integer ;
	j    : array [1..4] of char ;

    Begin
	if iostatus[lun].devindex = devindex_tape
	 then
	  begin
	   if odd( magtape( 7,0,lun,junk ) div 16 )
	    then
	     begin
	      write('Tape Density <800> ? ');break(output);
	      read_filespec( j ) ;
	      if     ( j[1] = '1' ) and ( j[2] = '6' )
	         and ( j[3] = '0' ) and ( j[4] = '0' )
	         then junk := 1600
	         else junk := 800 ;
	      junk := Set_density( junk,lun )
	     end
	  end
  end { check_density } ;



{	The following two procedures are used only for the
	optimized DOS/DISK tape copy. They provide 32 block
	buffering for the disk tape image file.  This  will
	provide a significant speed increase for TC.  Note
	that this is most effective if the clustersize  of
	the image file is at least 32 in order to keep the
	disk drivers from splitting the read to process  a
	cluster split.					 	}



  Procedure OUTDISK( flush : boolean ) ;
    var i,errc : integer ;
	begin
	 if flush or ( buffernum = buffcount )
	  then
	   begin
	    i := blocknum + first_cluster ;
	    putblk( tapebuff[1],buffernum * buffsize,out_lun,i,errc );
	    blocknum := blocknum + buffernum ;
	    buffernum := 1
	   end
	  else
	      buffernum := succ( buffernum )

  end   {outdisk}  ;


  Function INDISK : integer ;
    Var i,errc : integer ;
	begin
	 errc := 0 ;
	 if buffernum = buffcount
	  then
	   begin
	    i := blocknum + first_cluster ;
	    getblk( tapebuff[1],buffcount * buffsize,in_lun,i,errc ) ;
	    blocknum := blocknum + buffcount ;
	    buffernum := 1
	   end
	  else
	    buffernum := succ( buffernum ) ;
	 indisk := buffernum

  end { indisk } ;


  Procedure Check_volume ;

    Var i,j : integer ;
  
    Type xltable = array [0..255] of char ;
  
    Const			{ EBCDIC translation table }
	etb = xltable (
	 chr(  0) ,chr(  1) ,chr(  2) ,chr(  3) ,chr(  0) ,chr(  9) ,
	 chr(  0) ,chr(127) ,chr(  0) ,chr(  0) ,chr(  0) ,chr( 11) ,
	 chr( 12) ,chr( 13) ,chr( 14) ,chr( 15) ,chr( 16) ,chr( 17) ,
	 chr( 18) ,chr( 19) ,chr(  0) ,chr(  0) ,chr(  8) ,chr(  0) ,
	 chr( 24) ,chr( 25) ,chr(  0) ,chr(  0) ,chr( 28) ,chr( 29) ,
	 chr( 30) ,chr( 31) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr( 10) ,chr( 23) ,chr( 27) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  5) ,chr(  6) ,chr(  7) ,
	 chr(  0) ,chr(  0) ,chr( 22) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  4) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr( 20) ,chr( 21) ,chr(  0) ,chr( 26) ,chr( 32) ,chr(  0) ,	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) $	 chr(  0) ,chr(  0) ,chr( 91) ,chr( 46) ,chr( 60) ,chr( 40) $	 chr( 43) ,chr( 33) ,chr( 30! ,chr(  0) ,chr(  0) ,chr(  0) $	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) $	 chr( 93) ,chr( 36) ,chr( 42) ,chr( 41) ,chr( 59! ,chr( 94) ,	 chr( 45) ,chr( 47) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(124) ,chr( 44) ,	 chr( 37) ,chr( 95) ,chr( 62) ,chr( 63) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr( 96) ,chr( 58) ,chr( 35) ,chr( 64) ,chr( 39) ,
	 chr( 61) ,chr( 34) ,chr(  0) ,chr( 97) ,chr( 98) ,chr( 99) ,
	 chr(100) ,chr(101) ,chr(102) ,chr(103) ,chr(104) ,chr(105) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(106) ,chr(107) ,chr(108) ,chr(109) ,chr(110) ,
	 chr(111) ,chr(112) ,chr(113) ,chr(114) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(126) ,
	 chr(115) ,chr(116) ,chr(117) ,chr(118) ,chr(119) ,chr(120) ,
	 chr(121) ,chr(122) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(123) ,chr( 65) ,chr( 66) ,chr( 67) ,chr( 68) ,chr( 69) ,
	 chr( 70) ,chr( 71) ,chr( 72) ,chr( 73) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(125) ,chr( 74) ,
	 chr( 75) ,chr( 76) ,chr( 77) ,chr( 78) ,chr( 79) ,chr( 80) ,
	 chr( 81) ,chr( 82) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr( 92) ,chr(  0) ,chr( 83) ,chr( 84) ,
	 chr( 85) ,chr( 86) ,chr( 87) ,chr( 88) ,chr( 89) ,chr( 90) ,
	 chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,chr(  0) ,
	 chr( 48) ,chr( 49) ,chr( 50) ,chr( 51) ,chr( 52) ,chr( 53) ,
	 chr( 54) ,chr( 55) ,chr( 56) ,chr( 57) ,chr(255) ,chr(  0) ,
	 chr(  0) ,chr(  0) ,chr(  0)  )  ;

    Begin
	getblk( tapebuff[1],buffcount*buffsize,in_lun,0,errcode );
	if errcode = 0 then j := recount else j := 0 ;
	getblk( tapebuff[2],(buffcount-1)*buffsize,in_lun,0,errcode );
	i := rewind( in_lun ) ;
	if ( j = ansi_labelsize ) and ( errcode = err_eof )
	 then
	  begin
	   writeln ;
	   if     ( tapebuff[1][0] = 'V' ) and ( tapebuff[1][1] = 'O')
	      and ( tapebuff[1][2] = 'L' )
	    then
	     begin
	      write('Input tape is ANSI labeled.',nl,'Volume is    ',nl) ;
	      for i := 0 to 79 do write(tapebuff[1][i])
	     end
	    else
	     if    ( etb[ord( tapebuff[1][0] )] = 'V' )
	       and ( etb[ord( tapebuff[1][1] )] = 'O' )
	       and ( etb[ord( tapebuff[1][2] )] = 'L' )
	      then
	       begin
	        write('Input tape is IBM labeled.',nl,'Volume is    ',nl) ;
		for i := 0 to 79 do write(etb[ord(tapebuff[1][i])])
	       end;
	   writeln; break(output)
	  end
  End { check_volume } ;
{$L-}

{ Variable record length input/output routines }



  Procedure PUTREC( var buff : array [1..buffcount] of dskblock ;
		    recordsize : integer ; flushit : boolean ;
		    var errcode: integer ) ;

    var p1,p2,i : integer ;


    Procedure PUTC( ch : char ) ;
      var i : integer ;

      begin
	errcode := 0       ;
	i := dkbuff.bufpnt ;
	if i > dkbuffsize - 1 then
	 begin
	  putblk( dkbuff.bf,dkbuffsize,out_lun,dkbuff.blknum,errcode ) ;
	  dkbuff.blknum := dkbuff.blknum + ( dkbuffsize / buffsize ) ;
	  i := 0 
	 end ;
	if errcode = 0 then
	 begin
	  dkbuff.bf[i] := ch   ;
	  dkbuff.bufpnt := succ( i )
	 end

    end { PUTC } ;



    begin
	errcode   := 0 ;
	if flushit 
	 then
	  begin
	   for i := 1 to 4 do putc( null ) ;
	   i := dkbuff.bufpnt ;
	   while i < dkbuffsize - 1 do
	    begin
	     dkbuff.bf[ i ] := null ;
	     i := succ( i )
	    end ;
	   putblk( dkbuff.bf,dkbuffsize,out_lun,dkbuff.blknum,errcode ) 
	  end
	 else
	  begin
	   putc( chr( recordsize mod 256 ) ) ;
	   putc( chr( recordsize div 256 ) ) ;
	   i := 0 ;
	   while ( i < recordsize ) and ( errcode = 0 )
	    do
	     begin
	      putc( buff[1][i] ) ;
	      i := succ( i )
	     end 
	  end

  end { putrec } ;

{ Variable record length input/output routines }


  Procedure GETREC( var buff:array [1..buffcount] of dskblock ; 
		    maxsize :integer;var bytecount,errcode :integer );

    var p1,p2,recordsize,i : integer ;


    Function getc : char ;
      var i : integer ;

      begin
	with dkbuff do
	begin
	  i := bufpnt ;
	  if i >= xrbc then
	   begin
	    getblk( bf,dkbuffsize,in_lun,blknum,errcode ) ;
	    blknum :=blknum + (dkbuffsize / buffsize ) ; 
	    xrbc := recount ;
	    i := 0 
	   end ;
	  if errcode = err_eof then getc := null ;
	  if errcode = 0 then
	   begin
	    getc := bf[i] ;
	    bufpnt := succ( i )
	   end
	end

    end { GETC } ;



    begin
	errcode   := 0 ;
	bytecount := 0 ;
	p1 := ord( getc ) ; p2 := ord( getc ) ;
	recordsize := p1 + 256 * p2 ;
	i := 0 ;
	while ( i < recordsize ) and ( errcode = 0 )
	 do
	  begin
	   buff[1][i] := getc ;
	   i := succ( i )
	  end ;
	bytecount := i

  end { getrec } ;


  Procedure Dkbuffer_init( read_mode : boolean )  ;

    begin
	with dkbuff do
	 begin
	  blknum := 1 ; bufpnt := 0 ; xrbc := 0 ;
	  if read_mode then bufpnt := dkbuffsize
	 end

  end { Dkbuffer_init } ;

  Procedure foreigntape_to_Disk ;

    Begin

	end_of_tape := false ; end_of_file := false ;
	blockcount  := 0     ; errcode   := 0 ;
	filecount   := 0     ; ignore_datacheck := true ;
	dkbuffer_init( false ) ;

      { Put out some identification header information first }

	tapebuff[1][1] := 'T'  ; tapebuff[1][2] := 'C' ;
	tapebuff[1][0] := 'V'  ; tapebuff[1][3] := version ;
	for i := 4  to 12 do tapebuff[1][i] := sysdate[i-3] ;
	for i := 13 to 21 do tapebuff[1][i] := systime[i-12] ;
	putrec( tapebuff,22,false,errcode ) ;


     {	Now comes the real work, reading each block from the tape
	and writing the record to disk, writing null  records  to
	indicate a tape mark (end of file)			  }


	check_volume ;
	if detachit then detach ;
	while ( errcode = 0 ) and not end_of_tape do
	begin

	 getblk( tapebuff[1],buffsize*buffcount,in_lun,0,errcode ) ;
	 bytecount := recount ;
	 if     (  errcode = 0 )
	    or  (( errcode = err_datacheck ) and ignore_datacheck )
	  then
	   begin
	    end_of_file := false ;
	    blockcount := succ( blockcount );
	    if errcode <> 0 then dataerror ;
	    errcode := 0 ;
	    putrec( tapebuff,bytecount,false,errcode ) 
	   end
	  else
	   begin
	    if errcode = err_eof
	     then
	      begin
	       errcode := 0 ;
	       putrec( tapebuff,0,false,errcode ) ;
	       end_of_tape := end_of_file ;
	       if not end_of_tape then filecount := succ( filecount ) ;
	       end_of_file := true
	      end
	     else
	       errprint( errcode )
	   end 
	end;

	putrec( tapebuff,0,true,dummy01 ) ;
	if not end_of_tape then errprint(errcode) 

  end { foreigntape_to_Disk }  ;




  Procedure Disk_to_foreigntape ;

    Begin

	end_of_tape := false ; end_of_file := false ;
	blockcount  := 0     ; errcode   := 0 ;
	filecount   := 0     ; ignore_datacheck := true ;
	dkbuffer_init( true ) ;

	getrec( tapebuff,buffcount*buffsize,bytecount,errcode ) ;
	if	 ( tapebuff[1][0] = 'V' )
	     and ( tapebuff[1][1] = 'T' ) 
	     and ( tapebuff[1][2] = 'C' ) 
	     and ( bytecount = 22 )
	 then
	 begin
	  if not detached then
	   begin
	    write(nl,'Tape format is FOREIGN' );
	    write(nl,'Image  file id date is   ');
	    for i := 4  to 12 do write(tapebuff[1][i]);
	    write(' ':5);
	    for i := 13 to 21 do write(tapebuff[1][i]);
	    writeln(nl); break(output)
	   end ;
	  if detachit then detach ;

	  while ( errcode = 0 ) and not end_of_tape do
	  begin

	   getrec( tapebuff,buffcount*buffsize,bytecount,errcode ) ;
	   if bytecount = 0
	    then
	     begin
	      end_of_tape := end_of_file ;
	      if not end_of_tape then filecount := succ( filecount ) ;
	      end_of_file := true ;
	      dummy01 := write_eof( out_lun )
	     end
	    else
	     begin
	      if errcode = 0 then
	       putblk( tapebuff[1],bytecount,out_lun,0,errcode ) ; 
	      end_of_file := false ;
	      blockcount := succ( blockcount )
	     end
	  end;

	  dummy01 := write_eof( out_lun ) ;
	  if not end_of_tape then errprint(errcode) 
	 end
	else writeln(nl,'Var len disk image file not TC format',nl)

  end { Disk_to_foreigntape } ;

{$L-}
  Procedure dostape_to_disk ;

    Var i,j : integer ;
        newlabel : boolean ;

    Begin

	errcode := 0 ;
	newlabel    := true  ;
	end_of_tape := false ; end_of_file := false ;
	blockcount  := 0     ; filecount   := 0 ;
	blocknum    := 0     ; buffernum   := 1 ;
	ignore_datacheck := true ;
	for i := 0 to index_size - 1 do fileloc[i] := 0 ;
	if detachit then detach ;


	while ( errcode = 0 ) and not end_of_tape do
	begin

	 getblk( tapebuff[buffernum],buffsize,in_lun,0,errcode ) ;
	 bytecount := recount ;
	 if     (  errcode = 0 )
	    or  (( errcode = err_datacheck ) and ignore_datacheck )
	  then
	   begin
	    end_of_file := false ;
	    blockcount := succ( blockcount );
	    if errcode <> 0 then dataerror ;
	    errcode := 0 ;
	    if ( bytecount = dos_labelsize ) and newlabel
	     then
	      begin
	       newlabel  := false ;
	       filecount := succ( filecount ) ;
	       fileloc[ filecount ] := blockcount
	      end 
	     else
	      begin
	       while bytecount < buffsize do
	        begin
	         tapebuff[buffernum][bytecount] := null ;
		 bytecount := succ( bytecount )
		end
	      end;
	    outdisk( false )
	   end
	  else
	   begin
	    if errcode = err_eof
	     then
	      begin
	       errcode := 0 ;
	       newlabel := true ;
	       end_of_tape := end_of_file ;
	       end_of_file := true
	      end
	     else
	       errprint( errcode )
	   end 
	end;

	outdisk( true ) ;
	fileloc[ filecount + 1 ] := blocknum ;
	fileloc[0] := filecount ;
	j := filelabelsize ;
	for i := 0 to index_size - filelabelsize - 1 do
	 begin
	  tapebuff[1][j] := chr( fileloc[i] mod 256 );
	  tapebuff[1][j+1] := chr( fileloc[i] div 256 );
	  j := j + 2
	 end ;
	for i := 0 to filelabelsize-1 do tapebuff[1][i] := space ;
	tapebuff[1][1] := 'T' ; tapebuff[1][2] := 'C' ;
	tapebuff[1][3] := version ;
	for i := 4  to 12 do tapebuff[1][i] := sysdate[i-3] ;
	for i := 13 to 20 do tapebuff[1][i] := systime[i-12] ;
	putblk( tapebuff[1],index_size*2,out_lun,1,dummy01 ) ;
	if dummy01 <> 0 then
	 begin
	  write('? Fatal error on index write -- ') ;
	  errprint( dummy01 ); writeln ; break(output)
	 end;
	if not end_of_tape then errprint(errcode) 

  end    {dostape_to_disk} ;



  Procedure DISK_to_DOSTAPE ;

    Var i,j,low,hi,errc,blocks  : integer ;
        number_of_files         : integer ;
	filetype		: boolean ;

    Begin

	errcode := 0 ;
	end_of_tape := false ; end_of_file := false ;
	blockcount  := 0     ; filecount   := 0 ;
	blocknum    := 0     ; buffernum   := buffcount;
	getblk(tapebuff[1],index_size*2,in_lun,1,errcode) ;
	if errcode <> 0
	 then
	  errprint( errcode )
	 else
	  begin
	   j := filelabelsize ;
	   for i := 0 to index_size - filelabelsize - 1 do
	    begin
	     low := ord( tapebuff[1][j] ) ;
	     hi  := ord( tapebuff[1][j+1] ) ;
	     fileloc[i] := low + 256 * hi ;
	     j := j + 2
	    end ;
	   number_of_files := fileloc[0] ;
	   filetype :=     ( tapebuff[1][0] = ' ' )
		       and ( tapebuff[1][1] = 'T' ) 
		       and ( tapebuff[1][2] = 'C' ) ;


	   if filetype then
	    begin
	     writeln(nl,'Tape format is  DOS');
	     writeln('Total file count is ',number_of_files,nl);
	     write('Image  file id date is   ');
	     for i := 4  to 12 do write(tapebuff[1][i]);
	     write(' ':5);
	     for i := 13 to 21 do write(tapebuff[1][i]);
	     writeln(nl); break(output);
	     if detachit then detach ;
	     errc := 0 ;

	     while  ( filecount < number_of_files ) and ( errc = 0 ) do
	      begin
	       filecount := succ( filecount ) ;
	       blocks    := fileloc[filecount+1] - fileloc[filecount]-1;
	       i := indisk ;
	       putblk( tapebuff[i],dos_labelsize,out_lun,0,errc ) ;
	       if errc = 0
	        then
	         begin
		  i := 1 ; errc := 0 ;
		  while ( i <= blocks ) and ( errc = 0 ) do
		  begin
		   putblk( tapebuff[indisk],buffsize,out_lun,0,errc );
		   i := succ( i ) ;
		   blockcount := succ( blockcount )
		  end ;
	          errcode := errc ;
	          i := write_eof( out_lun )
	         end
	        else
	         errcode := errc;
	      j := succ( j ) 
	     end ;
	    if errc <> 0 then errcode := errc ;
	    j := write_eof( out_lun ) ;
	    j := write_eof( out_lun )

	   end
	    else writeln('? Input file was not created by TC')
	  end 


  end {DISK_to_DOSTAPE} ;


  Procedure TAPE_TO_TAPE ;

    Begin

      errcode := 0 ;
      filecount  := 0 ;
      blockcount := 0 ;
      end_of_tape := false ;
      end_of_file := false ;
      ignore_datacheck := true ;
      if detachit then detach ;


      while ( errcode = 0 ) and not end_of_tape do
       begin

	getblk( tapebuff[1],buffsize*buffcount,in_lun,0,errcode ) ;
	bytecount := recount ;
	if errcode = 0 then 
	  begin
	   end_of_file := false ;
	   putblk( tapebuff[1],bytecount,out_lun,0,errcode );
	   blockcount := succ( blockcount )
	  end 
	  else
	  begin
	   if errcode = err_eof
	    then
	     begin
	      junk := write_eof( out_lun ) ;
	      errcode := 0 ;
	      end_of_tape := end_of_file ;
	      if not end_of_tape then filecount := succ( filecount );
	      end_of_file := true 
	     end
	    else
	     begin
	      if ( errcode = err_datacheck ) and ignore_datacheck
		then
		begin
		 putblk( tapebuff[1],bytecount,out_lun,0,errcode );
		 blockcount := succ( blockcount ) ;
		 dataerror
		end
	     end
	  end


      end

  end { tape_to_tape } ;

  Procedure disk_to_disk ;

    Const
	rk05_size = 4800 ;
	rk05_devcluster = 1 ;
    Var
        i,j,errc : integer ;

    Begin
	if  ( indevice[2] = 'K' ) and ( outdevice[2] = 'K' )
         then
          begin
	   if detachit then detach ;
	   j := 0 ; errc := 0 ;
	   while  ( j < rk05_size ) and ( errc = 0 ) do
            begin
             getblk( tapebuff[1],buffcount*buffsize,in_lun,j,errc ) ;
             if errc = 0 then
              putblk( tapebuff[1],buffcount*buffsize,out_lun,j,errc ) ;
             j := j + buffcount div rk05_devcluster
            end ;
           errcode := errc ;
	   filecount  := 1 ;
	   blockcount := j ;
          end
         else
           writeln('Input and output must be RK05 type disk',nl)

  end  {disk_to_disk} ;


  Procedure TAPE_to_DISK ;

    begin
	if dostape then dostape_to_disk
		   else foreigntape_to_disk
  end ;

  Procedure DISK_to_TAPE ;

    begin
	getblk( tapebuff[1],512,in_lun,1,errcode ) ;
	if errcode = 0 then
	 begin
	  if ( tapebuff[1][0] = chr(22) ) and ( tapebuff[1][2] = 'V' )
	   then
	    disk_to_foreigntape
	   else
	    disk_to_dostape
	 end
  end { disk_to_tape } ;

  begin

      dattim( sysdate, systime ) ;
      writeln(nl,programname,version,nl) ; break(output) ;
      openfiles ;
      if    ( outtype.devindex = devindex_disk )
	and ( intype.devindex  = devindex_tape )
	then
	 begin
	  write('Dos tape <Yes>  ? ');break(output);
	  read(ch) ;
	  dostape := not (( ch = 'N' ) or ( ch = 'n' ) ) ;
	  while ch <> nl do read(ch)
	 end ;

      check_density( out_lun ) ;
      write('Detach job <NO> ? ') ; break(output) ;
      read(ch) ;
      detached := false ;
      detachit :=  ( ch = 'Y' ) or ( ch = 'y' )  ;
      junk := rewind( in_lun ) ; junk := rewind( out_lun ) ;
      errorcount := 0 ;

      case intype.devindex of

	devindex_tty , devindex_tu56 , devindex_lp ,
	devindex_cr  , devindex_pk   , devindex_flop ,
	devindex_null:
	  writeln('? Illegal input device for TC',nl) ;

	devindex_tape:
	 begin
	  if outtype.devindex = devindex_disk
	   then
	    tape_to_disk
	   else
	    if outtype.devindex = devindex_tape
	     then
	      tape_to_tape
	     else
	      writeln('Output MUST be to DISK or TAPE, please.')
	 end ;

	devindex_disk:
	 begin
	  if outtype.devindex = devindex_tape
	   then
	    disk_to_tape
	   else
	    if outtype.devindex = devindex_disk
	     then
	      disk_to_disk
	     else
	      writeln('Output to disk or tape only.')
	 end 

      end ;
      If errcode <> 0 then errprint( errcode ) ;



      writeln('Termination. ',blockcount:6,'  records copied') ;
      writeln(' ':13,filecount:6, '  files   copied') ;
      if    ( outtype.devindex = devindex_tape )
	 or ( intype.devindex  = devindex_tape )
       then writeln(' ':13,errorcount:6,'  Magtape errors',nl) ;
      junk := rewind( in_lun ) ; junk := rewind( out_lun) 
end.
                                                                                                                  