#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * RSX-11M V3.2 Executive C Extensions Library -- PLAS Demo.
 *
 * Task 'B'  --  Receiver
 *
 * Bob Denny
 * 14-Jun-80
 *
 */

#include <stdio.h>
#include <cx.h>			/* Must precede the next 2 */
#include <rdbdf.h>
#include <wdbdf.h>

/*
 * Static Declarations
 */

struct rdb region;		/* Region Definition Block */
struct wdb window;		/* Window Definition Block */

/*
 * Directive error procedure.
 */

direrr(msg)
char *msg;
  {
  printf("<B> %s $DSW = %d\n", msg, $dsw);
  exitt();
  }

/*
 * Main program.
 */

main()
  {
  struct 	{			/* 10 word buffer */
		struct rad50 sndtsk;
		int data[8];
		} rbuf;
  char sender[8];

					/* Set up for 1KW window with APR7 */
  window.w_napr = 7;
  window.w_nsiz = 040;
  window.w_noff = 0;
  window.w_nlen = 0;
  window.w_nsts = WS_WRT;		/* Ask for write access */
  window.w_nsrb = &rbuf;

  if( craw(&window) < 0 )
    direrr("CRAW error.");

					/* Attempt to receive reference */
  window.w_nsts |= WS_MAP;		/* Request auto map */
  if( rref(&window) < 0 )
    direrr("RREF error.");
  else
    {					/* OK, Display what happened */
    puts("<B> Receive OK");
    printf("<B> Window Status = %06o\n", window.w_nsts);
    r50toa(sender, &(rbuf.sndtsk), 2);
    sender[6] = 0;			/* Make sender name a string */
    printf("<B> Sender task: %s\n", sender);
    printf("<B> Message:\n%s\n\n",window.w_nbas);
    }
  }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       