	SUBROUTINE ADBASH (H,X,N,YIP1,YI,YIM1,YIM2,YIM3,F,G)
C
C---------------------------------------------------------------------
C
C	Subroutine for performing one step in the solution of a
C	system of first-order differential equations by the
C	Adams-Bashford method.
C
C	H  is the step size
C	X  is the initial value of the independent variable
C	N  is the number of dependent variables (or equations)
C	YIP1 is an array of values to be calculated
C	YI   is an array of values from the previous time step
C	YIM1 is an array of values from two time steps before
C	YIM2 is an array of values from three time steps before
C	YIM3 is an array of values from four time steps before
C	F,G are arrays dimensioned at least N to be supplied by
C	   the calling program.  They are scratch arrays used for
C	   intermediate calculations.
C
C	The initial values of the arrays YI, YIM1, YIM2, and YIM3
C	must be supplied by the user by some other method.  The
C	subroutine KUTSIM, which requires only the starting value
C	can be used to compute the starting values at the next
C	three time steps.
C
C	The arrays YI, YIM1, YIM2, YIM3 are updated one time step
C	before exit from this subroutine.
C
C	The user must supply a function evaluation routine
C		SUBROUTINE FUNC (F, X, Y)
C	that returns the values of the N derivative functions in 
C	the vector F.
C
C	Written by Robert Walraven		9 Oct 81
C	           Applied Science
C	           Univ. of Calif., Davis 95616
C	           (916) 752-0360
C
C---------------------------------------------------------------------
C
	DIMENSION YIP1(1),YI(1),YIM1(1),YIM2(1),YIM3(1),F(1),G(1)
C
	H24 = H/24.
	CALL FUNC (F, X, YI)
	DO 10 I=1,N
	G(I) = 55. * F(I)
10	YIP1(I) = 19. * F(I)
	CALL FUNC (F, X-H, YIM1)
	DO 20 I=1,N
	G(I) = G(I) - 59. * F(I)
20	YIP1(I) = YIP1(I) - 5. * F(I)
	CALL FUNC (F, X-2.*H, YIM2)
	DO 30 I=1,N
	G(I) = G(I) + 37. * F(I)
30	YIP1(I) = YIP1(I) + F(I)
	CALL FUNC (F, X-3.*H, YIM3)
	DO 40 I=1,N
40	G(I) = YI(I) + H24 * (G(I)-9.*F(I))
	CALL FUNC (F, X+H, G)
	DO 50 I=1,N
	YIP1(I) = YI(I) + H24 * (YIP1(I)+9.*F(I))
50	YIP1(I) = (19.*G(I)+251.*YIP1(I))/270.
	DO 60 I=1,N
	YIM3(I) = YIM2(I)
	YIM2(I) = YIM1(I)
	YIM1(I) = YI(I)
60	YI(I) = YIP1(I)
	RETURN
	END
                                                                                                                                                                                                                                                                                               