#include	<sy:std.h>
#include	<sy:rt11.h>

#define	MEMSIZE	4096
#define	TYPEL	10
#define DEFPRM	"2516"

struct filopt
{
	BOOL	echo;
	COUNT	start;
	COUNT	count;
	COUNT	col;
	COUNT	base;
	BOOL	and;
	COUNT	titles;
	BOOL	high;
	BOOL	low;
	COUNT	words;
	TEXT	filnam[15];
};
struct prmopt
{
	BOOL	echo;
	COUNT	start;
	COUNT	count;
	COUNT	type;
};
struct memopt
{
	BOOL	echo;
	COUNT	start;
	COUNT	count;
	UTINY	a[MEMSIZE];
};
TEXT	*flist[] = {	"START",
			"COUNT",
			"COLUMNS",
			"BASE",
			"AND",
			"TITLES",
			"ECHO",
			"HIGH",
			"LOW",
			"WORDS",
			"NAME"
			""};
TEXT	*prmlst[] = {	"START",
			"P",
			"TYPE",
			"ECHO",
			""};
TEXT	*memlst[] = {	"START",
			"A",
			"ECHO",
			""};
TEXT	*oufmt[17][2] = {"**","**",
			"**","**",
			"%+08b","%+016b",
			"","",
			"","",
			"","",
			"","",
			"","",
			"%+03b","%+07b",
			"","",
			"","",
			"","",
			"","",
			"","",
			"","",
			"","",
			"%+02b","%+04b"
			};

TEXT	s[132] = 0;
COUNT	ns = 0;

TEXT	*rs = 0;	/*right side buffer*/
COUNT	nrs = 0;	/*length*/
COUNT	tr = 0;		/*type 0 = none, 1 = mem, 2 = prom, 3 = file*/

TEXT	*ls = 0;	/*left side buffer*/
COUNT	nls = 0;	/*length*/
COUNT	tl = 0;		/*type 0 = none, 1 = mem, 2 = prom, 3 = file*/

struct	filopt	strfr = 0;
struct	filopt	strfl = 0;
struct	prmopt	strpr = 0;
struct	prmopt	strpl = 0;
struct	memopt	strm = 0;
TEXT	*_prmpt = 0;
main()
{
	COUNT	i;
	errfmt("*");
	inimem(&strm);
	FOREVER
	{
		ns = getlin(s,132);
		ns--;
		if(ns > 0)
		{
			s[ns] = '\0';
			for(i = 0; i < ns; i++)
				s[i] = toupper(s[i]);
			proc(s,ns);
		}
		else if(ns < 0)
		{	/*intercept ^Z*/
			break;
		}
		else
		{
			errfmt("LEE MERRICK & ASSOCIATES PROM\n");
		}
		errfmt("\r*");
	}
}
proc(s,ns)
TEXT	*s;
COUNT	ns;
{
	TEXT	*pp = 0;
	COUNT	i = 0;
	COUNT	len = 0;
	COUNT	k;
	COUNT	fub = 0;
	if((k = scnbuf(s,ns,'=')) < ns)
	{
		ls = s;
		nls = k;
		s[k] = '\0';
		rs = &s[k+1];
		nrs = ns - k - 1;
		if(len = getopt(ls,nls,0,&pp))
		{
			tl = typget(&strfl,&strpl,&strm,pp,lenstr(pp));
		}
		if(len = getopt(rs,nrs,0,&pp))
		{
			tr = typget(&strfr,&strpr,&strm,pp,lenstr(pp));
		}
		if(tl == 1 && tr == 1)
			errfmt("two mems\n");
		else if(tl == 1 && tr == 2)
		{
			if(!ptom(&strm,&strpr))/*prom to memory*/
			{
				errfmt("error\n");
				return(0);
			}
		}
		else if(tl == 1 && tr == 3)
		{
			if(!(i = ftom(&strm,&strfr)))
			{/*file to memory*/
				errfmt("file open failed\n");
				return(0);
			}
			else
				errfmt("%i bytes read.\n",i);
		}
		else if(tl == 2 && tr == 1)
		{
			if(!mtop(&strpl,&strm))/*memory to prom*/
			{
				errfmt("error\n");
				return(0);
			}
		}
		else if(tl == 2 && tr == 2)
			errfmt("two proms\n");
		else if(tl == 2 && tr == 3)
		{
			if((i = ftom(&strm,&strfr)) < 0)
			{/*file to memory*/
				errfmt("file open failed\n");
				return(0);
			}
			errfmt("%i bytes read.\n",i);
			strm.count = i;
			if(!mtop(&strpl,&strm))/*memory to prom*/
			{
				errfmt("error\n");
				return(0);
			}

		}
		else if(tl == 3 && tr == 1)
		{
			mtof(&strfl,&strm);
		}
		else if(tl == 3 && tr == 2)
		{
			inimem(&strm);
			if(!ptom(&strm,&strpr))/*prom to memory*/
			{
				errfmt("error\n");
				return(0);
			}
			mtof(&strfl,&strm);
		}
		else if(tl == 3 && tr == 3)
		{
			inimem(&strm);
			ftom(&strm,&strfr);	/*file to memory*/
			mtof(&strfl,&strm);
		}
		else
		{
			errfmt("illegal operation\n");
		}
	}
	else
	{
		if(s[0] == 'E' && s[1] == ' ')
			errfmt("examine\n");
		else if(s[0] == 'D' && s[1] == ' ')
			errfmt("deposit\n");
		else if(s[0] == 'V' && s[1] == ' ')
			errfmt("verify\n");
		else if(ns && cmpbuf(s,"HELP ",ns))
		{
			errfmt("HELP\n");
			errfmt("----\n");
			errfmt("\n");
			errfmt("FILE OPTIONS\n");
			errfmt("------------\n");
			errfmt("START:nn      starting byte in file\n");
			errfmt("COUNT:nn      number of bytes to read\n");
			errfmt("COLUMNS:nn    number of columns\n");
			errfmt("BASE:nn       base of data\n");
			errfmt("AND           not working yet\n");
			errfmt("TITLES:nn     base of titles\n");
			errfmt("               0 = no titles\n");
			errfmt("ECHO          shows memory contents\n");
			errfmt("HIGH          not working yet\n");
			errfmt("LOW           not working yet\n");
			errfmt("WORDS         not working yet\n");
			errfmt("NAME          not working yet\n");
			errfmt("\n");
			errfmt("PROM OPTIONS\n");
			errfmt("------------\n");
			errfmt("Connect prom burner to port 1.(console is port 3)\n");
			errfmt("P:nn          number of bytes\n");
			errfmt("START:nn      starting byte\n");
			errfmt("TYPE:nn       type of prom\n");
			errfmt("ECHO          echo prom replies\n");
			errfmt("               0 2716\n");
			errfmt("               1 2516\n");
			errfmt("               2 2758\n");
			errfmt("               3 2508\n");
			errfmt("               4 2532\n");
			errfmt("               5 2732\n");
			errfmt("               6 MCM68764\n");
			errfmt("\n");
			errfmt("MEMORY OPTIONS\n");
			errfmt("------------\n");
			errfmt("A:nn          number of bytes\n");
			errfmt("START:nn      starting byte\n");
			errfmt("ECHO          shows memory contents\n");
		}
	}
	return(1);
}
typget(strf,strp,strm,s,ns)
struct	filopt	*strf;
struct	memopt	*strp;
struct	prmopt	*strm;
TEXT	*s;
COUNT	ns;
{
	TEXT	*pp;
	COUNT	len;
	COUNT	m;
	COUNT	ty = 0;
	COUNT	i;
	if(cmpbuf(s,"A:",2) || cmpbuf(s,"A/",2) || (s[0] == 'A' && ns == 1))
	{
		i = 0;
		while(len = getopt(s,ns,i,&pp))
		{
			if((m = memopt(pp,len,strm,memlst)) < 0)
			break;
			i++;
		}
		if(m >= 0)
		{
			ty = 1;
		}
	}
	else if(cmpbuf(s,"P:",2)||cmpbuf(s,"P/",2)||(s[0] == 'P' && ns == 1))
	{
		iniprm(strp);
		i = 0;
		while(len = getopt(s,ns,i,&pp))
		{
			if((m = prmopt(pp,len,strp,prmlst)) < 0)
				break;
			i++;
		}
		if(m >= 0)
		{
			ty = 2;
		}
	}
	else 
	{
		inifil(strf);
		if(len = getopt(s,ns,0,&pp))
		{
			len = min(14,len);
			cpybuf(strf->filnam,pp,len);
			(strf->filnam)[len] = '\0';
			if(!namchk(strf->filnam))
			{
				return(0);
			}
		}
		i = 1;
		m = 0;
		while(len = getopt(s,ns,i,&pp))
		{
			if((m = filopt(pp,len,strf,flist)) < 0)
				break;
			i++;
		}
		if(m >= 0)
		{
			ty = 3;
		}
	}
	return(ty);
}
filopt(s,n,pfld,list)
TEXT	*s;
COUNT	n;
struct	filopt	*pfld;
TEXT	**list;
{
	COUNT	i;
	COUNT	m;
	TEXT	*pp;
	COUNT	val;
	COUNT	len;

	/*set given value*/
	i = getnop(s,n);
	if((m = matopt(s,i,list)) < 0)
	{
		if(m == -3)
		{
			errfmt("ambiguous option: %b\n",s,i);
			return(-2);
		}
		else if(m == -2)
		{
			errfmt("illegal option: %b\n",s,i);
			return(-2);
		}
		else
		{
			return(0);
		}
		
	}
	switch(m) {
	case 0:	/*start*/
		if(getiop(s,n,&val))
		{
			pfld->start = val;
		}
		break;
	case 1:	/*count option */
		if(getiop(s,n,&val))
		{
			pfld->count = val;
		}
		break;
	case 2:	/*columns*/
		if(getiop(s,n,&val))
		{
			pfld->col = val;
		}
		break;
	case 3:	/*base*/
		if(getiop(s,n,&val))
		{
			pfld->base = val;
		}
		break;
	case 4:	/*and in data*/
		pfld->and = YES;
		break;
	case 5:	/*titles*/
		if(getiop(s,n,&val))
		{
			pfld->titles = val;
		}
		else
			pfld->titles = 8;
		break;
	case 6:	/*echo lines*/
		pfld->echo = YES;
		break;
	case 7:	/*high bytes only*/
		pfld->high = YES;
		pfld->low = NO;
		break;
	case 8:/*low bytes only*/
		pfld->high = NO;
		pfld->low = YES;
		break;
	case 9:/*words instruction*/
		pfld->words = 1;
		break;
	case 10:	/* 'F' option*/
		if((len = getcop(s,n,&pp)) > 0)
		{
			len = min(14,len);
			cpybuf(pfld->filnam,pp,len);
			(pfld->filnam)[len] = '\0';
		}
		break;
	default:
		errfmt("nothing done\n");
		break;
	}
	return(1);
}
prmopt(s,n,pfld,list)
TEXT	*s;
COUNT	n;
struct	prmopt	*pfld;
TEXT	**list;
{
	COUNT	i;
	COUNT	m;
	COUNT	val;
	COUNT	len;

	/*set given value*/
	i = getnop(s,n);
	if((m = matopt(s,i,list)) < 0)
	{
		if(m == -3)
		{
			errfmt("ambiguous option: %b\n",s,i);
			return(-2);
		}
		else if(m == -2)
		{
			errfmt("illegal option: %b\n",s,i);
			return(-2);
		}
		else
		{
			return(0);
		}
	}
	switch(m) {
	case 0:	/*start*/
		if(getiop(s,n,&val))
		{
			pfld->start = val;
		}
		break;
	case 1:	/*'P' bytes*/
		if(getiop(s,n,&val))
		{
			pfld->count = val;
		}
		break;
	case 2:/*type of prom*/
		if(getiop(s,n,&val))
		{
			pfld->type = val;
		}
		break;
	case 3:/*echo*/
		pfld->echo = YES;
		break;
	default:
		errfmt("nothing done\n");
		break;
	}
	return(1);
}
memopt(s,n,pfld,list)
TEXT	*s;
COUNT	n;
struct	memopt	*pfld;
TEXT	**list;
{
	COUNT	i;
	COUNT	m;
	COUNT	stt;
	COUNT	val;
	COUNT	len;

	/*set given value*/
	i = getnop(s,n);
	if((m = matopt(s,i,list)) < 0)
	{
		if(m == -3)
		{
			errfmt("ambiguous option: %b\n",s,i);
			return(-3);
		}
		else if(m == -2)
		{
			errfmt("illegal option: %b\n",s,i);
			return(-2);
		}
		else
		{
			return(1);
		}
	}
	switch(m) {
	case 0:	/*start*/
		if(getiop(s,n,&val))
		{
			pfld->start = val;
		}
		break;
	case 1:	/*'A' bytes*/
		if(getiop(s,n,&val))
		{
			pfld->count = val;
		}
		break;
	case 2:/*echo*/
		pfld->echo = YES;
		break;
	default:
		errfmt("nothing done\n");
		break;
	}
	return(1);
}
inifil(pfld)
struct	filopt	*pfld;
{
	/*set default values*/
	pfld->echo = NO;
	pfld->start = 0;
	pfld->count = MEMSIZE;
	pfld->col = 16;
	pfld->base = 8;
	pfld->and = NO;
	pfld->titles = 8;
	pfld->high = NO;
	pfld->low = NO;
	pfld->words = 0;
	cpystr(pfld->filnam,"fub.out",NULL);
}
iniprm(pfld)
struct	prmopt	*pfld;
{
	/*set default values*/
	pfld->echo = NO;
	pfld->start = 0;
	pfld->count = MEMSIZE;
	pfld->type = 1;
}
inimem(pfld)
struct	memopt	*pfld;
{
	COUNT	i;
	/*set default values*/
	pfld->echo = NO;
	pfld->start = 0;
	pfld->count = MEMSIZE;
	for(i = 0; i < MEMSIZE; i++)
	{
		pfld->a[i] = 0377;
	}
}
oufil(pfld)
struct	filopt	*pfld;
{
	/*type values*/
	errfmt("*********************************\n");
	errfmt("start  = %i\n",pfld->start);
	errfmt("count  = %i\n",pfld->count);
	errfmt("col    = %i\n",pfld->col);
	errfmt("base   = %i\n",pfld->base);
	errfmt("and    = %i\n",pfld->and);
	errfmt("titles = %i\n",pfld->titles);
	errfmt("echo   = %i\n",pfld->echo);
	errfmt("high   = %i\n",pfld->high);
	errfmt("low    = %i\n",pfld->low);
	errfmt("words = %i\n",pfld->words);
	errfmt("filena = %p\n",pfld->filnam);
}
ouprm(pfld)
struct	prmopt	*pfld;
{
	/*type values*/
	errfmt("*********************************\n");
	errfmt("start = %i\n",pfld->start);
	errfmt("count = %i\n",pfld->count);
	errfmt("type  = %i\n",pfld->type);
}
oumem(pfld)
struct	memopt	*pfld;
{
	/*type values*/
	errfmt("*********************************\n");
	errfmt("start = %i\n",pfld->start);
	errfmt("count = %i\n",pfld->count);
}

ftom(pmem,pfil)
struct memopt	*pmem;
struct filopt	*pfil;
{
	static	FIO fio;
	BYTES	num;
	COUNT	i;
	COUNT	j;
	BYTES	*w;
	UTINY	*b;
	COUNT	nc;
	COUNT	len;
	COUNT	k;	
	static char outbuf[17];
	static char buf[17];

	if (!fopen(&fio,pfil->filnam,READ))
	{
		errfmt("can't open %p\n",pfil->filnam);
		return(-1);
	}
	w = &(pmem->a[0]);
	b = &(pmem->a[0]);

	pmem->count = pfil->count;
	nc = pmem->start + pfil->count;
	for(i = pmem->start; i < nc;)
	{
		if(pfil->titles)
		{
			if(len = getwrd(&fio,buf,17))
			{
				btoi(buf,len,&num,pfil->titles);
/*				errfmt("num title = %i\n",num);
*/
			}
			else
				return(i - pmem->start);
		}
		for(j = 0; j < pfil->col; j++)
		{
			if(len = getwrd(&fio,buf,17))
			{		
				btoi(buf,len,&num,pfil->base);
				if(pfil->words)
					w[i] = num;
				else
				{
					b[i] = (UTINY) num;
/*					errfmt("num = %ui\n",num);
					errfmt("i = %i\n",i);
*/
				}
				i++;
			}
			else
				return(i - pmem->start);
		}
	}
	fclose(&fio);
	return(i - pmem->start);
}

mtof(pfil,pmem)
struct filopt	*pfil;
struct memopt	*pmem;
{
	static	FIO fio;
	COUNT	i;
	COUNT	j;
	BYTES	*w;
	UTINY	*b;
	COUNT	nc;
	COUNT	len;
	COUNT	k;	
	static char outbuf[17];
	static char buf[17];

	if (!fcreate(&fio,pfil->filnam,WRITE))
	{
		errfmt("can't create %p\n",pfil->filnam);
		return(NO);
	}
	w = &(pmem->a[0]);
	b = &(pmem->a[0]);

	pfil->count = pmem->count;
	nc = pmem->start + pmem->count;
	for (i = pmem->start; i < nc; i++)
	{
		if (pfil->titles)
		{
			len = itob(outbuf,i%512,pfil->titles);
			for(k = 0; k < len; k++)
				outbuf[k] = toupper(outbuf[k]);
			len = decode(buf,17,"%+04b",outbuf,len);
			putf(&fio,"%b/ ",buf,len);
		}
		for (j = 0; j < pfil->col; j++, i++)
		{
			if (pfil->words)
			{
				len = itob(outbuf,w[i],pfil->base);
				for(k = 0; k < len; k++)
					outbuf[k] = toupper(outbuf[k]);
				len = decode(buf,17,oufmt[pfil->base][1],
					outbuf,len);
				putf(&fio,"%b",buf,len);
			}
			else
			{
				len = itob(outbuf,b[i],pfil->base);
				for(k = 0; k < len; k++)
					outbuf[k] = toupper(outbuf[k]);
				len = decode(buf,17,oufmt[pfil->base][0],
					outbuf,len);
				putf(&fio,"%b",buf,len);
			}
			if(j == pfil->col - 1 || i == nc - 1)
				break;
			else
				putf(&fio," ");
		}
		putf(&fio,"\n");
	}
	fclose(&fio);
	return(YES);
}
                                                                                                                                                                                                                                                                                                                                                                            