10 REM -- PROGRAM TO PRINT OUT BIORHYTHMS FOR ONE MONTH
20 REM    GIVEN A BIRTHDATE AND A MONTH
30 REM
40 DIM M9(12),L(3),V(4),C$(4),M$(12)
45 OPEN "CYCLES.DAT" FOR OUTPUT AS FILE VF1$(3813)=1
50 REM
60 REM -- CALCULATE JULIAN DAY BASED ON DATE
70 REM
80 DEF FNJ(D0,M0,Y0)=M9(M0)+D0+SGN(INT(M0/3))*(1+SGN(4*INT(Y0/4)-Y0))
110 REM
120 REM -- CALCULATE DAYS BETWEEN TWO JULIAN DATES
130 REM
140 DEF FND(J1,Y1,J2,Y2)=INT(Y2/4-1-INT(Y1/4))+J2-J1+365*(Y2-Y1)
180 REM
190 REM -- INITIALIZE THE ARRAYS
200 REM
210 READ D$\FOR I=1 TO 3\READ L(I)\NEXT I
220 FOR I=1 TO 4\READ C$(I)\NEXT I
230 FOR I=1 TO 12\READ M9(I)\NEXT I
240 FOR I=1 TO 12\READ M$(I)\NEXT I
250 DATA "-"
252 DATA 23,28,33
254 DATA "P","E","I","*"
260 DATA 0,31,59,90,120,151,181,212,243,273,304,334
270 DATA "JANUARY","FEBRUARY","MARCH","APRIL","MAY","JUNE","JULY"
280 DATA "AUGUST","SEPTEMBER","OCTOBER","NOVEMBER","DECEMBER"
290 PRINT "OUTPUT DEV:FILNAM.EXT";\INPUT F$
291 IF F$="" THEN 293 
292 GO TO 300 
293 LET F$="KB:"
300 OPEN F$ FOR OUTPUT AS FILE #1
310 REM
320 REM -- RESET ARRAY P$
325 REM
330 FOR J=1 TO 41
340 FOR I=1 TO 93\VF1(93*(J-1)+I)=" "\NEXT I
350 NEXT J
360 FOR I=1 TO 93
380 VF1(1860+I)="-"
390 NEXT I
400 REM
410 PRINT "INPUT BIRTHDATE IN FORMAT MMDDYY -- ";\INPUT #0:N$
415 B2=VAL(SEG$(N$,1,2))\B1=VAL(SEG$(N$,3,4))\B3=VAL(SEG$(N$,5,6))
420 PRINT "INPUT DESIRED MONTH IN FORMAT MMYY -- ";\INPUT #0:N$
425 C2=VAL(SEG$(N$,1,2))\C3=VAL(SEG$(N$,3,4))
430 REM
440 T0=FND(FNJ(B1,B2,B3),B3,FNJ(1,C2,C3),C3)
450 T=T0
460 REM
462 PRINT "NAME, PLEASE -- ";\INPUT #0:N$
463 PRINT "INPUT ANY MISCELLANEOUS COMMENT HERE. "\INPUT L$
464 PRINT \PRINT 
465 PRINT #1:TAB(50);N$
466 PRINT #1:,,L$\PRINT #1:
467 PRINT #1:,,"BIORHYTHM CHART FOR ";M$(C2);" ";C3+1900
468 PRINT #1:
469 PRINT #1:,,"CHARTING THE PHYSICAL     - P (23 DAY CYCLE)"
470 PRINT #1:,,"             EMOTIONAL    - E (28 DAY CYCLE)"
480 PRINT #1:,,"             INTELLECTUAL - I (33 DAY CYCLE)"
490 PRINT #1:,,"         AND OVERALL      - *"
491 PRINT #1:,"THESE CYCLES ARE BELIEVED TO OCCUR IN ";
492 PRINT #1:"EVERYONE, BEGINNING ON THE DAY OF THEIR BIRTH."
493 PRINT #1:\PRINT #1:,"NUMBER OF CYCLES SINCE BIRTH:  ";
500 FOR I=1 TO 3\PRINT #1:C$(I);" ";T/L(I),\NEXT I
510 PRINT #1:
520 REM
530 REM -- COMPUTE THE CYCLES AND SET ARRAY P$
540 REM
541 LET P=3.14159
550 FOR I=1 TO 93
560 FOR K=1 TO 3
561 LET V(K)=-20*SIN(T/L(K)*2*P)
562 NEXT K
570 V(4)=(V(1)+V(2)+V(3))/3
580 FOR K=1 TO 4
590 K0=INT(ABS(V(K)+.5)*SGN(V(K)))+21
600 VF1(93*(K0-1)+I)=C$(K)
610 NEXT K
620 T=T+1/3
630 NEXT I
640 REM
650 REM -- PRINT ARRAY P$
660 REM
670 PRINT #1:\PRINT #1:
680 FOR J=1 TO 41
690 PRINT #1:,"I ";
700 FOR I=1 TO 93\PRINT #1:VF1(93*(J-1)+I);\NEXT I
710 PRINT #1:
720 NEXT J
730 PRINT #1:,"I--+-----------+--------------+--------------+------";
740 PRINT #1:"--------+--------------+--------------+---"
750 PRINT #1:,"   1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17";
760 PRINT #1:" 18 19 20 21 22 23 24 25 26 27 28 29 30 31"
770 PRINT #1:\PRINT #1:\PRINT #1:\PRINT #1:TAB(48);M$(C2);" ";C3+1900
780 PRINT #1:CHR$(12)\CLOSE #1
790 END
                                                                                                                                                                                                                                                                                                                                                                                                                                  