/*+
 * VOID tfrmes(mess, field)
 *     TEXT  *mess, *field;
 *
 * Description  : Routine to put error message on screen
 *
 * Arguments    : mess  = STRING containing the message or null-string
 *                        If MESS is a null-string: the help-text for
 *                        the field will be displayed. In that case FIELD
 *                        must not be empty
 *                field = STRING containing the field name if MESS is a
 *                        null-string
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : TFRMES.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrmes.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrmes(mess, field)
    TEXT  *mess, *field;

    {
    IMPORT TFRCOM t;

#include <upddef.h>

    COUNT i, irec;
    COUNT *pf;

    pf = &t.frec;
/*
 *    check arguments
 */
    if((i = lenstr(mess)) > 0)
        {
        if(i > 2*t.maxbuf-1)
            {
            mess[2*t.maxbuf] = NULL;
            }
        cpystr(&t.sbuf, mess, NULL);
        }
    else if(lenstr(field) > 0  &&  t.nrfufr > 0)
        {
        scvtlu(field);
        for(i = t.nrfufr; i <= t.nrlufr; ++i)
            {
            tfrru(i, "VAR");              /* read update field record */
            if(cmpstr(field, pf->updfld))
                {
                irec = pf->nrhlp;
                if(irec == 0)
                    {
                    cpystr(&t.sbuf, "No help available", NULL);
                    }
                else
                    {
                    tfrfs(&irec);
                    }
                }
            }
        }
    else
        {
        error("TFRERR", "Field not found");
        }
    swrite(t.iscr, "+$", &t.herpos, &t.erlstr, &t.hlpatt, &t.sbuf,
           NULL);
    t.iheflg = TRUE;
    }
                                                                                                              