/*+
 * VOID swrits(unit, cc, string)
 *     TEXT *cc, *string;
 *     COUNT unit;
 *
 * Description  : This routine is used by the general routine SWRITE
 *
 * Arguments    : iunit  = unit number to write to
 *                cc     = two character control character string
 *                string = string to be written
 *
 * Author       : R. Beetz
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 26-oct-82
 *
 * Module name  : SWRITS.FOR
 *
 * Package      : RT11-LIBRARY
 *
 * Compilation/Linking : FORT/NOLINE SWRITS
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : swrits.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>

VOID swrits(unit, cc, string)
    TEXT *cc, *string;
    COUNT unit;

    {
    LOCAL TEXT  lf[] = "\n";
    BOOL lff;

    lff = TRUE;
    switch(cc[0])
        {
    case ' ':
        break;
    case '0':
        cwrite(unit, lf, 1);
        break;
    case '-':
        cwrite(unit, lf, 1);
        cwrite(unit, lf, 1);
        break;
    case '1':
        cwrite(unit, "\f", 1);
        lff = FALSE;
        break;
    case '+':
        lff = FALSE;
        break;
        }
    if(lff)
        {
        cwrite(unit, lf, 1);
        }
    cwrite(unit, string, lenstr(string));
    if(cc[1] != '$')
        {
        cwrite(unit, "\r", 1);
        }
    }
                                                                                                                                                                                                                                            