SENDRC.MAC
	.TITLE	SENDRC
	.IDENT	/790707/
; USED IN CONJUNCTION WITH TRANS.PAS AND RECVER.PAS
; TO ALLOW RT-11 FILES TO BE TRANSFERRED BETWEEN
; SYSTEMS OVER A SERIAL LINE.
CSI=177510	;SET TO FIRST ADDRESS OF DL11 LINE
CLEAR::;PROCEDURE CLEAR;
	BICB	#100,@#CSI
	BICB	#100,@#CSI+4
1$:	MOVB	@#CSI+2,R0
	BIT	#200,@#CSI
	BNE	1$
	RTS	PC
SEND::;PROCEDURE SEND( CH: CHAR );
1$:	BIT	#200,@#CSI+4
	BEQ	1$
	MOVB	2(SP),@#CSI+6
	MOV	(SP)+,(SP)
	RTS	PC
RECV::;PROCEDURE RECV( VAR CH: CHAR );
1$:	BIT	#200,@#CSI
	BEQ	1$
	MOV	2(SP),R1
	MOVB	@#CSI+2,(R1)
	MOV	(SP)+,(SP)
	RTS	PC
	.END
****
TRANS.PAS
PROGRAM TRANSFER;
  VAR I:INTEGER;
      CH:CHAR;
      SOURCE:FILE OF CHAR;
PROCEDURE SEND( CH:CHAR ); EXTERN;
PROCEDURE RECV(VAR CH:CHAR); EXTERN;
BEGIN
  RESET(SOURCE,ARGV[1]@);
  REPEAT
    RECV(CH)
  UNTIL CH='G';
  WHILE NOT EOF(SOURCE) DO BEGIN
    FOR I:=1 TO 512 DO BEGIN
      SEND(SOURCE@); GET(SOURCE) END;
    REPEAT
      RECV(CH)
    UNTIL CH='G';
    END;
  FOR I:=1 TO 512 DO SEND(CHR(0))
END.
****
RECVER.PAS
PROGRAM RECVER;
  VAR I:INTEGER;
      BUFF:ARRAY [1..512] OF CHAR;
      SOURCE:FILE OF CHAR;
      FLAG:BOOLEAN;
PROCEDURE CLEAR; EXTERN;
PROCEDURE SEND( CH:CHAR ); EXTERN;
PROCEDURE RECV(VAR CH:CHAR); EXTERN;
BEGIN
  REWRITE(SOURCE,ARGV[1]@);
  CLEAR;
  SEND('G');
  FLAG := TRUE;
  WHILE FLAG DO BEGIN
    FLAG := FALSE;
    FOR I:=1 TO 512 DO BEGIN
      RECV(BUFF[I]);
      IF BUFF[I]<>CHR(0) THEN FLAG := TRUE
      END;
    IF FLAG THEN FOR I:=1 TO 512 DO BEGIN
      SOURCE@:=BUFF[I]; PUT(SOURCE) END;
    IF FLAG THEN SEND('G');
    END;
  I := 0;
  WHILE ARGV[1]@[I]<>CHR(0) DO BEGIN
    WRITE(ARGV[1]@[I]);
    I := SUCC(I)
    END;
  WRITELN(' TRANSFERED.')
END.
****
INTPRT.PAS
program intprint;
{INTPRINT: print the intermediate code and data
 files written by pass 1 of the NBS Pascal compiler.
 
 08 Jun 79 - Bill Heidebrecht, TRW DSSG
 Corresponds to NBS Pascal compiler version 1.5g.
 
 This version of INTPRINT asks the user
 to select the procedures to be printed.
 Allowed user responses are:
  Y - print the current procedure;
  N - do not print;
  E - wrapup files and exit.
 
 RSX-11 usage:
 MCR>ITP -options outfile.lst intfile.int datfile.dat
 
     where options =
       S: select procedures interactively;
       D: print data file.
}
 
const
  nl=chr(10); ff=chr(12);
 
var
  nch: integer;
  PrintData, SelectProcs, prnt, done: boolean;
  ch: char;
  int, dat, lst: text;
 
 
procedure nextch;
begin
  ch := int@;
  nch := ord(ch);
  get(int)
end {nextch};
 
procedure outmne (opcode: integer);
const mtabsize = 179;
type mtabtype = array [0..mtabsize] of array [0..4] of char;
const mtab = mtabtype(                                             {opcode}
  'nop  ','xch  ','del  ','error','error','ident','proc ','end  ', {0 - 7}
  'null ','refer','stol ','stor ','stof ','error','error','error', {8 - 15}
  'succ ','pred ','error','error','error','error','error','error', {16 - 23}
  'uceq ','ucne ','ucgt ','ucle ','ucge ','uclt ','umax ','umin ', {24 - 31}
  'iadd ','isub ','imul ','idiv ','imod ','isqr ','error','error', {32 - 39}
  'ineg ','iabs ','iodd ','error','ceil ','floor','error','error', {40 - 47}
  'error','error','error','error','error','error','error','error', {48 - 55}
  'iceq ','icne ','icgt ','icle ','icge ','iclt ','imax ','imin ', {56 - 63}
  'fadd ','fsub ','fmul ','fdiv ','error','fsqr ','error','error', {64 - 71}
  'fneg ','fabs ','float','trunc','round','error','error','error', {72 - 79}
  'error','error','error','error','error','error','error','error', {80 - 87}
  'fceq ','fcne ','fcgt ','fcle ','fcge ','fclt ','fmax ','fmin ', {88 - 95}
  'not  ','error','error','error','error','error','error','error', {96 - 103}
  'eqv  ','xor  ','nimp ','rimp ','imp  ','nrimp','or   ','and  ', {104 - 111}
  'compl','union','inter','sdiff','error','sgens','sadel','empty', {112 - 119}
  'sceq ','scne ','scgt ','scle ','scge ','sclt ','in   ','sany ', {120 - 127}
  'error','error','error','field','ofset','indir','index','movem', {128 - 135}
  'error','error','invok','error','rtemp','dtemp','error','error', {136 - 143}
  'if   ','case ','entry','loop ','exit ','for  ','error','error', {144 - 151}
  'seq  ','error','error','error','error','error','error','error', {152 - 159}
  'error','error','liter','rdata','litd ','error','error','error', {160 - 167}
  'vceq ','vcne ','vcgt ','vcle ','vcge ','vclt ','error','error', {168 - 175}
  'varbl','param','call ','error');                                {176 - 179}
 
begin {outmne}
  write(lst, mtab[opcode]:5, '  ')
end {outmne};
 
procedure outc (c: char);
begin
  if prnt then write(lst, c)
end {outc};
 
procedure out8;
{ output numeric value of 8 bit byte }
begin
  nextch; if prnt then write(lst, nch)
end {out8};
 
procedure out16;
{ output numeric value of 16 bit word }
var i: integer;
begin
  nextch; i := nch*256;
  nextch; if prnt then write(lst, nch+i)
end {out16};
 
procedure outlevel;
begin
  if prnt then write(lst, nch mod 16)
end {outlevel};
 
procedure outsize;
begin
  nextch;
  if prnt then write(lst, ':', nch)
end {outsize};
 
procedure outds;
begin
  outsize;
  outc(','); out16
end {outds};
 
procedure options;
var ch: char;
    i: integer;
begin
  PrintData := false;
  SelectProcs := false;
  if argv[1]@[0] = '-' then
  begin
    i := 1;
    loop
      ch := argv[1]@[i];
    exit if ch = chr(0);
      if (ch = 'd') or (ch = 'D')
        then PrintData := true
      else if (ch = 's') or (ch = 'S')
        then SelectProcs := true;
      i := i + 1
    end
  end
end {options};
 
procedure ask_user;
var ch: char;
begin
  write(output,'?'); break(output);
  read(input,ch);
  prnt := (ch='Y') or (ch='y');
  if (ch='E') or (ch='e') then done := true
end {ask_user};
 
 
procedure scancode;
var
  i, n, opcode, opcode2: integer;
begin {scancode}
  writeln(lst, ' Code', nl, ' ----', nl, ' ');
  while not done do
  begin
    nextch;
    opcode := nch;
    if opcode > 223 then opcode2 := 179
      else if opcode > 207 then opcode2 := 178 {call}
      else if opcode > 191 then opcode2 := 177 {param}
      else if opcode > 175 then opcode2 := 176 {varbl}
      else opcode2 := opcode;
    if opcode2 = 5 {ident} then
    begin
      prnt := true;
      writeln(lst)
    end;
    if prnt then
    begin
      writeln(lst);
      write(lst, opcode:4, '  '); {print op code number}
      outmne(opcode2)                 {print mnemonic}
    end;
 
case opcode2 of
  0,1,2,3,4: ;
 
  5: begin {ident}
       if SelectProcs then writeln(output);
       nextch; n := nch;
       outc('''');
       for i := 1 to n do
       begin
         nextch;
         write(lst,ch);
         if SelectProcs then write(output,ch)
       end;
       outc('''');
       if SelectProcs then ask_user
     end;
 
  6: {proc} out8;
 
  7: begin {end}
       out8;  outc(',');
       out8;  outc(',');
       out16; outc(',');
       out16; outc(',');
       out16
     end;
 
  8,9,10,11,12,13,14,15,16,17,18,19,20,
  21,22,23,24,25,26,27,28,29,30,31,32,33,34,
  35,36,37,38,39,40,41,42,43,44,45,46,47,48,
  49,50,51,52,53,54,55,56,57,58,59,60,61,
  62,63,64,65,66,67,68,69,70,71,72,73,74,75,
  76,77,78,79,80,81,82,83,84,85,86,87,88,89,
  90,91,92,93,94,95,96,97,98,99,100,
  101,102,103,104,105,106,107,108,109,110,
  111,112,113,114,115,116,117,118,119,120,
  121,122,123,124,125,126,127,128,129,130: ;
 
  131,132,133,134,135: {field,ofset,indir,index,movem}
     outds;
 
  136,137: ;
 
  138: begin {invok}
         out8; outc(','); out8
       end;
 
  139: ;
 
  140,141: out8; {rtemp,dtemp}
 
  142,143,144: ;
 
  145: begin {case}
         out8; outc(','); out8
       end;
 
  146,147,152: out8; {entry,loop,seq}
 
  148,149: ; {exit,for}
 
  150,151,153,154,155,156,157,158,159,160,161: ;
 
  162: out16; {liter}
 
  163: begin {rdata}
         out16
       end;
 
  164: begin {litd}
         for i := 1 to 3 do
         begin
           out16; outc(',')
         end;
         out16
       end;
 
  165,166,167,174,175: ;
 
  168,169,170,171,172,173: {vector ops}
      outds;
 
  176,177: begin {varbl,param}
             outlevel; outds
           end;
 
  178: begin {call}
         outlevel; outsize;
         outc('('); out8; outc(')');
         outc(','); out8
       end;
 
  179:
 
end {case};
 
    if eof(int) then done := true
  end {while not done}
 
end {scancode};
 
 
procedure scandata;
const nbytes = 8 {bytes printed per line};
var
  i, n, dataloc, lineloc: integer;
  bytes: array [1..nbytes] of char;
  ch, byt: char;
  finished: boolean;
begin {scandata}
  writeln(lst);
  writeln(lst,' Data');
  writeln(lst,' ----');
  writeln(lst);
  dataloc := 0;
  lineloc := 0;
  finished := eof(dat);
  while not finished do
  begin
    n := 0;
    repeat {collect enough data for 1 line}
      ch := dat@; get(dat);
      dataloc := dataloc + 1;
      n := n + 1;
      bytes[n] := ch;
      finished := eof(dat)
    until finished or (n = nbytes);
    if n > 0 then
    begin {print the line}
      write(lst, lineloc:6, ': ');
      for i := 1 to n do
      {print bytes}
      begin
        byt := bytes[i];
        write(lst, ord(byt):4);
        if (byt >= ' ') and (byt <= '~')
          then write(lst, ' ''', byt, ''' ')
          else write(lst, '     ');
      end;
      lineloc := lineloc + nbytes;
      writeln(lst)
    end {of print the line}
  end {while not finished};
  writeln(lst);
  writeln(lst,' *** eof ***')
end {scandata};
 
 
procedure openfiles;
begin
  reset(int, argv[3]@);
  rewrite(lst, argv[2]@, 2)
end {openfiles};
 
 
begin {intprint}
  openfiles;
  options;
  done := eof(int); prnt := true;
  scancode;
  if PrintData then
  begin
    reset(dat, argv[4]@);
    scandata
  end;
  writeln(lst,nl);
  writeln(output);
  writeln(output,'end intprt')
end.
****
CMPMOD.PAS
{*	COMPARE - Compare two text files and report their differences.
*
*	Copyright (C) 1977, 1978
*	James F. Miner
*	Social Science Research Facilities Center
*	University of Minnesota
*
*	General permission to make fair use in non-profit activities
*	of all or part of this material is granted provided that
*	this notice is given.  To obtain permission for other uses
*	and/or machine readable copies write to:
*
*		The Director
*		Social Science Research Facilities Center
*		25 Blegen Hall
*		269 19th Ave. So.
*		University of Minnesota
*		Minneapolis, Minnesota  55455
*		U S A
}
 
{*	Compare is used to display on "Output" the differences
*	between two similar texts ("Filea" and "Fileb"). Notable
*	charactersitics are:
*
*	- Compare is line oriented. The smallest unit of comparison
*	  is the text line (ignoring trailing blanks).  The present
*	  implementation has a fixed maximum line length.
*
*	- By manipulating a program parameter, the user can affect
*	  Compare's sensitivity to the "locality" of differences.
*	  More specifically this parameter, "Minlinesformatch",
*	  specifies the number of consecutive lines on each file
*	  which must match in order that they be considered as
*	  terminating the prior mismatch.  A large value of
*	  "Minlinesformatch" tends to produce fewer but larger
*	  mismatches than does a small value.  The value six appears
*	  to give good results on Pascal source files but may be
*	  inappropriate for other applications.
*
*	  If compare is to be used as a general utility program,
*	  "Minlinesformatch" should be treated as a program
*	  parameter of some sort.  It is declared as a constant here
*	  for portability's sake.
*
*	- Compare employs a simple backtracking search algorithm to
*	  isolate mismatches from their surrounding matches.  This
*	  requires (heap) storage roughly  proportional to the size
*	  of the largest mismatch, and time roughly proportional to
*	  the square of the size of the mismatch for each mismatch.
*	  For this reason it may not be feasible to use Compare on
*	  files with very long mismatches.
*
*	- To the best of the author's knowledge, Compare utilizes
*	  only features of Standard Pascal.
*
*	Compare was originally published in "Pascal News",
*	Number 12, June 1978 by James Miner.  See future
*	issues of "Pascal News" for possible updates to
*	this program.
*
*	Modified for NBS Pascal by:
*	James L. Agin  -  25 November 1978
*	TRW DSSG
*	90 / 2824
*	One Space Park
*	Redondo Beach, CA 90278
*
*	CMPMOD is a modified version of Compare, which outputs
*	a report of file differences as does Compare, or
*	optionally outputs a modset suitable for input to
*	the TRW MODIFY program.  Also, the program parameter
*	"minlinesformatch" can be set by the user.
* 
*	This version of CMPMOD uses some nonstandard
*	Pascal features.
*
*	RSX-11 usage:
*	CMPMOD -options outfile.ext filea.ext fileb.ext
*	  where
*	  optiion = M (output modset format (default));
*	            R (output report format);
*	            Nd (set minlinesformatch parameter
*	                to d, a decimal integer);
*	  outfile = output modset or report file;
*	  filea   = input file a;
*	  fileb   = input file b.
}
 
program cmpmod (filea, fileb, outfile, output);
 
  const
    version = '1.2p  (78/03/01)';
    linelength = 120;			{max input linelength}
    defaultminlines = 6;		{default value of parameter}
    nl = chr(10);			{newline character}
 
 
  type
    linepointer = @line;
    line =
      {packed} record
        nextline: linepointer;
        length: 0..linelength;
        image: {packed} array [1..linelength] of char
      end;
 
    stream =
      record
        cursor, head, tail: linepointer;
        cursorlineno, headlineno, taillineno: integer;
        endfile: boolean
      end;
 
  var
    filea, fileb, outfile: text;
    a, b: stream;
    match: boolean;
    endfile: boolean;	{ set if end stream a or b }
 
    templine:	{ used by readline }
      record 
        length: integer;
        image: array [0..linelength] of char
      end;
 
    freelines: linepointer;	{ free list of line buffer }	
 
    same: boolean;		{ false if no mis-match occur }
    report: boolean;		{ report/modify option flag }
    minlinesformatch: integer;	{ parameter }
 
 
  procedure comparefiles;
 
    function endstream(var x: stream): boolean;
    begin  { endstream }
      endstream := (x.cursor = nil) and x.endfile
    end;   { endstream }
 
    procedure markcmp(var x: stream);
 
      { causes beginning of stream to be positioned before current
        sream cursor. buffers get reclaimed, line counters reset, etc. }
 
      var p: linepointer;
 
    begin  { markcmp }
      with x do
        if head <> nil then
          begin
            while head <> cursor do { reclaim buffers }
              begin
                with head@ do
                  begin p := nextline;
                    nextline := freelines; freelines := head
                  end;
                head := p
              end;
          headlineno := cursorlineno;
          if cursor = nil then
            begin 
              tail := nil; taillineno := cursorlineno
            end
    end
  end;  { markcmp }
 
  procedure movecursor(var x: stream; var filex: text);
 
    { filex is the input file associated with x. the cursor for
      x is moved forward one line, reading fraom x if
      necessary, and incrementing the line count. endfile is set
      if eof is encountered on either stream. }
 
    procedure readline;
      var 
        newline: linepointer;
        c, c2: 0..linelength;
    begin { readline }
      if not x.endfile then
        begin
          c := 0;
          while  not eoln(filex) and (c < linelength) do
            begin
              c := c + 1; templine.image[c] := filex@;
              get(filex)
            end;
	  get(filex);
          while templine.image[c] = ' ' do c := c - 1;
          if c < templine.length then
            for c2 := c + 1 to templine.length do
              templine.image[c2] := ' ';
          templine.length := c;
          newline := freelines;
          if newline = nil then new(newline) 
            else freelines := freelines@.nextline;
         {** pack(templine.image,1,newline@.image) **}
	  for c2 := 1 to c do
		newline@.image[c2] := templine.image[c2];
          newline@.length := c;
          newline@.nextline := nil;
          if x.tail = nil then
            begin
              x.head := newline;
              x.taillineno := 1; x.headlineno :=1
            end
           else
            begin
              x.tail@.nextline := newline;
              x.taillineno := x.taillineno + 1
            end;
          x.tail := newline;
          x.endfile := eof(filex)
        end
      end;  {  readline  }
 
    begin { movecursor }
      if x.cursor <> nil then
        begin
         if x.cursor = x.tail then readline;
          x.cursor := x.cursor@.nextline;
          if x.cursor = nil then endfile := true;
          x.cursorlineno := x.cursorlineno + 1
        end
       else
        if not x.endfile then  { beginning of stream }
          begin
            readline; x.cursor := x.head;
            x.cursorlineno := x.headlineno
          end
         else
          endfile := true
    end;  { movecursor }
 
procedure backtrack(var x: stream; var xlines: integer);
	{ causes the current position of stream x to become
	  that of the last mark operation. xlines is set to
	  the number of lines from the new cursor to the 
	  old cursor, inclusive }
begin { backtrack }
  xlines := x.cursorlineno + 1 - x.headlineno;
  x.cursor := x.head; x.cursorlineno := x.headlineno;
  endfile := endstream(a) or endstream(b)
end;  { backtrack }
 
procedure comparelines(var match: boolean);
  { Compare the current lines of streams a and b, returning }
  { match to signal their (non-) equivalence.  Eof on both streams }
  { is considered a match, but eof on only one stream is a mismatch. }
begin
  if (a.cursor = nil) or (b.cursor = nil)
    then match := endstream(a) and endstream(b)
   else
    begin
      match := (a.cursor@.length = b.cursor@.length);
      if match
        then match := (a.cursor@.image = b.cursor@.image)
    end
end; { comparelines }
 
procedure findmismatch;
begin { findmismatch }
  { not endfile and match }
  repeat  { compare nextlines }
    movecursor(a, filea); movecursor(b, fileb);
    markcmp(a); markcmp(b);
    comparelines(match)
  until endfile or not match
end; { findmismatch }
 
procedure findmatch;
  var advanceb: boolean; { toggle one line lookahead between
				streams }
 
  procedure search(var x: stream; { to search }
		   var filex: text;
		   var y: stream; { to lookahead }
		   var filey: text);
    { look ahead one line on stream y, and search for that line
      backtracking on stream x. }
    var count: integer; { number lines backtracked on x }
 
    procedure checkfullmatch;
      { from the current positions in x and y, which match,
        make sure that the next minlinesformatch - 1 lines also
        match, or else match := false }
      var
        n: integer;
        savexcur, saveycur: linepointer;
        savexline, saveyline: integer;
    begin { checkfullmatch }
      savexcur := x.cursor; saveycur := y.cursor;
      savexline := x.cursorlineno; saveyline := y.cursorlineno;
      comparelines(match);
      n := minlinesformatch - 1;
      while match and (n<>0) do
        begin
          movecursor(x,filex); movecursor(y, filey);
          comparelines(match); n := pred(n)
        end;
      x.cursor := savexcur; x.cursorlineno := savexline;
      y.cursor := saveycur; y.cursorlineno := saveyline
    end; { checkfullmatch }
 
  begin { search }
    movecursor(y, filey); backtrack(x, count);
    checkfullmatch; count := pred(count);
    while (count <> 0) and not match do
      begin
        movecursor(x, filex); count := pred(count);
        checkfullmatch
      end
  end; { search }
 
  procedure printmismatch;
    var emptya, emptyb: boolean;
 
    procedure writetext(p, q: linepointer);
    begin { writetext }
      if report then writeln(outfile,' ');
      while (p<>nil) and (p <> q) do
        begin
          if report then write (outfile,'*');
          if p@.length = 0 then writeln(outfile,' ')
           else
            writeln(outfile,p@.image: p@.length);
            p := p@.nextline
        end;
      if (p = nil) and report then
      begin
	writeln(outfile, ' *** eof ***');
	writeln(outfile,' ')
      end
    end;  { writetext }
 
    procedure writelineno(var x: stream);
      var f, l: integer;
    begin { writelineno }
      f := x.headlineno; l := x.cursorlineno - 1;
      if report then
      begin
	write(outfile,'line');
	if f = l then write(outfile,' ',f)
	 else write(outfile,'s ',f,' to ', l);
	if x.cursor = nil then write(outfile,' (before eof)')
      end else { modset format }
      begin
	if f = l then write(outfile,' ',f)
	  else write(outfile,' ',f,',',l)
      end
    end; { writelineno }
 
  procedure printextratext(var x: stream; xname: char;
                           var y: stream; yname: char);
  begin { printextratext }
    if report then
    begin
      write(outfile,' extra text on file',xname,', ');
      writelineno(x); writeln(outfile,' ');
      if y.head = nil then
        writeln(outfile,' before eof on file', yname)
       else
        writeln(outfile,' between lines ',y.headlineno - 1,
        ' and ', y.headlineno,' of file', yname);
    end
    else begin { modset format }
      if xname = 'a' then
	write(outfile, '*DELETE ')
      else
	write(outfile, '*INSERT ');
      writelineno(x);
      write(outfile, nl)
    end;
    writetext(x.head, x.cursor)
  end; { printextratext }
 
begin {printmismatch }
  if report then writeln(outfile,' ************************************');
  emptya := (a.head = a.cursor);
  emptyb := (b.head = b.cursor);
  if emptya or emptyb then
    if emptya then printextratext(b,'b',a,'a')
     else printextratext(a,'a',b,'b')
   else
    if report then
    begin
      writeln(outfile,' mismatch:'); writeln(outfile, ' ');
      write(outfile,' filea, '); writelineno(a);
      writeln(outfile,':'); writetext(a.head, a.cursor);
      write(outfile,' fileb, '); writelineno(b);
      writeln(outfile,':'); writetext(b.head, b.cursor)
    end
    else begin { modset format }
      write(outfile, '*DELETE ');
      writelineno(a);
      write(outfile, nl);
      writetext(b.head, b.cursor)
    end
end; { printmismatch }
 
begin { findmatch }
  { not match }
  advanceb := true;
  repeat
    if not endfile then advanceb := not advanceb
     else advanceb := endstream(a);
    if advanceb then search(a, filea, b, fileb)
     else search(b, fileb, a, filea)
  until match;
  printmismatch
end; { findmatch }
 
begin { comparefiles }
  match := true; { beginning of files match }
  repeat
    if match then findmismatch 
     else begin
       same := false; findmatch
     end
  until endfile and match;
end; { comparefiles }
 
procedure initialize;
 
  procedure initstream(var x: stream; var filex: text);
  begin { initstream }
    with x do
      begin
        cursor := nil; head := nil; tail := nil;
        cursorlineno := 0; headlineno := 0; taillineno := 0
      end;
    x.endfile := eof(filex)
  end; { initstream }
 
  procedure options;
  var ch: char;
      i: integer;
  begin {options}
    report := false; { default M }
    minlinesformatch := defaultminlines;
    if argv[1]@[0] = '-' then
    begin
      i := 1;
      loop
        ch := argv[1]@[i];
      exit if ch = chr(0);
        if (ch = 'r') or (ch = 'R')
          then report := true
        else if (ch = 'm') or (ch = 'M')
          then report := false
          else if (ch='n') or (ch='N') then begin
            minlinesformatch := 0;
            repeat
              i := succ(i);
              ch := argv[1]@[i];
              if (ch>='0') and (ch<='9') then
                minlinesformatch := minlinesformatch*10 + (ord(ch)-ord('0'))
            until (ch<'0') or (ch>'9');
            i := pred(i)
           end;
        i := i + 1
      end {loop}
    end
  end {options};
 
 
begin { initialize }
  reset(filea, argv[3]@,2);  reset(fileb, argv[4]@,2);
  initstream(a, filea);  initstream(b, fileb);
  rewrite(outfile, argv[2]@, 2);
  endfile := a.endfile or b.endfile;
  freelines := nil;
  templine.length := linelength;
  templine.image[0] := 'x'; { sentinel };
  options
end; { initialize }
 
 
begin { **** cmpmod **** }
  writeln(output,' Cmpmod version ', version);
  writeln(output,' ');
  initialize;
  writeln(output,' match criterion = ', minlinesformatch,
          ' lines.');
  writeln(output,' ');
  break(output);
  if a.endfile then writeln(output,' filea is empty.');
  if b.endfile then writeln(output,' fileb is empty.');
  if not endfile then
    begin
      same := true;
      comparefiles;
      if same then writeln(output,' no differences.')
	else if not report then
	  writeln(outfile, '*/ end modset')
    end
end.  { compare }
****
                                                                                                                                                                                                                                                                                                                                                                                                                   