/*
 *				s c a n f . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	scanf	Formatted input conversion
index		Formatted input conversion

synopsis
	.s.nf
	scanf(fmt, pointer(s))
	char		*fmt;	/* Format string	*/

	fscanf(fd, fmt, pointer(s))
	FILE		*fd;	/* Input file pointer	*/
	char		*fmt;	/* Format string	*/

	sscanf(buf, fmt, pointer(s))
	char		*buf;	/* Input text buffer	*/
	char		*fmt;	/* Format string	*/

	c_doscan(fmt, argp, iov)
	char		*fmt;	/* Format string	*/
	int		*ptr[];	/* Pointer vector	*/
	FILE		*iov;	/* Input file des.	*/
	.s.f
Description

	Using the format string, these functions parse the input file
	(or given text file), storing the results in the pointer
	arguments.  The three user-callable routines differ as follows:

	  scanf		Reads from the standard input file.

	  fscanf	Reads from the indicated file.

	  sscanf	Reads from the text buffer.

	c_doscan() is an internal routine called by the above to actually
	parse the input text.  It is functionally identical to the Unix
	and Vax-11 C _doscan() routine.  Unfortunately, the leading
	'_' conflicts with RSX file control service routine naming
	conventions.

	The format string may contain control characters to direct
	the conversion of the input textual data:
	.lm +4
	.s.i -4;' ' Blanks, tabs, or newlines are ignored in  format
	strings.  To match whitespace, use "%[ \t\n]".
	.s.i -4;#x##An  ordinary  character  (not  %) must match the
	next input character.
	.s.i -4;#%##Conversion specifications consist of a  '%',  an
	optional   '*'  (to   supress   assignment),  an
	optional  maximum  numeric  field  width,  and a
	conversion specifier.
	.s.lm -4
	Unless value assignment was supressed by the '*' format modifier,
	the next field is converted and stored in the variable pointed to
	by the corresponding argument.  An input field is defined as a
	string of non-space characters, extending to the first inappropriate
	character or until the field width (if given) is exhausted.

	The following conversion characters are specified:
	.lm +4
	.s.i -4;#%##A single  '%'  is  expected  in  the  input,  no
	assignment is done.
	.s.i -4;dox#An integer  of  the  specified  class  (decimal,
	octal,  or  hexadecimal)   is   expected.    The
	corresponding  argument  should  be  an  integer
	pointer.   If   the  format specifer is given in
	upper-case, or preceeded by 'l', a long  integer
	will be stored.  For example, "%ld" is identical
	to "%D".   Leading  whitespace  will be ignored.
	A null field is not converted.  Scanf()  returns
	a  count  of the number of fields converted, but
	does not indicate which fields were ignored.
	.s.i -4;#s##A character string is expected.  The input field
	will be terminated by a space, tab, or  newline.
	The corresponding argument  should  point  to  a
	buffer large enough to contain the  text  and  a
	terminating  NULL.   Leading  whitespace will be
	ignored.
	.s.i -4;#c##A single character is read. Leading white  space
	is not supressed  --  to read the next non-blank
	character, use "%1s".  If a field width is given
	the  corresponding  argument  is  a pointer to a
	vector of characters and the indicated number of
	characters are read.
	.s.lm -4
	Scanf() returns the number of successfully matched and
	assigned input items.  If the end of input was reached,
	EOF (-1) is returned.  For example:

	    main()
	    {
		register int	c;
		int		i;
		char		text[10];

		c = scanf("%d%9s", &i, &text);
		printf("i = %d, text = %s\n", i, text);
	   }

	If the input line is "150   foobar", the program will print:

	    i = 150, text = foobar

Diagnostics

	Scanf() returns -1 if an end of file (end of string) condition
	exists and no data was stored.  It returns -2 if a palpably
	incorrect format, such as "%" is encountered.

Bugs

	This version of scanf does not support floating point
	and [] character class formats.

#endif

#include	<stdio.h>

int
scanf(format, args)
char		*format;
/*
 * Formatted input conversion
 */
{
	return (c_doscan(stdin, format, &args));
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          