/* VIRT.H
** header file for virtual I/O routines.
** Rev 1281.041
*/

#define BLK_SIZE	512
#define BLK_W_SIZE	(BLK_SIZE / 2)
#define CREATERR	5
#define DATA_SIZE	8
#define DESTROY		2
#define ENTER		4	/* error flag for entry difficulties */
#define KEEP		1
#define NEW		1
#define OLD		2
#define OPENERR		6
#define P_SIZE		(sizeof(struct page) )
#define RB_SIZE		4			/* a  real is 4 bytes long */
#define READERR 	3	/* error flag for read routines */
#define ROOM		1	/* error flag for no room to get any pages */
#define SCRATCH		4
#define VDIM		7
#define WRITERR		2	/* error flag for error  in write routines */

/************************************************************************
****************** DATA STRUCTURE DEFINITIONS ***************************
************************************************************************/

/* define basic unit of dynamic memory management
*/

struct page {
	BOOL update;		/* YES if a write has occured to this block */
	BYTES blk_num;		/* block number of this data */
	TINY data[BLK_SIZE];	/* data storage area */
	LONG acc_time;		/*  time of last access to this page */
	struct page *nxt_page;	/* pointer to next page of data */
	} ;

typedef struct page PAGE, *PAGE_PTR;


/* define static structure
*/

GLOBAL struct rt {
	COUNT chan;		/* I/O channel used for the file */
	COUNT size;		/* size of data item in bytes */
	COUNT dispos;		/* disposition action on file upon closure */
	PAGE_PTR frst_page;	/* pointer to first page */
	COUNT n_blks;		/* max number of blocks in the file */
	COUNT n_pages;		/* number of page descriptors allocated */
	};

/* This structure allows for the passing of different sized data between
** user routines and vread() and vwrite().  The appropriate size is selected
** by the value of ROOT.size.
*/

union virt_data {
	TEXT bval;
	COUNT ival;
	LONG lval;
	float fval;
	DOUBLE dval;
	} ;

typedef union virt_data DATA, *DATA_PTR;

/************************************************************************
**************   MACRO DEFINITIONS **************************************
************************************************************************/

/* These macros do direct operating system trap calls to perform the
** actual block for block I/O. _write and _read are the basic read and
** write routines. cwrite and cread use completion routines and return
** immediately.  wwrite and wread wait for completion of the I/O operation
** before they return.  If these types of macros aren't included then
** routines by the same name must be written in assembly language to do
** the same jobs.  These routines must follow the C protocalls of course
*/

#define _write(a,b,c,d)		emt375((011<<8)|(BYTMASK&(a)),(b),(c),(d),1)
#define cwrite(a,b,c,d,e)	emt375((011<<8)|(BYTMASK&(a)),(b),(c),(d),(e))
#define wwrite(a,b,c,d)		emt375((011<<8)|(BYTMASK&(a)),(b),(c),(d),0)

#define _read(a,b,c,d)		emt375((010<<8)|(BYTMASK&(a)),(b),(c),(d),1)
#define cread(a,b,c,d,e)	emt375((010<<8)|(BYTMASK&(a)),(b),(c),(d),(e))
#define wread(a,b,c,d)		emt375((010<<8)|(BYTMASK&(a)),(b),(c),(d),0)

/* These three routines handle file creation and lookup details.
** The same general comments apply here as for the block I/O operations
** mentioned above
*/

#define lookup(a,b,c)		emt375((1<<8)+(a),(b),(c))
#define u_enter(a,b,c,d)	emt375((2<<8)+(a),(b),(c),(d))
#define u_close(a)		emt(0374,(6<<8)+(a))

/* To make access easier and more straight forward these macros are defined
** for the vread() function.  They are used to recover data. 
*/

#define LVREAD(a, b)	(long *)(vread((a), (long)(b)))
#define BVREAD(a, b)	(char *)(vread((a), (long)(b)))
#define IVREAD(a, b)	(int *)(vread((a), (long)(b)))
#define DVREAD(a, b)	(double *)(vread((a), (long)(b)))
#define FVREAD(a, b)	(long *)(vread((a), (long)(b)))

/* These macros aid the use of vwrite() in the same way.  Note that we're
** not implicitly doing an address operation, the user is responsible for
** putting a pointer here.
*/

#define VWRITE(a, b, c)	vwrite((a), (long)(b), (c))
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               