Program List;
(*LIST.PAS--Lists a source file.  No globals*)

Const
  maxnbr	= 32500;   (*Maximum number of lines to be printed*)
  nbrsize	= 5;   (*Number of digits in maxnbr*)

Label 10;

Type
  Namerecord	= Packed Array [1..14] of char;   (*This holds the physical file name*)

Var
  pagelength	: Integer;   (*Number of lines to be printed on a page*)
  topmargin	: Integer;   (*Number of unused lines at top of page*)
  bottommargin  : Integer;   (*Number of unused lines at bottom of page*)
  name		: namerecord;  (*Array to hold physical file name*)
  f		: Text;   (*Logical file name to be printed*)
  p		: Text;   (*Logical file name for printer*)
 
  fac		: Text; (*Logical file name of the file containing format data*)
  low,high	: Integer;   (*Starting & ending line numbers to be printed*)
 
  code		: Integer;   (*Flag that aborts program*)
  len		: Integer;

		(**********  BEGINLINE  **********)

Procedure beginline(Var low : Integer);
(*This procedure sets the beginning line that is to be printed.  If no
number is entered then the beginning is set at first line*)

  Label 5,10;

  Var
    nbr		: Packed array [1..nbrsize] of char;   (*Holds beginning line
						number entered from the keyboard*)

    count	: Integer;

  Begin
    5: low := 0;
    For count := 1 to nbrsize do   (*Initializes nbr array*)
       nbr[count] := '0';
    count := 0;
    write('Enter starting line number.  ');
    while NOT eoln do
       begin
	count := count + 1;
	If count > nbrsize then   (*Number limited to 4 digits*)
	   begin
		write('Number entered exceeds ',maxnbr:nbrsize,'   ');
		readln;
		goto 5
	   end;
	read(nbr[count]);   (*Read beginning line number from keyboard*)
	If nbr[1] = ' ' then   (*If no entry, set beginning line to 1*)
	   begin
		low := 1;
		goto 10
	   end;
	If nbr[1] = '0' then  (*First number cannot be zero*)
	  begin
		write('First number cannot be a zero.  ');
		readln;
		goto 5
	  end;
	If (nbr[count] < '0') or (nbr[count] > '9') then   (*After first
					number, only allow  numbers*)
	  begin
		write('Bad number.  ');
		readln;
		writeln;
		goto 5
	  end
       end;
  For count := 1 to count do   (*Convert nbr array to an integer*)
	low := low * 10 + ord(nbr[count]) - ord('0');
  If low > maxnbr then
     begin

	write('Number entered exceeds ',maxnbr:nbrsize,'   ');
	readln;
	goto 5
     end;
10: readln
  End;     (*Beginline*)

		(**********  ENDLINE  **********)

Procedure endline(Var high,low : Integer);
(*This procedure sets the last line to be printed.  If no number is entered,
then the last line to be printed is set to maxnbr*)

  Label 5,10;

  Var
    nbr		: Packed array [1..nbrsize] of char; (*Holds ending line number
							entered from keyboard*)
    count	: Integer;

  Begin
    5: high := 0;
    For count := 1 to nbrsize do   (*Initializes nbr array*)
	nbr[count] := '0';
    count := 0;
    write('Enter ending line number.  ');
    while NOT eoln do
       begin
	count := count + 1;
	If count > nbrsize then   (*Number limited to four digits*)
	   begin
		write('Number entered exceeds ',maxnbr:nbrsize,'   ');
		readln;
		goto 5
	   end;
	read(nbr[count]);   (*Read ending line number*)
	If nbr[1] = ' ' then   (*If no entry, set ending line to maxnbr*)
	   begin
		high := maxnbr;
		goto 10
	   end;
	If nbr[1] = '0' then  (*First number cannot be zero*)
	  begin
		write('First number cannot be a zero.  ');
		readln;
		goto 5
	  end;
	If (nbr[count] < '0') or (nbr[count] > '9') then   (*After first
					number, allow only numbers from 0 to 9*)
	  begin
		write('Bad number.  ');
		readln;
		writeln;
		goto 5
	  end
       end;
  For count := 1 to count do   (*Convert nbr array to an integer*)
		high := high * 10 + ord(nbr[count]) - ord('0');
    If high < low then (*Ending number cannot be lower than beginning number*)
       begin
	write('Ending number is less than beginning number.  ');
	readln;
	goto 5
       end;
  If high > maxnbr then
     begin
	write('Number entered exceeds ',maxnbr:nbrsize,'   ');
	readln;
	goto 5
     end;
10: readln
  End;     (*Endline*)

		(**********  OPENFILE  **********)

Procedure openfile(Var code : Integer;Var f : Text;Var name : Namerecord);
(*This procedure takes the physical file name from keyboard and links it to 
the logical file name, ie, opens the desired file*)

  Label 5,10;
  
  Var
    len,count	: Integer;

  Begin
5: write('Enter file name.  ');  (*File name must be int the form of
						Device:Filename.Extension*)
    count := 0;
    while NOT eoln do
	begin
	    count := count + 1;
	    If count > 14 then   (*Device,file name and extension limited to 14
								 characters*)
		begin
		    write('File name to large   ');
		    readln;
		    writeln;
		    goto 5
		end;
	    read(name[count])
	end;
    readln;
    If name[1] = ' ' then   (*If no name entered, abort program*)
       begin
	code :=1;
	goto 10
       end;
    reset(f,name,'.PAS',len);   (*Open file for reading*)
    If len = -1 then   (*If no file is opened len will = -1*)
       begin
	write('Bad file name.  ');
	writeln;
	goto 5
       end;
  10: End;     (*Openfile*)

		(**********  STARTPRINTAT  **********)

Procedure startprintat(low : Integer;Var f : Text);
(*This procedure puts file pointer on first line to be printed*)

  Var
    k	: Integer;

  Begin
    If low > 1 then   (*Move file pointer down to beginning line*)
	    For k := 1 to low-1 do
		readln(f)
  End;     (*Startprintat*)

		(**********  PRINTLINES  **********)

Procedure printlines(low,high : Integer;Var f : Text;Var name : Namerecord);
(*This procedure prints contents of a file starting at the line set as the
beginning line to either the line set as the last line or EOF*)

  Var
    linenbr	: Integer;   (*Line numbers*)
    k		: Integer;   (*Counts lines*)
    pagenbr  	: Integer;   (*Page numbers*)
    i		: Integer;   (*counter*)
    ch		: Char;
    p		: Text;   (*Printer*)
    mo,da,yr	: Integer;   (*Date*)

Procedure idate(Var mo,da,yr : Integer); Fortran;  (*Gets date from RT-11*)

  Begin
    idate(mo,da,yr);
    pagenbr := 1;
    k := 1;
    rewrite(p,'LP:')   (*Connects p to printer*);
    linenbr := low;   (*Starts line number at beginning number*)
    For i := 1 to topmargin do   (*Line feeds for top margin*)
	writeln(p);
    writeln(p,name,'                     ',mo:1,'/',da:1,'/',yr:1,   (*Heading*)
			'                              Page # ',pagenbr:3);
    while NOT eof(f) and (linenbr <= high) do   (*Print until EOF or ending
							 number is reached*)
       begin
	write(p,linenbr:4,'    ');   (*Line numbers*)
	while NOT eoln(f) do   (*Read a line of text*)
	   begin
		read(f,ch);   (*Read a character*)
		write(p,ch)   (*Print a character*)
	   end;
	readln(f);   (*Go to next line of file*)
	writeln(p);   (*Go to next line of printer*)
	If ((k MOD pagelength) = 0) and NOT eof(f) then   (*Go to bottom of the
		 page, print a heading and then go to top of lnext page and
		and print another heading*)
	   begin
		For i := 1 to bottommargin - 1 do   (*Line Feeds for the bottom
									margin*)
			writeln(p);
		writeln(p,name,'                    ',mo:1,'/',da:1,'/',yr:1,(*Heading*)
				'                              Page # ',pagenbr:3);
		pagenbr := succ(pagenbr);
		For i := 1 to topmargin do   (*Line feeds for top margin*)
			writeln(p);
		writeln(p,name,'                              ',   (*Heading*)
				'                              Page # ',pagenbr:3);
	   end;
	If eof(f) or (linenbr = high) then   (*After finishing the listing go to
					bottom of page and print a heading*)
	   begin
		If k MOD pagelength = 0 then
		   For i := 1 to bottommargin - 1 do  (*Line feeds for bottom
									margin*)
			writeln(p)
		else 
		   begin
			k := k MOD pagelength;   (*If you are beyond the first page
					then divide the last line number by the
					page length and the remainder is the
					number of lines used on the last page*)
			For i := k + 1 to pagelength + bottommargin - 1 do
				(*Move to last line on page and print heading*)
			   writeln(p)
		   end;
		writeln(p,name,'                    ',mo:1,'/',da:1,'/',yr:1,(*Heading*)
				'                              Page # ',pagenbr:3)
	   end;
	linenbr := succ(linenbr);
	k := succ(k)
       end;
    close(p)
  End;     (*Printlines*)

		(**********  MAIN PROGRAM  **********)

Begin
  reset(fac,'DK0:FAC','.DAT',len);
  If len = -1 then   (*If file fac does not exist, abort the program*)
     begin
	writeln('Format data file does not exist.  Run FACE program!');
	readln;
	goto 10
     end;
  readln(fac,topmargin);
  readln(fac,pagelength);
  readln(fac,bottommargin);
  code := 0;
  beginline(low);     (*Sets beginning line #*)
  endline(high,low);     (*Sets ending line #*)
  openfile(code,f,name);     (*Opens file*)
  If code = 1 then goto 10;   (*If no entry of file name, abort program*)
  startprintat(low,f);     (*Moves file pointer to beginning line number*)
  printlines(low,high,f,name);     (*Prints the file*)
  close(f);
  10: End.     (*Main*)
                                                                                                                                                                                                                                                                                                                                                                                                                                                    