.;	ARChiv IDV:FILE/OPTIONS ODV:
.;
.;	--- THIS COMMAND IMPLEMENTS A FILE ARCHIVE PROCESS USING A RANGE OF
.;	    FLOPPY DISCS AND WITH AN ON-LINE CATALOG OF ARCHIVED FILES.
.;
.;	--- THE SYSTEM MAINTAINS A CATALOG OF ARCHIVED FILES FOR EACH USER
.;	    AREA OF SATELLITE 1 AND FOR EACH OF THE OTHER SATELLITES.
.;
.;	--- IF THE OUTPUT FLOPPY DISC HAS ALREADY BEEN INCLUDED IN A CATALOG
.;	    . ARCHIVE PROCEDURE:
.;		. COPIES SPECIFIED FILES ONTO THE DISC IN SPECIFIED DRIVE 
.;		. UPDATES FILE CATALOG NAMED IN VOLUME STRING (DISC DIRECTORY)
.;
.;	--- IF THE OUTPUT FLOPPY DISC DOES NOT SPECIFY A CATALOG IN DIRECTORY
.;	    . ARCHIVE PROCEDURE:
.;		. COPIES SPECIFIED FILES ONTO THE DISC IN SPECIFIED DRIVE 
.;		. UPDATES FILE CATALOG APPROPRIATE TO AREA OR SATELLITE
.;		. INSERTS CAT NAME IN VOLUME STRING OF FLOPPY DISC DIRECTORY
.;		. PROMPTS USER WITH DISC LABEL INFORMATION
.;
.;	--- LOCATE PROCEDURE:
.;		. FINDS ALL ENTRIES IN CATALOG WHICH MATCH FILESPEC
.;		. PUTS OUTPUT TO PRINTER IF /PR OPTION ADDED
.;
.;	--- WILDCARDS MAY BE USED IN FILE SPECIFICATION BUT NOT DEVICE OR
.;	    CATALOG NAMES
.;
.;	--- DEFAULT INPUT DEVICE IS DK:
.;
.;	--- DEFAULT OUTPUT DEVICE IS DY2:
.;
.;	--- FILE CATALOG IS DL3:ARCHIV.IDV WHERE IDV IS INPUT DEVICE FOR SAT1
.;	    AND SATELLITE NUMBER FOR OTHER SATELLITES.
.;
.;OPTIONS:
.;	NOTE that options may only be added to file specification.
.;
.;	/L	Locate option; no copy operation; catalog locate only
.;	/Q	Query option; allows COPY/QUERY operation; very useful if
.;		wildcards in file specification.
.;	/PR	PRint option which may be combined with /L only.
.;
.;
.;EXAMPLES:
.;
.;	ARC FILE
.;		copy file to default device and put in catalog for dk:
.;	ARC FILE/Q
.;		as above but use COPY/Q command
.;	ARC FILE/L
.;		locate file in catalog for dk:
.;	ARC FILE/L/PR
.;		locate file in catalog for dk: and print list
.;	ARC FILE ODV[:]
.;		copy file to odev device and put in catalog for dk:
.;	ARC FILE/Q ODV[:]
.;		as above but use COPY/Q command
.;	ARC IDV:FILE ODV[:]
.;		copy idv:file to odev device and put in catalog for idv:
.;	ARC IDV:FILE/Q ODV[:]
.;		as above but use COPY/Q command
.;	ARC CAT:FILE/L
.;		locate file in catalog for cat:
.;	ARC CAT:FILE/L/PR
.;		locate file in catalog for cat: and print list
.;	ARC IDV:FILE
.;		copy file to default device and put in catalog for idv
.;	ARC IDV:FILE/Q
.;		as above but use COPY/Q command
.;
.;DEFAULT DEVICES.
.;
.;ARCHIV MAINTAINS ITS CATALOG USING THE SAME VERSION OF THE DISK LIBRARIAN
.;DSKLIB AS USED BY THE DECUS SOFTWARE CATALOG. THIS VERSION OF DSKLIB RESIDES
.;ON DL3: AND DEFAULTS TO OPEN "DL3:LIBCAT.DCS" AND HAS THE FOLLOWING TABLE OF
.;DEVICE UNITS:
.;
.;NUMBER:      0     1     2     3     4     5     6     7     8     9
.;DEVICE:     DY0   DY1   DY2   DY3   DX0   DX1   DX2   DX3   ARC   BKU
.;
.;NOTE THAT AN ASSIGNMENT OF DEVICE ARC: IS MADE BY THE COMMAND PROCESSOR.
.;
.;CATALOGS.
.;
.;ARCHIV MAINTAINS CATALOGS ON DL3: FOR EACH USER AREA OF SATELLITE 1 AND FOR
.;EACH OF THE OTHER SATELLITES. THESE HAVE THE FORM:
.;	DL3:ARCHIV.Anm		for Sat1 areas, and 
.;	DL3:ARCHIV.Spq		for the other Satellites.
.;
.;
.;
.;ARCHIV COMMAND
.;USE AS "IND ARCHIV FILE/OPTIONS"
.;1.  FILE		copy file to default device and put in catalog for dk:
.;1a. FILE/Q		as above but use COPY/Q command
.;2.  FILE/L		locate file in catalog for dk:
.;3.  FILE ODEV[:]	copy file to odev device and put in catalog for cat:
.;3a. FILE/Q ODEV[:]	as above but use COPY/Q command
.;4.  IDV:FILE ODEV[:]	copy file to odev device and put in catalog for cat:
.;4a. IDV:FILE/Q ODEV[:]	as above but use COPY/Q command
.;5.  CAT:FILE/L		locate file in catalog for cat:
.;6.  IDV:FILE		copy file to default device and put in catalog for cat
.;6a. IDV:FILE/Q		as above but use COPY/Q command
.;
.;/L option may also carry a /PR option to put list to printer
.;therefore can regard Q option as part of file spec 
.;need to identify 6 varieties of command

.;use ind to get file name and options
.DISABLE PREFIX
.ENABLE SUBSTITUTION
.ENABLE QUIET
.;if no input file ask for one
.IF <STRLEN> EQ 1 .ASKS P1 CATALOG NAME AND OPTIONS
.SETS LINE P1
.SETS ODEV1 P2
.;
.;check for /L option
.TEST LINE "/L"
.IF <STRLEN> EQ 0 .GOTO CHKOUT
.;FIRST STRIP SWITCH
.SETS OLINE LINE[1:<STRLEN>-1]+LINE[<STRLEN>+2:40.]
.;have option 2 or 5
.TEST OLINE ":"
.IF <STRLEN> EQ 0 .GOTO CATLOC
.;have option 5
.PARSE OLINE ":" CAT FILE
.GOTO LOCATE

.CATLOC:
.;FILE IS INPUT LINE
.SETS FILE OLINE

.;CAT SET BY SATELLITE NUMBER AND DK: DEVICE
.;NEED TO IDENTIFY CAT FROM DK:

.GOSUB WHOWE
.IF SATNUM EQ "S01" .GOTO DOVOL
.SETS CAT SATNUM
.GOTO LOCATE

.DOVOL:
.VOL WASTE DK:
.SETS CAT WASTE[1:3]

.;now do locate function and exit
.LOCATE:
.OPEN DK:COMMAN.TMP
.ENABLE DATA
DL3:DSKLIB
ODL3:ARCHIV.'CAT'
F'FILE'
Q
.DISABLE DATA
.CLOSE
$@COMMAN.TMP
DELETE/NOQ (COMMAN).TMP
/


.;come here for variants 1,3,4,6
.;first check for specified output device
.CHKOUT:
.;set up defaults
.SETS FILE LINE
.;default output device is DY2
.SETS ODEV "DY2"

.;check default/specified output device for valid disc present
.;check for 2 words in command using length of second word
.TEST ODEV1
.IF <STRLEN> EQ 0 .GOTO SETIDV
.;drop : from odev for consistent behaviour
.PARSE ODEV1 ":" ODEV WASTE
.;need to check for separate IDV: in file
.SETIDV:
.;set up default of dk: for idv:
.SETS IDV "DK"
.TEST FILE ":"
.IF <STRLEN> EQ 0 .GOTO SETCAT
.PARSE FILE ":" IDV WASTE

.SETCAT:
.;find out which satellite we are
.GOSUB WHOWE
.IF SATNUM EQ "S01" .GOTO SAT1
.SETS CAT SATNUM
.GOTO COPY

.SAT1:
.;need to identify cat from idv:
.VOL TEMP 'IDV':
.SETS CAT TEMP[1:3]

.;copy file to device
.COPY:
.TESTDEVICE 'ODEV'
.TEST <EXSTRI> "NSD"
.IF <STRLEN> EQ 0 .GOTO DEVOK
;OUTPUT DEVICE NOT FOUND - TRY AGAIN
/
.DEVOK:
.TEST <EXSTRI> "ONL"
.IF <STRLEN> NE 0 .GOTO COPY2
;OUTPUT DEVICE NOT READY - TRY AGAIN
/
.COPY2:
copy 'file' 'odev':

.;check if volume shows correct format
.VOL IDENT 'ODEV'
.TEST IDENT "ARCHIV"
.IF <STRLEN> EQ 4 .GOTO UPDATE

.;if disc not dsklib volume then 1. get size 2. init/vol
.DOSIZ:
.;with catalog extension in CAT

.OPEN DK:COMMAN.TMP
.ENABLE DATA
DL3:DSKLIB
ODL3:ARCHIV.'CAT'
PCATSIZ.TMP
F/VOL/DISK/REV/PR/COL 1
Q
.DISABLE DATA
.CLOSE
$@COMMAN.TMP
DELETE/NOQ (COMMAN).TMP
.OPENR CATSIZ.TMP
.READ WASTE
.READ WASTE
.READ WASTE
.READ WASTE
.READ LINE
.CLOSE CATSIZ.TMP
DELETE/NOQ CATSIZ.TMP
.;.SETD NUMBER
.SETD NEXT
.SETS NUMBER LINE[1:3]
.SETN NEXT 'NUMBER'+1

.;NUMBER OF ENTRIES IN CATALOG 'CAT' IS 'NUMBER'
.;NEXT VOLUME ID NUMBER WILL BE 'NEXT'
;
;
;--------------------------------------------------------------------------
;|                                                                         |
;|WHEN FINISHED PLEASE LABEL THE OUTPUT DISC AS --- ARCHIV.'CAT' NO. 'NEXT'
;|                                                                         |
;--------------------------------------------------------------------------
;
;
.OPEN DK:COMMAN.TMP

.ENABLE DATA
AS 'ODEV' ARC:
DL3:DSKLIB
ODL3:ARCHIV.'CAT'
V8'NEXT'
ARCHIV.'CAT'
U8Q
.DISABLE DATA
.GOTO UPD2

.;update existing catalog as defined by VOL entry in ODEV:
.UPDATE:
.SETS CAT IDENT[10.:12.]
.OPEN DK:COMMAN.TMP

.ENABLE DATA
AS 'ODEV' ARC:
DL3:DSKLIB
ODL3:ARCHIV.'CAT'
U8Q
.DISABLE DATA

.UPD2:
.CLOSE
$@COMMAN.TMP
DELETE/NOQ (COMMAN).TMP
/

.;whowe tells who we are
.;puts Satellite number in SATNUM; Monitor type in MONITR
.WHOWE:
WHOFIL
.OPENR WHO.TMP
.READ WASTE
.READ TEMP
.PARSE TEMP " = " MONITR WASTE
.READ WASTE
.READ WASTE
.READ TEMP
.PARSE TEMP " = " NUM WASTE
.SETS SATNUM "S0"+NUM
.;support up to 10 satellites using 1 to 9 and then :
.IF NUM EQ ":" .SETS SATNUM="S10"
.CLOSE
.RETURN
.END
                                                                                                                                                                                                                                                           