	subroutine SPLINP (ICHAR, ESC, ECHO)
c
c	This routine uses the TTY special mode to allow single-
c	character and escape sequence inputs to be processed
c	without the need of a carriage return.
c
c	This routine calls the VT library routine CRLF.
c
c	The arguments are:
c	ICHAR (Byte)	- the character obtained from the input.
c			- ICHAR is an ASCII value for printable
c			  characters.  Non-printable characters
c			  will return the negative of their value.
c	ESC (Byte)	- Logical flag to indicate whether an
c			  escape sequence was inputted.
c			  If ESC is true, ICHAR contains the
c			  last character of the escape sequence.
c	ECHO (Integer*2)- If = 0, no echoing will be done;
c			  If = 1, printable characters will be echoed;
c			  If = 2, printables will be echoed and a <CR>
c			  will echo as a <CR><LF>.
c
c		Written by:
c		BIO/COMP Applications
c		P. O. Box 5342
c		Albuquerque, NM 87185
c		Version 1.3,	5-May-86.
c
	integer*2 INPCHR, ISTAT, ECHO
	byte ICHAR, ESC, ICHARB
c
	equivalence (INPCHR, ICHARB)
c
	call IPOKE ("44,"10100 .or. IPEEK("44))	!Set TTY Special Mode
c
10	INPCHR= ITTINR ()		!Get the character, if there is
	if (INPCHR.lt.0) go to 10	!one.
c
	ESC= .false.
c
	if (ICHARB.eq.127) then		!A delete.
	  ICHAR= -127
c
	else if (ICHARB.ge.32) then	!Printable character processing.
	  if (ECHO.gt.0) ISTAT= ITTOUR (ICHARB)	!Echo it
	  ICHAR= INPCHR			!Put character in output.
c
c	Unprintable character processing.
	else if (ICHARB.eq.27) then	!Escape sequence.
	  ESC= .true.
	  INPCHR= -27			!In case only an <ESC> was typed.
20	  ICHAR= INPCHR
	  ISTAT= ISLEEP (0,0,0,1)	!We need to wait bec ESC SEQ's 
	  if (ISTAT.ne.0) stop 'SPLINP-F-Q-Element Failure'	!come too fast
	  INPCHR= ITTINR ()		!Get the next characters.
	  if (INPCHR.ge.0) go to 20	!Loop until done.
c
c	Non-escape unprintable characters return as negative values.
	else if (ICHARB.eq.13) then	!A CR was typed.
	  ICHAR= -ICHARB
	  ISTAT= ISLEEP (0,0,0,1)
	  if (ISTAT.ne.0) stop 'SPLINP-F-Q-Element Failure'
	  INPCHR= ITTINR ()		!Get the LF
	  if (ECHO.gt.1) call CRLF	!Echo a CRLF, if desired.
c
	else				!Other unprintable was typed.
	  ICHAR= -ICHARB		!Return the negative of its value.
	endif
c
	call IPOKE ("44,"10100 .xor. IPEEK("44))	!Back to normal input.
	return
c
	end
	subroutine UDELCH
c
c	This routine handles deletion of single chracters 
c	on the CRT screen.
c
	byte BS, SP
c
	parameter (BS=8, SP=32)
c
	L= ITTOUR (BS)
	L= ITTOUR (SP)
	L= ITTOUR (BS)
	return
c
	end
	subroutine UBADNT
c
c	This routine signals a bad entry by beeping.
c
	byte BEL
c
	parameter (BEL=7)
c
	L= ITTOUR (BEL)
	return
c
	end
	subroutine UECHO (STRING, LENSTR)
c
c	This routine writes a string of length LENSTR to the
c	terminal.  No carriage control is done, either before
c	or after the string.
c
	parameter (MC=80)
	byte LOCAL(MC+1), STRING(1)
c
	do 10 K= 1, LENSTR
	  LOCAL(K)= STRING(K)
10	continue
	LOCAL(LENSTR+1)= '200'O		!No CRLF.
c
	call PRINT (LOCAL)
	return
c
	end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      